/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.symbol;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.WorkspaceSymbolParams;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.requestmanager.RequestManager;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.contributors.icon.LSPIconProvider;
import org.wso2.lsp4intellij.contributors.label.LSPLabelProvider;
import org.wso2.lsp4intellij.contributors.symbol.LSPNavigationItem;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.utils.FileUtils;
import org.wso2.lsp4intellij.utils.GUIUtils;

public class WorkspaceSymbolProvider {
    private static final Logger LOG = Logger.getInstance(WorkspaceSymbolProvider.class);

    public List<LSPNavigationItem> workspaceSymbols(String name, Project project) {
        Set serverWrappers = IntellijLanguageClient.getProjectToLanguageWrappers().getOrDefault(FileUtils.projectToUri(project), Collections.emptySet());
        WorkspaceSymbolParams symbolParams = new WorkspaceSymbolParams(name);
        return serverWrappers.stream().filter(s -> s.getStatus() == ServerStatus.INITIALIZED).flatMap(server -> this.collectSymbol((LanguageServerWrapper)server, server.getRequestManager(), symbolParams)).map(s -> this.createNavigationItem((LSPSymbolResult)s, project)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private LSPNavigationItem createNavigationItem(LSPSymbolResult result, Project project) {
        SymbolInformation information = result.getSymbolInformation();
        Location location = information.getLocation();
        VirtualFile file = FileUtils.URIToVFS(location.getUri());
        if (file != null) {
            LSPIconProvider iconProviderFor = GUIUtils.getIconProviderFor(result.getDefinition());
            LSPLabelProvider labelProvider = GUIUtils.getLabelProviderFor(result.getDefinition());
            return new LSPNavigationItem(labelProvider.symbolNameFor(information, project), labelProvider.symbolLocationFor(information, project), iconProviderFor.getSymbolIcon(information.getKind()), project, file, location.getRange().getStart().getLine(), location.getRange().getStart().getCharacter());
        }
        return null;
    }

    private Stream<LSPSymbolResult> collectSymbol(LanguageServerWrapper wrapper, RequestManager requestManager, WorkspaceSymbolParams symbolParams) {
        CompletableFuture<List<? extends SymbolInformation>> request = requestManager.symbol(symbolParams);
        if (request == null) {
            return Stream.empty();
        }
        try {
            List<? extends SymbolInformation> symbolInformations = request.get(20000L, TimeUnit.MILLISECONDS);
            wrapper.notifySuccess(Timeouts.SYMBOLS);
            return symbolInformations.stream().map(si -> new LSPSymbolResult((SymbolInformation)si, wrapper.getServerDefinition()));
        }
        catch (TimeoutException e) {
            LOG.warn((Throwable)e);
            wrapper.notifyFailure(Timeouts.SYMBOLS);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Throwable)e);
            wrapper.crashed(e);
        }
        return Stream.empty();
    }

    private static class LSPSymbolResult {
        private SymbolInformation symbolInformation;
        private LanguageServerDefinition definition;

        public LSPSymbolResult(SymbolInformation symbolInformation, LanguageServerDefinition definition) {
            this.symbolInformation = symbolInformation;
            this.definition = definition;
        }

        public SymbolInformation getSymbolInformation() {
            return this.symbolInformation;
        }

        public LanguageServerDefinition getDefinition() {
            return this.definition;
        }
    }
}

