/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.contributors.annotator;

import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.IntellijLanguageClient;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;
import org.wso2.lsp4intellij.utils.DocumentUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class LSPAnnotator
extends ExternalAnnotator {
    private static final Logger LOG = Logger.getInstance(LSPAnnotator.class);
    private static final Object RESULT = new Object();

    @Nullable
    public Object collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            LSPAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LSPAnnotator.$$$reportNull$$$0(1);
        }
        try {
            VirtualFile virtualFile = file.getVirtualFile();
            if (!FileUtils.isFileSupported(virtualFile) || !IntellijLanguageClient.isExtensionSupported(virtualFile)) {
                return null;
            }
            String uri = FileUtils.VFSToURI(virtualFile);
            EditorEventManager eventManager = EditorEventManagerBase.forUri(uri);
            if (eventManager == null || !eventManager.isDiagnosticSyncRequired() && !eventManager.isCodeActionSyncRequired()) {
                return null;
            }
            return RESULT;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public Object doAnnotate(Object collectedInfo) {
        return RESULT;
    }

    public void apply(@NotNull PsiFile file, Object annotationResult, @NotNull AnnotationHolder holder) {
        VirtualFile virtualFile;
        if (file == null) {
            LSPAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            LSPAnnotator.$$$reportNull$$$0(3);
        }
        if (FileUtils.isFileSupported(virtualFile = file.getVirtualFile()) && IntellijLanguageClient.isExtensionSupported(virtualFile)) {
            String uri = FileUtils.VFSToURI(virtualFile);
            EditorEventManager eventManager = EditorEventManagerBase.forUri(uri);
            if (eventManager == null) {
                return;
            }
            if (eventManager.isCodeActionSyncRequired()) {
                try {
                    this.updateAnnotations(holder, eventManager);
                }
                catch (ConcurrentModificationException e) {
                    LOG.warn("Error occurred when updating LSP diagnostics due to concurrent modifications.", (Throwable)e);
                }
                catch (Throwable t) {
                    LOG.warn("Error occurred when updating LSP diagnostics.", t);
                }
            } else if (eventManager.isDiagnosticSyncRequired()) {
                try {
                    this.createAnnotations(holder, eventManager);
                }
                catch (ConcurrentModificationException e) {
                    LOG.warn("Error occurred when updating LSP code actions due to concurrent modifications.", (Throwable)e);
                }
                catch (Throwable t) {
                    LOG.warn("Error occurred when updating LSP code actions.", t);
                }
            }
        }
    }

    private void updateAnnotations(AnnotationHolder holder, EditorEventManager eventManager) {
        List<Annotation> annotations = eventManager.getAnnotations();
        if (annotations == null) {
            return;
        }
        annotations.forEach(annotation -> {
            Annotation anon = holder.createAnnotation(annotation.getSeverity(), new TextRange(annotation.getStartOffset(), annotation.getEndOffset()), annotation.getMessage());
            if (annotation.getQuickFixes() == null || annotation.getQuickFixes().isEmpty()) {
                return;
            }
            annotation.getQuickFixes().forEach(quickFixInfo -> anon.registerFix(quickFixInfo.quickFix));
        });
    }

    private void createAnnotations(AnnotationHolder holder, EditorEventManager eventManager) {
        List<Diagnostic> diagnostics = eventManager.getDiagnostics();
        Editor editor = eventManager.editor;
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        diagnostics.forEach(d -> {
            Annotation annotation;
            int end;
            int start = DocumentUtils.LSPPosToOffset(editor, d.getRange().getStart());
            if (start >= (end = DocumentUtils.LSPPosToOffset(editor, d.getRange().getEnd()))) {
                return;
            }
            TextRange textRange = new TextRange(start, end);
            switch (d.getSeverity()) {
                case Error: {
                    annotation = holder.createErrorAnnotation(textRange, d.getMessage());
                    break;
                }
                case Warning: {
                    annotation = holder.createWarningAnnotation(textRange, d.getMessage());
                    break;
                }
                case Information: {
                    annotation = holder.createInfoAnnotation(textRange, d.getMessage());
                    break;
                }
                default: {
                    annotation = holder.createWeakWarningAnnotation(textRange, d.getMessage());
                }
            }
            annotations.add(annotation);
        });
        eventManager.setAnnotations(annotations);
        eventManager.setAnonHolder(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "org/wso2/lsp4intellij/contributors/annotator/LSPAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectInformation";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

