/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.languageserver.serverdefinition;

import com.intellij.openapi.diagnostic.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.wso2.lsp4intellij.client.connection.StreamConnectionProvider;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.ServerListener;

public class LanguageServerDefinition {
    private static final Logger LOG = Logger.getInstance(LanguageServerDefinition.class);
    public String ext;
    protected Map<String, String> languageIds = Collections.emptyMap();
    private Map<String, StreamConnectionProvider> streamConnectionProviders = new ConcurrentHashMap<String, StreamConnectionProvider>();
    public static final String SPLIT_CHAR = ",";

    public Pair<InputStream, OutputStream> start(String workingDir) throws IOException {
        StreamConnectionProvider streamConnectionProvider = this.streamConnectionProviders.get(workingDir);
        if (streamConnectionProvider != null) {
            return new ImmutablePair((Object)streamConnectionProvider.getInputStream(), (Object)streamConnectionProvider.getOutputStream());
        }
        streamConnectionProvider = this.createConnectionProvider(workingDir);
        streamConnectionProvider.start();
        this.streamConnectionProviders.put(workingDir, streamConnectionProvider);
        return new ImmutablePair((Object)streamConnectionProvider.getInputStream(), (Object)streamConnectionProvider.getOutputStream());
    }

    public void stop(String workingDir) {
        StreamConnectionProvider streamConnectionProvider = this.streamConnectionProviders.get(workingDir);
        if (streamConnectionProvider != null) {
            streamConnectionProvider.stop();
            this.streamConnectionProviders.remove(workingDir);
        } else {
            LOG.warn("No connection for workingDir " + workingDir + " and ext " + this.ext);
        }
    }

    public Object getInitializationOptions(URI uri) {
        return null;
    }

    public String toString() {
        return "ServerDefinition for " + this.ext;
    }

    public StreamConnectionProvider createConnectionProvider(String workingDir) {
        throw new UnsupportedOperationException();
    }

    public ServerListener getServerListener() {
        return ServerListener.DEFAULT;
    }

    public String languageIdFor(String extension) {
        return this.languageIds.getOrDefault(extension, extension);
    }
}

