/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.client.connection;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.client.connection.StreamConnectionProvider;

public class ProcessStreamConnectionProvider
implements StreamConnectionProvider {
    private Logger LOG;
    @Nullable
    private ProcessBuilder builder;
    @Nullable
    private Process process;
    private List<String> commands;
    private String workingDir;

    public ProcessStreamConnectionProvider(List<String> commands, String workingDir) {
        this.LOG = Logger.getInstance(ProcessStreamConnectionProvider.class);
        this.process = null;
        this.commands = commands;
        this.workingDir = workingDir;
        this.builder = null;
    }

    public ProcessStreamConnectionProvider(@NotNull ProcessBuilder processBuilder) {
        if (processBuilder == null) {
            ProcessStreamConnectionProvider.$$$reportNull$$$0(0);
        }
        this.LOG = Logger.getInstance(ProcessStreamConnectionProvider.class);
        this.process = null;
        this.builder = processBuilder;
    }

    @Override
    public void start() throws IOException {
        if ((this.workingDir == null || this.commands == null || this.commands.isEmpty() || this.commands.contains(null)) && this.builder == null) {
            throw new IOException("Unable to start language server: " + this.toString());
        }
        ProcessBuilder builder = this.createProcessBuilder();
        this.LOG.info("Starting server process with commands " + this.commands + " and workingDir " + this.workingDir);
        this.process = builder.start();
        if (!this.process.isAlive()) {
            throw new IOException("Unable to start language server: " + this.toString());
        }
        this.LOG.info("Server process started " + this.process);
    }

    private ProcessBuilder createProcessBuilder() {
        if (this.builder != null) {
            return this.builder;
        }
        this.commands.forEach(c -> {
            c = c.replace("'", "");
        });
        ProcessBuilder builder = new ProcessBuilder(this.commands);
        builder.directory(new File(this.workingDir));
        builder.redirectError(ProcessBuilder.Redirect.INHERIT);
        return builder;
    }

    @Override
    @Nullable
    public InputStream getInputStream() {
        return this.process != null ? this.process.getInputStream() : null;
    }

    @Override
    @Nullable
    public OutputStream getOutputStream() {
        return this.process != null ? this.process.getOutputStream() : null;
    }

    @Override
    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof ProcessStreamConnectionProvider) {
            ProcessStreamConnectionProvider other = (ProcessStreamConnectionProvider)obj;
            return this.commands.size() == other.commands.size() && new HashSet<String>(this.commands).equals(new HashSet<String>(other.commands)) && this.workingDir.equals(other.workingDir);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.commands) ^ Objects.hashCode(this.workingDir);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processBuilder", "org/wso2/lsp4intellij/client/connection/ProcessStreamConnectionProvider", "<init>"));
    }
}

