/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij.actions;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.awt.Color;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.wso2.lsp4intellij.editor.EditorEventManager;
import org.wso2.lsp4intellij.editor.EditorEventManagerBase;

public class LSPReferencesAction
extends DumbAwareAction {
    public void actionPerformed(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor != null) {
            EditorEventManager eventManager = EditorEventManagerBase.forEditor(editor);
            if (eventManager == null) {
                return;
            }
            ArrayList<PsiElement2UsageTargetAdapter> targets = new ArrayList<PsiElement2UsageTargetAdapter>();
            Pair<List<PsiElement>, List<VirtualFile>> references = eventManager.references(editor.getCaretModel().getCurrentCaret().getOffset());
            if (references.first != null && references.second != null) {
                ((List)references.first).forEach(element -> targets.add(new PsiElement2UsageTargetAdapter(element)));
            }
            this.showReferences(editor, targets, editor.getCaretModel().getCurrentCaret().getLogicalPosition());
        }
    }

    public void forManagerAndOffset(EditorEventManager manager, int offset) {
        ArrayList<PsiElement2UsageTargetAdapter> targets = new ArrayList<PsiElement2UsageTargetAdapter>();
        Pair<List<PsiElement>, List<VirtualFile>> references = manager.references(offset);
        if (references.first != null && references.second != null) {
            ((List)references.first).forEach(element -> targets.add(new PsiElement2UsageTargetAdapter(element)));
        }
        Editor editor = manager.editor;
        this.showReferences(editor, targets, editor.offsetToLogicalPosition(offset));
    }

    private void showReferences(Editor editor, List<PsiElement2UsageTargetAdapter> targets, LogicalPosition position) {
        if (targets.isEmpty()) {
            short constraint = 1;
            int flags = 42;
            JLabel label = new JLabel("No references found");
            label.setBackground((Color)new JBColor(new Color(150, 0, 0), new Color(150, 0, 0)));
            LightweightHint hint = new LightweightHint((JComponent)label);
            Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (LogicalPosition)position, (short)constraint);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, p, flags, 0, false, HintManagerImpl.createHintHint((Editor)editor, (Point)p, (LightweightHint)hint, (short)constraint).setContentActive(false));
        } else {
            ArrayList usages = new ArrayList();
            targets.forEach(ut -> {
                PsiElement elem = ut.getElement();
                usages.add(new UsageInfo2UsageAdapter(new UsageInfo(elem, -1, -1, false)));
            });
            if (editor == null) {
                return;
            }
            Project project = editor.getProject();
            if (project == null) {
                return;
            }
            UsageViewPresentation presentation = this.createPresentation(targets.get(0).getElement(), new FindUsagesOptions(editor.getProject()), false);
            UsageViewManager.getInstance((Project)project).showUsages(new UsageTarget[]{(UsageTarget)targets.get(0)}, usages.toArray(new Usage[usages.size()]), presentation);
        }
    }

    private UsageViewPresentation createPresentation(PsiElement psiElement, FindUsagesOptions options, boolean toOpenInNewTab) {
        UsageViewPresentation presentation = new UsageViewPresentation();
        String scopeString = options.searchScope.getDisplayName();
        presentation.setScopeText(scopeString);
        String usagesString = options.generateUsagesString();
        presentation.setUsagesString(usagesString);
        String title = FindBundle.message((String)"find.usages.of.element.in.scope.panel.title", (Object[])new Object[]{usagesString, UsageViewUtil.getLongName((PsiElement)psiElement), scopeString});
        presentation.setTabText(title);
        presentation.setTabName(FindBundle.message((String)"find.usages.of.element.tab.name", (Object[])new Object[]{usagesString, UsageViewUtil.getShortName((PsiElement)psiElement)}));
        presentation.setTargetsNodeText(StringUtil.capitalize((String)UsageViewUtil.getType((PsiElement)psiElement)));
        presentation.setOpenInNewTab(toOpenInNewTab);
        presentation.setShowCancelButton(true);
        return presentation;
    }
}

