/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.lsp4intellij;

import com.intellij.AppTopics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.lsp4j.DidChangeConfigurationParams;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.wso2.lsp4intellij.client.languageserver.ServerStatus;
import org.wso2.lsp4intellij.client.languageserver.serverdefinition.LanguageServerDefinition;
import org.wso2.lsp4intellij.client.languageserver.wrapper.LanguageServerWrapper;
import org.wso2.lsp4intellij.extensions.LSPExtensionManager;
import org.wso2.lsp4intellij.listeners.LSPEditorListener;
import org.wso2.lsp4intellij.listeners.LSPFileDocumentManagerListener;
import org.wso2.lsp4intellij.listeners.LSPProjectManagerListener;
import org.wso2.lsp4intellij.listeners.VFSListener;
import org.wso2.lsp4intellij.requests.Timeout;
import org.wso2.lsp4intellij.requests.Timeouts;
import org.wso2.lsp4intellij.utils.ApplicationUtils;
import org.wso2.lsp4intellij.utils.FileUtils;

public class IntellijLanguageClient
implements ApplicationComponent,
Disposable {
    private static Logger LOG = Logger.getInstance(IntellijLanguageClient.class);
    private static final Map<Pair<String, String>, LanguageServerWrapper> extToLanguageWrapper = new ConcurrentHashMap<Pair<String, String>, LanguageServerWrapper>();
    private static Map<String, Set<LanguageServerWrapper>> projectToLanguageWrappers = new ConcurrentHashMap<String, Set<LanguageServerWrapper>>();
    private static Map<Pair<String, String>, LanguageServerDefinition> extToServerDefinition = new ConcurrentHashMap<Pair<String, String>, LanguageServerDefinition>();
    private static Map<String, LSPExtensionManager> extToExtManager = new ConcurrentHashMap<String, LSPExtensionManager>();
    private static final Predicate<LanguageServerWrapper> RUNNING = s -> s.getStatus() != ServerStatus.STOPPED;

    public void initComponent() {
        try {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new LSPProjectManagerListener());
            EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)new LSPEditorListener(), (Disposable)this);
            VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new VFSListener());
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new LSPFileDocumentManagerListener());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> projectToLanguageWrappers.values().stream().flatMap(Collection::stream).filter(RUNNING).forEach(s -> s.stop(true))));
            LOG.info("Intellij Language Client initialized successfully");
        }
        catch (Exception e) {
            LOG.warn("Fatal error occurred when initializing Intellij language client.", (Throwable)e);
        }
    }

    public static void addServerDefinition(@NotNull LanguageServerDefinition definition) {
        if (definition == null) {
            IntellijLanguageClient.$$$reportNull$$$0(0);
        }
        IntellijLanguageClient.addServerDefinition(definition, null);
    }

    public static void addServerDefinition(@NotNull LanguageServerDefinition definition, @Nullable Project project) {
        if (definition == null) {
            IntellijLanguageClient.$$$reportNull$$$0(1);
        }
        if (project != null) {
            IntellijLanguageClient.processDefinition(definition, FileUtils.projectToUri(project));
            FileUtils.reloadEditors(project);
        } else {
            IntellijLanguageClient.processDefinition(definition, "");
            FileUtils.reloadAllEditors();
        }
        LOG.info("Added definition for " + definition);
    }

    public static void addExtensionManager(@NotNull String ext, @NotNull LSPExtensionManager manager) {
        if (ext == null) {
            IntellijLanguageClient.$$$reportNull$$$0(2);
        }
        if (manager == null) {
            IntellijLanguageClient.$$$reportNull$$$0(3);
        }
        if (extToExtManager.get(ext) != null) {
            LOG.warn("An extension manager is already registered for \"" + ext + "\" extension");
        }
        extToExtManager.put(ext, manager);
    }

    public static Set<LanguageServerWrapper> getAllServerWrappersFor(String projectUri) {
        HashSet<LanguageServerWrapper> allWrappers = new HashSet<LanguageServerWrapper>();
        extToLanguageWrapper.forEach((stringStringPair, languageServerWrapper) -> {
            if (FileUtils.projectToUri(languageServerWrapper.getProject()).equals(projectUri)) {
                allWrappers.add((LanguageServerWrapper)languageServerWrapper);
            }
        });
        return allWrappers;
    }

    public static LSPExtensionManager getExtensionManagerFor(String fileExt) {
        if (extToExtManager.containsKey(fileExt)) {
            return extToExtManager.get(fileExt);
        }
        return null;
    }

    public static boolean isExtensionSupported(VirtualFile virtualFile) {
        return extToServerDefinition.keySet().stream().anyMatch(keyMap -> ((String)keyMap.getLeft()).equals(virtualFile.getExtension()) || virtualFile.getName().matches((String)keyMap.getLeft()));
    }

    public static void editorOpened(Editor editor) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!FileUtils.isFileSupported(file)) {
            LOG.debug("Handling open on a editor which host a LightVirtual/Null file");
            return;
        }
        Project project = editor.getProject();
        if (project == null) {
            LOG.debug("Opened an unsupported editor, which does not have an attached project.");
            return;
        }
        String projectUri = FileUtils.projectToUri(project);
        if (projectUri == null) {
            LOG.warn("File for editor " + editor.getDocument().getText() + " is null");
            return;
        }
        ApplicationUtils.pool(() -> {
            Optional<Pair> keyForFile;
            String ext = file.getExtension();
            String fileName = file.getName();
            LOG.info("Opened " + fileName);
            LanguageServerDefinition serverDefinition = extToServerDefinition.get(new ImmutablePair((Object)ext, (Object)projectUri));
            if (serverDefinition == null && (keyForFile = extToServerDefinition.keySet().stream().filter(keyPair -> fileName.matches((String)keyPair.getLeft()) && ((String)keyPair.getRight()).equals(projectUri)).findFirst()).isPresent()) {
                serverDefinition = extToServerDefinition.get(keyForFile.get());
                ext = (String)keyForFile.get().getLeft();
            }
            if (serverDefinition == null) {
                serverDefinition = extToServerDefinition.get(new ImmutablePair((Object)ext, (Object)""));
            }
            if (serverDefinition == null && (keyForFile = extToServerDefinition.keySet().stream().filter(keyPair -> fileName.matches((String)keyPair.getLeft()) && ((String)keyPair.getRight()).isEmpty()).findFirst()).isPresent()) {
                serverDefinition = extToServerDefinition.get(keyForFile.get());
                ext = (String)keyForFile.get().getLeft();
            }
            if (serverDefinition == null) {
                LOG.warn("Could not find a server definition for " + ext);
                return;
            }
            LanguageServerWrapper wrapper = extToLanguageWrapper.get(new MutablePair((Object)ext, (Object)projectUri));
            if (wrapper == null) {
                String[] exts;
                LOG.info("Instantiating wrapper for " + ext + " : " + projectUri);
                wrapper = extToExtManager.get(ext) != null ? new LanguageServerWrapper(serverDefinition, project, extToExtManager.get(ext)) : new LanguageServerWrapper(serverDefinition, project);
                for (String ex : exts = serverDefinition.ext.split(",")) {
                    extToLanguageWrapper.put((Pair<String, String>)new ImmutablePair((Object)ex, (Object)projectUri), wrapper);
                }
                Set wrappers = projectToLanguageWrappers.computeIfAbsent(projectUri, k -> new HashSet());
                wrappers.add(wrapper);
            } else {
                LOG.info("Wrapper already existing for " + ext + " , " + projectUri);
            }
            LOG.info("Adding file " + fileName);
            wrapper.connect(editor);
        });
    }

    public static void editorClosed(Editor editor) {
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (!FileUtils.isFileSupported(file)) {
            LOG.debug("Handling close on a editor which host a LightVirtual/Null file");
            return;
        }
        ApplicationUtils.pool(() -> {
            LanguageServerWrapper serverWrapper = LanguageServerWrapper.forEditor(editor);
            if (serverWrapper != null) {
                LOG.info("Disconnecting " + FileUtils.editorToURIString(editor));
                serverWrapper.disconnect(editor);
            }
        });
    }

    public static Map<Timeouts, Integer> getTimeouts() {
        return Timeout.getTimeouts();
    }

    public static int getTimeout(Timeouts timeoutType) {
        return IntellijLanguageClient.getTimeouts().get((Object)timeoutType);
    }

    public static void setTimeouts(Map<Timeouts, Integer> newTimeouts) {
        Timeout.setTimeouts(newTimeouts);
    }

    public static void setTimeout(Timeouts timeout, int value) {
        HashMap<Timeouts, Integer> newTimeout = new HashMap<Timeouts, Integer>();
        newTimeout.put(timeout, value);
        IntellijLanguageClient.setTimeouts(newTimeout);
    }

    public static void removeWrapper(LanguageServerWrapper wrapper) {
        if (wrapper.getProject() != null) {
            String[] extensions;
            for (String ext : extensions = wrapper.getServerDefinition().ext.split(",")) {
                extToLanguageWrapper.remove(new MutablePair((Object)ext, (Object)FileUtils.pathToUri(new File(wrapper.getProjectRootPath()).getAbsolutePath())));
            }
        } else {
            LOG.error("No attached projects found for wrapper");
        }
    }

    public static Map<String, Set<LanguageServerWrapper>> getProjectToLanguageWrappers() {
        return projectToLanguageWrappers;
    }

    public static void didChangeConfiguration(@NotNull DidChangeConfigurationParams params, @NotNull Project project) {
        if (params == null) {
            IntellijLanguageClient.$$$reportNull$$$0(4);
        }
        if (project == null) {
            IntellijLanguageClient.$$$reportNull$$$0(5);
        }
        Set<LanguageServerWrapper> serverWrappers = IntellijLanguageClient.getProjectToLanguageWrappers().get(FileUtils.projectToUri(project));
        serverWrappers.forEach(s -> s.getRequestManager().didChangeConfiguration(params));
    }

    public static Optional<LSPExtensionManager> getExtensionManagerForDefinition(@NotNull LanguageServerDefinition definition) {
        if (definition == null) {
            IntellijLanguageClient.$$$reportNull$$$0(6);
        }
        return Optional.ofNullable(extToExtManager.get(definition.ext.split(",")[0]));
    }

    public void disposeComponent() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this);
    }

    private static void processDefinition(LanguageServerDefinition definition, String projectUri) {
        String[] extensions;
        for (String ext : extensions = definition.ext.split(",")) {
            ImmutablePair keyPair = new ImmutablePair((Object)ext, (Object)projectUri);
            if (extToServerDefinition.get(keyPair) == null) {
                extToServerDefinition.put((Pair<String, String>)keyPair, definition);
                LOG.info("Added server definition for " + ext);
                continue;
            }
            extToServerDefinition.replace((Pair<String, String>)keyPair, definition);
            LOG.info("Updated server definition for " + ext);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/wso2/lsp4intellij/IntellijLanguageClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addServerDefinition";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addExtensionManager";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "didChangeConfiguration";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getExtensionManagerForDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

