/*
 * Decompiled with CFR 0.152.
 */
package com.badoualy.stepperindicator;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.RectF;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.UiThread;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import com.badoualy.stepperindicator.R;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StepperIndicator
extends View
implements ViewPager.OnPageChangeListener {
    private static final String TAG = "StepperIndicator";
    private static final int DEFAULT_ANIMATION_DURATION = 250;
    private static final float EXPAND_MARK = 1.3f;
    private static final int STEP_INVALID = -1;
    private Paint circlePaint;
    private List<Paint> stepsCirclePaintList;
    private float circleRadius;
    private boolean showStepTextNumber;
    private Paint stepTextNumberPaint;
    private List<Paint> stepsTextNumberPaintList;
    private Paint indicatorPaint;
    private List<Paint> stepsIndicatorPaintList;
    private Paint linePaint;
    private Paint lineDonePaint;
    private Paint lineDoneAnimatedPaint;
    private List<Path> linePathList = new ArrayList<Path>();
    private float animProgress;
    private float animIndicatorRadius;
    private float animCheckRadius;
    private boolean useBottomIndicator;
    private float bottomIndicatorMarginTop = 0.0f;
    private float bottomIndicatorWidth = 0.0f;
    private float bottomIndicatorHeight = 0.0f;
    private boolean useBottomIndicatorWithStepColors;
    private float lineLength;
    private float checkRadius;
    private float indicatorRadius;
    private float lineMargin;
    private int animDuration;
    private List<OnStepClickListener> onStepClickListeners = new ArrayList<OnStepClickListener>(0);
    private List<RectF> stepsClickAreas;
    private GestureDetector gestureDetector;
    private int stepCount;
    private int currentStep;
    private int previousStep;
    private float[] indicators;
    private Rect stepAreaRect = new Rect();
    private RectF stepAreaRectF = new RectF();
    private ViewPager pager;
    private Bitmap doneIcon;
    private boolean showDoneIcon;
    private AnimatorSet animatorSet;
    private ObjectAnimator lineAnimator;
    private ObjectAnimator indicatorAnimator;
    private ObjectAnimator checkAnimator;
    private GestureDetector.OnGestureListener gestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onSingleTapConfirmed(MotionEvent e) {
            float xCord = e.getX();
            float yCord = e.getY();
            int clickedStep = -1;
            if (StepperIndicator.this.isOnStepClickListenerAvailable()) {
                for (int i = 0; i < StepperIndicator.this.stepsClickAreas.size(); ++i) {
                    if (!((RectF)StepperIndicator.this.stepsClickAreas.get(i)).contains(xCord, yCord)) continue;
                    clickedStep = i;
                    break;
                }
            }
            if (clickedStep != -1) {
                for (OnStepClickListener listener : StepperIndicator.this.onStepClickListeners) {
                    listener.onStepClicked(clickedStep);
                }
            }
            return super.onSingleTapConfirmed(e);
        }
    };

    public StepperIndicator(Context context) {
        this(context, null);
    }

    public StepperIndicator(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs, defStyleAttr);
    }

    @TargetApi(value=21)
    public StepperIndicator(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs, defStyleAttr);
    }

    public static int getPrimaryColor(Context context) {
        int color2 = context.getResources().getIdentifier("colorPrimary", "attr", context.getPackageName());
        if (color2 != 0) {
            TypedValue t = new TypedValue();
            context.getTheme().resolveAttribute(color2, t, true);
            color2 = t.data;
        } else if (Build.VERSION.SDK_INT >= 21) {
            TypedArray t = context.obtainStyledAttributes(new int[]{16843827});
            color2 = t.getColor(0, ContextCompat.getColor((Context)context, (int)R.color.stpi_default_primary_color));
            t.recycle();
        } else {
            TypedArray t = context.obtainStyledAttributes(new int[]{R.attr.colorPrimary});
            color2 = t.getColor(0, ContextCompat.getColor((Context)context, (int)R.color.stpi_default_primary_color));
            t.recycle();
        }
        return color2;
    }

    private static PathEffect createPathEffect(float pathLength, float phase, float offset) {
        return new DashPathEffect(new float[]{pathLength, pathLength}, Math.max(phase * pathLength, offset));
    }

    private void init(Context context, AttributeSet attrs, int defStyleAttr) {
        Resources resources = this.getResources();
        int defaultPrimaryColor = StepperIndicator.getPrimaryColor(context);
        int defaultCircleColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_circle_color);
        float defaultCircleRadius = resources.getDimension(R.dimen.stpi_default_circle_radius);
        float defaultCircleStrokeWidth = resources.getDimension(R.dimen.stpi_default_circle_stroke_width);
        int defaultIndicatorColor = defaultPrimaryColor;
        float defaultIndicatorRadius = resources.getDimension(R.dimen.stpi_default_indicator_radius);
        float defaultLineStrokeWidth = resources.getDimension(R.dimen.stpi_default_line_stroke_width);
        float defaultLineMargin = resources.getDimension(R.dimen.stpi_default_line_margin);
        int defaultLineColor = ContextCompat.getColor((Context)context, (int)R.color.stpi_default_line_color);
        int defaultLineDoneColor = defaultPrimaryColor;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.StepperIndicator, defStyleAttr, 0);
        this.circlePaint = new Paint();
        this.circlePaint.setStrokeWidth(a.getDimension(R.styleable.StepperIndicator_stpi_circleStrokeWidth, defaultCircleStrokeWidth));
        this.circlePaint.setStyle(Paint.Style.STROKE);
        this.circlePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_circleColor, defaultCircleColor));
        this.circlePaint.setAntiAlias(true);
        this.setStepCount(a.getInteger(R.styleable.StepperIndicator_stpi_stepCount, 2));
        int stepsCircleColorsResId = a.getResourceId(R.styleable.StepperIndicator_stpi_stepsCircleColors, 0);
        if (stepsCircleColorsResId != 0) {
            this.stepsCirclePaintList = new ArrayList<Paint>(this.stepCount);
            for (int i = 0; i < this.stepCount; ++i) {
                Paint circlePaint = new Paint(this.circlePaint);
                if (this.isInEditMode()) {
                    circlePaint.setColor(this.getRandomColor());
                } else {
                    TypedArray colorResValues = context.getResources().obtainTypedArray(stepsCircleColorsResId);
                    if (this.stepCount > colorResValues.length()) {
                        throw new IllegalArgumentException("Invalid number of colors for the circles. Please provide a list of colors with as many items as the number of steps required!");
                    }
                    circlePaint.setColor(colorResValues.getColor(i, 0));
                    colorResValues.recycle();
                }
                this.stepsCirclePaintList.add(circlePaint);
            }
        }
        this.indicatorPaint = new Paint(this.circlePaint);
        this.indicatorPaint.setStyle(Paint.Style.FILL);
        this.indicatorPaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_indicatorColor, defaultIndicatorColor));
        this.indicatorPaint.setAntiAlias(true);
        this.stepTextNumberPaint = new Paint(this.indicatorPaint);
        this.stepTextNumberPaint.setTextSize(this.getResources().getDimension(R.dimen.stpi_default_text_size));
        this.showStepTextNumber = a.getBoolean(R.styleable.StepperIndicator_stpi_showStepNumberInstead, false);
        int stepsIndicatorColorsResId = a.getResourceId(R.styleable.StepperIndicator_stpi_stepsIndicatorColors, 0);
        if (stepsIndicatorColorsResId != 0) {
            this.stepsIndicatorPaintList = new ArrayList<Paint>(this.stepCount);
            if (this.showStepTextNumber) {
                this.stepsTextNumberPaintList = new ArrayList<Paint>(this.stepCount);
            }
            for (int i = 0; i < this.stepCount; ++i) {
                Paint textNumberPaint;
                Paint indicatorPaint = new Paint(this.indicatorPaint);
                Paint paint = textNumberPaint = this.showStepTextNumber ? new Paint(this.stepTextNumberPaint) : null;
                if (this.isInEditMode()) {
                    indicatorPaint.setColor(this.getRandomColor());
                    if (null != textNumberPaint) {
                        textNumberPaint.setColor(indicatorPaint.getColor());
                    }
                } else {
                    TypedArray colorResValues = context.getResources().obtainTypedArray(stepsIndicatorColorsResId);
                    if (this.stepCount > colorResValues.length()) {
                        throw new IllegalArgumentException("Invalid number of colors for the indicators. Please provide a list of colors with as many items as the number of steps required!");
                    }
                    indicatorPaint.setColor(colorResValues.getColor(i, 0));
                    if (null != textNumberPaint) {
                        textNumberPaint.setColor(indicatorPaint.getColor());
                    }
                    colorResValues.recycle();
                }
                this.stepsIndicatorPaintList.add(indicatorPaint);
                if (!this.showStepTextNumber || null == textNumberPaint) continue;
                this.stepsTextNumberPaintList.add(textNumberPaint);
            }
        }
        this.linePaint = new Paint();
        this.linePaint.setStrokeWidth(a.getDimension(R.styleable.StepperIndicator_stpi_lineStrokeWidth, defaultLineStrokeWidth));
        this.linePaint.setStrokeCap(Paint.Cap.ROUND);
        this.linePaint.setStyle(Paint.Style.STROKE);
        this.linePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineColor, defaultLineColor));
        this.linePaint.setAntiAlias(true);
        this.lineDonePaint = new Paint(this.linePaint);
        this.lineDonePaint.setColor(a.getColor(R.styleable.StepperIndicator_stpi_lineDoneColor, defaultLineDoneColor));
        this.lineDoneAnimatedPaint = new Paint(this.lineDonePaint);
        this.useBottomIndicator = a.getBoolean(R.styleable.StepperIndicator_stpi_useBottomIndicator, false);
        if (this.useBottomIndicator) {
            float defaultHeight = resources.getDimension(R.dimen.stpi_default_bottom_indicator_height);
            this.bottomIndicatorHeight = a.getDimension(R.styleable.StepperIndicator_stpi_bottomIndicatorHeight, defaultHeight);
            if (this.bottomIndicatorHeight <= 0.0f) {
                Log.d((String)TAG, (String)"init: Invalid indicator height, disabling bottom indicator feature! Please provide a value greater than 0.");
                this.useBottomIndicator = false;
            }
            float defaultWidth = resources.getDimension(R.dimen.stpi_default_bottom_indicator_width);
            this.bottomIndicatorWidth = a.getDimension(R.styleable.StepperIndicator_stpi_bottomIndicatorWidth, defaultWidth);
            float defaultTopMargin = resources.getDimension(R.dimen.stpi_default_bottom_indicator_margin_top);
            this.bottomIndicatorMarginTop = a.getDimension(R.styleable.StepperIndicator_stpi_bottomIndicatorMarginTop, defaultTopMargin);
            this.useBottomIndicatorWithStepColors = a.getBoolean(R.styleable.StepperIndicator_stpi_useBottomIndicatorWithStepColors, false);
        }
        this.circleRadius = a.getDimension(R.styleable.StepperIndicator_stpi_circleRadius, defaultCircleRadius);
        this.checkRadius = this.circleRadius + this.circlePaint.getStrokeWidth() / 2.0f;
        this.animIndicatorRadius = this.indicatorRadius = a.getDimension(R.styleable.StepperIndicator_stpi_indicatorRadius, defaultIndicatorRadius);
        this.animCheckRadius = this.checkRadius;
        this.lineMargin = a.getDimension(R.styleable.StepperIndicator_stpi_lineMargin, defaultLineMargin);
        this.animDuration = a.getInteger(R.styleable.StepperIndicator_stpi_animDuration, 250);
        this.showDoneIcon = a.getBoolean(R.styleable.StepperIndicator_stpi_showDoneIcon, true);
        a.recycle();
        if (this.showDoneIcon) {
            this.doneIcon = BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.ic_done_white_18dp);
        }
        if (this.isInEditMode()) {
            this.currentStep = Math.max((int)Math.ceil((float)this.stepCount / 2.0f), 1);
        }
        this.gestureDetector = new GestureDetector(this.getContext(), this.gestureListener);
    }

    private Paint getRandomPaint() {
        Paint paint = new Paint(this.indicatorPaint);
        paint.setColor(this.getRandomColor());
        return paint;
    }

    private int getRandomColor() {
        Random rnd = new Random();
        return Color.argb((int)255, (int)rnd.nextInt(256), (int)rnd.nextInt(256), (int)rnd.nextInt(256));
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.gestureDetector.onTouchEvent(event);
        return true;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.compute();
    }

    private void compute() {
        int i;
        if (null == this.circlePaint) {
            throw new IllegalArgumentException("circlePaint is invalid! Make sure you setup the field circlePaint before calling compute() method!");
        }
        this.indicators = new float[this.stepCount];
        this.linePathList.clear();
        float startX = this.circleRadius * 1.3f + this.circlePaint.getStrokeWidth() / 2.0f;
        if (this.useBottomIndicator) {
            startX += this.bottomIndicatorWidth / 2.0f - startX;
        }
        float divider = ((float)this.getMeasuredWidth() - startX * 2.0f) / (float)(this.stepCount - 1);
        this.lineLength = divider - (this.circleRadius * 2.0f + this.circlePaint.getStrokeWidth()) - this.lineMargin * 2.0f;
        for (i = 0; i < this.indicators.length; ++i) {
            this.indicators[i] = startX + divider * (float)i;
        }
        for (i = 0; i < this.indicators.length - 1; ++i) {
            float position = (this.indicators[i] + this.indicators[i + 1]) / 2.0f - this.lineLength / 2.0f;
            Path linePath = new Path();
            float lineY = this.getStepCenterY();
            linePath.moveTo(position, lineY);
            linePath.lineTo(position + this.lineLength, lineY);
            this.linePathList.add(linePath);
        }
        this.computeStepsClickAreas();
    }

    public void computeStepsClickAreas() {
        if (this.stepCount == -1) {
            throw new IllegalArgumentException("stepCount wasn't setup yet. Make sure you call setStepCount() before computing the steps click area!");
        }
        if (null == this.indicators) {
            throw new IllegalArgumentException("indicators wasn't setup yet. Make sure the indicators are initialized and setup correctly before trying to compute the click area for each step!");
        }
        this.stepsClickAreas = new ArrayList<RectF>(this.stepCount);
        for (float indicator : this.indicators) {
            float left = indicator - this.circleRadius * 2.0f;
            float right = indicator + this.circleRadius * 2.0f;
            float top = this.getStepCenterY() - this.circleRadius * 2.0f;
            float bottom = this.getStepCenterY() + this.circleRadius + (float)this.getBottomIndicatorHeight();
            RectF area = new RectF(left, top, right, bottom);
            this.stepsClickAreas.add(area);
        }
    }

    private int getBottomIndicatorHeight() {
        if (this.useBottomIndicator) {
            return (int)(this.bottomIndicatorHeight + this.bottomIndicatorMarginTop);
        }
        return 0;
    }

    private float getStepCenterY() {
        return (float)(this.getMeasuredHeight() - this.getBottomIndicatorHeight()) / 2.0f;
    }

    protected void onDraw(Canvas canvas) {
        float centerY = this.getStepCenterY();
        boolean inAnimation = this.animatorSet != null && this.animatorSet.isRunning();
        boolean inLineAnimation = this.lineAnimator != null && this.lineAnimator.isRunning();
        boolean inIndicatorAnimation = this.indicatorAnimator != null && this.indicatorAnimator.isRunning();
        boolean inCheckAnimation = this.checkAnimator != null && this.checkAnimator.isRunning();
        boolean drawToNext = this.previousStep == this.currentStep - 1;
        boolean drawFromNext = this.previousStep == this.currentStep + 1;
        for (int i = 0; i < this.indicators.length; ++i) {
            float indicator = this.indicators[i];
            boolean drawCheck = i < this.currentStep || drawFromNext && i == this.currentStep;
            canvas.drawCircle(indicator, centerY, this.circleRadius, this.getStepCirclePaint(i));
            if (this.showStepTextNumber) {
                String stepLabel = String.valueOf(i + 1);
                this.stepAreaRect.set((int)(indicator - this.circleRadius), (int)(centerY - this.circleRadius), (int)(indicator + this.circleRadius), (int)(centerY + this.circleRadius));
                this.stepAreaRectF.set(this.stepAreaRect);
                Paint stepTextNumberPaint = this.getStepTextNumberPaint(i);
                this.stepAreaRectF.right = stepTextNumberPaint.measureText(stepLabel, 0, stepLabel.length());
                this.stepAreaRectF.bottom = stepTextNumberPaint.descent() - stepTextNumberPaint.ascent();
                this.stepAreaRectF.left += ((float)this.stepAreaRect.width() - this.stepAreaRectF.right) / 2.0f;
                this.stepAreaRectF.top += ((float)this.stepAreaRect.height() - this.stepAreaRectF.bottom) / 2.0f;
                canvas.drawText(stepLabel, this.stepAreaRectF.left, this.stepAreaRectF.top - stepTextNumberPaint.ascent(), stepTextNumberPaint);
            }
            if (this.useBottomIndicator) {
                if (i == this.currentStep) {
                    canvas.drawRect(indicator - this.bottomIndicatorWidth / 2.0f, (float)this.getHeight() - this.bottomIndicatorHeight, indicator + this.bottomIndicatorWidth / 2.0f, (float)this.getHeight(), this.useBottomIndicatorWithStepColors ? this.getStepIndicatorPaint(i) : this.indicatorPaint);
                }
            } else if (i == this.currentStep && !drawFromNext || i == this.previousStep && drawFromNext && inAnimation) {
                canvas.drawCircle(indicator, centerY, this.animIndicatorRadius, this.getStepIndicatorPaint(i));
            }
            if (drawCheck) {
                float radius = this.checkRadius;
                if (i == this.previousStep && drawToNext || i == this.currentStep && drawFromNext) {
                    radius = this.animCheckRadius;
                }
                canvas.drawCircle(indicator, centerY, radius, this.getStepIndicatorPaint(i));
                if (!this.isInEditMode() && this.showDoneIcon && (i != this.previousStep && i != this.currentStep || !inCheckAnimation && (i != this.currentStep || inAnimation))) {
                    canvas.drawBitmap(this.doneIcon, indicator - (float)(this.doneIcon.getWidth() / 2), centerY - (float)(this.doneIcon.getHeight() / 2), null);
                }
            }
            if (i >= this.linePathList.size()) continue;
            if (i >= this.currentStep) {
                canvas.drawPath(this.linePathList.get(i), this.linePaint);
                if (i != this.currentStep || !drawFromNext || !inLineAnimation && !inIndicatorAnimation) continue;
                canvas.drawPath(this.linePathList.get(i), this.lineDoneAnimatedPaint);
                continue;
            }
            if (i == this.currentStep - 1 && drawToNext && inLineAnimation) {
                canvas.drawPath(this.linePathList.get(i), this.linePaint);
                canvas.drawPath(this.linePathList.get(i), this.lineDoneAnimatedPaint);
                continue;
            }
            canvas.drawPath(this.linePathList.get(i), this.lineDonePaint);
        }
    }

    private Paint getStepIndicatorPaint(int stepPosition) {
        return this.getPaint(stepPosition, this.stepsIndicatorPaintList, this.indicatorPaint);
    }

    private Paint getStepTextNumberPaint(int stepPosition) {
        return this.getPaint(stepPosition, this.stepsTextNumberPaintList, this.stepTextNumberPaint);
    }

    private Paint getStepCirclePaint(int stepPosition) {
        return this.getPaint(stepPosition, this.stepsCirclePaintList, this.circlePaint);
    }

    private Paint getPaint(int stepPosition, List<Paint> sourceList, Paint defaultPaint) {
        this.isStepValid(stepPosition);
        Paint paint = null;
        if (null != sourceList && !sourceList.isEmpty()) {
            try {
                paint = sourceList.get(stepPosition);
            }
            catch (IndexOutOfBoundsException e) {
                Log.d((String)TAG, (String)"getPaint: could not find the specific step paint to use! Try to use default instead!");
            }
        }
        if (null == paint && null != defaultPaint) {
            paint = defaultPaint;
        }
        if (null == paint) {
            Log.d((String)TAG, (String)"getPaint: could not use default paint for the specific step! Using random Paint instead!");
            paint = this.getRandomPaint();
        }
        return paint;
    }

    private boolean isStepValid(int stepPos) {
        if (stepPos < 0 || stepPos > this.stepCount - 1) {
            throw new IllegalArgumentException("Invalid step position. " + stepPos + " is not a valid position! it should be between 0 and stepCount(" + this.stepCount + ")");
        }
        return true;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int desiredHeight = (int)Math.ceil(this.circleRadius * 1.3f * 2.0f + this.circlePaint.getStrokeWidth() + (float)this.getBottomIndicatorHeight());
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int width = widthMode == 0x40000000 ? widthSize : this.getSuggestedMinimumWidth();
        int height = heightMode == 0x40000000 ? heightSize : desiredHeight;
        this.setMeasuredDimension(width, height);
    }

    public int getStepCount() {
        return this.stepCount;
    }

    public void setStepCount(int stepCount) {
        if (stepCount < 2) {
            throw new IllegalArgumentException("stepCount must be >= 2");
        }
        this.stepCount = stepCount;
        this.currentStep = 0;
        this.compute();
        this.invalidate();
    }

    public int getCurrentStep() {
        return this.currentStep;
    }

    @UiThread
    public void setCurrentStep(int currentStep) {
        if (currentStep < 0 || currentStep > this.stepCount) {
            throw new IllegalArgumentException("Invalid step value " + currentStep);
        }
        this.previousStep = this.currentStep;
        this.currentStep = currentStep;
        if (Build.VERSION.SDK_INT >= 11) {
            if (this.animatorSet != null) {
                this.animatorSet.cancel();
            }
            this.animatorSet = null;
            this.lineAnimator = null;
            this.indicatorAnimator = null;
            if (currentStep == this.previousStep + 1) {
                this.animatorSet = new AnimatorSet();
                this.lineAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animProgress", (float[])new float[]{1.0f, 0.0f});
                this.checkAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animCheckRadius", (float[])new float[]{this.indicatorRadius, this.checkRadius * 1.3f, this.checkRadius});
                this.animIndicatorRadius = 0.0f;
                this.indicatorAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animIndicatorRadius", (float[])new float[]{0.0f, this.indicatorRadius * 1.4f, this.indicatorRadius});
                this.animatorSet.play((Animator)this.lineAnimator).with((Animator)this.checkAnimator).before((Animator)this.indicatorAnimator);
            } else if (currentStep == this.previousStep - 1) {
                this.animatorSet = new AnimatorSet();
                this.indicatorAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animIndicatorRadius", (float[])new float[]{this.indicatorRadius, 0.0f});
                this.animProgress = 1.0f;
                this.lineDoneAnimatedPaint.setPathEffect(null);
                this.lineAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animProgress", (float[])new float[]{0.0f, 1.0f});
                this.animCheckRadius = this.checkRadius;
                this.checkAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"animCheckRadius", (float[])new float[]{this.checkRadius, this.indicatorRadius});
                this.animatorSet.playSequentially(new Animator[]{this.indicatorAnimator, this.lineAnimator, this.checkAnimator});
            }
            if (this.animatorSet != null) {
                this.lineAnimator.setDuration((long)Math.min(500, this.animDuration));
                this.lineAnimator.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                this.indicatorAnimator.setDuration(this.lineAnimator.getDuration() / 2L);
                this.checkAnimator.setDuration(this.lineAnimator.getDuration() / 2L);
                this.animatorSet.start();
            }
        }
        this.invalidate();
    }

    public void setAnimProgress(float animProgress) {
        this.animProgress = animProgress;
        this.lineDoneAnimatedPaint.setPathEffect(StepperIndicator.createPathEffect(this.lineLength, animProgress, 0.0f));
        this.invalidate();
    }

    public void setAnimIndicatorRadius(float animIndicatorRadius) {
        this.animIndicatorRadius = animIndicatorRadius;
        this.invalidate();
    }

    public void setAnimCheckRadius(float animCheckRadius) {
        this.animCheckRadius = animCheckRadius;
        this.invalidate();
    }

    public void setViewPager(ViewPager pager) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.setViewPager(pager, pager.getAdapter().getCount());
    }

    public void setViewPager(ViewPager pager, boolean keepLastPage) {
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.setViewPager(pager, pager.getAdapter().getCount() - (keepLastPage ? 1 : 0));
    }

    public void setViewPager(ViewPager pager, int stepCount) {
        if (this.pager == pager) {
            return;
        }
        if (this.pager != null) {
            pager.removeOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        }
        if (pager.getAdapter() == null) {
            throw new IllegalStateException("ViewPager does not have adapter instance.");
        }
        this.pager = pager;
        this.stepCount = stepCount;
        this.currentStep = 0;
        pager.addOnPageChangeListener((ViewPager.OnPageChangeListener)this);
        this.invalidate();
    }

    public void addOnStepClickListener(OnStepClickListener listener) {
        this.onStepClickListeners.add(listener);
    }

    public void removeOnStepClickListener(OnStepClickListener listener) {
        this.onStepClickListeners.remove(listener);
    }

    public void clearOnStepClickListeners() {
        this.onStepClickListeners.clear();
    }

    public boolean isOnStepClickListenerAvailable() {
        return null != this.onStepClickListeners && !this.onStepClickListeners.isEmpty();
    }

    public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
    }

    public void onPageSelected(int position) {
        this.setCurrentStep(position);
    }

    public void onPageScrollStateChanged(int state) {
    }

    public void onRestoreInstanceState(Parcelable state) {
        SavedState savedState = (SavedState)state;
        super.onRestoreInstanceState(savedState.getSuperState());
        this.currentStep = savedState.mCurrentStep;
        this.requestLayout();
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState savedState = new SavedState(superState);
        savedState.mCurrentStep = this.currentStep;
        return savedState;
    }

    private static class SavedState
    extends View.BaseSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };
        private int mCurrentStep;

        public SavedState(Parcelable superState) {
            super(superState);
        }

        private SavedState(Parcel in) {
            super(in);
            this.mCurrentStep = in.readInt();
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.mCurrentStep);
        }
    }

    public static interface OnStepClickListener {
        public void onStepClicked(int var1);
    }
}

