package com.github.badoualy.telegram.tl.api;

import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.api.account.TLAuthorizations;
import com.github.badoualy.telegram.tl.api.account.TLNoPassword;
import com.github.badoualy.telegram.tl.api.account.TLPassword;
import com.github.badoualy.telegram.tl.api.account.TLPasswordInputSettings;
import com.github.badoualy.telegram.tl.api.account.TLPasswordSettings;
import com.github.badoualy.telegram.tl.api.account.TLPrivacyRules;
import com.github.badoualy.telegram.tl.api.account.TLTmpPassword;
import com.github.badoualy.telegram.tl.api.auth.TLCheckedPhone;
import com.github.badoualy.telegram.tl.api.auth.TLCodeTypeCall;
import com.github.badoualy.telegram.tl.api.auth.TLCodeTypeFlashCall;
import com.github.badoualy.telegram.tl.api.auth.TLCodeTypeSms;
import com.github.badoualy.telegram.tl.api.auth.TLExportedAuthorization;
import com.github.badoualy.telegram.tl.api.auth.TLPasswordRecovery;
import com.github.badoualy.telegram.tl.api.auth.TLSentCode;
import com.github.badoualy.telegram.tl.api.auth.TLSentCodeTypeApp;
import com.github.badoualy.telegram.tl.api.auth.TLSentCodeTypeCall;
import com.github.badoualy.telegram.tl.api.auth.TLSentCodeTypeFlashCall;
import com.github.badoualy.telegram.tl.api.auth.TLSentCodeTypeSms;
import com.github.badoualy.telegram.tl.api.channels.TLChannelParticipants;
import com.github.badoualy.telegram.tl.api.contacts.TLBlocked;
import com.github.badoualy.telegram.tl.api.contacts.TLBlockedSlice;
import com.github.badoualy.telegram.tl.api.contacts.TLContacts;
import com.github.badoualy.telegram.tl.api.contacts.TLContactsNotModified;
import com.github.badoualy.telegram.tl.api.contacts.TLFound;
import com.github.badoualy.telegram.tl.api.contacts.TLImportedContacts;
import com.github.badoualy.telegram.tl.api.contacts.TLLink;
import com.github.badoualy.telegram.tl.api.contacts.TLResolvedPeer;
import com.github.badoualy.telegram.tl.api.contacts.TLTopPeers;
import com.github.badoualy.telegram.tl.api.contacts.TLTopPeersNotModified;
import com.github.badoualy.telegram.tl.api.help.TLAppUpdate;
import com.github.badoualy.telegram.tl.api.help.TLInviteText;
import com.github.badoualy.telegram.tl.api.help.TLNoAppUpdate;
import com.github.badoualy.telegram.tl.api.help.TLSupport;
import com.github.badoualy.telegram.tl.api.help.TLTermsOfService;
import com.github.badoualy.telegram.tl.api.messages.TLAffectedHistory;
import com.github.badoualy.telegram.tl.api.messages.TLAffectedMessages;
import com.github.badoualy.telegram.tl.api.messages.TLAllStickers;
import com.github.badoualy.telegram.tl.api.messages.TLAllStickersNotModified;
import com.github.badoualy.telegram.tl.api.messages.TLArchivedStickers;
import com.github.badoualy.telegram.tl.api.messages.TLBotCallbackAnswer;
import com.github.badoualy.telegram.tl.api.messages.TLBotResults;
import com.github.badoualy.telegram.tl.api.messages.TLChannelMessages;
import com.github.badoualy.telegram.tl.api.messages.TLChats;
import com.github.badoualy.telegram.tl.api.messages.TLChatsSlice;
import com.github.badoualy.telegram.tl.api.messages.TLDhConfig;
import com.github.badoualy.telegram.tl.api.messages.TLDhConfigNotModified;
import com.github.badoualy.telegram.tl.api.messages.TLDialogs;
import com.github.badoualy.telegram.tl.api.messages.TLDialogsSlice;
import com.github.badoualy.telegram.tl.api.messages.TLFeaturedStickers;
import com.github.badoualy.telegram.tl.api.messages.TLFeaturedStickersNotModified;
import com.github.badoualy.telegram.tl.api.messages.TLFoundGifs;
import com.github.badoualy.telegram.tl.api.messages.TLHighScores;
import com.github.badoualy.telegram.tl.api.messages.TLMessageEditData;
import com.github.badoualy.telegram.tl.api.messages.TLMessages;
import com.github.badoualy.telegram.tl.api.messages.TLMessagesSlice;
import com.github.badoualy.telegram.tl.api.messages.TLPeerDialogs;
import com.github.badoualy.telegram.tl.api.messages.TLRecentStickers;
import com.github.badoualy.telegram.tl.api.messages.TLRecentStickersNotModified;
import com.github.badoualy.telegram.tl.api.messages.TLSavedGifs;
import com.github.badoualy.telegram.tl.api.messages.TLSavedGifsNotModified;
import com.github.badoualy.telegram.tl.api.messages.TLSentEncryptedFile;
import com.github.badoualy.telegram.tl.api.messages.TLSentEncryptedMessage;
import com.github.badoualy.telegram.tl.api.messages.TLStickerSetInstallResultArchive;
import com.github.badoualy.telegram.tl.api.messages.TLStickerSetInstallResultSuccess;
import com.github.badoualy.telegram.tl.api.messages.TLStickers;
import com.github.badoualy.telegram.tl.api.messages.TLStickersNotModified;
import com.github.badoualy.telegram.tl.api.payments.TLPaymentForm;
import com.github.badoualy.telegram.tl.api.payments.TLPaymentReceipt;
import com.github.badoualy.telegram.tl.api.payments.TLPaymentResult;
import com.github.badoualy.telegram.tl.api.payments.TLPaymentVerficationNeeded;
import com.github.badoualy.telegram.tl.api.payments.TLSavedInfo;
import com.github.badoualy.telegram.tl.api.payments.TLValidatedRequestedInfo;
import com.github.badoualy.telegram.tl.api.photos.TLPhotos;
import com.github.badoualy.telegram.tl.api.photos.TLPhotosSlice;
import com.github.badoualy.telegram.tl.api.storage.TLFileGif;
import com.github.badoualy.telegram.tl.api.storage.TLFileJpeg;
import com.github.badoualy.telegram.tl.api.storage.TLFileMov;
import com.github.badoualy.telegram.tl.api.storage.TLFileMp3;
import com.github.badoualy.telegram.tl.api.storage.TLFileMp4;
import com.github.badoualy.telegram.tl.api.storage.TLFilePartial;
import com.github.badoualy.telegram.tl.api.storage.TLFilePdf;
import com.github.badoualy.telegram.tl.api.storage.TLFilePng;
import com.github.badoualy.telegram.tl.api.storage.TLFileUnknown;
import com.github.badoualy.telegram.tl.api.storage.TLFileWebp;
import com.github.badoualy.telegram.tl.api.updates.TLChannelDifference;
import com.github.badoualy.telegram.tl.api.updates.TLChannelDifferenceEmpty;
import com.github.badoualy.telegram.tl.api.updates.TLChannelDifferenceTooLong;
import com.github.badoualy.telegram.tl.api.updates.TLDifference;
import com.github.badoualy.telegram.tl.api.updates.TLDifferenceEmpty;
import com.github.badoualy.telegram.tl.api.updates.TLDifferenceSlice;
import com.github.badoualy.telegram.tl.api.updates.TLDifferenceTooLong;
import com.github.badoualy.telegram.tl.api.updates.TLState;
import com.github.badoualy.telegram.tl.api.upload.TLCdnFile;
import com.github.badoualy.telegram.tl.api.upload.TLCdnFileReuploadNeeded;
import com.github.badoualy.telegram.tl.api.upload.TLFile;
import com.github.badoualy.telegram.tl.api.upload.TLFileCdnRedirect;
import com.github.badoualy.telegram.tl.api.upload.TLWebFile;

/**
 * @author Yannick Badoual yann.badoual@gmail.com
 * @see <a href="http://github.com/badoualy/kotlogram">http://github.com/badoualy/kotlogram</a>
 */
@SuppressWarnings("unused")
public class TLApiContext extends TLContext {

    private static TLApiContext instance;

    public TLApiContext() {
        super(543);
    }

    public static TLApiContext getInstance() {
        if (instance == null) {
            instance = new TLApiContext();
        }
        return instance;
    }

    @Override
    public void init() {
        registerClass(TLAuthorizations.CONSTRUCTOR_ID, TLAuthorizations.class);
        registerClass(TLNoPassword.CONSTRUCTOR_ID, TLNoPassword.class);
        registerClass(TLPassword.CONSTRUCTOR_ID, TLPassword.class);
        registerClass(TLPasswordInputSettings.CONSTRUCTOR_ID, TLPasswordInputSettings.class);
        registerClass(TLPasswordSettings.CONSTRUCTOR_ID, TLPasswordSettings.class);
        registerClass(TLPrivacyRules.CONSTRUCTOR_ID, TLPrivacyRules.class);
        registerClass(TLTmpPassword.CONSTRUCTOR_ID, TLTmpPassword.class);
        registerClass(TLAccountDaysTTL.CONSTRUCTOR_ID, TLAccountDaysTTL.class);
        registerClass(com.github.badoualy.telegram.tl.api.auth.TLAuthorization.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.auth.TLAuthorization.class);
        registerClass(TLCheckedPhone.CONSTRUCTOR_ID, TLCheckedPhone.class);
        registerClass(TLCodeTypeCall.CONSTRUCTOR_ID, TLCodeTypeCall.class);
        registerClass(TLCodeTypeFlashCall.CONSTRUCTOR_ID, TLCodeTypeFlashCall.class);
        registerClass(TLCodeTypeSms.CONSTRUCTOR_ID, TLCodeTypeSms.class);
        registerClass(TLExportedAuthorization.CONSTRUCTOR_ID, TLExportedAuthorization.class);
        registerClass(TLPasswordRecovery.CONSTRUCTOR_ID, TLPasswordRecovery.class);
        registerClass(TLSentCode.CONSTRUCTOR_ID, TLSentCode.class);
        registerClass(TLSentCodeTypeApp.CONSTRUCTOR_ID, TLSentCodeTypeApp.class);
        registerClass(TLSentCodeTypeCall.CONSTRUCTOR_ID, TLSentCodeTypeCall.class);
        registerClass(TLSentCodeTypeFlashCall.CONSTRUCTOR_ID, TLSentCodeTypeFlashCall.class);
        registerClass(TLSentCodeTypeSms.CONSTRUCTOR_ID, TLSentCodeTypeSms.class);
        registerClass(TLAuthorization.CONSTRUCTOR_ID, TLAuthorization.class);
        registerClass(TLBotCommand.CONSTRUCTOR_ID, TLBotCommand.class);
        registerClass(TLBotInfo.CONSTRUCTOR_ID, TLBotInfo.class);
        registerClass(TLBotInlineMediaResult.CONSTRUCTOR_ID, TLBotInlineMediaResult.class);
        registerClass(TLBotInlineMessageMediaAuto.CONSTRUCTOR_ID, TLBotInlineMessageMediaAuto.class);
        registerClass(TLBotInlineMessageMediaContact.CONSTRUCTOR_ID, TLBotInlineMessageMediaContact.class);
        registerClass(TLBotInlineMessageMediaGeo.CONSTRUCTOR_ID, TLBotInlineMessageMediaGeo.class);
        registerClass(TLBotInlineMessageMediaVenue.CONSTRUCTOR_ID, TLBotInlineMessageMediaVenue.class);
        registerClass(TLBotInlineMessageText.CONSTRUCTOR_ID, TLBotInlineMessageText.class);
        registerClass(TLBotInlineResult.CONSTRUCTOR_ID, TLBotInlineResult.class);
        registerClass(TLCdnConfig.CONSTRUCTOR_ID, TLCdnConfig.class);
        registerClass(TLCdnPublicKey.CONSTRUCTOR_ID, TLCdnPublicKey.class);
        registerClass(TLChannel.CONSTRUCTOR_ID, TLChannel.class);
        registerClass(TLChannelForbidden.CONSTRUCTOR_ID, TLChannelForbidden.class);
        registerClass(TLChannelFull.CONSTRUCTOR_ID, TLChannelFull.class);
        registerClass(TLChannelMessagesFilter.CONSTRUCTOR_ID, TLChannelMessagesFilter.class);
        registerClass(TLChannelMessagesFilterEmpty.CONSTRUCTOR_ID, TLChannelMessagesFilterEmpty.class);
        registerClass(TLChannelParticipant.CONSTRUCTOR_ID, TLChannelParticipant.class);
        registerClass(TLChannelParticipantCreator.CONSTRUCTOR_ID, TLChannelParticipantCreator.class);
        registerClass(TLChannelParticipantEditor.CONSTRUCTOR_ID, TLChannelParticipantEditor.class);
        registerClass(TLChannelParticipantKicked.CONSTRUCTOR_ID, TLChannelParticipantKicked.class);
        registerClass(TLChannelParticipantModerator.CONSTRUCTOR_ID, TLChannelParticipantModerator.class);
        registerClass(TLChannelParticipantSelf.CONSTRUCTOR_ID, TLChannelParticipantSelf.class);
        registerClass(TLChannelParticipantsAdmins.CONSTRUCTOR_ID, TLChannelParticipantsAdmins.class);
        registerClass(TLChannelParticipantsBots.CONSTRUCTOR_ID, TLChannelParticipantsBots.class);
        registerClass(TLChannelParticipantsKicked.CONSTRUCTOR_ID, TLChannelParticipantsKicked.class);
        registerClass(TLChannelParticipantsRecent.CONSTRUCTOR_ID, TLChannelParticipantsRecent.class);
        registerClass(TLChannelRoleEditor.CONSTRUCTOR_ID, TLChannelRoleEditor.class);
        registerClass(TLChannelRoleEmpty.CONSTRUCTOR_ID, TLChannelRoleEmpty.class);
        registerClass(TLChannelRoleModerator.CONSTRUCTOR_ID, TLChannelRoleModerator.class);
        registerClass(com.github.badoualy.telegram.tl.api.channels.TLChannelParticipant.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.channels.TLChannelParticipant.class);
        registerClass(TLChannelParticipants.CONSTRUCTOR_ID, TLChannelParticipants.class);
        registerClass(TLChat.CONSTRUCTOR_ID, TLChat.class);
        registerClass(TLChatEmpty.CONSTRUCTOR_ID, TLChatEmpty.class);
        registerClass(TLChatForbidden.CONSTRUCTOR_ID, TLChatForbidden.class);
        registerClass(TLChatFull.CONSTRUCTOR_ID, TLChatFull.class);
        registerClass(TLChatInvite.CONSTRUCTOR_ID, TLChatInvite.class);
        registerClass(TLChatInviteAlready.CONSTRUCTOR_ID, TLChatInviteAlready.class);
        registerClass(TLChatInviteEmpty.CONSTRUCTOR_ID, TLChatInviteEmpty.class);
        registerClass(TLChatInviteExported.CONSTRUCTOR_ID, TLChatInviteExported.class);
        registerClass(TLChatParticipant.CONSTRUCTOR_ID, TLChatParticipant.class);
        registerClass(TLChatParticipantAdmin.CONSTRUCTOR_ID, TLChatParticipantAdmin.class);
        registerClass(TLChatParticipantCreator.CONSTRUCTOR_ID, TLChatParticipantCreator.class);
        registerClass(TLChatParticipants.CONSTRUCTOR_ID, TLChatParticipants.class);
        registerClass(TLChatParticipantsForbidden.CONSTRUCTOR_ID, TLChatParticipantsForbidden.class);
        registerClass(TLChatPhoto.CONSTRUCTOR_ID, TLChatPhoto.class);
        registerClass(TLChatPhotoEmpty.CONSTRUCTOR_ID, TLChatPhotoEmpty.class);
        registerClass(TLConfig.CONSTRUCTOR_ID, TLConfig.class);
        registerClass(TLContact.CONSTRUCTOR_ID, TLContact.class);
        registerClass(TLContactBlocked.CONSTRUCTOR_ID, TLContactBlocked.class);
        registerClass(TLContactLinkContact.CONSTRUCTOR_ID, TLContactLinkContact.class);
        registerClass(TLContactLinkHasPhone.CONSTRUCTOR_ID, TLContactLinkHasPhone.class);
        registerClass(TLContactLinkNone.CONSTRUCTOR_ID, TLContactLinkNone.class);
        registerClass(TLContactLinkUnknown.CONSTRUCTOR_ID, TLContactLinkUnknown.class);
        registerClass(TLContactStatus.CONSTRUCTOR_ID, TLContactStatus.class);
        registerClass(TLBlocked.CONSTRUCTOR_ID, TLBlocked.class);
        registerClass(TLBlockedSlice.CONSTRUCTOR_ID, TLBlockedSlice.class);
        registerClass(TLContacts.CONSTRUCTOR_ID, TLContacts.class);
        registerClass(TLContactsNotModified.CONSTRUCTOR_ID, TLContactsNotModified.class);
        registerClass(TLFound.CONSTRUCTOR_ID, TLFound.class);
        registerClass(TLImportedContacts.CONSTRUCTOR_ID, TLImportedContacts.class);
        registerClass(TLLink.CONSTRUCTOR_ID, TLLink.class);
        registerClass(TLResolvedPeer.CONSTRUCTOR_ID, TLResolvedPeer.class);
        registerClass(TLTopPeers.CONSTRUCTOR_ID, TLTopPeers.class);
        registerClass(TLTopPeersNotModified.CONSTRUCTOR_ID, TLTopPeersNotModified.class);
        registerClass(TLDataJSON.CONSTRUCTOR_ID, TLDataJSON.class);
        registerClass(TLDcOption.CONSTRUCTOR_ID, TLDcOption.class);
        registerClass(TLDialog.CONSTRUCTOR_ID, TLDialog.class);
        registerClass(TLDisabledFeature.CONSTRUCTOR_ID, TLDisabledFeature.class);
        registerClass(TLDocument.CONSTRUCTOR_ID, TLDocument.class);
        registerClass(TLDocumentAttributeAnimated.CONSTRUCTOR_ID, TLDocumentAttributeAnimated.class);
        registerClass(TLDocumentAttributeAudio.CONSTRUCTOR_ID, TLDocumentAttributeAudio.class);
        registerClass(TLDocumentAttributeFilename.CONSTRUCTOR_ID, TLDocumentAttributeFilename.class);
        registerClass(TLDocumentAttributeHasStickers.CONSTRUCTOR_ID, TLDocumentAttributeHasStickers.class);
        registerClass(TLDocumentAttributeImageSize.CONSTRUCTOR_ID, TLDocumentAttributeImageSize.class);
        registerClass(TLDocumentAttributeSticker.CONSTRUCTOR_ID, TLDocumentAttributeSticker.class);
        registerClass(TLDocumentAttributeVideo.CONSTRUCTOR_ID, TLDocumentAttributeVideo.class);
        registerClass(TLDocumentEmpty.CONSTRUCTOR_ID, TLDocumentEmpty.class);
        registerClass(TLDraftMessage.CONSTRUCTOR_ID, TLDraftMessage.class);
        registerClass(TLDraftMessageEmpty.CONSTRUCTOR_ID, TLDraftMessageEmpty.class);
        registerClass(TLEncryptedChat.CONSTRUCTOR_ID, TLEncryptedChat.class);
        registerClass(TLEncryptedChatDiscarded.CONSTRUCTOR_ID, TLEncryptedChatDiscarded.class);
        registerClass(TLEncryptedChatEmpty.CONSTRUCTOR_ID, TLEncryptedChatEmpty.class);
        registerClass(TLEncryptedChatRequested.CONSTRUCTOR_ID, TLEncryptedChatRequested.class);
        registerClass(TLEncryptedChatWaiting.CONSTRUCTOR_ID, TLEncryptedChatWaiting.class);
        registerClass(TLEncryptedFile.CONSTRUCTOR_ID, TLEncryptedFile.class);
        registerClass(TLEncryptedFileEmpty.CONSTRUCTOR_ID, TLEncryptedFileEmpty.class);
        registerClass(TLEncryptedMessage.CONSTRUCTOR_ID, TLEncryptedMessage.class);
        registerClass(TLEncryptedMessageService.CONSTRUCTOR_ID, TLEncryptedMessageService.class);
        registerClass(TLExportedMessageLink.CONSTRUCTOR_ID, TLExportedMessageLink.class);
        registerClass(TLFileLocation.CONSTRUCTOR_ID, TLFileLocation.class);
        registerClass(TLFileLocationUnavailable.CONSTRUCTOR_ID, TLFileLocationUnavailable.class);
        registerClass(TLFoundGif.CONSTRUCTOR_ID, TLFoundGif.class);
        registerClass(TLFoundGifCached.CONSTRUCTOR_ID, TLFoundGifCached.class);
        registerClass(TLGame.CONSTRUCTOR_ID, TLGame.class);
        registerClass(TLGeoPoint.CONSTRUCTOR_ID, TLGeoPoint.class);
        registerClass(TLGeoPointEmpty.CONSTRUCTOR_ID, TLGeoPointEmpty.class);
        registerClass(TLAppUpdate.CONSTRUCTOR_ID, TLAppUpdate.class);
        registerClass(TLInviteText.CONSTRUCTOR_ID, TLInviteText.class);
        registerClass(TLNoAppUpdate.CONSTRUCTOR_ID, TLNoAppUpdate.class);
        registerClass(TLSupport.CONSTRUCTOR_ID, TLSupport.class);
        registerClass(TLTermsOfService.CONSTRUCTOR_ID, TLTermsOfService.class);
        registerClass(TLHighScore.CONSTRUCTOR_ID, TLHighScore.class);
        registerClass(TLImportedContact.CONSTRUCTOR_ID, TLImportedContact.class);
        registerClass(TLInlineBotSwitchPM.CONSTRUCTOR_ID, TLInlineBotSwitchPM.class);
        registerClass(TLInputAppEvent.CONSTRUCTOR_ID, TLInputAppEvent.class);
        registerClass(TLInputBotInlineMessageGame.CONSTRUCTOR_ID, TLInputBotInlineMessageGame.class);
        registerClass(TLInputBotInlineMessageID.CONSTRUCTOR_ID, TLInputBotInlineMessageID.class);
        registerClass(TLInputBotInlineMessageMediaAuto.CONSTRUCTOR_ID, TLInputBotInlineMessageMediaAuto.class);
        registerClass(TLInputBotInlineMessageMediaContact.CONSTRUCTOR_ID, TLInputBotInlineMessageMediaContact.class);
        registerClass(TLInputBotInlineMessageMediaGeo.CONSTRUCTOR_ID, TLInputBotInlineMessageMediaGeo.class);
        registerClass(TLInputBotInlineMessageMediaVenue.CONSTRUCTOR_ID, TLInputBotInlineMessageMediaVenue.class);
        registerClass(TLInputBotInlineMessageText.CONSTRUCTOR_ID, TLInputBotInlineMessageText.class);
        registerClass(TLInputBotInlineResult.CONSTRUCTOR_ID, TLInputBotInlineResult.class);
        registerClass(TLInputBotInlineResultDocument.CONSTRUCTOR_ID, TLInputBotInlineResultDocument.class);
        registerClass(TLInputBotInlineResultGame.CONSTRUCTOR_ID, TLInputBotInlineResultGame.class);
        registerClass(TLInputBotInlineResultPhoto.CONSTRUCTOR_ID, TLInputBotInlineResultPhoto.class);
        registerClass(TLInputChannel.CONSTRUCTOR_ID, TLInputChannel.class);
        registerClass(TLInputChannelEmpty.CONSTRUCTOR_ID, TLInputChannelEmpty.class);
        registerClass(TLInputChatPhoto.CONSTRUCTOR_ID, TLInputChatPhoto.class);
        registerClass(TLInputChatPhotoEmpty.CONSTRUCTOR_ID, TLInputChatPhotoEmpty.class);
        registerClass(TLInputChatUploadedPhoto.CONSTRUCTOR_ID, TLInputChatUploadedPhoto.class);
        registerClass(TLInputDocument.CONSTRUCTOR_ID, TLInputDocument.class);
        registerClass(TLInputDocumentEmpty.CONSTRUCTOR_ID, TLInputDocumentEmpty.class);
        registerClass(TLInputDocumentFileLocation.CONSTRUCTOR_ID, TLInputDocumentFileLocation.class);
        registerClass(TLInputEncryptedChat.CONSTRUCTOR_ID, TLInputEncryptedChat.class);
        registerClass(TLInputEncryptedFile.CONSTRUCTOR_ID, TLInputEncryptedFile.class);
        registerClass(TLInputEncryptedFileBigUploaded.CONSTRUCTOR_ID, TLInputEncryptedFileBigUploaded.class);
        registerClass(TLInputEncryptedFileEmpty.CONSTRUCTOR_ID, TLInputEncryptedFileEmpty.class);
        registerClass(TLInputEncryptedFileLocation.CONSTRUCTOR_ID, TLInputEncryptedFileLocation.class);
        registerClass(TLInputEncryptedFileUploaded.CONSTRUCTOR_ID, TLInputEncryptedFileUploaded.class);
        registerClass(TLInputFile.CONSTRUCTOR_ID, TLInputFile.class);
        registerClass(TLInputFileBig.CONSTRUCTOR_ID, TLInputFileBig.class);
        registerClass(TLInputFileLocation.CONSTRUCTOR_ID, TLInputFileLocation.class);
        registerClass(TLInputGameID.CONSTRUCTOR_ID, TLInputGameID.class);
        registerClass(TLInputGameShortName.CONSTRUCTOR_ID, TLInputGameShortName.class);
        registerClass(TLInputGeoPoint.CONSTRUCTOR_ID, TLInputGeoPoint.class);
        registerClass(TLInputGeoPointEmpty.CONSTRUCTOR_ID, TLInputGeoPointEmpty.class);
        registerClass(TLInputMediaContact.CONSTRUCTOR_ID, TLInputMediaContact.class);
        registerClass(TLInputMediaDocument.CONSTRUCTOR_ID, TLInputMediaDocument.class);
        registerClass(TLInputMediaDocumentExternal.CONSTRUCTOR_ID, TLInputMediaDocumentExternal.class);
        registerClass(TLInputMediaEmpty.CONSTRUCTOR_ID, TLInputMediaEmpty.class);
        registerClass(TLInputMediaGame.CONSTRUCTOR_ID, TLInputMediaGame.class);
        registerClass(TLInputMediaGeoPoint.CONSTRUCTOR_ID, TLInputMediaGeoPoint.class);
        registerClass(TLInputMediaGifExternal.CONSTRUCTOR_ID, TLInputMediaGifExternal.class);
        registerClass(TLInputMediaInvoice.CONSTRUCTOR_ID, TLInputMediaInvoice.class);
        registerClass(TLInputMediaPhoto.CONSTRUCTOR_ID, TLInputMediaPhoto.class);
        registerClass(TLInputMediaPhotoExternal.CONSTRUCTOR_ID, TLInputMediaPhotoExternal.class);
        registerClass(TLInputMediaUploadedDocument.CONSTRUCTOR_ID, TLInputMediaUploadedDocument.class);
        registerClass(TLInputMediaUploadedPhoto.CONSTRUCTOR_ID, TLInputMediaUploadedPhoto.class);
        registerClass(TLInputMediaUploadedThumbDocument.CONSTRUCTOR_ID, TLInputMediaUploadedThumbDocument.class);
        registerClass(TLInputMediaVenue.CONSTRUCTOR_ID, TLInputMediaVenue.class);
        registerClass(TLInputMessageEntityMentionName.CONSTRUCTOR_ID, TLInputMessageEntityMentionName.class);
        registerClass(TLInputMessagesFilterChatPhotos.CONSTRUCTOR_ID, TLInputMessagesFilterChatPhotos.class);
        registerClass(TLInputMessagesFilterDocument.CONSTRUCTOR_ID, TLInputMessagesFilterDocument.class);
        registerClass(TLInputMessagesFilterEmpty.CONSTRUCTOR_ID, TLInputMessagesFilterEmpty.class);
        registerClass(TLInputMessagesFilterGif.CONSTRUCTOR_ID, TLInputMessagesFilterGif.class);
        registerClass(TLInputMessagesFilterMusic.CONSTRUCTOR_ID, TLInputMessagesFilterMusic.class);
        registerClass(TLInputMessagesFilterPhoneCalls.CONSTRUCTOR_ID, TLInputMessagesFilterPhoneCalls.class);
        registerClass(TLInputMessagesFilterPhotoVideo.CONSTRUCTOR_ID, TLInputMessagesFilterPhotoVideo.class);
        registerClass(TLInputMessagesFilterPhotoVideoDocuments.CONSTRUCTOR_ID,
                      TLInputMessagesFilterPhotoVideoDocuments.class);
        registerClass(TLInputMessagesFilterPhotos.CONSTRUCTOR_ID, TLInputMessagesFilterPhotos.class);
        registerClass(TLInputMessagesFilterRoundVideo.CONSTRUCTOR_ID, TLInputMessagesFilterRoundVideo.class);
        registerClass(TLInputMessagesFilterRoundVoice.CONSTRUCTOR_ID, TLInputMessagesFilterRoundVoice.class);
        registerClass(TLInputMessagesFilterUrl.CONSTRUCTOR_ID, TLInputMessagesFilterUrl.class);
        registerClass(TLInputMessagesFilterVideo.CONSTRUCTOR_ID, TLInputMessagesFilterVideo.class);
        registerClass(TLInputMessagesFilterVoice.CONSTRUCTOR_ID, TLInputMessagesFilterVoice.class);
        registerClass(TLInputNotifyAll.CONSTRUCTOR_ID, TLInputNotifyAll.class);
        registerClass(TLInputNotifyChats.CONSTRUCTOR_ID, TLInputNotifyChats.class);
        registerClass(TLInputNotifyPeer.CONSTRUCTOR_ID, TLInputNotifyPeer.class);
        registerClass(TLInputNotifyUsers.CONSTRUCTOR_ID, TLInputNotifyUsers.class);
        registerClass(TLInputPaymentCredentials.CONSTRUCTOR_ID, TLInputPaymentCredentials.class);
        registerClass(TLInputPaymentCredentialsSaved.CONSTRUCTOR_ID, TLInputPaymentCredentialsSaved.class);
        registerClass(TLInputPeerChannel.CONSTRUCTOR_ID, TLInputPeerChannel.class);
        registerClass(TLInputPeerChat.CONSTRUCTOR_ID, TLInputPeerChat.class);
        registerClass(TLInputPeerEmpty.CONSTRUCTOR_ID, TLInputPeerEmpty.class);
        registerClass(TLInputPeerNotifyEventsAll.CONSTRUCTOR_ID, TLInputPeerNotifyEventsAll.class);
        registerClass(TLInputPeerNotifyEventsEmpty.CONSTRUCTOR_ID, TLInputPeerNotifyEventsEmpty.class);
        registerClass(TLInputPeerNotifySettings.CONSTRUCTOR_ID, TLInputPeerNotifySettings.class);
        registerClass(TLInputPeerSelf.CONSTRUCTOR_ID, TLInputPeerSelf.class);
        registerClass(TLInputPeerUser.CONSTRUCTOR_ID, TLInputPeerUser.class);
        registerClass(TLInputPhoneCall.CONSTRUCTOR_ID, TLInputPhoneCall.class);
        registerClass(TLInputPhoneContact.CONSTRUCTOR_ID, TLInputPhoneContact.class);
        registerClass(TLInputPhoto.CONSTRUCTOR_ID, TLInputPhoto.class);
        registerClass(TLInputPhotoEmpty.CONSTRUCTOR_ID, TLInputPhotoEmpty.class);
        registerClass(TLInputPrivacyKeyChatInvite.CONSTRUCTOR_ID, TLInputPrivacyKeyChatInvite.class);
        registerClass(TLInputPrivacyKeyPhoneCall.CONSTRUCTOR_ID, TLInputPrivacyKeyPhoneCall.class);
        registerClass(TLInputPrivacyKeyStatusTimestamp.CONSTRUCTOR_ID, TLInputPrivacyKeyStatusTimestamp.class);
        registerClass(TLInputPrivacyValueAllowAll.CONSTRUCTOR_ID, TLInputPrivacyValueAllowAll.class);
        registerClass(TLInputPrivacyValueAllowContacts.CONSTRUCTOR_ID, TLInputPrivacyValueAllowContacts.class);
        registerClass(TLInputPrivacyValueAllowUsers.CONSTRUCTOR_ID, TLInputPrivacyValueAllowUsers.class);
        registerClass(TLInputPrivacyValueDisallowAll.CONSTRUCTOR_ID, TLInputPrivacyValueDisallowAll.class);
        registerClass(TLInputPrivacyValueDisallowContacts.CONSTRUCTOR_ID, TLInputPrivacyValueDisallowContacts.class);
        registerClass(TLInputPrivacyValueDisallowUsers.CONSTRUCTOR_ID, TLInputPrivacyValueDisallowUsers.class);
        registerClass(TLInputReportReasonOther.CONSTRUCTOR_ID, TLInputReportReasonOther.class);
        registerClass(TLInputReportReasonPornography.CONSTRUCTOR_ID, TLInputReportReasonPornography.class);
        registerClass(TLInputReportReasonSpam.CONSTRUCTOR_ID, TLInputReportReasonSpam.class);
        registerClass(TLInputReportReasonViolence.CONSTRUCTOR_ID, TLInputReportReasonViolence.class);
        registerClass(TLInputStickerSetEmpty.CONSTRUCTOR_ID, TLInputStickerSetEmpty.class);
        registerClass(TLInputStickerSetID.CONSTRUCTOR_ID, TLInputStickerSetID.class);
        registerClass(TLInputStickerSetShortName.CONSTRUCTOR_ID, TLInputStickerSetShortName.class);
        registerClass(TLInputStickeredMediaDocument.CONSTRUCTOR_ID, TLInputStickeredMediaDocument.class);
        registerClass(TLInputStickeredMediaPhoto.CONSTRUCTOR_ID, TLInputStickeredMediaPhoto.class);
        registerClass(TLInputUser.CONSTRUCTOR_ID, TLInputUser.class);
        registerClass(TLInputUserEmpty.CONSTRUCTOR_ID, TLInputUserEmpty.class);
        registerClass(TLInputUserSelf.CONSTRUCTOR_ID, TLInputUserSelf.class);
        registerClass(TLInputWebDocument.CONSTRUCTOR_ID, TLInputWebDocument.class);
        registerClass(TLInputWebFileLocation.CONSTRUCTOR_ID, TLInputWebFileLocation.class);
        registerClass(TLInvoice.CONSTRUCTOR_ID, TLInvoice.class);
        registerClass(TLKeyboardButton.CONSTRUCTOR_ID, TLKeyboardButton.class);
        registerClass(TLKeyboardButtonBuy.CONSTRUCTOR_ID, TLKeyboardButtonBuy.class);
        registerClass(TLKeyboardButtonCallback.CONSTRUCTOR_ID, TLKeyboardButtonCallback.class);
        registerClass(TLKeyboardButtonGame.CONSTRUCTOR_ID, TLKeyboardButtonGame.class);
        registerClass(TLKeyboardButtonRequestGeoLocation.CONSTRUCTOR_ID, TLKeyboardButtonRequestGeoLocation.class);
        registerClass(TLKeyboardButtonRequestPhone.CONSTRUCTOR_ID, TLKeyboardButtonRequestPhone.class);
        registerClass(TLKeyboardButtonRow.CONSTRUCTOR_ID, TLKeyboardButtonRow.class);
        registerClass(TLKeyboardButtonSwitchInline.CONSTRUCTOR_ID, TLKeyboardButtonSwitchInline.class);
        registerClass(TLKeyboardButtonUrl.CONSTRUCTOR_ID, TLKeyboardButtonUrl.class);
        registerClass(TLLabeledPrice.CONSTRUCTOR_ID, TLLabeledPrice.class);
        registerClass(TLMaskCoords.CONSTRUCTOR_ID, TLMaskCoords.class);
        registerClass(TLMessage.CONSTRUCTOR_ID, TLMessage.class);
        registerClass(TLMessageActionChannelCreate.CONSTRUCTOR_ID, TLMessageActionChannelCreate.class);
        registerClass(TLMessageActionChannelMigrateFrom.CONSTRUCTOR_ID, TLMessageActionChannelMigrateFrom.class);
        registerClass(TLMessageActionChatAddUser.CONSTRUCTOR_ID, TLMessageActionChatAddUser.class);
        registerClass(TLMessageActionChatCreate.CONSTRUCTOR_ID, TLMessageActionChatCreate.class);
        registerClass(TLMessageActionChatDeletePhoto.CONSTRUCTOR_ID, TLMessageActionChatDeletePhoto.class);
        registerClass(TLMessageActionChatDeleteUser.CONSTRUCTOR_ID, TLMessageActionChatDeleteUser.class);
        registerClass(TLMessageActionChatEditPhoto.CONSTRUCTOR_ID, TLMessageActionChatEditPhoto.class);
        registerClass(TLMessageActionChatEditTitle.CONSTRUCTOR_ID, TLMessageActionChatEditTitle.class);
        registerClass(TLMessageActionChatJoinedByLink.CONSTRUCTOR_ID, TLMessageActionChatJoinedByLink.class);
        registerClass(TLMessageActionChatMigrateTo.CONSTRUCTOR_ID, TLMessageActionChatMigrateTo.class);
        registerClass(TLMessageActionEmpty.CONSTRUCTOR_ID, TLMessageActionEmpty.class);
        registerClass(TLMessageActionGameScore.CONSTRUCTOR_ID, TLMessageActionGameScore.class);
        registerClass(TLMessageActionHistoryClear.CONSTRUCTOR_ID, TLMessageActionHistoryClear.class);
        registerClass(TLMessageActionPaymentSent.CONSTRUCTOR_ID, TLMessageActionPaymentSent.class);
        registerClass(TLMessageActionPaymentSentMe.CONSTRUCTOR_ID, TLMessageActionPaymentSentMe.class);
        registerClass(TLMessageActionPhoneCall.CONSTRUCTOR_ID, TLMessageActionPhoneCall.class);
        registerClass(TLMessageActionPinMessage.CONSTRUCTOR_ID, TLMessageActionPinMessage.class);
        registerClass(TLMessageEmpty.CONSTRUCTOR_ID, TLMessageEmpty.class);
        registerClass(TLMessageEntityBold.CONSTRUCTOR_ID, TLMessageEntityBold.class);
        registerClass(TLMessageEntityBotCommand.CONSTRUCTOR_ID, TLMessageEntityBotCommand.class);
        registerClass(TLMessageEntityCode.CONSTRUCTOR_ID, TLMessageEntityCode.class);
        registerClass(TLMessageEntityEmail.CONSTRUCTOR_ID, TLMessageEntityEmail.class);
        registerClass(TLMessageEntityHashtag.CONSTRUCTOR_ID, TLMessageEntityHashtag.class);
        registerClass(TLMessageEntityItalic.CONSTRUCTOR_ID, TLMessageEntityItalic.class);
        registerClass(TLMessageEntityMention.CONSTRUCTOR_ID, TLMessageEntityMention.class);
        registerClass(TLMessageEntityMentionName.CONSTRUCTOR_ID, TLMessageEntityMentionName.class);
        registerClass(TLMessageEntityPre.CONSTRUCTOR_ID, TLMessageEntityPre.class);
        registerClass(TLMessageEntityTextUrl.CONSTRUCTOR_ID, TLMessageEntityTextUrl.class);
        registerClass(TLMessageEntityUnknown.CONSTRUCTOR_ID, TLMessageEntityUnknown.class);
        registerClass(TLMessageEntityUrl.CONSTRUCTOR_ID, TLMessageEntityUrl.class);
        registerClass(TLMessageFwdHeader.CONSTRUCTOR_ID, TLMessageFwdHeader.class);
        registerClass(TLMessageMediaContact.CONSTRUCTOR_ID, TLMessageMediaContact.class);
        registerClass(TLMessageMediaDocument.CONSTRUCTOR_ID, TLMessageMediaDocument.class);
        registerClass(TLMessageMediaEmpty.CONSTRUCTOR_ID, TLMessageMediaEmpty.class);
        registerClass(TLMessageMediaGame.CONSTRUCTOR_ID, TLMessageMediaGame.class);
        registerClass(TLMessageMediaGeo.CONSTRUCTOR_ID, TLMessageMediaGeo.class);
        registerClass(TLMessageMediaInvoice.CONSTRUCTOR_ID, TLMessageMediaInvoice.class);
        registerClass(TLMessageMediaPhoto.CONSTRUCTOR_ID, TLMessageMediaPhoto.class);
        registerClass(TLMessageMediaUnsupported.CONSTRUCTOR_ID, TLMessageMediaUnsupported.class);
        registerClass(TLMessageMediaVenue.CONSTRUCTOR_ID, TLMessageMediaVenue.class);
        registerClass(TLMessageMediaWebPage.CONSTRUCTOR_ID, TLMessageMediaWebPage.class);
        registerClass(TLMessageRange.CONSTRUCTOR_ID, TLMessageRange.class);
        registerClass(TLMessageService.CONSTRUCTOR_ID, TLMessageService.class);
        registerClass(TLAffectedHistory.CONSTRUCTOR_ID, TLAffectedHistory.class);
        registerClass(TLAffectedMessages.CONSTRUCTOR_ID, TLAffectedMessages.class);
        registerClass(TLAllStickers.CONSTRUCTOR_ID, TLAllStickers.class);
        registerClass(TLAllStickersNotModified.CONSTRUCTOR_ID, TLAllStickersNotModified.class);
        registerClass(TLArchivedStickers.CONSTRUCTOR_ID, TLArchivedStickers.class);
        registerClass(TLBotCallbackAnswer.CONSTRUCTOR_ID, TLBotCallbackAnswer.class);
        registerClass(TLBotResults.CONSTRUCTOR_ID, TLBotResults.class);
        registerClass(TLChannelMessages.CONSTRUCTOR_ID, TLChannelMessages.class);
        registerClass(com.github.badoualy.telegram.tl.api.messages.TLChatFull.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.messages.TLChatFull.class);
        registerClass(TLChats.CONSTRUCTOR_ID, TLChats.class);
        registerClass(TLChatsSlice.CONSTRUCTOR_ID, TLChatsSlice.class);
        registerClass(TLDhConfig.CONSTRUCTOR_ID, TLDhConfig.class);
        registerClass(TLDhConfigNotModified.CONSTRUCTOR_ID, TLDhConfigNotModified.class);
        registerClass(TLDialogs.CONSTRUCTOR_ID, TLDialogs.class);
        registerClass(TLDialogsSlice.CONSTRUCTOR_ID, TLDialogsSlice.class);
        registerClass(TLFeaturedStickers.CONSTRUCTOR_ID, TLFeaturedStickers.class);
        registerClass(TLFeaturedStickersNotModified.CONSTRUCTOR_ID, TLFeaturedStickersNotModified.class);
        registerClass(TLFoundGifs.CONSTRUCTOR_ID, TLFoundGifs.class);
        registerClass(TLHighScores.CONSTRUCTOR_ID, TLHighScores.class);
        registerClass(TLMessageEditData.CONSTRUCTOR_ID, TLMessageEditData.class);
        registerClass(TLMessages.CONSTRUCTOR_ID, TLMessages.class);
        registerClass(TLMessagesSlice.CONSTRUCTOR_ID, TLMessagesSlice.class);
        registerClass(TLPeerDialogs.CONSTRUCTOR_ID, TLPeerDialogs.class);
        registerClass(TLRecentStickers.CONSTRUCTOR_ID, TLRecentStickers.class);
        registerClass(TLRecentStickersNotModified.CONSTRUCTOR_ID, TLRecentStickersNotModified.class);
        registerClass(TLSavedGifs.CONSTRUCTOR_ID, TLSavedGifs.class);
        registerClass(TLSavedGifsNotModified.CONSTRUCTOR_ID, TLSavedGifsNotModified.class);
        registerClass(TLSentEncryptedFile.CONSTRUCTOR_ID, TLSentEncryptedFile.class);
        registerClass(TLSentEncryptedMessage.CONSTRUCTOR_ID, TLSentEncryptedMessage.class);
        registerClass(com.github.badoualy.telegram.tl.api.messages.TLStickerSet.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.messages.TLStickerSet.class);
        registerClass(TLStickerSetInstallResultArchive.CONSTRUCTOR_ID, TLStickerSetInstallResultArchive.class);
        registerClass(TLStickerSetInstallResultSuccess.CONSTRUCTOR_ID, TLStickerSetInstallResultSuccess.class);
        registerClass(TLStickers.CONSTRUCTOR_ID, TLStickers.class);
        registerClass(TLStickersNotModified.CONSTRUCTOR_ID, TLStickersNotModified.class);
        registerClass(TLNearestDc.CONSTRUCTOR_ID, TLNearestDc.class);
        registerClass(TLNotifyAll.CONSTRUCTOR_ID, TLNotifyAll.class);
        registerClass(TLNotifyChats.CONSTRUCTOR_ID, TLNotifyChats.class);
        registerClass(TLNotifyPeer.CONSTRUCTOR_ID, TLNotifyPeer.class);
        registerClass(TLNotifyUsers.CONSTRUCTOR_ID, TLNotifyUsers.class);
        registerClass(TLPageBlockAnchor.CONSTRUCTOR_ID, TLPageBlockAnchor.class);
        registerClass(TLPageBlockAuthorDate.CONSTRUCTOR_ID, TLPageBlockAuthorDate.class);
        registerClass(TLPageBlockBlockquote.CONSTRUCTOR_ID, TLPageBlockBlockquote.class);
        registerClass(TLPageBlockChannel.CONSTRUCTOR_ID, TLPageBlockChannel.class);
        registerClass(TLPageBlockCollage.CONSTRUCTOR_ID, TLPageBlockCollage.class);
        registerClass(TLPageBlockCover.CONSTRUCTOR_ID, TLPageBlockCover.class);
        registerClass(TLPageBlockDivider.CONSTRUCTOR_ID, TLPageBlockDivider.class);
        registerClass(TLPageBlockEmbed.CONSTRUCTOR_ID, TLPageBlockEmbed.class);
        registerClass(TLPageBlockEmbedPost.CONSTRUCTOR_ID, TLPageBlockEmbedPost.class);
        registerClass(TLPageBlockFooter.CONSTRUCTOR_ID, TLPageBlockFooter.class);
        registerClass(TLPageBlockHeader.CONSTRUCTOR_ID, TLPageBlockHeader.class);
        registerClass(TLPageBlockList.CONSTRUCTOR_ID, TLPageBlockList.class);
        registerClass(TLPageBlockParagraph.CONSTRUCTOR_ID, TLPageBlockParagraph.class);
        registerClass(TLPageBlockPhoto.CONSTRUCTOR_ID, TLPageBlockPhoto.class);
        registerClass(TLPageBlockPreformatted.CONSTRUCTOR_ID, TLPageBlockPreformatted.class);
        registerClass(TLPageBlockPullquote.CONSTRUCTOR_ID, TLPageBlockPullquote.class);
        registerClass(TLPageBlockSlideshow.CONSTRUCTOR_ID, TLPageBlockSlideshow.class);
        registerClass(TLPageBlockSubheader.CONSTRUCTOR_ID, TLPageBlockSubheader.class);
        registerClass(TLPageBlockSubtitle.CONSTRUCTOR_ID, TLPageBlockSubtitle.class);
        registerClass(TLPageBlockTitle.CONSTRUCTOR_ID, TLPageBlockTitle.class);
        registerClass(TLPageBlockUnsupported.CONSTRUCTOR_ID, TLPageBlockUnsupported.class);
        registerClass(TLPageBlockVideo.CONSTRUCTOR_ID, TLPageBlockVideo.class);
        registerClass(TLPageFull.CONSTRUCTOR_ID, TLPageFull.class);
        registerClass(TLPagePart.CONSTRUCTOR_ID, TLPagePart.class);
        registerClass(TLPaymentCharge.CONSTRUCTOR_ID, TLPaymentCharge.class);
        registerClass(TLPaymentRequestedInfo.CONSTRUCTOR_ID, TLPaymentRequestedInfo.class);
        registerClass(TLPaymentSavedCredentialsCard.CONSTRUCTOR_ID, TLPaymentSavedCredentialsCard.class);
        registerClass(TLPaymentForm.CONSTRUCTOR_ID, TLPaymentForm.class);
        registerClass(TLPaymentReceipt.CONSTRUCTOR_ID, TLPaymentReceipt.class);
        registerClass(TLPaymentResult.CONSTRUCTOR_ID, TLPaymentResult.class);
        registerClass(TLPaymentVerficationNeeded.CONSTRUCTOR_ID, TLPaymentVerficationNeeded.class);
        registerClass(TLSavedInfo.CONSTRUCTOR_ID, TLSavedInfo.class);
        registerClass(TLValidatedRequestedInfo.CONSTRUCTOR_ID, TLValidatedRequestedInfo.class);
        registerClass(TLPeerChannel.CONSTRUCTOR_ID, TLPeerChannel.class);
        registerClass(TLPeerChat.CONSTRUCTOR_ID, TLPeerChat.class);
        registerClass(TLPeerNotifyEventsAll.CONSTRUCTOR_ID, TLPeerNotifyEventsAll.class);
        registerClass(TLPeerNotifyEventsEmpty.CONSTRUCTOR_ID, TLPeerNotifyEventsEmpty.class);
        registerClass(TLPeerNotifySettings.CONSTRUCTOR_ID, TLPeerNotifySettings.class);
        registerClass(TLPeerNotifySettingsEmpty.CONSTRUCTOR_ID, TLPeerNotifySettingsEmpty.class);
        registerClass(TLPeerSettings.CONSTRUCTOR_ID, TLPeerSettings.class);
        registerClass(TLPeerUser.CONSTRUCTOR_ID, TLPeerUser.class);
        registerClass(com.github.badoualy.telegram.tl.api.phone.TLPhoneCall.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.phone.TLPhoneCall.class);
        registerClass(TLPhoneCall.CONSTRUCTOR_ID, TLPhoneCall.class);
        registerClass(TLPhoneCallAccepted.CONSTRUCTOR_ID, TLPhoneCallAccepted.class);
        registerClass(TLPhoneCallDiscardReasonBusy.CONSTRUCTOR_ID, TLPhoneCallDiscardReasonBusy.class);
        registerClass(TLPhoneCallDiscardReasonDisconnect.CONSTRUCTOR_ID, TLPhoneCallDiscardReasonDisconnect.class);
        registerClass(TLPhoneCallDiscardReasonHangup.CONSTRUCTOR_ID, TLPhoneCallDiscardReasonHangup.class);
        registerClass(TLPhoneCallDiscardReasonMissed.CONSTRUCTOR_ID, TLPhoneCallDiscardReasonMissed.class);
        registerClass(TLPhoneCallDiscarded.CONSTRUCTOR_ID, TLPhoneCallDiscarded.class);
        registerClass(TLPhoneCallEmpty.CONSTRUCTOR_ID, TLPhoneCallEmpty.class);
        registerClass(TLPhoneCallProtocol.CONSTRUCTOR_ID, TLPhoneCallProtocol.class);
        registerClass(TLPhoneCallRequested.CONSTRUCTOR_ID, TLPhoneCallRequested.class);
        registerClass(TLPhoneCallWaiting.CONSTRUCTOR_ID, TLPhoneCallWaiting.class);
        registerClass(TLPhoneConnection.CONSTRUCTOR_ID, TLPhoneConnection.class);
        registerClass(TLPhoto.CONSTRUCTOR_ID, TLPhoto.class);
        registerClass(TLPhotoCachedSize.CONSTRUCTOR_ID, TLPhotoCachedSize.class);
        registerClass(TLPhotoEmpty.CONSTRUCTOR_ID, TLPhotoEmpty.class);
        registerClass(TLPhotoSize.CONSTRUCTOR_ID, TLPhotoSize.class);
        registerClass(TLPhotoSizeEmpty.CONSTRUCTOR_ID, TLPhotoSizeEmpty.class);
        registerClass(com.github.badoualy.telegram.tl.api.photos.TLPhoto.CONSTRUCTOR_ID,
                      com.github.badoualy.telegram.tl.api.photos.TLPhoto.class);
        registerClass(TLPhotos.CONSTRUCTOR_ID, TLPhotos.class);
        registerClass(TLPhotosSlice.CONSTRUCTOR_ID, TLPhotosSlice.class);
        registerClass(TLPostAddress.CONSTRUCTOR_ID, TLPostAddress.class);
        registerClass(TLPrivacyKeyChatInvite.CONSTRUCTOR_ID, TLPrivacyKeyChatInvite.class);
        registerClass(TLPrivacyKeyPhoneCall.CONSTRUCTOR_ID, TLPrivacyKeyPhoneCall.class);
        registerClass(TLPrivacyKeyStatusTimestamp.CONSTRUCTOR_ID, TLPrivacyKeyStatusTimestamp.class);
        registerClass(TLPrivacyValueAllowAll.CONSTRUCTOR_ID, TLPrivacyValueAllowAll.class);
        registerClass(TLPrivacyValueAllowContacts.CONSTRUCTOR_ID, TLPrivacyValueAllowContacts.class);
        registerClass(TLPrivacyValueAllowUsers.CONSTRUCTOR_ID, TLPrivacyValueAllowUsers.class);
        registerClass(TLPrivacyValueDisallowAll.CONSTRUCTOR_ID, TLPrivacyValueDisallowAll.class);
        registerClass(TLPrivacyValueDisallowContacts.CONSTRUCTOR_ID, TLPrivacyValueDisallowContacts.class);
        registerClass(TLPrivacyValueDisallowUsers.CONSTRUCTOR_ID, TLPrivacyValueDisallowUsers.class);
        registerClass(TLReceivedNotifyMessage.CONSTRUCTOR_ID, TLReceivedNotifyMessage.class);
        registerClass(TLReplyInlineMarkup.CONSTRUCTOR_ID, TLReplyInlineMarkup.class);
        registerClass(TLReplyKeyboardForceReply.CONSTRUCTOR_ID, TLReplyKeyboardForceReply.class);
        registerClass(TLReplyKeyboardHide.CONSTRUCTOR_ID, TLReplyKeyboardHide.class);
        registerClass(TLReplyKeyboardMarkup.CONSTRUCTOR_ID, TLReplyKeyboardMarkup.class);
        registerClass(TLSendMessageCancelAction.CONSTRUCTOR_ID, TLSendMessageCancelAction.class);
        registerClass(TLSendMessageChooseContactAction.CONSTRUCTOR_ID, TLSendMessageChooseContactAction.class);
        registerClass(TLSendMessageGamePlayAction.CONSTRUCTOR_ID, TLSendMessageGamePlayAction.class);
        registerClass(TLSendMessageGeoLocationAction.CONSTRUCTOR_ID, TLSendMessageGeoLocationAction.class);
        registerClass(TLSendMessageRecordAudioAction.CONSTRUCTOR_ID, TLSendMessageRecordAudioAction.class);
        registerClass(TLSendMessageRecordRoundAction.CONSTRUCTOR_ID, TLSendMessageRecordRoundAction.class);
        registerClass(TLSendMessageRecordVideoAction.CONSTRUCTOR_ID, TLSendMessageRecordVideoAction.class);
        registerClass(TLSendMessageTypingAction.CONSTRUCTOR_ID, TLSendMessageTypingAction.class);
        registerClass(TLSendMessageUploadAudioAction.CONSTRUCTOR_ID, TLSendMessageUploadAudioAction.class);
        registerClass(TLSendMessageUploadDocumentAction.CONSTRUCTOR_ID, TLSendMessageUploadDocumentAction.class);
        registerClass(TLSendMessageUploadPhotoAction.CONSTRUCTOR_ID, TLSendMessageUploadPhotoAction.class);
        registerClass(TLSendMessageUploadRoundAction.CONSTRUCTOR_ID, TLSendMessageUploadRoundAction.class);
        registerClass(TLSendMessageUploadVideoAction.CONSTRUCTOR_ID, TLSendMessageUploadVideoAction.class);
        registerClass(TLShippingOption.CONSTRUCTOR_ID, TLShippingOption.class);
        registerClass(TLStickerPack.CONSTRUCTOR_ID, TLStickerPack.class);
        registerClass(TLStickerSet.CONSTRUCTOR_ID, TLStickerSet.class);
        registerClass(TLStickerSetCovered.CONSTRUCTOR_ID, TLStickerSetCovered.class);
        registerClass(TLStickerSetMultiCovered.CONSTRUCTOR_ID, TLStickerSetMultiCovered.class);
        registerClass(TLFileGif.CONSTRUCTOR_ID, TLFileGif.class);
        registerClass(TLFileJpeg.CONSTRUCTOR_ID, TLFileJpeg.class);
        registerClass(TLFileMov.CONSTRUCTOR_ID, TLFileMov.class);
        registerClass(TLFileMp3.CONSTRUCTOR_ID, TLFileMp3.class);
        registerClass(TLFileMp4.CONSTRUCTOR_ID, TLFileMp4.class);
        registerClass(TLFilePartial.CONSTRUCTOR_ID, TLFilePartial.class);
        registerClass(TLFilePdf.CONSTRUCTOR_ID, TLFilePdf.class);
        registerClass(TLFilePng.CONSTRUCTOR_ID, TLFilePng.class);
        registerClass(TLFileUnknown.CONSTRUCTOR_ID, TLFileUnknown.class);
        registerClass(TLFileWebp.CONSTRUCTOR_ID, TLFileWebp.class);
        registerClass(TLTextBold.CONSTRUCTOR_ID, TLTextBold.class);
        registerClass(TLTextConcat.CONSTRUCTOR_ID, TLTextConcat.class);
        registerClass(TLTextEmail.CONSTRUCTOR_ID, TLTextEmail.class);
        registerClass(TLTextEmpty.CONSTRUCTOR_ID, TLTextEmpty.class);
        registerClass(TLTextFixed.CONSTRUCTOR_ID, TLTextFixed.class);
        registerClass(TLTextItalic.CONSTRUCTOR_ID, TLTextItalic.class);
        registerClass(TLTextPlain.CONSTRUCTOR_ID, TLTextPlain.class);
        registerClass(TLTextStrike.CONSTRUCTOR_ID, TLTextStrike.class);
        registerClass(TLTextUnderline.CONSTRUCTOR_ID, TLTextUnderline.class);
        registerClass(TLTextUrl.CONSTRUCTOR_ID, TLTextUrl.class);
        registerClass(TLTopPeer.CONSTRUCTOR_ID, TLTopPeer.class);
        registerClass(TLTopPeerCategoryBotsInline.CONSTRUCTOR_ID, TLTopPeerCategoryBotsInline.class);
        registerClass(TLTopPeerCategoryBotsPM.CONSTRUCTOR_ID, TLTopPeerCategoryBotsPM.class);
        registerClass(TLTopPeerCategoryChannels.CONSTRUCTOR_ID, TLTopPeerCategoryChannels.class);
        registerClass(TLTopPeerCategoryCorrespondents.CONSTRUCTOR_ID, TLTopPeerCategoryCorrespondents.class);
        registerClass(TLTopPeerCategoryGroups.CONSTRUCTOR_ID, TLTopPeerCategoryGroups.class);
        registerClass(TLTopPeerCategoryPeers.CONSTRUCTOR_ID, TLTopPeerCategoryPeers.class);
        registerClass(TLUpdateBotCallbackQuery.CONSTRUCTOR_ID, TLUpdateBotCallbackQuery.class);
        registerClass(TLUpdateBotInlineQuery.CONSTRUCTOR_ID, TLUpdateBotInlineQuery.class);
        registerClass(TLUpdateBotInlineSend.CONSTRUCTOR_ID, TLUpdateBotInlineSend.class);
        registerClass(TLUpdateBotPrecheckoutQuery.CONSTRUCTOR_ID, TLUpdateBotPrecheckoutQuery.class);
        registerClass(TLUpdateBotShippingQuery.CONSTRUCTOR_ID, TLUpdateBotShippingQuery.class);
        registerClass(TLUpdateBotWebhookJSON.CONSTRUCTOR_ID, TLUpdateBotWebhookJSON.class);
        registerClass(TLUpdateBotWebhookJSONQuery.CONSTRUCTOR_ID, TLUpdateBotWebhookJSONQuery.class);
        registerClass(TLUpdateChannel.CONSTRUCTOR_ID, TLUpdateChannel.class);
        registerClass(TLUpdateChannelMessageViews.CONSTRUCTOR_ID, TLUpdateChannelMessageViews.class);
        registerClass(TLUpdateChannelPinnedMessage.CONSTRUCTOR_ID, TLUpdateChannelPinnedMessage.class);
        registerClass(TLUpdateChannelTooLong.CONSTRUCTOR_ID, TLUpdateChannelTooLong.class);
        registerClass(TLUpdateChannelWebPage.CONSTRUCTOR_ID, TLUpdateChannelWebPage.class);
        registerClass(TLUpdateChatAdmins.CONSTRUCTOR_ID, TLUpdateChatAdmins.class);
        registerClass(TLUpdateChatParticipantAdd.CONSTRUCTOR_ID, TLUpdateChatParticipantAdd.class);
        registerClass(TLUpdateChatParticipantAdmin.CONSTRUCTOR_ID, TLUpdateChatParticipantAdmin.class);
        registerClass(TLUpdateChatParticipantDelete.CONSTRUCTOR_ID, TLUpdateChatParticipantDelete.class);
        registerClass(TLUpdateChatParticipants.CONSTRUCTOR_ID, TLUpdateChatParticipants.class);
        registerClass(TLUpdateChatUserTyping.CONSTRUCTOR_ID, TLUpdateChatUserTyping.class);
        registerClass(TLUpdateConfig.CONSTRUCTOR_ID, TLUpdateConfig.class);
        registerClass(TLUpdateContactLink.CONSTRUCTOR_ID, TLUpdateContactLink.class);
        registerClass(TLUpdateContactRegistered.CONSTRUCTOR_ID, TLUpdateContactRegistered.class);
        registerClass(TLUpdateDcOptions.CONSTRUCTOR_ID, TLUpdateDcOptions.class);
        registerClass(TLUpdateDeleteChannelMessages.CONSTRUCTOR_ID, TLUpdateDeleteChannelMessages.class);
        registerClass(TLUpdateDeleteMessages.CONSTRUCTOR_ID, TLUpdateDeleteMessages.class);
        registerClass(TLUpdateDialogPinned.CONSTRUCTOR_ID, TLUpdateDialogPinned.class);
        registerClass(TLUpdateDraftMessage.CONSTRUCTOR_ID, TLUpdateDraftMessage.class);
        registerClass(TLUpdateEditChannelMessage.CONSTRUCTOR_ID, TLUpdateEditChannelMessage.class);
        registerClass(TLUpdateEditMessage.CONSTRUCTOR_ID, TLUpdateEditMessage.class);
        registerClass(TLUpdateEncryptedChatTyping.CONSTRUCTOR_ID, TLUpdateEncryptedChatTyping.class);
        registerClass(TLUpdateEncryptedMessagesRead.CONSTRUCTOR_ID, TLUpdateEncryptedMessagesRead.class);
        registerClass(TLUpdateEncryption.CONSTRUCTOR_ID, TLUpdateEncryption.class);
        registerClass(TLUpdateInlineBotCallbackQuery.CONSTRUCTOR_ID, TLUpdateInlineBotCallbackQuery.class);
        registerClass(TLUpdateMessageID.CONSTRUCTOR_ID, TLUpdateMessageID.class);
        registerClass(TLUpdateNewChannelMessage.CONSTRUCTOR_ID, TLUpdateNewChannelMessage.class);
        registerClass(TLUpdateNewEncryptedMessage.CONSTRUCTOR_ID, TLUpdateNewEncryptedMessage.class);
        registerClass(TLUpdateNewMessage.CONSTRUCTOR_ID, TLUpdateNewMessage.class);
        registerClass(TLUpdateNewStickerSet.CONSTRUCTOR_ID, TLUpdateNewStickerSet.class);
        registerClass(TLUpdateNotifySettings.CONSTRUCTOR_ID, TLUpdateNotifySettings.class);
        registerClass(TLUpdatePhoneCall.CONSTRUCTOR_ID, TLUpdatePhoneCall.class);
        registerClass(TLUpdatePinnedDialogs.CONSTRUCTOR_ID, TLUpdatePinnedDialogs.class);
        registerClass(TLUpdatePrivacy.CONSTRUCTOR_ID, TLUpdatePrivacy.class);
        registerClass(TLUpdatePtsChanged.CONSTRUCTOR_ID, TLUpdatePtsChanged.class);
        registerClass(TLUpdateReadChannelInbox.CONSTRUCTOR_ID, TLUpdateReadChannelInbox.class);
        registerClass(TLUpdateReadChannelOutbox.CONSTRUCTOR_ID, TLUpdateReadChannelOutbox.class);
        registerClass(TLUpdateReadFeaturedStickers.CONSTRUCTOR_ID, TLUpdateReadFeaturedStickers.class);
        registerClass(TLUpdateReadHistoryInbox.CONSTRUCTOR_ID, TLUpdateReadHistoryInbox.class);
        registerClass(TLUpdateReadHistoryOutbox.CONSTRUCTOR_ID, TLUpdateReadHistoryOutbox.class);
        registerClass(TLUpdateReadMessagesContents.CONSTRUCTOR_ID, TLUpdateReadMessagesContents.class);
        registerClass(TLUpdateRecentStickers.CONSTRUCTOR_ID, TLUpdateRecentStickers.class);
        registerClass(TLUpdateSavedGifs.CONSTRUCTOR_ID, TLUpdateSavedGifs.class);
        registerClass(TLUpdateServiceNotification.CONSTRUCTOR_ID, TLUpdateServiceNotification.class);
        registerClass(TLUpdateShort.CONSTRUCTOR_ID, TLUpdateShort.class);
        registerClass(TLUpdateShortChatMessage.CONSTRUCTOR_ID, TLUpdateShortChatMessage.class);
        registerClass(TLUpdateShortMessage.CONSTRUCTOR_ID, TLUpdateShortMessage.class);
        registerClass(TLUpdateShortSentMessage.CONSTRUCTOR_ID, TLUpdateShortSentMessage.class);
        registerClass(TLUpdateStickerSets.CONSTRUCTOR_ID, TLUpdateStickerSets.class);
        registerClass(TLUpdateStickerSetsOrder.CONSTRUCTOR_ID, TLUpdateStickerSetsOrder.class);
        registerClass(TLUpdateUserBlocked.CONSTRUCTOR_ID, TLUpdateUserBlocked.class);
        registerClass(TLUpdateUserName.CONSTRUCTOR_ID, TLUpdateUserName.class);
        registerClass(TLUpdateUserPhone.CONSTRUCTOR_ID, TLUpdateUserPhone.class);
        registerClass(TLUpdateUserPhoto.CONSTRUCTOR_ID, TLUpdateUserPhoto.class);
        registerClass(TLUpdateUserStatus.CONSTRUCTOR_ID, TLUpdateUserStatus.class);
        registerClass(TLUpdateUserTyping.CONSTRUCTOR_ID, TLUpdateUserTyping.class);
        registerClass(TLUpdateWebPage.CONSTRUCTOR_ID, TLUpdateWebPage.class);
        registerClass(TLUpdates.CONSTRUCTOR_ID, TLUpdates.class);
        registerClass(TLChannelDifference.CONSTRUCTOR_ID, TLChannelDifference.class);
        registerClass(TLChannelDifferenceEmpty.CONSTRUCTOR_ID, TLChannelDifferenceEmpty.class);
        registerClass(TLChannelDifferenceTooLong.CONSTRUCTOR_ID, TLChannelDifferenceTooLong.class);
        registerClass(TLDifference.CONSTRUCTOR_ID, TLDifference.class);
        registerClass(TLDifferenceEmpty.CONSTRUCTOR_ID, TLDifferenceEmpty.class);
        registerClass(TLDifferenceSlice.CONSTRUCTOR_ID, TLDifferenceSlice.class);
        registerClass(TLDifferenceTooLong.CONSTRUCTOR_ID, TLDifferenceTooLong.class);
        registerClass(TLState.CONSTRUCTOR_ID, TLState.class);
        registerClass(TLUpdatesCombined.CONSTRUCTOR_ID, TLUpdatesCombined.class);
        registerClass(TLUpdatesTooLong.CONSTRUCTOR_ID, TLUpdatesTooLong.class);
        registerClass(TLCdnFile.CONSTRUCTOR_ID, TLCdnFile.class);
        registerClass(TLCdnFileReuploadNeeded.CONSTRUCTOR_ID, TLCdnFileReuploadNeeded.class);
        registerClass(TLFile.CONSTRUCTOR_ID, TLFile.class);
        registerClass(TLFileCdnRedirect.CONSTRUCTOR_ID, TLFileCdnRedirect.class);
        registerClass(TLWebFile.CONSTRUCTOR_ID, TLWebFile.class);
        registerClass(TLUser.CONSTRUCTOR_ID, TLUser.class);
        registerClass(TLUserEmpty.CONSTRUCTOR_ID, TLUserEmpty.class);
        registerClass(TLUserFull.CONSTRUCTOR_ID, TLUserFull.class);
        registerClass(TLUserProfilePhoto.CONSTRUCTOR_ID, TLUserProfilePhoto.class);
        registerClass(TLUserProfilePhotoEmpty.CONSTRUCTOR_ID, TLUserProfilePhotoEmpty.class);
        registerClass(TLUserStatusEmpty.CONSTRUCTOR_ID, TLUserStatusEmpty.class);
        registerClass(TLUserStatusLastMonth.CONSTRUCTOR_ID, TLUserStatusLastMonth.class);
        registerClass(TLUserStatusLastWeek.CONSTRUCTOR_ID, TLUserStatusLastWeek.class);
        registerClass(TLUserStatusOffline.CONSTRUCTOR_ID, TLUserStatusOffline.class);
        registerClass(TLUserStatusOnline.CONSTRUCTOR_ID, TLUserStatusOnline.class);
        registerClass(TLUserStatusRecently.CONSTRUCTOR_ID, TLUserStatusRecently.class);
        registerClass(TLWallPaper.CONSTRUCTOR_ID, TLWallPaper.class);
        registerClass(TLWallPaperSolid.CONSTRUCTOR_ID, TLWallPaperSolid.class);
        registerClass(TLWebDocument.CONSTRUCTOR_ID, TLWebDocument.class);
        registerClass(TLWebPage.CONSTRUCTOR_ID, TLWebPage.class);
        registerClass(TLWebPageEmpty.CONSTRUCTOR_ID, TLWebPageEmpty.class);
        registerClass(TLWebPageNotModified.CONSTRUCTOR_ID, TLWebPageNotModified.class);
        registerClass(TLWebPagePending.CONSTRUCTOR_ID, TLWebPagePending.class);
    }
}
