/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/badoualy/telegram/mtproto/util/NamedThreadFactory;", "Ljava/util/concurrent/ThreadFactory;", "name", "", "singleThread", "", "(Ljava/lang/String;Z)V", "group", "Ljava/lang/ThreadGroup;", "kotlin.jvm.PlatformType", "getName", "()Ljava/lang/String;", "namePrefix", "getSingleThread", "()Z", "threadNumber", "Ljava/util/concurrent/atomic/AtomicInteger;", "newThread", "Ljava/lang/Thread;", "r", "Ljava/lang/Runnable;", "mtproto_main"})
public final class NamedThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final AtomicInteger threadNumber;
    private final String namePrefix;
    @NotNull
    private final String name;
    private final boolean singleThread;

    @Override
    @NotNull
    public Thread newThread(@NotNull Runnable r) {
        Intrinsics.checkParameterIsNotNull((Object)r, (String)"r");
        Thread t = new Thread(this.group, r, this.singleThread ? this.name : this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getSingleThread() {
        return this.singleThread;
    }

    public NamedThreadFactory(@NotNull String name, boolean singleThread) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        this.singleThread = singleThread;
        Object object = System.getSecurityManager();
        if (object == null || (object = ((SecurityManager)object).getThreadGroup()) == null) {
            object = Thread.currentThread().getThreadGroup();
        }
        this.group = object;
        this.threadNumber = new AtomicInteger(1);
        this.namePrefix = this.name + "-thread-";
    }

    public /* synthetic */ NamedThreadFactory(String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(string, bl);
    }
}

