/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.transport;

import com.github.badoualy.telegram.mtproto.model.DataCenter;
import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.tl.ByteBufferUtils;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 82\u00020\u0001:\u00018B)\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\"\u001a\u00020#H\u0017J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020%H\u0017J\b\u0010'\u001a\u00020\bH\u0016J&\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00052\n\b\u0002\u0010*\u001a\u0004\u0018\u00010\u00152\b\b\u0002\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020%H\u0017J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\bH\u0016J\n\u00104\u001a\u0004\u0018\u00010\u001bH\u0016J\u0010\u00105\u001a\u00020#2\u0006\u00106\u001a\u00020\u0015H\u0002J\u0010\u00107\u001a\u00020#2\u0006\u0010&\u001a\u00020%H\u0017R\u000e\u0010\n\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003@VX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\f\"\u0004\b \u0010!\u00a8\u00069"}, d2={"Lcom/github/badoualy/telegram/mtproto/transport/MTProtoTcpConnection;", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "ip", "", "port", "", "tag", "abridgedProtocol", "", "(Ljava/lang/String;ILjava/lang/String;Z)V", "ATTEMPT_COUNT", "getIp", "()Ljava/lang/String;", "<set-?>", "Lorg/slf4j/Marker;", "marker", "getMarker", "()Lorg/slf4j/Marker;", "setMarker", "(Lorg/slf4j/Marker;)V", "msgHeaderBuffer", "Ljava/nio/ByteBuffer;", "kotlin.jvm.PlatformType", "msgLengthBuffer", "getPort", "()I", "selectionKey", "Ljava/nio/channels/SelectionKey;", "socketChannel", "Ljava/nio/channels/SocketChannel;", "value", "getTag", "setTag", "(Ljava/lang/String;)V", "close", "", "executeMethod", "", "request", "isOpen", "readBytes", "length", "recycledBuffer", "order", "Ljava/nio/ByteOrder;", "readMessage", "register", "selector", "Ljava/nio/channels/Selector;", "setBlocking", "Ljava/nio/channels/SelectableChannel;", "blocking", "unregister", "writeBytes", "buffer", "writeMessage", "Companion", "mtproto_main"})
public final class MTProtoTcpConnection
implements MTProtoConnection {
    private final int ATTEMPT_COUNT = 3;
    @NotNull
    private String tag;
    @NotNull
    private Marker marker;
    private SocketChannel socketChannel;
    private final ByteBuffer msgHeaderBuffer;
    private final ByteBuffer msgLengthBuffer;
    private SelectionKey selectionKey;
    @NotNull
    private final String ip;
    private final int port;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    @NotNull
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(@NotNull String value) {
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.tag = value;
        Marker marker = MarkerFactory.getMarker((String)this.getTag());
        Intrinsics.checkExpressionValueIsNotNull((Object)marker, (String)"MarkerFactory.getMarker(tag)");
        this.setMarker(marker);
    }

    @Override
    @NotNull
    public Marker getMarker() {
        return this.marker;
    }

    private void setMarker(Marker marker) {
        this.marker = marker;
    }

    @Override
    @NotNull
    public byte[] readMessage() throws IOException {
        int length = ByteBufferUtils.readByteAsInt((ByteBuffer)MTProtoTcpConnection.readBytes$default(this, 1, this.msgHeaderBuffer, null, 4, null));
        if (length == 127) {
            length = ByteBufferUtils.readInt24((ByteBuffer)MTProtoTcpConnection.readBytes$default(this, 3, this.msgLengthBuffer, null, 4, null));
        }
        MTProtoTcpConnection.Companion.getLogger().debug(this.getMarker(), "About to read a message of length " + length * 4);
        ByteBuffer buffer = MTProtoTcpConnection.readBytes$default(this, length * 4, null, null, 6, null);
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes, 0, buffer.remaining());
        return bytes;
    }

    @Override
    public void writeMessage(@NotNull byte[] request) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        int length = request.length / 4;
        int headerLength = length >= 127 ? 4 : 1;
        int totalLength = request.length + headerLength;
        ByteBuffer buffer = ByteBuffer.allocate(totalLength);
        if (headerLength == 4) {
            ByteBufferUtils.writeByte((int)127, (ByteBuffer)buffer);
            ByteBufferUtils.writeInt24((int)length, (ByteBuffer)buffer);
        } else {
            ByteBufferUtils.writeByte((int)length, (ByteBuffer)buffer);
        }
        buffer.put(request);
        buffer.flip();
        ByteBuffer byteBuffer = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"buffer");
        this.writeBytes(byteBuffer);
    }

    @Override
    @NotNull
    public byte[] executeMethod(@NotNull byte[] request) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        this.writeMessage(request);
        return this.readMessage();
    }

    @Override
    @NotNull
    public SelectionKey register(@NotNull Selector selector) {
        Intrinsics.checkParameterIsNotNull((Object)selector, (String)"selector");
        this.socketChannel.configureBlocking(false);
        SelectionKey selectionKey = this.selectionKey = this.socketChannel.register(selector, 1);
        if (selectionKey == null) {
            Intrinsics.throwNpe();
        }
        return selectionKey;
    }

    @Override
    @Nullable
    public SelectionKey unregister() {
        SelectionKey selectionKey = this.selectionKey;
        Selector selector = selectionKey != null ? selectionKey.selector() : null;
        SelectionKey selectionKey2 = this.selectionKey;
        if (selectionKey2 != null) {
            selectionKey2.cancel();
        }
        Selector selector2 = selector;
        if (selector2 != null) {
            selector2.wakeup();
        }
        this.socketChannel.configureBlocking(true);
        return this.selectionKey;
    }

    @Override
    @NotNull
    public SelectableChannel setBlocking(boolean blocking) {
        SelectableChannel selectableChannel = this.socketChannel.configureBlocking(blocking);
        if (selectableChannel == null) {
            Intrinsics.throwNpe();
        }
        return selectableChannel;
    }

    @Override
    public void close() throws IOException {
        MTProtoTcpConnection.Companion.getLogger().debug(this.getMarker(), "Closing connection");
        this.socketChannel.close();
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen() && this.socketChannel.isConnected();
    }

    private final ByteBuffer readBytes(int length, ByteBuffer recycledBuffer, ByteOrder order) {
        int read;
        ByteBuffer byteBuffer;
        ByteBuffer byteBuffer2 = recycledBuffer;
        if (byteBuffer2 != null) {
            byteBuffer2.clear();
        }
        if ((byteBuffer = recycledBuffer) == null) {
            byteBuffer = ByteBuffer.allocate(length);
        }
        ByteBuffer buffer = byteBuffer;
        buffer.order(order);
        for (int totalRead = 0; totalRead < length; totalRead += read) {
            read = this.socketChannel.read(buffer);
            if (read != -1) continue;
            throw (Throwable)new IOException("Reached end-of-stream");
        }
        buffer.flip();
        ByteBuffer byteBuffer3 = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer3, (String)"buffer");
        return byteBuffer3;
    }

    static /* bridge */ /* synthetic */ ByteBuffer readBytes$default(MTProtoTcpConnection mTProtoTcpConnection, int n, ByteBuffer byteBuffer, ByteOrder byteOrder, int n2, Object object) {
        if ((n2 & 2) != 0) {
            byteBuffer = null;
        }
        if ((n2 & 4) != 0) {
            ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteOrder2, (String)"ByteOrder.BIG_ENDIAN");
            byteOrder = byteOrder2;
        }
        return mTProtoTcpConnection.readBytes(n, byteBuffer, byteOrder);
    }

    private final void writeBytes(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.socketChannel.write(buffer);
        }
    }

    @Override
    @NotNull
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @JvmOverloads
    public MTProtoTcpConnection(@NotNull String ip, int port, @NotNull String tag, boolean abridgedProtocol) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)ip, (String)"ip");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.ip = ip;
        this.port = port;
        this.ATTEMPT_COUNT = 3;
        this.tag = tag;
        Marker marker = MarkerFactory.getMarker((String)tag);
        if (marker == null) {
            Intrinsics.throwNpe();
        }
        this.marker = marker;
        this.msgHeaderBuffer = ByteBuffer.allocate(1);
        this.msgLengthBuffer = ByteBuffer.allocate(3);
        int attempt = 1;
        while (true) {
            Intrinsics.checkExpressionValueIsNotNull((Object)SocketChannel.open(), (String)"SocketChannel.open()");
            this.socketChannel = this.socketChannel;
            this.socketChannel.setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, (Object)true);
            this.socketChannel.configureBlocking(true);
            try {
                this.socketChannel.connect(new InetSocketAddress(this.getIp(), this.getPort()));
                this.socketChannel.finishConnect();
                if (abridgedProtocol) {
                    MTProtoTcpConnection.Companion.getLogger().info(this.getMarker(), "Using abridged protocol");
                    this.socketChannel.write(ByteBuffer.wrap(new byte[]{(byte)239}));
                }
                MTProtoTcpConnection.Companion.getLogger().info(this.getMarker(), "Connected to " + this.getIp() + ":" + this.getPort());
            }
            catch (Exception e) {
                MTProtoTcpConnection.Companion.getLogger().error(this.getMarker(), "Failed to connect", (Throwable)e);
                try {
                    this.socketChannel.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(TimeUnit.SECONDS.toMillis(2L));
                if (attempt != this.ATTEMPT_COUNT) continue;
                throw (Throwable)new ConnectException("Failed to join Telegram server at " + this.getIp() + ":" + this.getPort());
                if (attempt++ < this.ATTEMPT_COUNT) continue;
            }
            break;
        }
    }

    @JvmOverloads
    public /* synthetic */ MTProtoTcpConnection(String string, int n, String string2, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) throws IOException {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(string, n, string2, bl);
    }

    @JvmOverloads
    public MTProtoTcpConnection(@NotNull String ip, int port, @NotNull String tag) throws IOException {
        this(ip, port, tag, false, 8, null);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(MTProtoTcpConnection.class);
    }

    @Override
    @NotNull
    public DataCenter getDataCenter() {
        return MTProtoConnection.DefaultImpls.getDataCenter(this);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/badoualy/telegram/mtproto/transport/MTProtoTcpConnection$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "mtproto_main"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

