/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.time;

import com.github.badoualy.telegram.mtproto.model.DataCenter;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0006J\u0016\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0006R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/github/badoualy/telegram/mtproto/time/TimeOverlord;", "", "()V", "deltaMap", "Ljava/util/HashMap;", "Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "", "localTime", "getLocalTime", "()J", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "generateMessageId", "dataCenter", "getServerTime", "setServerTime", "", "serverTime", "synchronizeTime", "messageId", "mtproto_main"})
public final class TimeOverlord {
    private static final Logger logger;
    private static final HashMap<DataCenter, Long> deltaMap;
    public static final TimeOverlord INSTANCE;

    private final long getLocalTime() {
        return System.currentTimeMillis();
    }

    public final long getServerTime(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        long l = this.getLocalTime();
        Long l2 = deltaMap.getOrDefault(dataCenter, 0L);
        Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"deltaMap.getOrDefault(dataCenter, 0L)");
        return l + ((Number)l2).longValue();
    }

    public final long generateMessageId(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        return this.getServerTime(dataCenter) / (long)1000 << 32;
    }

    public final void setServerTime(@NotNull DataCenter dataCenter, long serverTime) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        deltaMap.put(dataCenter, serverTime - this.getLocalTime());
        logger.warn("New server time for " + dataCenter + " is " + serverTime);
        logger.warn("New time delta for " + dataCenter + " is " + deltaMap.get(dataCenter));
    }

    public final void synchronizeTime(@NotNull DataCenter dataCenter, long messageId) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        this.setServerTime(dataCenter, (messageId >>> 32) * (long)1000);
    }

    private TimeOverlord() {
        INSTANCE = this;
        logger = LoggerFactory.getLogger(TimeOverlord.class);
        deltaMap = new HashMap();
    }

    static {
        new TimeOverlord();
    }
}

