/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.secure;

import java.math.BigInteger;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/badoualy/telegram/mtproto/secure/RandomUtils;", "", "()V", "Companion", "mtproto_main"})
public final class RandomUtils {
    private static final SecureRandom random;
    public static final Companion Companion;

    static {
        Companion = new Companion(null);
        random = new SecureRandom();
        RandomUtils.Companion.getRandom().setSeed(System.currentTimeMillis());
    }

    @JvmStatic
    @NotNull
    public static final synchronized byte[] randomByteArray(int byteCount) {
        return Companion.randomByteArray(byteCount);
    }

    @JvmStatic
    public static final synchronized int randomInt() {
        return Companion.randomInt();
    }

    @JvmStatic
    @NotNull
    public static final synchronized byte[] randomSessionId() {
        return Companion.randomSessionId();
    }

    @JvmStatic
    public static final synchronized long randomLong() {
        return Companion.randomLong();
    }

    @JvmStatic
    @NotNull
    public static final synchronized byte[] randomInt128() {
        return Companion.randomInt128();
    }

    @JvmStatic
    @NotNull
    public static final synchronized byte[] randomInt256() {
        return Companion.randomInt256();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\b\u0010\u000b\u001a\u00020\nH\u0007J\b\u0010\f\u001a\u00020\bH\u0007J\b\u0010\r\u001a\u00020\bH\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0007J\b\u0010\u0010\u001a\u00020\bH\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/github/badoualy/telegram/mtproto/secure/RandomUtils$Companion;", "", "()V", "random", "Ljava/security/SecureRandom;", "getRandom", "()Ljava/security/SecureRandom;", "randomByteArray", "", "byteCount", "", "randomInt", "randomInt128", "randomInt256", "randomLong", "", "randomSessionId", "mtproto_main"})
    public static final class Companion {
        private final SecureRandom getRandom() {
            return random;
        }

        @JvmStatic
        @NotNull
        public final synchronized byte[] randomByteArray(int byteCount) {
            byte[] byteArray = new byte[byteCount];
            this.getRandom().nextBytes(byteArray);
            return byteArray;
        }

        @JvmStatic
        public final synchronized int randomInt() {
            return this.getRandom().nextInt();
        }

        @JvmStatic
        @NotNull
        public final synchronized byte[] randomSessionId() {
            return this.randomByteArray(8);
        }

        @JvmStatic
        public final synchronized long randomLong() {
            return new BigInteger(this.randomByteArray(8)).longValue();
        }

        @JvmStatic
        @NotNull
        public final synchronized byte[] randomInt128() {
            return this.randomByteArray(16);
        }

        @JvmStatic
        @NotNull
        public final synchronized byte[] randomInt256() {
            return this.randomByteArray(32);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

