/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.secure;

import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.secure.CryptoUtils;
import com.github.badoualy.telegram.mtproto.secure.EncryptedMessage;
import com.github.badoualy.telegram.mtproto.tl.MTMessage;
import com.github.badoualy.telegram.mtproto.util.AesKeyIvPair;
import com.github.badoualy.telegram.tl.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/github/badoualy/telegram/mtproto/secure/MTProtoMessageEncryption;", "", "()V", "Companion", "mtproto_main"})
public final class MTProtoMessageEncryption {
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final byte[] generateMsgKey(@NotNull byte[] unencryptedData) {
        Intrinsics.checkParameterIsNotNull((Object)unencryptedData, (String)"unencryptedData");
        return Companion.generateMsgKey(unencryptedData);
    }

    @JvmStatic
    @Nullable
    public static final byte[] generateMsgKey(@NotNull byte[] serverSalt, @NotNull byte[] sessionId, @NotNull MTMessage message) {
        Intrinsics.checkParameterIsNotNull((Object)serverSalt, (String)"serverSalt");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)message), (String)"message");
        return Companion.generateMsgKey(serverSalt, sessionId, message);
    }

    @JvmStatic
    @NotNull
    public static final EncryptedMessage encrypt(@NotNull AuthKey authKey, @NotNull byte[] sessionId, long serverSalt, @NotNull MTMessage message) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)((Object)message), (String)"message");
        return Companion.encrypt(authKey, sessionId, serverSalt, message);
    }

    @JvmStatic
    @NotNull
    public static final MTMessage decrypt(@NotNull AuthKey authKey, @NotNull byte[] sessionId, @NotNull byte[] data) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
        Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return Companion.decrypt(authKey, sessionId, data);
    }

    @JvmStatic
    private static final AesKeyIvPair computeAESKeyAndInitVector(AuthKey authKey, byte[] msgKey, int x) {
        return MTProtoMessageEncryption.Companion.computeAESKeyAndInitVector(authKey, msgKey, x);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0003J \u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bH\u0007J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\fH\u0007J\u0018\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\b0\b2\u0006\u0010\u0016\u001a\u00020\bH\u0007J\"\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\fH\u0007\u00a8\u0006\u0017"}, d2={"Lcom/github/badoualy/telegram/mtproto/secure/MTProtoMessageEncryption$Companion;", "", "()V", "computeAESKeyAndInitVector", "Lcom/github/badoualy/telegram/mtproto/util/AesKeyIvPair;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "msgKey", "", "x", "", "decrypt", "Lcom/github/badoualy/telegram/mtproto/tl/MTMessage;", "sessionId", "data", "encrypt", "Lcom/github/badoualy/telegram/mtproto/secure/EncryptedMessage;", "serverSalt", "", "message", "generateMsgKey", "kotlin.jvm.PlatformType", "unencryptedData", "mtproto_main"})
    public static final class Companion {
        @JvmStatic
        public final byte[] generateMsgKey(@NotNull byte[] unencryptedData) {
            Intrinsics.checkParameterIsNotNull((Object)unencryptedData, (String)"unencryptedData");
            return CryptoUtils.substring(CryptoUtils.SHA1(unencryptedData), 4, 16);
        }

        @JvmStatic
        @Nullable
        public final byte[] generateMsgKey(@NotNull byte[] serverSalt, @NotNull byte[] sessionId, @NotNull MTMessage message) {
            Intrinsics.checkParameterIsNotNull((Object)serverSalt, (String)"serverSalt");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)message), (String)"message");
            try {
                MessageDigest crypt = MessageDigest.getInstance("SHA-1");
                crypt.reset();
                crypt.update(serverSalt);
                crypt.update(sessionId);
                crypt.update(StreamUtils.longToBytes((long)message.getMessageId()));
                crypt.update(StreamUtils.intToBytes((int)message.getSeqNo()));
                crypt.update(StreamUtils.intToBytes((int)message.getPayloadLength()));
                crypt.update(message.getPayload(), 0, message.getPayloadLength());
                return CryptoUtils.substring(crypt.digest(), 4, 16);
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                return null;
            }
        }

        @JvmStatic
        @NotNull
        public final EncryptedMessage encrypt(@NotNull AuthKey authKey, @NotNull byte[] sessionId, long serverSalt, @NotNull MTMessage message) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull((Object)((Object)message), (String)"message");
            ByteArrayOutputStream unencryptedStream = new ByteArrayOutputStream();
            StreamUtils.writeLong((long)serverSalt, (OutputStream)unencryptedStream);
            StreamUtils.writeByteArray((byte[])sessionId, (OutputStream)unencryptedStream);
            StreamUtils.writeLong((long)message.getMessageId(), (OutputStream)unencryptedStream);
            StreamUtils.writeInt((int)message.getSeqNo(), (OutputStream)unencryptedStream);
            StreamUtils.writeInt((int)message.getPayload().length, (OutputStream)unencryptedStream);
            StreamUtils.writeByteArray((byte[])message.getPayload(), (OutputStream)unencryptedStream);
            byte[] unencryptedData = unencryptedStream.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)unencryptedData, (String)"unencryptedData");
            byte[] msgKey = this.generateMsgKey(unencryptedData);
            Intrinsics.checkExpressionValueIsNotNull((Object)msgKey, (String)"msgKey");
            AesKeyIvPair aesKeyIvPair = this.computeAESKeyAndInitVector(authKey, msgKey, 0);
            byte[] encryptedData = CryptoUtils.AES256IGEEncrypt(CryptoUtils.align(unencryptedData, 16), aesKeyIvPair.getIv(), aesKeyIvPair.getKey());
            ByteArrayOutputStream out = new ByteArrayOutputStream(24 + encryptedData.length);
            StreamUtils.writeByteArray((byte[])authKey.getKeyId(), (OutputStream)out);
            StreamUtils.writeByteArray((byte[])msgKey, (OutputStream)out);
            StreamUtils.writeByteArray((byte[])encryptedData, (OutputStream)out);
            byte[] byArray = out.toByteArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.toByteArray()");
            return new EncryptedMessage(message, byArray);
        }

        @JvmStatic
        @NotNull
        public final MTMessage decrypt(@NotNull AuthKey authKey, @NotNull byte[] sessionId, @NotNull byte[] data) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
            Intrinsics.checkParameterIsNotNull((Object)sessionId, (String)"sessionId");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            byte[] msgAuthKeyId = StreamUtils.readBytes((int)8, (InputStream)stream);
            if (!Arrays.equals(authKey.getKeyId(), msgAuthKeyId)) {
                throw (Throwable)new RuntimeException("Message's authKey doesn't match given authKey");
            }
            byte[] msgKey = StreamUtils.readBytes((int)16, (InputStream)stream);
            Intrinsics.checkExpressionValueIsNotNull((Object)msgKey, (String)"msgKey");
            AesKeyIvPair aesKeyIvPair = this.computeAESKeyAndInitVector(authKey, msgKey, 8);
            int encryptedDataLength = data.length - 24;
            byte[] encryptedData = new byte[encryptedDataLength];
            StreamUtils.readBytes((byte[])encryptedData, (int)0, (int)encryptedDataLength, (InputStream)stream);
            byte[] unencryptedData = new byte[encryptedDataLength];
            CryptoUtils.AES256IGEDecryptBig(encryptedData, unencryptedData, encryptedDataLength, aesKeyIvPair.getIv(), aesKeyIvPair.getKey());
            ByteArrayInputStream unencryptedStream = new ByteArrayInputStream(unencryptedData);
            byte[] serverSalt = StreamUtils.readBytes((int)8, (InputStream)unencryptedStream);
            byte[] session = StreamUtils.readBytes((int)8, (InputStream)unencryptedStream);
            long msgId = StreamUtils.readLong((InputStream)unencryptedStream);
            int seqNo = StreamUtils.readInt((InputStream)unencryptedStream);
            int msgLength = StreamUtils.readInt((InputStream)unencryptedStream);
            int paddingSize = encryptedDataLength - 32 - msgLength;
            if (msgId % (long)2 == 0L) {
                throw (Throwable)new SecurityException("Message id of messages sent be the server must be odd, found " + msgId);
            }
            if (msgLength % 4 != 0) {
                throw (Throwable)new SecurityException("Message length must be a multiple of 4, found " + msgLength);
            }
            if (paddingSize > 15 || paddingSize < 0) {
                throw (Throwable)new SecurityException("Padding must be between 0 and 15 included, found " + paddingSize);
            }
            if (!Arrays.equals(session, sessionId)) {
                throw (Throwable)new SecurityException("The message was not intended for this session, expected " + new BigInteger(sessionId).longValue() + ", found " + new BigInteger(session).longValue());
            }
            byte[] message = new byte[msgLength];
            StreamUtils.readBytes((byte[])message, (int)0, (int)msgLength, (InputStream)unencryptedStream);
            MTMessage mtMessage = new MTMessage(msgId, seqNo, message, message.length);
            Intrinsics.checkExpressionValueIsNotNull((Object)serverSalt, (String)"serverSalt");
            Intrinsics.checkExpressionValueIsNotNull((Object)session, (String)"session");
            byte[] checkMsgKey = this.generateMsgKey(serverSalt, session, mtMessage);
            if (!Arrays.equals(checkMsgKey, msgKey)) {
                throw (Throwable)new SecurityException("The message msgKey is inconsistent with it's data");
            }
            return mtMessage;
        }

        @JvmStatic
        private final AesKeyIvPair computeAESKeyAndInitVector(AuthKey authKey, byte[] msgKey, int x) {
            byte[] sha1_a = CryptoUtils.SHA1(msgKey, CryptoUtils.substring(authKey.getKey(), x, 32));
            byte[] sha1_b = CryptoUtils.SHA1(CryptoUtils.substring(authKey.getKey(), 32 + x, 16), msgKey, CryptoUtils.substring(authKey.getKey(), 48 + x, 16));
            byte[] sha1_c = CryptoUtils.SHA1(CryptoUtils.substring(authKey.getKey(), 64 + x, 32), msgKey);
            byte[] sha1_d = CryptoUtils.SHA1(msgKey, CryptoUtils.substring(authKey.getKey(), 96 + x, 32));
            byte[] aesKey = CryptoUtils.concat(CryptoUtils.substring(sha1_a, 0, 8), CryptoUtils.substring(sha1_b, 8, 12), CryptoUtils.substring(sha1_c, 4, 12));
            byte[] aesIv = CryptoUtils.concat(CryptoUtils.substring(sha1_a, 8, 12), CryptoUtils.substring(sha1_b, 0, 8), CryptoUtils.substring(sha1_c, 16, 4), CryptoUtils.substring(sha1_d, 0, 8));
            Intrinsics.checkExpressionValueIsNotNull((Object)aesKey, (String)"aesKey");
            Intrinsics.checkExpressionValueIsNotNull((Object)aesIv, (String)"aesIv");
            return new AesKeyIvPair(aesKey, aesIv);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

