/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.model;

import com.github.badoualy.telegram.mtproto.model.DataCenter;
import com.github.badoualy.telegram.mtproto.secure.RandomUtils;
import com.github.badoualy.telegram.mtproto.time.TimeOverlord;
import com.github.badoualy.telegram.tl.TLObjectUtils;
import com.github.badoualy.telegram.tl.core.TLObject;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0006\u0010&\u001a\u00020\u0007J\u000e\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)J\u0016\u0010'\u001a\u00020\t2\u000e\u0010*\u001a\n\u0012\u0006\b\u0001\u0012\u00020)0+J\u0010\u0010'\u001a\u00020\t2\u0006\u0010,\u001a\u00020-H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u001f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001b\"\u0004\b#\u0010\u001dR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006."}, d2={"Lcom/github/badoualy/telegram/mtproto/model/MTSession;", "", "dataCenter", "Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "id", "", "salt", "", "contentRelatedCount", "", "lastMessageId", "tag", "", "(Lcom/github/badoualy/telegram/mtproto/model/DataCenter;[BJIJLjava/lang/String;)V", "getContentRelatedCount", "()I", "setContentRelatedCount", "(I)V", "getDataCenter", "()Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "setDataCenter", "(Lcom/github/badoualy/telegram/mtproto/model/DataCenter;)V", "getId", "()[B", "setId", "([B)V", "getLastMessageId", "()J", "setLastMessageId", "(J)V", "marker", "Lorg/slf4j/Marker;", "getMarker", "()Lorg/slf4j/Marker;", "getSalt", "setSalt", "getTag", "()Ljava/lang/String;", "generateMessageId", "generateSeqNo", "message", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "clazz", "Ljava/lang/Class;", "contentRelated", "", "mtproto_main"})
public final class MTSession {
    @NotNull
    private final transient String tag;
    @NotNull
    private final transient Marker marker;
    @NotNull
    private DataCenter dataCenter;
    @NotNull
    private byte[] id;
    private long salt;
    private int contentRelatedCount;
    private long lastMessageId;

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    @NotNull
    public final Marker getMarker() {
        return this.marker;
    }

    public final int generateSeqNo(@NotNull Class<? extends TLObject> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
        return this.generateSeqNo(TLObjectUtils.isContentRelated(clazz));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final int generateSeqNo(boolean contentRelated) {
        void seqNo;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        MTSession mTSession = this;
        synchronized (mTSession) {
            int n;
            if (contentRelated) {
                seqNo.element = this.contentRelatedCount * 2 + 1;
                int n2 = this.contentRelatedCount;
                this.contentRelatedCount = n2 + 1;
                n = seqNo.element;
            } else {
                n = this.contentRelatedCount * 2;
            }
            seqNo.element = n;
            Unit unit = Unit.INSTANCE;
        }
        return seqNo.element;
    }

    public final int generateSeqNo(@NotNull TLObject message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        return this.generateSeqNo(message.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long generateMessageId() {
        long weakMessageId = TimeOverlord.INSTANCE.generateMessageId(this.dataCenter);
        MTSession mTSession = this;
        synchronized (mTSession) {
            this.lastMessageId = Math.max(weakMessageId, this.lastMessageId + (long)4);
            Unit unit = Unit.INSTANCE;
        }
        return this.lastMessageId;
    }

    @NotNull
    public final DataCenter getDataCenter() {
        return this.dataCenter;
    }

    public final void setDataCenter(@NotNull DataCenter dataCenter) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"<set-?>");
        this.dataCenter = dataCenter;
    }

    @NotNull
    public final byte[] getId() {
        return this.id;
    }

    public final void setId(@NotNull byte[] byArray) {
        Intrinsics.checkParameterIsNotNull((Object)byArray, (String)"<set-?>");
        this.id = byArray;
    }

    public final long getSalt() {
        return this.salt;
    }

    public final void setSalt(long l) {
        this.salt = l;
    }

    public final int getContentRelatedCount() {
        return this.contentRelatedCount;
    }

    public final void setContentRelatedCount(int n) {
        this.contentRelatedCount = n;
    }

    public final long getLastMessageId() {
        return this.lastMessageId;
    }

    public final void setLastMessageId(long l) {
        this.lastMessageId = l;
    }

    public MTSession(@NotNull DataCenter dataCenter, @NotNull byte[] id, long salt, int contentRelatedCount, long lastMessageId, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.dataCenter = dataCenter;
        this.id = id;
        this.salt = salt;
        this.contentRelatedCount = contentRelatedCount;
        this.lastMessageId = lastMessageId;
        this.tag = tag + ":" + new BigInteger(this.id).longValue();
        Marker marker = MarkerFactory.getMarker((String)this.tag);
        if (marker == null) {
            Intrinsics.throwNpe();
        }
        this.marker = marker;
    }

    public /* synthetic */ MTSession(DataCenter dataCenter, byte[] byArray, long l, int n, long l2, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            byArray = RandomUtils.Companion.randomSessionId();
        }
        if ((n2 & 4) != 0) {
            l = 0L;
        }
        if ((n2 & 8) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            l2 = 0L;
        }
        this(dataCenter, byArray, l, n, l2, string);
    }
}

