/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.auth;

import com.github.badoualy.telegram.mtproto.MTProtoHandler;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.TempAuthKey;
import com.github.badoualy.telegram.mtproto.secure.EncryptedMessage;
import com.github.badoualy.telegram.mtproto.secure.MTProtoMessageEncryption;
import com.github.badoualy.telegram.mtproto.secure.RandomUtils;
import com.github.badoualy.telegram.mtproto.tl.MTMessage;
import com.github.badoualy.telegram.mtproto.tl.auth.BindAuthKeyInner;
import com.github.badoualy.telegram.tl.api.request.TLRequestAuthBindTempAuthKey;
import com.github.badoualy.telegram.tl.core.TLBytes;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/github/badoualy/telegram/mtproto/auth/TempAuthKeyBinding;", "", "()V", "TAG", "", "bindKey", "", "tempAuthKey", "Lcom/github/badoualy/telegram/mtproto/auth/TempAuthKey;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "mtProtoHandler", "Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;", "mtproto_main"})
public final class TempAuthKeyBinding {
    private static final String TAG = "TempAuthKeyBinding";
    public static final TempAuthKeyBinding INSTANCE;

    @JvmStatic
    public static final boolean bindKey(@NotNull TempAuthKey tempAuthKey, @NotNull AuthKey authKey, @NotNull MTProtoHandler mtProtoHandler) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)tempAuthKey, (String)"tempAuthKey");
        Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
        Intrinsics.checkParameterIsNotNull((Object)mtProtoHandler, (String)"mtProtoHandler");
        AuthKey authKey2 = mtProtoHandler.getAuthKey();
        if (authKey2 == null) {
            Intrinsics.throwNpe();
        }
        if (!Arrays.equals(authKey2.getKeyId(), tempAuthKey.getKeyId())) {
            throw (Throwable)new IllegalStateException("The MTProtoHandler must use the temporary authorization key that you want to bind");
        }
        long nonce = new BigInteger(RandomUtils.Companion.randomByteArray(8)).longValue();
        BindAuthKeyInner bindingMessage = new BindAuthKeyInner(nonce, tempAuthKey.getKeyIdAsLong(), authKey.getKeyIdAsLong(), mtProtoHandler.getSession().getId(), tempAuthKey.getExpiresAt());
        byte[] randomPart1 = RandomUtils.Companion.randomByteArray(8);
        long randomPart2 = RandomUtils.Companion.randomLong();
        long msgId = 0L;
        byte[] byArray = bindingMessage.serialize();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"bindingMessage.serialize()");
        MTMessage mtBindingMessage = new MTMessage(msgId, 0, byArray, 0, 8, null);
        EncryptedMessage encryptedMessage = MTProtoMessageEncryption.Companion.encrypt(authKey, randomPart1, randomPart2, mtBindingMessage);
        TLRequestAuthBindTempAuthKey request = new TLRequestAuthBindTempAuthKey(authKey.getKeyIdAsLong(), nonce, tempAuthKey.getExpiresAt(), new TLBytes(encryptedMessage.getData()));
        byte[] byArray2 = request.serialize();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"request.serialize()");
        MTMessage message = new MTMessage(msgId, 0, byArray2, 0, 8, null);
        return false;
    }

    private TempAuthKeyBinding() {
        INSTANCE = this;
        TAG = TAG;
    }

    static {
        new TempAuthKeyBinding();
    }
}

