/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto.auth;

import com.github.badoualy.telegram.mtproto.secure.CryptoUtils;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "", "key", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "", "([B)V", "getKey", "()[B", "keyId", "getKeyId", "keyIdAsLong", "", "getKeyIdAsLong", "()J", "mtproto_main"})
public class AuthKey {
    @NotNull
    private final byte[] keyId;
    private final long keyIdAsLong;
    @NotNull
    private final byte[] key;

    @NotNull
    public final byte[] getKeyId() {
        return this.keyId;
    }

    public final long getKeyIdAsLong() {
        return this.keyIdAsLong;
    }

    @NotNull
    public final byte[] getKey() {
        return this.key;
    }

    public AuthKey(@NotNull byte[] key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.key = key;
        if (this.key.length != 256) {
            throw (Throwable)new RuntimeException("AuthKey must be 256 Bytes found " + this.key.length + " bytes");
        }
        byte[] byArray = CryptoUtils.substring(CryptoUtils.SHA1(this.key), 12, 8);
        if (byArray == null) {
            Intrinsics.throwNpe();
        }
        this.keyId = byArray;
        this.keyIdAsLong = new BigInteger(this.keyId).longValue();
    }

    public AuthKey(@NotNull ByteBuffer key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        byte[] byArray = key.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"key.array()");
        this(byArray);
    }
}

