/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto;

import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.util.NamedThreadFactory;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Subscriber;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001cJ\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00180\u001f2\u0006\u0010\u001a\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00020\f8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u000f*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u000f*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0016\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\u00180\u00170\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoWatchdog;", "Ljava/lang/Runnable;", "()V", "SELECT_TIMEOUT_DELAY", "", "connectionList", "Ljava/util/ArrayList;", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "connectionMap", "Ljava/util/HashMap;", "Ljava/nio/channels/SelectionKey;", "dirty", "", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "logger", "Lorg/slf4j/Logger;", "pool", "running", "selector", "Ljava/nio/channels/Selector;", "subscriberMap", "Lrx/Subscriber;", "", "readMessage", "connection", "run", "", "shutdown", "start", "Lrx/Observable;", "stop", "mtproto_main"})
public final class MTProtoWatchdog
implements Runnable {
    private static final Logger logger;
    private static final long SELECT_TIMEOUT_DELAY = 10000L;
    private static final Selector selector;
    private static final HashMap<SelectionKey, MTProtoConnection> connectionMap;
    private static final ArrayList<MTProtoConnection> connectionList;
    private static final HashMap<MTProtoConnection, Subscriber<? super byte[]>> subscriberMap;
    private static final ExecutorService executor;
    private static final ExecutorService pool;
    private static volatile boolean dirty;
    private static boolean running;
    public static final MTProtoWatchdog INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void run() {
        while (true) {
            Unit unit;
            Iterable $receiver$iv;
            MTProtoWatchdog mTProtoWatchdog;
            if (dirty) {
                mTProtoWatchdog = this;
                synchronized (mTProtoWatchdog) {
                    void $receiver$iv$iv;
                    $receiver$iv = connectionList;
                    unit = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv : $receiver$iv$iv) {
                        MTProtoConnection it = (MTProtoConnection)element$iv$iv;
                        if (connectionMap.containsValue(it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $receiver$iv = (List)destination$iv$iv;
                    for (Object element$iv : $receiver$iv) {
                        MTProtoConnection it = (MTProtoConnection)element$iv;
                        Selector selector = MTProtoWatchdog.selector;
                        Intrinsics.checkExpressionValueIsNotNull((Object)selector, (String)"selector");
                        connectionMap.put(it.register(selector), it);
                    }
                    dirty = false;
                    unit = Unit.INSTANCE;
                }
            }
            if (selector.select(SELECT_TIMEOUT_DELAY) > 0) {
                mTProtoWatchdog = this;
                synchronized (mTProtoWatchdog) {
                    $receiver$iv = selector.selectedKeys();
                    for (Object element$iv : $receiver$iv) {
                        SelectionKey key = (SelectionKey)element$iv;
                        key.interestOps(0);
                        MTProtoConnection connection = connectionMap.get(key);
                        if (connection == null) continue;
                        pool.execute(new Runnable(connection, key){
                            final /* synthetic */ MTProtoConnection $connection;
                            final /* synthetic */ SelectionKey $key;

                            public final void run() {
                                if (!this.$connection.isOpen()) {
                                    return;
                                }
                                boolean wentGood = MTProtoWatchdog.access$readMessage(MTProtoWatchdog.INSTANCE, this.$connection);
                                if (wentGood && this.$key.isValid()) {
                                    this.$key.interestOps(1);
                                    MTProtoWatchdog.access$getSelector$p(MTProtoWatchdog.INSTANCE).wakeup();
                                } else if (!wentGood) {
                                    MTProtoWatchdog.INSTANCE.stop(this.$connection);
                                }
                            }
                            {
                                this.$connection = mTProtoConnection;
                                this.$key = selectionKey;
                            }
                        });
                    }
                    unit = Unit.INSTANCE;
                }
                selector.selectedKeys().clear();
            }
            if (!connectionList.isEmpty()) continue;
            mTProtoWatchdog = this;
            synchronized (mTProtoWatchdog) {
                if (connectionList.isEmpty()) {
                    running = false;
                    logger.warn("Stopping watchdog...");
                    return;
                }
                unit = Unit.INSTANCE;
            }
        }
    }

    private final boolean readMessage(MTProtoConnection connection) {
        logger.info(connection.getMarker(), "readMessage()");
        Subscriber<? super byte[]> subscriber = subscriberMap.get(connection);
        if (subscriber == null || subscriber.isUnsubscribed() || !connectionList.contains(connection)) {
            logger.warn(connection.getMarker(), "Subscribed already unsubscribed, dropping");
            return false;
        }
        try {
            byte[] message = connection.readMessage();
            logger.debug(connection.getMarker(), "New message of length: " + message.length);
            subscriber.onNext((Object)message);
        }
        catch (IOException e) {
            if (!subscriber.isUnsubscribed()) {
                logger.error(connection.getMarker(), "Sending exception to subscriber");
                subscriber.onError((Throwable)e);
            }
            logger.warn(connection.getMarker(), "Already unsubscribed");
            return false;
        }
        return true;
    }

    @NotNull
    public final Observable<byte[]> start(@NotNull MTProtoConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Observable observable2 = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(connection){
            final /* synthetic */ MTProtoConnection $connection;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void call(Subscriber<? super byte[]> s) {
                MTProtoWatchdog.access$getLogger$p(MTProtoWatchdog.INSTANCE).info(this.$connection.getMarker(), "Adding " + this.$connection.getTag() + " to watchdog");
                MTProtoWatchdog mTProtoWatchdog = MTProtoWatchdog.INSTANCE;
                synchronized (mTProtoWatchdog) {
                    MTProtoWatchdog.access$getConnectionList$p(MTProtoWatchdog.INSTANCE).add(this.$connection);
                    MTProtoWatchdog.access$getSubscriberMap$p(MTProtoWatchdog.INSTANCE).put(this.$connection, s);
                    MTProtoWatchdog.access$setDirty$p(MTProtoWatchdog.INSTANCE, true);
                    if (!MTProtoWatchdog.access$getRunning$p(MTProtoWatchdog.INSTANCE)) {
                        MTProtoWatchdog.access$setRunning$p(MTProtoWatchdog.INSTANCE, true);
                        MTProtoWatchdog.access$getExecutor$p(MTProtoWatchdog.INSTANCE).execute(MTProtoWatchdog.INSTANCE);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                MTProtoWatchdog.access$getSelector$p(MTProtoWatchdog.INSTANCE).wakeup();
            }
            {
                this.$connection = mTProtoConnection;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"Observable.create<ByteAr\u2026  selector.wakeup()\n    }");
        return observable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull MTProtoConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        logger.info(connection.getMarker(), "Stopping " + connection.getTag());
        MTProtoWatchdog mTProtoWatchdog = this;
        synchronized (mTProtoWatchdog) {
            Subscriber<? super byte[]> subscriber;
            connectionList.remove(connection);
            Subscriber<? super byte[]> subscriber2 = subscriber = subscriberMap.remove(connection);
            if (subscriber2 != null) {
                subscriber2.unsubscribe();
            }
            SelectionKey key = connection.unregister();
            if (key != null) {
                connectionMap.remove(key);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void shutdown() {
        logger.warn("==================== SHUTTING DOWN WATCHDOG ====================");
        executor.shutdownNow();
        pool.shutdownNow();
    }

    private MTProtoWatchdog() {
        INSTANCE = this;
        logger = LoggerFactory.getLogger(INSTANCE.getClass());
        SELECT_TIMEOUT_DELAY = 10000L;
        selector = Selector.open();
        connectionMap = new HashMap();
        connectionList = new ArrayList();
        subscriberMap = new HashMap();
        String string = this.getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        executor = Executors.newSingleThreadExecutor(new NamedThreadFactory(string, true));
        pool = Executors.newCachedThreadPool(new NamedThreadFactory(this.getClass().getSimpleName() + "-exec", false, 2, null));
    }

    static {
        new MTProtoWatchdog();
    }

    public static final /* synthetic */ boolean access$readMessage(MTProtoWatchdog $this, @NotNull MTProtoConnection connection) {
        return $this.readMessage(connection);
    }

    public static final /* synthetic */ Selector access$getSelector$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return selector;
    }

    public static final /* synthetic */ Logger access$getLogger$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return logger;
    }

    @NotNull
    public static final /* synthetic */ ArrayList access$getConnectionList$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return connectionList;
    }

    @NotNull
    public static final /* synthetic */ HashMap access$getSubscriberMap$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return subscriberMap;
    }

    public static final /* synthetic */ boolean access$getDirty$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return dirty;
    }

    public static final /* synthetic */ void access$setDirty$p(MTProtoWatchdog $this, boolean bl) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        dirty = bl;
    }

    public static final /* synthetic */ boolean access$getRunning$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return running;
    }

    public static final /* synthetic */ void access$setRunning$p(MTProtoWatchdog $this, boolean bl) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        running = bl;
    }

    public static final /* synthetic */ ExecutorService access$getExecutor$p(MTProtoWatchdog $this) {
        MTProtoWatchdog mTProtoWatchdog = $this;
        return executor;
    }
}

