/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.mtproto;

import com.github.badoualy.telegram.mtproto.ApiCallback;
import com.github.badoualy.telegram.mtproto.MTProtoHandler;
import com.github.badoualy.telegram.mtproto.MTProtoWatchdog;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.AuthResult;
import com.github.badoualy.telegram.mtproto.model.DataCenter;
import com.github.badoualy.telegram.mtproto.model.MTSession;
import com.github.badoualy.telegram.mtproto.secure.EncryptedMessage;
import com.github.badoualy.telegram.mtproto.secure.MTProtoMessageEncryption;
import com.github.badoualy.telegram.mtproto.time.MTProtoTimer;
import com.github.badoualy.telegram.mtproto.time.TimeOverlord;
import com.github.badoualy.telegram.mtproto.tl.MTBadMessage;
import com.github.badoualy.telegram.mtproto.tl.MTBadMessageNotification;
import com.github.badoualy.telegram.mtproto.tl.MTBadServerSalt;
import com.github.badoualy.telegram.mtproto.tl.MTFutureSalts;
import com.github.badoualy.telegram.mtproto.tl.MTMessage;
import com.github.badoualy.telegram.mtproto.tl.MTMessageDetailedInfo;
import com.github.badoualy.telegram.mtproto.tl.MTMessagesContainer;
import com.github.badoualy.telegram.mtproto.tl.MTMsgsAck;
import com.github.badoualy.telegram.mtproto.tl.MTNeedResendMessage;
import com.github.badoualy.telegram.mtproto.tl.MTNewMessageDetailedInfo;
import com.github.badoualy.telegram.mtproto.tl.MTNewSessionCreated;
import com.github.badoualy.telegram.mtproto.tl.MTProtoContext;
import com.github.badoualy.telegram.mtproto.tl.MTRpcError;
import com.github.badoualy.telegram.mtproto.tl.MTRpcResult;
import com.github.badoualy.telegram.mtproto.transport.MTProtoConnection;
import com.github.badoualy.telegram.mtproto.transport.MTProtoTcpConnection;
import com.github.badoualy.telegram.mtproto.util.NamedThreadFactory;
import com.github.badoualy.telegram.tl.StreamUtils;
import com.github.badoualy.telegram.tl.TLContext;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.api.TLApiContext;
import com.github.badoualy.telegram.tl.api.request.TLRequestHelpGetNearestDc;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.exception.DeserializationException;
import com.github.badoualy.telegram.tl.exception.RpcErrorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u0016\n\u0002\b\u0005\u0018\u0000 a2\u00020\u0001:\u0002abB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB3\b\u0017\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u00020'H\u0003J.\u00103\u001a\b\u0012\u0004\u0012\u0002H504\"\b\b\u0000\u00105*\u0002012\f\u00106\u001a\b\u0012\u0004\u0012\u0002H50\"2\u0006\u00107\u001a\u00020\u0013H\u0007J-\u00108\u001a\u0002H5\"\b\b\u0000\u00105*\u0002012\f\u00106\u001a\b\u0012\u0004\u0012\u0002H50\"2\u0006\u00107\u001a\u00020\u0013H\u0007\u00a2\u0006\u0002\u00109J<\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H50\"04\"\b\b\u0000\u00105*\u0002012\u0014\u0010;\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H50\"0<2\u0006\u00107\u001a\u00020\u0013H\u0007J6\u0010=\u001a\b\u0012\u0004\u0012\u0002H50<\"\b\b\u0000\u00105*\u0002012\u0014\u0010;\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u0002H50\"0<2\u0006\u00107\u001a\u00020\u0013H\u0007J\n\u0010>\u001a\u0004\u0018\u00010'H\u0002J\u000e\u0010?\u001a\b\u0012\u0004\u0012\u00020'0<H\u0002J\u0018\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020'H\u0003J\u0010\u0010D\u001a\u00020/2\u0006\u00102\u001a\u00020'H\u0003J\u0010\u0010E\u001a\u00020/2\u0006\u0010F\u001a\u00020GH\u0003J\u0010\u0010H\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010I\u001a\u00020/2\u0006\u0010J\u001a\u00020\u00112\b\b\u0002\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020/2\u0006\u0010N\u001a\u00020OH\u0002J\u0010\u0010P\u001a\u00020/2\u0006\u0010Q\u001a\u00020RH\u0002J>\u0010S\u001a\b\u0012\u0004\u0012\u0002H504\"\b\b\u0000\u00105*\u0002012\f\u00106\u001a\b\u0012\u0004\u0012\u0002H50\"2\b\b\u0002\u0010T\u001a\u00020\u00112\u0006\u0010U\u001a\u00020\u00132\u0006\u00107\u001a\u00020\u0013J\b\u0010V\u001a\u00020/H\u0007J\u0010\u0010W\u001a\u00020/2\u0006\u0010X\u001a\u00020RH\u0002J\u0010\u0010Y\u001a\u00020/2\u0006\u00102\u001a\u00020'H\u0003J\u0010\u0010Z\u001a\u00020/2\u0006\u0010[\u001a\u00020\u0013H\u0003J\u0010\u0010\\\u001a\u00020/2\u0006\u0010]\u001a\u00020^H\u0003J\u0006\u0010_\u001a\u00020/J\b\u0010`\u001a\u00020/H\u0002R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010 \u001a\u0012\u0012\u0004\u0012\u00020\u0013\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010#\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020'0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R$\u0010,\u001a\u0018\u0012\u0004\u0012\u00020\u0013\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0-0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006c"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;", "", "authResult", "Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;", "apiCallback", "Lcom/github/badoualy/telegram/mtproto/ApiCallback;", "tag", "", "(Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;Lcom/github/badoualy/telegram/mtproto/ApiCallback;Ljava/lang/String;)V", "dataCenter", "Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "session", "Lcom/github/badoualy/telegram/mtproto/model/MTSession;", "(Lcom/github/badoualy/telegram/mtproto/model/DataCenter;Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;Lcom/github/badoualy/telegram/mtproto/model/MTSession;Lcom/github/badoualy/telegram/mtproto/ApiCallback;Ljava/lang/String;)V", "ACK_BUFFER_SIZE", "", "ACK_BUFFER_TIMEOUT", "", "<set-?>", "getAuthKey", "()Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "setAuthKey", "(Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;)V", "bufferId", "bufferTimeoutTask", "Ljava/util/TimerTask;", "connection", "Lcom/github/badoualy/telegram/mtproto/transport/MTProtoConnection;", "messageToAckList", "Ljava/util/ArrayList;", "requestMap", "Ljava/util/Hashtable;", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "requestQueue", "Ljava/util/LinkedList;", "Lcom/github/badoualy/telegram/mtproto/MTProtoHandler$QueuedMethod;", "sentMessageList", "Lcom/github/badoualy/telegram/mtproto/tl/MTMessage;", "getSession", "()Lcom/github/badoualy/telegram/mtproto/model/MTSession;", "setSession", "(Lcom/github/badoualy/telegram/mtproto/model/MTSession;)V", "subscriberMap", "Lrx/Subscriber;", "close", "", "deserializeMessageContent", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "message", "executeMethod", "Lrx/Observable;", "T", "method", "timeout", "executeMethodSync", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;J)Lcom/github/badoualy/telegram/tl/core/TLObject;", "executeMethods", "methods", "", "executeMethodsSync", "getAckToSend", "getQueuedRequestToSend", "handleBadMessage", "badMessage", "Lcom/github/badoualy/telegram/mtproto/tl/MTBadMessageNotification;", "container", "handleMessage", "handleResult", "result", "Lcom/github/badoualy/telegram/mtproto/tl/MTRpcResult;", "newSession", "onBufferTimeout", "id", "flush", "", "onErrorReceived", "it", "", "onMessageReceived", "bytes", "", "queueMethod", "type", "validityTimeout", "resetConnection", "sendData", "data", "sendMessage", "sendMessageAck", "messageId", "sendMessagesAck", "messagesId", "", "startWatchdog", "stopWatchdog", "Companion", "QueuedMethod", "mtproto_main"})
public final class MTProtoHandler {
    private final int ACK_BUFFER_SIZE = 15;
    private final long ACK_BUFFER_TIMEOUT = 150000L;
    private MTProtoConnection connection;
    @Nullable
    private AuthKey authKey;
    @NotNull
    private MTSession session;
    private final Hashtable<Long, Subscriber<TLMethod<?>>> subscriberMap;
    private final Hashtable<Long, TLMethod<?>> requestMap;
    private final ArrayList<MTMessage> sentMessageList;
    private ArrayList<Long> messageToAckList;
    private LinkedList<QueuedMethod<?>> requestQueue;
    private TimerTask bufferTimeoutTask;
    private int bufferId;
    private final ApiCallback apiCallback;
    private final String tag;
    private static final Logger logger;
    private static final MTProtoContext mtProtoContext;
    private static final TLApiContext apiContext;
    private static final ThreadPoolExecutor updatePool;
    private static final int QUEUE_TYPE_DISCARD = 0;
    public static final Companion Companion;

    @Nullable
    public final AuthKey getAuthKey() {
        return this.authKey;
    }

    private final void setAuthKey(AuthKey authKey) {
        this.authKey = authKey;
    }

    @NotNull
    public final MTSession getSession() {
        return this.session;
    }

    private final void setSession(MTSession mTSession) {
        this.session = mTSession;
    }

    private final MTSession newSession(DataCenter dataCenter) {
        MTSession session = new MTSession(dataCenter, null, 0L, 0, 0L, this.tag, 30, null);
        MTProtoHandler.Companion.getLogger().warn(session.getMarker(), "New session created");
        return session;
    }

    public final void startWatchdog() {
        MTProtoHandler.Companion.getLogger().info(this.session.getMarker(), "startWatchdog()");
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        MTProtoWatchdog.INSTANCE.start(mTProtoConnection).observeOn(Schedulers.computation()).doOnError((Action1)new Action1<Throwable>(this){
            final /* synthetic */ MTProtoHandler this$0;

            public final void call(Throwable it) {
                Throwable throwable = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                MTProtoHandler.access$onErrorReceived(this.this$0, throwable);
            }
            {
                this.this$0 = mTProtoHandler;
            }
        }).doOnNext((Action1)new Action1<byte[]>(this){
            final /* synthetic */ MTProtoHandler this$0;

            public final void call(byte[] it) {
                Intrinsics.checkExpressionValueIsNotNull((Object)it, (String)"it");
                MTProtoHandler.access$onMessageReceived(this.this$0, it);
            }
            {
                this.this$0 = mTProtoHandler;
            }
        }).subscribe();
    }

    private final void stopWatchdog() {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        MTProtoWatchdog.INSTANCE.stop(mTProtoConnection);
    }

    public final void resetConnection() throws IOException {
        MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "resetConnection()");
        TimerTask timerTask = this.bufferTimeoutTask;
        if (timerTask != null) {
            timerTask.cancel();
        }
        this.onBufferTimeout(this.bufferId, false);
        this.close();
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        this.session = this.newSession(mTProtoConnection.getDataCenter());
        MTProtoConnection mTProtoConnection2 = this.connection;
        if (mTProtoConnection2 == null) {
            Intrinsics.throwNpe();
        }
        String string = mTProtoConnection2.getIp();
        MTProtoConnection mTProtoConnection3 = this.connection;
        if (mTProtoConnection3 == null) {
            Intrinsics.throwNpe();
        }
        this.connection = new MTProtoTcpConnection(string, mTProtoConnection3.getPort(), this.session.getTag(), false, 8, null);
        this.startWatchdog();
        this.executeMethod((TLMethod)new TLRequestHelpGetNearestDc(), 5L);
    }

    public final void close() {
        MTProtoHandler.Companion.getLogger().info(this.session.getMarker(), "close()");
        TimerTask timerTask = this.bufferTimeoutTask;
        if (timerTask != null) {
            timerTask.cancel();
        }
        MTProtoHandler.onBufferTimeout$default(this, this.bufferId, false, 2, null);
        try {
            this.stopWatchdog();
            MTProtoConnection mTProtoConnection = this.connection;
            if (mTProtoConnection == null) {
                Intrinsics.throwNpe();
            }
            mTProtoConnection.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.subscriberMap.clear();
        this.requestMap.clear();
        this.sentMessageList.clear();
        this.messageToAckList.clear();
        this.requestQueue.clear();
    }

    @NotNull
    public final <T extends TLObject> T executeMethodSync(@NotNull TLMethod<T> method, long timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Object object = this.executeMethod(method, timeout).toBlocking().first();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"executeMethod(method, ti\u2026out).toBlocking().first()");
        return (T)((TLObject)object);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T extends TLObject> List<T> executeMethodsSync(@NotNull List<? extends TLMethod<? extends T>> methods, long timeout) throws IOException {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
        Iterable iterable = this.executeMethods(methods, timeout).toBlocking().toIterable();
        Iterable iterable2 = $receiver$iv;
        Comparator comparator = new Comparator<TLMethod<T>>(methods){
            final /* synthetic */ List $methods$inlined;
            {
                this.$methods$inlined = list;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public int compare(Object a, Object b) {
                TLMethod it = (TLMethod)a;
                Comparable comparable = Integer.valueOf(this.$methods$inlined.indexOf(it));
                it = (TLMethod)b;
                Comparable comparable2 = comparable;
                Integer n = this.$methods$inlined.indexOf(it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
            }
        };
        $receiver$iv = CollectionsKt.sortedWith((Iterable)iterable2, (Comparator)comparator);
        iterable2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            TLMethod tLMethod = (TLMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            TLObject tLObject = it.getResponse();
            collection.add(tLObject);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @NotNull
    public final <T extends TLObject> Observable<T> queueMethod(@NotNull TLMethod<T> method, int type, long validityTimeout, long timeout) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Observable observable2 = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(this, method, validityTimeout){
            final /* synthetic */ MTProtoHandler this$0;
            final /* synthetic */ TLMethod $method;
            final /* synthetic */ long $validityTimeout;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void call(Subscriber<? super TLMethod<T>> subscriber) {
                LinkedList linkedList = MTProtoHandler.access$getRequestQueue$p(this.this$0);
                synchronized (linkedList) {
                    com.github.badoualy.telegram.mtproto.MTProtoHandler$Companion.access$getLogger$p(MTProtoHandler.Companion).debug(this.this$0.getSession().getMarker(), "Queued " + this.$method + " with validityTimeout of " + this.$validityTimeout);
                    LinkedList linkedList2 = MTProtoHandler.access$getRequestQueue$p(this.this$0);
                    long l = System.currentTimeMillis() + this.$validityTimeout;
                    Subscriber<? super TLMethod<T>> subscriber2 = subscriber;
                    Intrinsics.checkExpressionValueIsNotNull(subscriber2, (String)"subscriber");
                    boolean bl = linkedList2.add(new QueuedMethod<T>(this.$method, l, subscriber2));
                }
            }
            {
                this.this$0 = mTProtoHandler;
                this.$method = tLMethod;
                this.$validityTimeout = l;
            }
        }).map((Func1)queueMethod.2.INSTANCE).timeout(timeout, TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"Observable.create<TLMeth\u2026t, TimeUnit.MILLISECONDS)");
        return observable2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Observable queueMethod$default(MTProtoHandler mTProtoHandler, TLMethod tLMethod, int n, long l, long l2, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = Companion.getQUEUE_TYPE_DISCARD();
        }
        return mTProtoHandler.queueMethod(tLMethod, n, l, l2);
    }

    @NotNull
    public final <T extends TLObject> Observable<T> executeMethod(@NotNull TLMethod<T> method, long timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        Observable observable2 = this.executeMethods(CollectionsKt.listOf(method), timeout).map((Func1)executeMethod.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable2, (String)"executeMethods(listOf(me\u2026eout).map { it.response }");
        return observable2;
    }

    @NotNull
    public final <T extends TLObject> Observable<TLMethod<T>> executeMethods(@NotNull List<? extends TLMethod<? extends T>> methods, long timeout) throws IOException {
        Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
        if (methods.isEmpty()) {
            throw (Throwable)new IllegalArgumentException("No methods to execute");
        }
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "executeMethod " + CollectionsKt.joinToString$default((Iterable)methods, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        Observable observable2 = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<T>(this, methods){
            final /* synthetic */ MTProtoHandler this$0;
            final /* synthetic */ List $methods;

            public final void call(Subscriber<? super TLMethod<T>> subscriber) {
                try {
                    List extraMethod;
                    Collection collection;
                    ArrayList<MTMessage> mtMessages = new ArrayList<MTMessage>(2);
                    MTMessage extraAck = MTProtoHandler.access$getAckToSend(this.this$0);
                    if (extraAck != null) {
                        mtMessages.add(extraAck);
                    }
                    if (!(collection = (Collection)(extraMethod = MTProtoHandler.access$getQueuedRequestToSend(this.this$0))).isEmpty()) {
                        com.github.badoualy.telegram.mtproto.MTProtoHandler$Companion.access$getLogger$p(MTProtoHandler.Companion).trace(this.this$0.getSession().getMarker(), "Queued " + extraMethod.size() + " methods");
                        mtMessages.addAll(extraMethod);
                    }
                    Subscriber<? super TLMethod<T>> subscriber2 = subscriber;
                    if (subscriber2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type rx.Subscriber<com.github.badoualy.telegram.tl.core.TLMethod<*>>");
                    }
                    Subscriber<? super TLMethod<T>> s = subscriber2;
                    Iterable $receiver$iv = this.$methods;
                    for (T element$iv : $receiver$iv) {
                        TLMethod method = (TLMethod)element$iv;
                        long l = this.this$0.getSession().generateMessageId();
                        int n = this.this$0.getSession().generateSeqNo((TLObject)method);
                        byte[] byArray = method.serialize();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"method.serialize()");
                        MTMessage mtMessage = new MTMessage(l, n, byArray, 0, 8, null);
                        mtMessages.add(mtMessage);
                        com.github.badoualy.telegram.mtproto.MTProtoHandler$Companion.access$getLogger$p(MTProtoHandler.Companion).info(this.this$0.getSession().getMarker(), "Sending method " + method + " with msgId " + mtMessage.getMessageId() + " and seqNo " + mtMessage.getSeqNo());
                        MTProtoHandler.access$getSubscriberMap$p(this.this$0).put(mtMessage.getMessageId(), s);
                        MTProtoHandler.access$getRequestMap$p(this.this$0).put(mtMessage.getMessageId(), method);
                    }
                    if (mtMessages.size() > 1) {
                        com.github.badoualy.telegram.mtproto.MTProtoHandler$Companion.access$getLogger$p(MTProtoHandler.Companion).debug(this.this$0.getSession().getMarker(), "Sending methods in container");
                        MTMessagesContainer container = new MTMessagesContainer();
                        container.getMessages().addAll((Collection<MTMessage>)mtMessages);
                        long l = this.this$0.getSession().generateMessageId();
                        int n = this.this$0.getSession().generateSeqNo(container);
                        byte[] byArray = container.serialize();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"container.serialize()");
                        MTProtoHandler.access$sendMessage(this.this$0, new MTMessage(l, n, byArray, 0, 8, null));
                    } else {
                        com.github.badoualy.telegram.mtproto.MTProtoHandler$Companion.access$getLogger$p(MTProtoHandler.Companion).debug(this.this$0.getSession().getMarker(), "Sending single method");
                        MTProtoHandler.access$sendMessage(this.this$0, (MTMessage)((Object)CollectionsKt.first((List)mtMessages)));
                    }
                }
                catch (IOException e) {
                    subscriber.onError((Throwable)e);
                }
            }
            {
                this.this$0 = mTProtoHandler;
                this.$methods = list;
            }
        });
        Observable observable3 = observable2.timeout(timeout, TimeUnit.MILLISECONDS);
        Intrinsics.checkExpressionValueIsNotNull((Object)observable3, (String)"observable.timeout(timeout, TimeUnit.MILLISECONDS)");
        return observable3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void sendMessageAck(long messageId) throws IOException {
        Object flush;
        Ref.IntRef id;
        Object startTimer;
        Object list;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Ref.BooleanRef booleanRef2 = new Ref.BooleanRef();
        booleanRef2.element = false;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Ref.IntRef intRef = new Ref.IntRef();
        intRef.element = -1;
        ArrayList<Long> arrayList = this.messageToAckList;
        synchronized (arrayList) {
            list.element = this.messageToAckList;
            ArrayList arrayList2 = (ArrayList)list.element;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            arrayList2.add(messageId);
            MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), "Adding msgId " + messageId + " to bufferId " + this.bufferId);
            id.element = this.bufferId;
            ArrayList arrayList3 = (ArrayList)list.element;
            if (arrayList3 == null) {
                Intrinsics.throwNpe();
            }
            if (arrayList3.size() == 1) {
                startTimer.element = true;
            } else {
                ArrayList arrayList4 = (ArrayList)list.element;
                if (arrayList4 == null) {
                    Intrinsics.throwNpe();
                }
                if (arrayList4.size() < this.ACK_BUFFER_SIZE) {
                    return;
                }
                this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
                int n = this.bufferId;
                this.bufferId = n + 1;
                flush.element = true;
            }
            Unit unit = Unit.INSTANCE;
        }
        if (startTimer.element) {
            try {
                this.bufferTimeoutTask = MTProtoTimer.INSTANCE.schedule(this.ACK_BUFFER_TIMEOUT, (Function1<? super TimerTask, Unit>)((Function1)new Function1<TimerTask, Unit>(this, id){
                    final /* synthetic */ MTProtoHandler this$0;
                    final /* synthetic */ Ref.IntRef $id;

                    public final void invoke(@NotNull TimerTask $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        MTProtoHandler.onBufferTimeout$default(this.this$0, this.$id.element, false, 2, null);
                    }
                    {
                        this.this$0 = mTProtoHandler;
                        this.$id = intRef;
                        super(1);
                    }
                }));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (flush.element) {
            MTProtoHandler.Companion.getLogger().info(this.session.getMarker(), "Flushing ack buffer");
            TimerTask timerTask = this.bufferTimeoutTask;
            if (timerTask != null) {
                timerTask.cancel();
            }
            this.bufferTimeoutTask = null;
            ArrayList arrayList5 = (ArrayList)list.element;
            if (arrayList5 == null) {
                Intrinsics.throwNpe();
            }
            this.sendMessagesAck(CollectionsKt.toLongArray((Collection)arrayList5));
        }
        id = null;
        list = null;
        startTimer = null;
        flush = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onBufferTimeout(int id, boolean flush) {
        Object list;
        MTProtoConnection mTProtoConnection = this.connection;
        if (!(mTProtoConnection != null ? mTProtoConnection.isOpen() : false)) {
            return;
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ArrayList<Long> arrayList = this.messageToAckList;
        synchronized (arrayList) {
            if (id != this.bufferId) {
                return;
            }
            list.element = this.messageToAckList;
            this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
            int n = this.bufferId;
            this.bufferId = n + 1;
            int n2 = n;
        }
        if (flush) {
            ArrayList arrayList2 = (ArrayList)list.element;
            if (arrayList2 == null) {
                Intrinsics.throwNpe();
            }
            this.sendMessagesAck(CollectionsKt.toLongArray((Collection)arrayList2));
        }
        list = null;
    }

    static /* bridge */ /* synthetic */ void onBufferTimeout$default(MTProtoHandler mTProtoHandler, int n, boolean bl, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = true;
        }
        mTProtoHandler.onBufferTimeout(n, bl);
    }

    private final void sendMessagesAck(long[] messagesId) throws IOException {
        long[] lArray = messagesId;
        if (lArray.length == 0) {
            return;
        }
        MTMsgsAck ackMessage = new MTMsgsAck(messagesId);
        long ackMessageId = this.session.generateMessageId();
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Sending ack for messages " + ArraysKt.joinToString$default((long[])messagesId, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " with ackMsgId " + ackMessageId);
        int n = this.session.generateSeqNo(ackMessage);
        byte[] byArray = ackMessage.serialize();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ackMessage.serialize()");
        this.sendMessage(new MTMessage(ackMessageId, n, byArray, 0, 8, null));
    }

    private final void sendMessage(MTMessage message) throws IOException {
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Sending message with msgId " + message.getMessageId() + " and seqNo " + message.getSeqNo());
        AuthKey authKey = this.authKey;
        if (authKey == null) {
            Intrinsics.throwNpe();
        }
        EncryptedMessage encryptedMessage = MTProtoMessageEncryption.Companion.encrypt(authKey, this.session.getId(), this.session.getSalt(), message);
        this.sendData(encryptedMessage.getData());
        this.sentMessageList.add(message);
    }

    private final void sendData(byte[] data) {
        MTProtoConnection mTProtoConnection = this.connection;
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        mTProtoConnection.writeMessage(data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final MTMessage getAckToSend() {
        void toAckList;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        ArrayList<Long> arrayList = this.messageToAckList;
        synchronized (arrayList) {
            toAckList.element = this.messageToAckList;
            Collection collection = this.messageToAckList;
            if (!collection.isEmpty()) {
                this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
                int n = this.bufferId;
                this.bufferId = n + 1;
                TimerTask timerTask = this.bufferTimeoutTask;
                if (timerTask != null) {
                    timerTask.cancel();
                }
                this.bufferTimeoutTask = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        ArrayList arrayList2 = (ArrayList)toAckList.element;
        if ((arrayList2 != null ? arrayList2.size() : 0) > 0) {
            ArrayList arrayList3 = (ArrayList)toAckList.element;
            if (arrayList3 == null) {
                Intrinsics.throwNpe();
            }
            MTMsgsAck ack = new MTMsgsAck(CollectionsKt.toLongArray((Collection)arrayList3));
            long l = this.session.generateMessageId();
            int n = this.session.generateSeqNo(ack);
            byte[] byArray = ack.serialize();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ack.serialize()");
            MTMessage ackMessage = new MTMessage(l, n, byArray, 0, 8, null);
            Logger logger = MTProtoHandler.Companion.getLogger();
            Marker marker = this.session.getMarker();
            StringBuilder stringBuilder = new StringBuilder().append("Building ack for messages ");
            ArrayList arrayList4 = (ArrayList)toAckList.element;
            if (arrayList4 == null) {
                Intrinsics.throwNpe();
            }
            logger.debug(marker, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)arrayList4, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)).append(" with msgId ").append(ackMessage.getMessageId()).append(" and seqNo ").append(ackMessage.getSeqNo()).toString());
            return ackMessage;
        }
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "No extra ack to send");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<MTMessage> getQueuedRequestToSend() {
        void $receiver$iv$iv;
        void toSend;
        QueuedMethod<?> request;
        block15: {
            block14: {
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                LinkedList<QueuedMethod<?>> linkedList = this.requestQueue;
                synchronized (linkedList) {
                    Collection collection = this.requestQueue;
                    if (!collection.isEmpty()) {
                        Collection collection2;
                        toSend.element = new ArrayList(5);
                        long time = System.currentTimeMillis();
                        while (!(collection2 = (Collection)this.requestQueue).isEmpty()) {
                            request = this.requestQueue.remove();
                            if (request.getValidityTimeout() < time) {
                                MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Queued method " + request.getMethod() + " timed out, dropping");
                                request.getSubscriber().onCompleted();
                                continue;
                            }
                            List list = (List)toSend.element;
                            if (list == null) {
                                Intrinsics.throwNpe();
                            }
                            QueuedMethod<?> queuedMethod = request;
                            Intrinsics.checkExpressionValueIsNotNull((Object)queuedMethod, (String)"request");
                            list.add(queuedMethod);
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if ((List)toSend.element == null) break block14;
                List list = (List)toSend.element;
                if (list == null) {
                    Intrinsics.throwNpe();
                }
                if (!list.isEmpty()) break block15;
            }
            return CollectionsKt.emptyList();
        }
        List list = (List)toSend.element;
        if (list == null) {
            Intrinsics.throwNpe();
        }
        Iterable $receiver$iv = list;
        request = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Subscriber s;
            void it;
            QueuedMethod $i$a$1$synchronized = (QueuedMethod)item$iv$iv;
            Collection collection = destination$iv$iv;
            long msgId = this.session.generateMessageId();
            if (it.getSubscriber() == null) {
                throw new TypeCastException("null cannot be cast to non-null type rx.Subscriber<com.github.badoualy.telegram.tl.core.TLMethod<*>>");
            }
            this.subscriberMap.put(msgId, s);
            this.requestMap.put(msgId, it.getMethod());
            int n = this.session.generateSeqNo((TLObject)it.getMethod());
            byte[] byArray = it.getMethod().serialize();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"it.method.serialize()");
            MTMessage mTMessage = new MTMessage(msgId, n, byArray, 0, 8, null);
            collection.add(mTMessage);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    private final void onErrorReceived(Throwable it) {
        Subscriber singleSubscriber;
        Object v0;
        MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "onErrorReceived()", it);
        Map map = this.subscriberMap;
        Iterable iterable = map.entrySet();
        Iterator iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            v0 = null;
        } else {
            Object t = iterator.next();
            Map.Entry it2 = (Map.Entry)t;
            Comparable comparable = (Long)it2.getKey();
            while (iterator.hasNext()) {
                Object t2 = iterator.next();
                Map.Entry it3 = (Map.Entry)t2;
                Comparable comparable2 = (Long)it3.getKey();
                if (comparable.compareTo(comparable2) >= 0) continue;
                t = t2;
                comparable = comparable2;
            }
            v0 = t;
        }
        Map.Entry entry = v0;
        Object object = singleSubscriber = entry != null ? (Subscriber)entry.getValue() : null;
        if (singleSubscriber != null) {
            MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Found a single subscriber, sending timeout");
            singleSubscriber.onError((Throwable)new TimeoutException());
        } else {
            this.resetConnection();
        }
    }

    private final void onMessageReceived(byte[] bytes) {
        Object message;
        block9: {
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = new MTMessage(0L, 0, null, 0, 15, null);
            try {
                if (bytes.length == 4) {
                    this.onErrorReceived((Throwable)new RpcErrorException(StreamUtils.readInt((byte[])bytes), "INVALID_AUTH_KEY"));
                    return;
                }
                AuthKey authKey = this.authKey;
                if (authKey == null) {
                    Intrinsics.throwNpe();
                }
                message.element = MTProtoMessageEncryption.Companion.decrypt(authKey, this.session.getId(), bytes);
                MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Received msg " + ((MTMessage)((Object)message.element)).getMessageId() + " with seqNo " + ((MTMessage)((Object)message.element)).getSeqNo());
                int n = StreamUtils.readInt((byte[])((MTMessage)((Object)message.element)).getPayload());
                if (n == MTMessagesContainer.CONSTRUCTOR_ID) {
                    Object v1;
                    MTMessagesContainer container;
                    block8: {
                        MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), "Message is a container");
                        container = (MTMessagesContainer)MTProtoHandler.Companion.getMtProtoContext().deserializeMessage(((MTMessage)((Object)message.element)).getPayload(), MTMessagesContainer.class, MTMessagesContainer.CONSTRUCTOR_ID);
                        MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), "Container has " + container.getMessages().size() + " items");
                        Iterable $receiver$iv = container.getMessages();
                        for (Object element$iv : $receiver$iv) {
                            MTMessage m = (MTMessage)((Object)element$iv);
                            if (!(m.getMessageId() >= ((MTMessage)((Object)message.element)).getMessageId())) continue;
                            v1 = element$iv;
                            break block8;
                        }
                        v1 = null;
                    }
                    if (v1 != null) {
                        MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "Message contained in container has a same or greater msgId than container, ignoring whole container");
                        throw (Throwable)new SecurityException("Message contained in container has a same or greater msgId than container, ignoring whole container");
                    }
                    Iterator<Object> iterator = container.getMessages().iterator();
                    while (iterator.hasNext()) {
                        MTMessage msg;
                        MTMessage mTMessage = msg = (MTMessage)((Object)iterator.next());
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)mTMessage), (String)"msg");
                        this.handleMessage(mTMessage);
                    }
                    break block9;
                }
                this.handleMessage((MTMessage)((Object)message.element));
            }
            catch (IOException e) {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Unknown error", (Throwable)e);
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Hex dump " + StreamUtils.toHexString((byte[])((MTMessage)((Object)message.element)).getPayload()));
            }
        }
        message = null;
    }

    private final TLObject deserializeMessageContent(MTMessage message) throws DeserializationException, IOException {
        int classId = StreamUtils.readInt((byte[])message.getPayload());
        MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), "Reading constructor " + classId);
        if (MTProtoHandler.Companion.getMtProtoContext().isSupportedObject(classId)) {
            MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), classId + " is supported by MTProtoContext");
            TLObject tLObject = MTProtoHandler.Companion.getMtProtoContext().deserializeMessage(message.getPayload());
            Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"mtProtoContext.deserializeMessage(message.payload)");
            return tLObject;
        }
        MTProtoHandler.Companion.getLogger().trace(this.session.getMarker(), classId + " is not supported by MTProtoContext");
        TLObject tLObject = MTProtoHandler.Companion.getApiContext().deserializeMessage(message.getPayload());
        Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"apiContext.deserializeMessage(message.payload)");
        return tLObject;
    }

    /*
     * WARNING - void declaration
     */
    private final void handleMessage(MTMessage message) throws IOException {
        TLObject messageContent = this.deserializeMessageContent(message);
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "handle " + messageContent);
        TLObject tLObject = messageContent;
        if (tLObject instanceof MTMsgsAck) {
            MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Received ack for " + CollectionsKt.joinToString$default((Iterable)((Iterable)((MTMsgsAck)messageContent).getMessages()), (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        } else if (tLObject instanceof MTRpcResult) {
            this.handleResult((MTRpcResult)messageContent);
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof TLAbsUpdates) {
            MTProtoHandler.Companion.getUpdatePool().execute(new Runnable(this, messageContent){
                final /* synthetic */ MTProtoHandler this$0;
                final /* synthetic */ TLObject $messageContent;

                public final void run() {
                    block0: {
                        ApiCallback apiCallback = MTProtoHandler.access$getApiCallback$p(this.this$0);
                        if (apiCallback == null) break block0;
                        apiCallback.onUpdates((TLAbsUpdates)this.$messageContent);
                    }
                }
                {
                    this.this$0 = mTProtoHandler;
                    this.$messageContent = tLObject;
                }
            });
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof MTNewSessionCreated) {
            this.sendMessageAck(message.getMessageId());
        } else if (tLObject instanceof MTBadMessageNotification) {
            this.handleBadMessage((MTBadMessageNotification)messageContent, message);
        } else if (tLObject instanceof MTBadServerSalt) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), ((MTBadServerSalt)messageContent).toPrettyString());
            this.session.setSalt(((MTBadServerSalt)messageContent).getNewSalt());
            Iterable iterable = $receiver$iv = (Iterable)this.sentMessageList;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MTMessage it = (MTMessage)((Object)element$iv$iv);
                if (!(it.getMessageId() == ((MTBadServerSalt)messageContent).getBadMsgId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MTMessage sentMessage = (MTMessage)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (sentMessage != null) {
                MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "Re-sending message " + ((MTBadServerSalt)messageContent).getBadMsgId() + " with new salt");
                this.sendMessage(sentMessage);
            } else {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Couldn't find sentMessage in history with msgId " + ((MTBadServerSalt)messageContent).getBadMsgId() + ", can't re-send with good salt");
            }
        } else if (tLObject instanceof MTNeedResendMessage) {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "TODO MTNeedResendMessage");
        } else if (tLObject instanceof MTNewMessageDetailedInfo) {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "TODO MTNewMessageDetailedInfo");
        } else if (tLObject instanceof MTMessageDetailedInfo) {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "TODO MTMessageDetailedInfo");
        } else if (tLObject instanceof MTFutureSalts) {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "TODO MTFutureSalts");
        } else {
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Unsupported constructor in handleMessage() " + messageContent + ": " + messageContent.getClass().getSimpleName());
            throw (Throwable)new IllegalStateException("Unsupported constructor in handleMessage() " + messageContent + ": " + messageContent.getClass().getSimpleName());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleBadMessage(MTBadMessageNotification badMessage, MTMessage container) throws IOException {
        MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), badMessage.toPrettyString());
        int n = badMessage.getErrorCode();
        if (n == MTBadMessage.ERROR_MSG_ID_TOO_LOW || n == MTBadMessage.ERROR_MSG_ID_TOO_HIGH) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            this.session.setLastMessageId(0L);
            MTProtoConnection mTProtoConnection = this.connection;
            if (mTProtoConnection == null) {
                Intrinsics.throwNpe();
            }
            TimeOverlord.INSTANCE.synchronizeTime(mTProtoConnection.getDataCenter(), container.getMessageId());
            Iterable iterable = $receiver$iv = (Iterable)this.sentMessageList;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MTMessage it = (MTMessage)((Object)element$iv$iv);
                if (!(it.getMessageId() == badMessage.getBadMsgId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MTMessage sentMessage = (MTMessage)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (sentMessage != null) {
                Subscriber<TLMethod<?>> subscriber = this.subscriberMap.remove(sentMessage.getMessageId());
                TLMethod<?> request = this.requestMap.remove(sentMessage.getMessageId());
                sentMessage.setMessageId(this.session.generateMessageId());
                this.subscriberMap.put(sentMessage.getMessageId(), subscriber);
                this.requestMap.put(sentMessage.getMessageId(), request);
                MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Re-sending message " + badMessage.getBadMsgId() + " with new msgId " + sentMessage.getMessageId());
                this.sendMessage(sentMessage);
            } else {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Couldn't find sentMessage in history with msgId " + badMessage.getBadMsgId() + ", can't re-send with good msgId");
            }
        } else if (n == MTBadMessage.ERROR_SEQNO_TOO_LOW || n == MTBadMessage.ERROR_SEQNO_TOO_HIGH) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            int sentMessage;
            if (badMessage.getErrorCode() == MTBadMessage.ERROR_MSG_ID_TOO_LOW) {
                MTSession mTSession = this.session;
                sentMessage = mTSession.getContentRelatedCount();
                mTSession.setContentRelatedCount(sentMessage + 1);
            } else {
                MTSession mTSession = this.session;
                sentMessage = mTSession.getContentRelatedCount();
                mTSession.setContentRelatedCount(sentMessage + -1);
            }
            Iterable request = $receiver$iv = (Iterable)this.sentMessageList;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                MTMessage it = (MTMessage)((Object)element$iv$iv);
                if (!(it.getMessageId() == badMessage.getBadMsgId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            MTMessage sentMessage2 = (MTMessage)((Object)CollectionsKt.firstOrNull((List)((List)destination$iv$iv)));
            if (sentMessage2 != null) {
                MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "Re-sending message " + badMessage.getBadMsgId() + " with new seqno");
                this.sendMessage(sentMessage2);
            } else {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Couldn't find sentMessage in history with msgId " + badMessage.getBadMsgId() + ", can't re-send with good seqno");
            }
        } else if (n == MTBadMessage.ERROR_SEQNO_EXPECTED_EVEN) {
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "ERROR_SEQNO_EXPECTED_EVEN for " + badMessage.getBadMsgId());
        } else if (n == MTBadMessage.ERROR_SEQNO_EXPECTED_ODD) {
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "ERROR_SEQNO_EXPECTED_ODD for " + badMessage.getBadMsgId());
        } else if (n == MTBadMessage.ERROR_MSG_ID_MODULO) {
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "ERROR_MSG_ID_MODULO for " + badMessage.getBadMsgId());
        } else {
            MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Unknown error " + badMessage.toPrettyString());
        }
    }

    private final void handleResult(MTRpcResult result) throws IOException {
        TLMethod<?> tLMethod;
        Subscriber<TLMethod<?>> subscriber;
        Subscriber<TLMethod<?>> subscriber2;
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Got result for msgId " + result.getMessageId());
        if (this.subscriberMap.containsKey(result.getMessageId())) {
            Subscriber<TLMethod<?>> subscriber3 = this.subscriberMap.remove(result.getMessageId());
            if (subscriber3 == null) {
                Intrinsics.throwNpe();
            }
            subscriber2 = subscriber3;
        } else {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "No subscriber found for msgId " + result.getMessageId());
            subscriber2 = subscriber = null;
        }
        if (this.requestMap.containsKey(result.getMessageId())) {
            TLMethod<?> tLMethod2 = this.requestMap.remove(result.getMessageId());
            if (tLMethod2 == null) {
                Intrinsics.throwNpe();
            }
            tLMethod = tLMethod2;
        } else {
            MTProtoHandler.Companion.getLogger().warn(this.session.getMarker(), "No request object found for msgId " + result.getMessageId());
            tLMethod = null;
        }
        TLMethod<?> request = tLMethod;
        int classId = StreamUtils.readInt((byte[])result.getContent());
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "Response is a " + classId);
        if (MTProtoHandler.Companion.getMtProtoContext().isSupportedObject(classId)) {
            TLObject resultContent = MTProtoHandler.Companion.getMtProtoContext().deserializeMessage(result.getContent());
            if (resultContent instanceof MTRpcError) {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "rpcError " + ((MTRpcError)resultContent).getErrorCode() + ": " + ((MTRpcError)resultContent).getMessage());
                Subscriber<TLMethod<?>> subscriber4 = subscriber;
                if (subscriber4 != null) {
                    subscriber4.onError((Throwable)new RpcErrorException(((MTRpcError)resultContent).getErrorCode(), ((MTRpcError)resultContent).getErrorTag()));
                }
            } else {
                MTProtoHandler.Companion.getLogger().error(this.session.getMarker(), "Unsupported content " + (Object)((Object)result));
            }
        } else {
            TLObject response;
            TLObject tLObject = response = request != null ? request.deserializeResponse(result.getContent(), (TLContext)MTProtoHandler.Companion.getApiContext()) : MTProtoHandler.Companion.getApiContext().deserializeMessage(result.getContent());
            if (request != null) {
                request.setResponse(response);
                Subscriber<TLMethod<?>> subscriber5 = subscriber;
                if (subscriber5 != null) {
                    subscriber5.onNext(request);
                }
            }
        }
        if (subscriber != null && !this.subscriberMap.containsValue(subscriber)) {
            subscriber.onCompleted();
        }
    }

    public MTProtoHandler(@NotNull AuthResult authResult, @Nullable ApiCallback apiCallback, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)authResult, (String)"authResult");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.ACK_BUFFER_SIZE = 15;
        this.ACK_BUFFER_TIMEOUT = 150000L;
        this.subscriberMap = new Hashtable(10);
        this.requestMap = new Hashtable(10);
        this.sentMessageList = new ArrayList(10);
        this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
        this.requestQueue = new LinkedList();
        this.tag = tag;
        this.apiCallback = apiCallback;
        MTProtoConnection mTProtoConnection = this.connection = authResult.getConnection();
        if (mTProtoConnection == null) {
            Intrinsics.throwNpe();
        }
        this.session = new MTSession(mTProtoConnection.getDataCenter(), null, 0L, 0, 0L, tag, 30, null);
        this.session.setSalt(authResult.getServerSalt());
        MTProtoConnection mTProtoConnection2 = this.connection;
        if (mTProtoConnection2 == null) {
            Intrinsics.throwNpe();
        }
        mTProtoConnection2.setTag(this.session.getTag());
        this.authKey = authResult.getAuthKey();
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "New handler from authResult");
    }

    public MTProtoHandler(@NotNull DataCenter dataCenter, @NotNull AuthKey authKey, @Nullable MTSession session, @Nullable ApiCallback apiCallback, @NotNull String tag) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)dataCenter, (String)"dataCenter");
        Intrinsics.checkParameterIsNotNull((Object)authKey, (String)"authKey");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.ACK_BUFFER_SIZE = 15;
        this.ACK_BUFFER_TIMEOUT = 150000L;
        this.subscriberMap = new Hashtable(10);
        this.requestMap = new Hashtable(10);
        this.sentMessageList = new ArrayList(10);
        this.messageToAckList = new ArrayList(this.ACK_BUFFER_SIZE);
        this.requestQueue = new LinkedList();
        this.apiCallback = apiCallback;
        this.tag = tag;
        MTSession mTSession = session;
        if (mTSession == null) {
            mTSession = new MTSession(dataCenter, null, 0L, 0, 0L, tag, 30, null);
        }
        this.session = mTSession;
        this.connection = new MTProtoTcpConnection(dataCenter.getIp(), dataCenter.getPort(), this.session.getTag(), false, 8, null);
        this.authKey = authKey;
        MTProtoHandler.Companion.getLogger().debug(this.session.getMarker(), "New handler from existing key");
    }

    static {
        Companion = new Companion(null);
        Logger logger = LoggerFactory.getLogger(MTProtoHandler.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        MTProtoHandler.logger = logger;
        mtProtoContext = MTProtoContext.INSTANCE;
        apiContext = TLApiContext.getInstance();
        updatePool = new ThreadPoolExecutor(4, 8, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new LinkedBlockingQueue(), new NamedThreadFactory("UpdatePool", false, 2, null));
    }

    public static final /* synthetic */ void access$onErrorReceived(MTProtoHandler $this, @NotNull Throwable it) {
        $this.onErrorReceived(it);
    }

    public static final /* synthetic */ void access$onMessageReceived(MTProtoHandler $this, @NotNull byte[] bytes) {
        $this.onMessageReceived(bytes);
    }

    @NotNull
    public static final /* synthetic */ LinkedList access$getRequestQueue$p(MTProtoHandler $this) {
        return $this.requestQueue;
    }

    public static final /* synthetic */ void access$setRequestQueue$p(MTProtoHandler $this, @NotNull LinkedList linkedList) {
        $this.requestQueue = linkedList;
    }

    @NotNull
    public static final /* synthetic */ MTSession access$getSession$p(MTProtoHandler $this) {
        return $this.session;
    }

    public static final /* synthetic */ void access$setSession$p(MTProtoHandler $this, @NotNull MTSession mTSession) {
        $this.session = mTSession;
    }

    @Nullable
    public static final /* synthetic */ MTMessage access$getAckToSend(MTProtoHandler $this) {
        return $this.getAckToSend();
    }

    @NotNull
    public static final /* synthetic */ List access$getQueuedRequestToSend(MTProtoHandler $this) {
        return $this.getQueuedRequestToSend();
    }

    @NotNull
    public static final /* synthetic */ Hashtable access$getSubscriberMap$p(MTProtoHandler $this) {
        return $this.subscriberMap;
    }

    @NotNull
    public static final /* synthetic */ Hashtable access$getRequestMap$p(MTProtoHandler $this) {
        return $this.requestMap;
    }

    public static final /* synthetic */ void access$sendMessage(MTProtoHandler $this, @NotNull MTMessage message) {
        $this.sendMessage(message);
    }

    @Nullable
    public static final /* synthetic */ ApiCallback access$getApiCallback$p(MTProtoHandler $this) {
        return $this.apiCallback;
    }

    public static final int getQUEUE_TYPE_DISCARD() {
        return Companion.getQUEUE_TYPE_DISCARD();
    }

    @JvmStatic
    public static final void shutdown() {
        Companion.shutdown();
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003B1\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0014\u0010\b\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\t\u00a2\u0006\u0002\u0010\nJ\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J\u0017\u0010\u0013\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\tH\u00c6\u0003JA\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0016\b\u0002\u0010\b\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\tH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001f\u0010\b\u001a\u0010\u0012\f\b\u0000\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoHandler$QueuedMethod;", "T", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "", "method", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "validityTimeout", "", "subscriber", "Lrx/Subscriber;", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;JLrx/Subscriber;)V", "getMethod", "()Lcom/github/badoualy/telegram/tl/core/TLMethod;", "getSubscriber", "()Lrx/Subscriber;", "getValidityTimeout", "()J", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "mtproto_main"})
    private static final class QueuedMethod<T extends TLObject> {
        @NotNull
        private final TLMethod<T> method;
        private final long validityTimeout;
        @NotNull
        private final Subscriber<? super TLMethod<T>> subscriber;

        @NotNull
        public final TLMethod<T> getMethod() {
            return this.method;
        }

        public final long getValidityTimeout() {
            return this.validityTimeout;
        }

        @NotNull
        public final Subscriber<? super TLMethod<T>> getSubscriber() {
            return this.subscriber;
        }

        public QueuedMethod(@NotNull TLMethod<T> method, long validityTimeout, @NotNull Subscriber<? super TLMethod<T>> subscriber) {
            Intrinsics.checkParameterIsNotNull(method, (String)"method");
            Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
            this.method = method;
            this.validityTimeout = validityTimeout;
            this.subscriber = subscriber;
        }

        @NotNull
        public final TLMethod<T> component1() {
            return this.method;
        }

        public final long component2() {
            return this.validityTimeout;
        }

        @NotNull
        public final Subscriber<? super TLMethod<T>> component3() {
            return this.subscriber;
        }

        @NotNull
        public final QueuedMethod<T> copy(@NotNull TLMethod<T> method, long validityTimeout, @NotNull Subscriber<? super TLMethod<T>> subscriber) {
            Intrinsics.checkParameterIsNotNull(method, (String)"method");
            Intrinsics.checkParameterIsNotNull(subscriber, (String)"subscriber");
            return new QueuedMethod<T>(method, validityTimeout, subscriber);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ QueuedMethod copy$default(QueuedMethod queuedMethod, TLMethod tLMethod, long l, Subscriber subscriber, int n, Object object) {
            if ((n & 1) != 0) {
                tLMethod = queuedMethod.method;
            }
            if ((n & 2) != 0) {
                l = queuedMethod.validityTimeout;
            }
            if ((n & 4) != 0) {
                subscriber = queuedMethod.subscriber;
            }
            return queuedMethod.copy(tLMethod, l, subscriber);
        }

        public String toString() {
            return "QueuedMethod(method=" + this.method + ", validityTimeout=" + this.validityTimeout + ", subscriber=" + this.subscriber + ")";
        }

        public int hashCode() {
            TLMethod<T> tLMethod = this.method;
            long l = this.validityTimeout;
            Subscriber<TLMethod<T>> subscriber = this.subscriber;
            return ((tLMethod != null ? tLMethod.hashCode() : 0) * 31 + (int)(l ^ l >>> 32)) * 31 + (subscriber != null ? subscriber.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof QueuedMethod)) break block3;
                    QueuedMethod queuedMethod = (QueuedMethod)object;
                    if (!Intrinsics.areEqual(this.method, queuedMethod.method) || !(this.validityTimeout == queuedMethod.validityTimeout) || !Intrinsics.areEqual(this.subscriber, queuedMethod.subscriber)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0007R\u001c\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/github/badoualy/telegram/mtproto/MTProtoHandler$Companion;", "", "()V", "QUEUE_TYPE_DISCARD", "", "QUEUE_TYPE_DISCARD$annotations", "getQUEUE_TYPE_DISCARD", "()I", "apiContext", "Lcom/github/badoualy/telegram/tl/api/TLApiContext;", "kotlin.jvm.PlatformType", "getApiContext", "()Lcom/github/badoualy/telegram/tl/api/TLApiContext;", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "mtProtoContext", "Lcom/github/badoualy/telegram/mtproto/tl/MTProtoContext;", "getMtProtoContext", "()Lcom/github/badoualy/telegram/mtproto/tl/MTProtoContext;", "updatePool", "Ljava/util/concurrent/ThreadPoolExecutor;", "getUpdatePool", "()Ljava/util/concurrent/ThreadPoolExecutor;", "shutdown", "", "mtproto_main"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private final MTProtoContext getMtProtoContext() {
            return mtProtoContext;
        }

        private final TLApiContext getApiContext() {
            return apiContext;
        }

        private final ThreadPoolExecutor getUpdatePool() {
            return updatePool;
        }

        @JvmStatic
        public static /* synthetic */ void QUEUE_TYPE_DISCARD$annotations() {
        }

        public final int getQUEUE_TYPE_DISCARD() {
            return QUEUE_TYPE_DISCARD;
        }

        @JvmStatic
        public final void shutdown() {
            this.getLogger().warn("shutdown()");
            MTProtoWatchdog.INSTANCE.shutdown();
            MTProtoTimer.INSTANCE.shutdown();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

