/*
 * Decompiled with CFR 0.152.
 */
package com.github.badoualy.telegram.api;

import com.github.badoualy.telegram.api.Kotlogram;
import com.github.badoualy.telegram.api.ReadOnlyApiStorage;
import com.github.badoualy.telegram.api.TelegramApiStorage;
import com.github.badoualy.telegram.api.TelegramApp;
import com.github.badoualy.telegram.api.TelegramClient;
import com.github.badoualy.telegram.api.UpdateCallback;
import com.github.badoualy.telegram.api.utils.InputFileLocation;
import com.github.badoualy.telegram.mtproto.ApiCallback;
import com.github.badoualy.telegram.mtproto.MTProtoHandler;
import com.github.badoualy.telegram.mtproto.auth.AuthKey;
import com.github.badoualy.telegram.mtproto.auth.AuthKeyCreation;
import com.github.badoualy.telegram.mtproto.auth.AuthResult;
import com.github.badoualy.telegram.mtproto.exception.SecurityException;
import com.github.badoualy.telegram.mtproto.model.DataCenter;
import com.github.badoualy.telegram.mtproto.secure.CryptoUtils;
import com.github.badoualy.telegram.mtproto.time.MTProtoTimer;
import com.github.badoualy.telegram.tl.api.TLAbsChat;
import com.github.badoualy.telegram.tl.api.TLAbsInputPeer;
import com.github.badoualy.telegram.tl.api.TLAbsUpdates;
import com.github.badoualy.telegram.tl.api.TLAbsUser;
import com.github.badoualy.telegram.tl.api.TLNearestDc;
import com.github.badoualy.telegram.tl.api.TLUpdateShort;
import com.github.badoualy.telegram.tl.api.TLUpdateShortChatMessage;
import com.github.badoualy.telegram.tl.api.TLUpdateShortMessage;
import com.github.badoualy.telegram.tl.api.TLUpdateShortSentMessage;
import com.github.badoualy.telegram.tl.api.TLUpdates;
import com.github.badoualy.telegram.tl.api.TLUpdatesCombined;
import com.github.badoualy.telegram.tl.api.TLUpdatesTooLong;
import com.github.badoualy.telegram.tl.api.TelegramApiWrapper;
import com.github.badoualy.telegram.tl.api.account.TLAbsPassword;
import com.github.badoualy.telegram.tl.api.account.TLPassword;
import com.github.badoualy.telegram.tl.api.auth.TLAuthorization;
import com.github.badoualy.telegram.tl.api.auth.TLExportedAuthorization;
import com.github.badoualy.telegram.tl.api.auth.TLSentCode;
import com.github.badoualy.telegram.tl.api.request.TLRequestAuthCheckPassword;
import com.github.badoualy.telegram.tl.api.request.TLRequestAuthImportAuthorization;
import com.github.badoualy.telegram.tl.api.request.TLRequestHelpGetNearestDc;
import com.github.badoualy.telegram.tl.api.request.TLRequestInitConnection;
import com.github.badoualy.telegram.tl.api.request.TLRequestInvokeWithLayer;
import com.github.badoualy.telegram.tl.api.request.TLRequestUpdatesGetState;
import com.github.badoualy.telegram.tl.api.request.TLRequestUploadGetFile;
import com.github.badoualy.telegram.tl.api.upload.TLAbsFile;
import com.github.badoualy.telegram.tl.api.upload.TLFile;
import com.github.badoualy.telegram.tl.api.upload.TLFileCdnRedirect;
import com.github.badoualy.telegram.tl.core.TLBytes;
import com.github.badoualy.telegram.tl.core.TLMethod;
import com.github.badoualy.telegram.tl.core.TLObject;
import com.github.badoualy.telegram.tl.exception.RpcErrorException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import rx.Observable;

@Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u00c0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 i2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001iB1\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\rH\u0017J \u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u00192\u0006\u00102\u001a\u00020\r2\u0006\u00103\u001a\u00020\u0019H\u0017J\b\u00104\u001a\u000205H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0019H\u0016J(\u00107\u001a\u0002052\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020\u00172\u0006\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u0002052\u0006\u0010?\u001a\u00020@H\u0003J,\u0010A\u001a\b\u0012\u0004\u0012\u0002HC0B\"\b\b\u0000\u0010C*\u00020D2\u0012\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0F0BH\u0017J>\u0010A\u001a\b\u0012\u0004\u0012\u0002HC0B\"\b\b\u0000\u0010C*\u00020D2\u0012\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0F0B2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010G\u001a\u00020\u0017H\u0003J4\u0010A\u001a\b\u0012\u0004\u0012\u0002HC0B\"\b\b\u0000\u0010C*\u00020D2\u0012\u0010E\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002HC0F0B2\u0006\u0010H\u001a\u00020\u0017H\u0017J%\u0010I\u001a\u0002HC\"\b\b\u0000\u0010C*\u00020D2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HC0FH\u0017\u00a2\u0006\u0002\u0010KJ7\u0010I\u001a\u0002HC\"\b\b\u0000\u0010C*\u00020D2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HC0F2\u0006\u0010$\u001a\u00020\u001c2\b\b\u0002\u0010G\u001a\u00020\u0017H\u0003\u00a2\u0006\u0002\u0010LJ\b\u0010 \u001a\u00020MH\u0002J\b\u0010N\u001a\u00020\u0000H\u0016J\u0010\u0010O\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\u0017H\u0003J\u0012\u0010P\u001a\u0002052\b\b\u0002\u0010Q\u001a\u00020\u0019H\u0002J-\u0010R\u001a\u0002HC\"\b\b\u0000\u0010C*\u00020D2\u0006\u0010$\u001a\u00020\u001c2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HC0FH\u0003\u00a2\u0006\u0002\u0010SJ%\u0010R\u001a\u0002HC\"\b\b\u0000\u0010C*\u00020D2\f\u0010T\u001a\b\u0012\u0004\u0012\u0002HC0FH\u0017\u00a2\u0006\u0002\u0010KJ\b\u0010U\u001a\u00020\u0019H\u0016J \u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020Y2\u0006\u0010Z\u001a\u00020\r2\u0006\u0010[\u001a\u00020\u001eH\u0017J\u0010\u0010\\\u001a\u0002052\u0006\u0010H\u001a\u00020\u0017H\u0002J\u0010\u0010]\u001a\u0002052\u0006\u0010H\u001a\u00020\u0017H\u0002J\u0010\u0010^\u001a\u0002052\u0006\u0010_\u001a\u00020WH\u0016J@\u0010`\u001a\n\u0012\u0004\u0012\u0002HC\u0018\u00010a\"\b\b\u0000\u0010C*\u00020D2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HC0F2\u0006\u0010b\u001a\u00020\u00172\u0006\u0010c\u001a\u00020\u001e2\u0006\u0010d\u001a\u00020\u001eH\u0016J(\u0010e\u001a\u000205\"\b\b\u0000\u0010C*\u00020D2\f\u0010J\u001a\b\u0012\u0004\u0012\u0002HC0F2\u0006\u0010c\u001a\u00020\u001eH\u0016J\u0018\u0010f\u001a\u0002052\u0006\u0010$\u001a\u00020\u001c2\u0006\u0010H\u001a\u00020\u0017H\u0002J\u0010\u0010g\u001a\u0002052\u0006\u0010d\u001a\u00020\u001eH\u0016J\u0010\u0010h\u001a\u0002052\u0006\u0010d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00140\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001c0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u001e0\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\n #*\u0004\u0018\u00010\"0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010)\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+\u00a8\u0006j"}, d2={"Lcom/github/badoualy/telegram/api/DefaultTelegramClient;", "Lcom/github/badoualy/telegram/tl/api/TelegramApiWrapper;", "Lcom/github/badoualy/telegram/api/TelegramClient;", "Lcom/github/badoualy/telegram/mtproto/ApiCallback;", "application", "Lcom/github/badoualy/telegram/api/TelegramApp;", "apiStorage", "Lcom/github/badoualy/telegram/api/TelegramApiStorage;", "preferredDataCenter", "Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "updateCallback", "Lcom/github/badoualy/telegram/api/UpdateCallback;", "tag", "", "(Lcom/github/badoualy/telegram/api/TelegramApp;Lcom/github/badoualy/telegram/api/TelegramApiStorage;Lcom/github/badoualy/telegram/mtproto/model/DataCenter;Lcom/github/badoualy/telegram/api/UpdateCallback;Ljava/lang/String;)V", "getApiStorage", "()Lcom/github/badoualy/telegram/api/TelegramApiStorage;", "getApplication", "()Lcom/github/badoualy/telegram/api/TelegramApp;", "authKey", "Lcom/github/badoualy/telegram/mtproto/auth/AuthKey;", "authKeyMap", "Ljava/util/HashMap;", "", "closed", "", "dataCenter", "exportedHandlerMap", "Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;", "exportedHandlerTimeout", "", "exportedHandlerTimeoutMap", "generateAuthKey", "marker", "Lorg/slf4j/Marker;", "kotlin.jvm.PlatformType", "mtProtoHandler", "getPreferredDataCenter", "()Lcom/github/badoualy/telegram/mtproto/model/DataCenter;", "getTag", "()Ljava/lang/String;", "timeoutDuration", "getUpdateCallback", "()Lcom/github/badoualy/telegram/api/UpdateCallback;", "authCheckPassword", "Lcom/github/badoualy/telegram/tl/api/auth/TLAuthorization;", "password", "authSendCode", "Lcom/github/badoualy/telegram/tl/api/auth/TLSentCode;", "allowFlashcall", "phoneNumber", "currentNumber", "close", "", "shutdown", "downloadSync", "inputLocation", "Lcom/github/badoualy/telegram/api/utils/InputFileLocation;", "size", "partSize", "outputStream", "Ljava/io/OutputStream;", "ensureNearestDc", "nearestDc", "Lcom/github/badoualy/telegram/tl/api/TLNearestDc;", "executeRpcQueries", "", "T", "Lcom/github/badoualy/telegram/tl/core/TLObject;", "methods", "Lcom/github/badoualy/telegram/tl/core/TLMethod;", "attemptCount", "dcId", "executeRpcQuery", "method", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;)Lcom/github/badoualy/telegram/tl/core/TLObject;", "(Lcom/github/badoualy/telegram/tl/core/TLMethod;Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;I)Lcom/github/badoualy/telegram/tl/core/TLObject;", "Lcom/github/badoualy/telegram/mtproto/auth/AuthResult;", "getDownloaderClient", "getExportedMTProtoHandler", "init", "checkNearestDc", "initConnection", "(Lcom/github/badoualy/telegram/mtproto/MTProtoHandler;Lcom/github/badoualy/telegram/tl/core/TLMethod;)Lcom/github/badoualy/telegram/tl/core/TLObject;", "query", "isClosed", "messagesSendMessage", "Lcom/github/badoualy/telegram/tl/api/TLAbsUpdates;", "peer", "Lcom/github/badoualy/telegram/tl/api/TLAbsInputPeer;", "message", "randomId", "migrate", "onExportedHandlerTimeout", "onUpdates", "update", "queueMethod", "Lrx/Observable;", "type", "validityTimeout", "timeout", "queueMethodImmediate", "releaseExportedHandler", "setExportedClientTimeout", "setTimeout", "Companion", "api_main"})
public final class DefaultTelegramClient
extends TelegramApiWrapper
implements TelegramClient,
ApiCallback {
    private MTProtoHandler mtProtoHandler;
    private AuthKey authKey;
    private DataCenter dataCenter;
    private boolean closed;
    private final HashMap<Integer, AuthKey> authKeyMap;
    private final HashMap<Integer, MTProtoHandler> exportedHandlerMap;
    private final HashMap<Integer, Long> exportedHandlerTimeoutMap;
    private long timeoutDuration;
    private long exportedHandlerTimeout;
    private boolean generateAuthKey;
    private final Marker marker;
    @NotNull
    private final TelegramApp application;
    @NotNull
    private final TelegramApiStorage apiStorage;
    @NotNull
    private final DataCenter preferredDataCenter;
    @Nullable
    private final UpdateCallback updateCallback;
    @NotNull
    private final String tag;
    private static final Logger logger;
    public static final Companion Companion;

    private final void init(boolean checkNearestDc) {
        block16: {
            MTProtoHandler mTProtoHandler;
            DefaultTelegramClient.Companion.getLogger().debug(this.marker, "init() " + checkNearestDc);
            if (this.generateAuthKey) {
                mTProtoHandler = new MTProtoHandler(this.generateAuthKey(), (ApiCallback)this, this.tag);
            } else {
                DataCenter dataCenter = this.dataCenter;
                if (dataCenter == null) {
                    Intrinsics.throwNpe();
                }
                AuthKey authKey = this.authKey;
                if (authKey == null) {
                    Intrinsics.throwNpe();
                }
                mTProtoHandler = new MTProtoHandler(dataCenter, authKey, this.apiStorage.loadSession(), (ApiCallback)this, this.tag);
            }
            MTProtoHandler mTProtoHandler2 = this.mtProtoHandler = mTProtoHandler;
            if (mTProtoHandler2 == null) {
                Intrinsics.throwNpe();
            }
            mTProtoHandler2.startWatchdog();
            try {
                block17: {
                    if (checkNearestDc) {
                        MTProtoHandler mTProtoHandler3 = this.mtProtoHandler;
                        if (mTProtoHandler3 == null) {
                            Intrinsics.throwNpe();
                        }
                        Object t = this.initConnection(mTProtoHandler3, (TLMethod)new TLRequestHelpGetNearestDc());
                        Intrinsics.checkExpressionValueIsNotNull(t, (String)"initConnection(mtProtoHa\u2026equestHelpGetNearestDc())");
                        this.ensureNearestDc((TLNearestDc)t);
                        break block16;
                    }
                    if (!this.generateAuthKey) {
                        try {
                            MTProtoHandler mTProtoHandler4 = this.mtProtoHandler;
                            if (mTProtoHandler4 == null) {
                                Intrinsics.throwNpe();
                            }
                            this.initConnection(mTProtoHandler4, (TLMethod)new TLRequestUpdatesGetState());
                            return;
                        }
                        catch (RpcErrorException e) {
                            if (e.getCode() == 401) break block17;
                            throw (Throwable)e;
                        }
                    }
                }
                MTProtoHandler mTProtoHandler5 = this.mtProtoHandler;
                if (mTProtoHandler5 == null) {
                    Intrinsics.throwNpe();
                }
                this.initConnection(mTProtoHandler5, (TLMethod)new TLRequestHelpGetNearestDc());
            }
            catch (Exception e) {
                MTProtoHandler mTProtoHandler6 = this.mtProtoHandler;
                if (mTProtoHandler6 != null) {
                    mTProtoHandler6.close();
                }
                if (e instanceof RpcErrorException && ((RpcErrorException)((Object)e)).getCode() == -404) {
                    throw (Throwable)new SecurityException("Your authorization key is invalid (error " + ((RpcErrorException)((Object)e)).getCode() + ")");
                }
                throw (Throwable)e;
            }
        }
    }

    static /* bridge */ /* synthetic */ void init$default(DefaultTelegramClient defaultTelegramClient, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        defaultTelegramClient.init(bl);
    }

    private final AuthResult generateAuthKey() {
        DataCenter dataCenter = this.dataCenter;
        if (dataCenter == null) {
            Intrinsics.throwNpe();
        }
        AuthResult authResult = AuthKeyCreation.createAuthKey((DataCenter)dataCenter, (String)this.tag);
        if (authResult == null) {
            throw (Throwable)new RuntimeException("Couldn't generate authorization key");
        }
        AuthResult authResult2 = authResult;
        AuthKey authKey = this.authKey = authResult2.getAuthKey();
        if (authKey == null) {
            Intrinsics.throwNpe();
        }
        this.apiStorage.saveAuthKey(authKey);
        DataCenter dataCenter2 = this.dataCenter;
        if (dataCenter2 == null) {
            Intrinsics.throwNpe();
        }
        this.apiStorage.saveDc(dataCenter2);
        return authResult2;
    }

    private final <T extends TLObject> T initConnection(MTProtoHandler mtProtoHandler, TLMethod<T> method) throws RpcErrorException, IOException {
        TLObject result;
        DefaultTelegramClient.Companion.getLogger().debug(this.marker, "Init connection with method " + method);
        TLRequestInitConnection initConnectionRequest = new TLRequestInitConnection(this.application.getApiId(), this.application.getDeviceModel(), this.application.getSystemVersion(), this.application.getAppVersion(), this.application.getLangCode(), method);
        TLObject tLObject = result = DefaultTelegramClient.executeRpcQuery$default(this, (TLMethod)new TLRequestInvokeWithLayer(Kotlogram.API_LAYER, (TLMethod)initConnectionRequest), mtProtoHandler, 0, 4, null);
        Intrinsics.checkExpressionValueIsNotNull((Object)tLObject, (String)"result");
        return (T)tLObject;
    }

    private final void ensureNearestDc(TLNearestDc nearestDc) throws RpcErrorException, IOException {
        DefaultTelegramClient.Companion.getLogger().debug(this.marker, "ensureNearestDc()");
        if (nearestDc.getThisDc() != nearestDc.getNearestDc()) {
            DefaultTelegramClient.Companion.getLogger().warn(this.marker, "Current DC" + nearestDc.getThisDc() + " is not the nearest (DC" + nearestDc.getNearestDc() + ")");
            if (!this.generateAuthKey) {
                MTProtoHandler mTProtoHandler = this.mtProtoHandler;
                if (mTProtoHandler != null) {
                    mTProtoHandler.close();
                }
                throw (Throwable)new RuntimeException("You tried to connect to an incorrect data center (DC" + nearestDc.getThisDc() + ") with an authorization key in storage, please connect to the nearest (DC" + nearestDc.getNearestDc() + ")");
            }
            this.migrate(nearestDc.getNearestDc());
        } else {
            DefaultTelegramClient.Companion.getLogger().info(this.marker, "Connected to the nearest DC" + nearestDc.getThisDc());
        }
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeoutDuration = timeout;
    }

    @Override
    public void setExportedClientTimeout(long timeout) {
        this.exportedHandlerTimeout = timeout;
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void close(boolean shutdown) {
        this.closed = true;
        try {
            MTProtoHandler mTProtoHandler = this.mtProtoHandler;
            if (mTProtoHandler != null) {
                mTProtoHandler.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (shutdown) {
            Kotlogram.shutdown();
        }
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler == null) {
            Intrinsics.throwNpe();
        }
        this.apiStorage.saveSession(mTProtoHandler.getSession());
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    @NotNull
    public DefaultTelegramClient getDownloaderClient() {
        AuthKey authKey = this.authKey;
        if (authKey == null) {
            Intrinsics.throwNpe();
        }
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler == null) {
            Intrinsics.throwNpe();
        }
        return new DefaultTelegramClient(this.application, new ReadOnlyApiStorage(authKey, mTProtoHandler.getSession()), this.preferredDataCenter, this.updateCallback, "Downloader:" + this.tag);
    }

    @Override
    public <T extends TLObject> void queueMethodImmediate(@NotNull TLMethod<T> method, long validityTimeout) {
        block0: {
            Intrinsics.checkParameterIsNotNull(method, (String)"method");
            Observable<T> observable = this.queueMethod(method, MTProtoHandler.Companion.getQUEUE_TYPE_DISCARD(), validityTimeout, Long.MAX_VALUE);
            if (observable == null) break block0;
            observable.subscribe();
        }
    }

    @Override
    @Nullable
    public <T extends TLObject> Observable<T> queueMethod(@NotNull TLMethod<T> method, int type, long validityTimeout, long timeout) {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        return mTProtoHandler != null ? mTProtoHandler.queueMethod(method, type, validityTimeout, timeout) : null;
    }

    @Override
    @NotNull
    public <T extends TLObject> T executeRpcQuery(@NotNull TLMethod<T> method) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return TelegramClient.DefaultImpls.executeRpcQuery(this, method);
    }

    @Override
    @NotNull
    public <T extends TLObject> List<T> executeRpcQueries(@NotNull List<? extends TLMethod<T>> methods) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler == null) {
            Intrinsics.throwNpe();
        }
        return DefaultTelegramClient.executeRpcQueries$default(this, methods, mTProtoHandler, 0, 4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <T extends TLObject> List<T> executeRpcQueries(@NotNull List<? extends TLMethod<T>> methods, int dcId) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(methods, (String)"methods");
        DefaultTelegramClient.Companion.getLogger().debug(this.marker, "executeRpcQuery " + CollectionsKt.joinToString$default((Iterable)methods, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null) + " on DC" + dcId);
        if (Intrinsics.areEqual((Object)Kotlogram.getDcById(dcId), (Object)this.dataCenter)) {
            return this.executeRpcQueries(methods);
        }
        DefaultTelegramClient.Companion.getLogger().info(this.marker, "Need to export handler");
        MTProtoHandler exportedHandler = this.getExportedMTProtoHandler(dcId);
        try {
            List list = DefaultTelegramClient.executeRpcQueries$default(this, methods, exportedHandler, 0, 4, null);
            return list;
        }
        finally {
            this.releaseExportedHandler(exportedHandler, dcId);
        }
    }

    private final <T extends TLObject> T executeRpcQuery(TLMethod<T> method, MTProtoHandler mtProtoHandler, int attemptCount) throws RpcErrorException, IOException {
        return (T)((TLObject)CollectionsKt.first(this.executeRpcQueries(CollectionsKt.listOf(method), mtProtoHandler, attemptCount)));
    }

    static /* bridge */ /* synthetic */ TLObject executeRpcQuery$default(DefaultTelegramClient defaultTelegramClient, TLMethod tLMethod, MTProtoHandler mTProtoHandler, int n, int n2, Object object) throws RpcErrorException, IOException {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return defaultTelegramClient.executeRpcQuery(tLMethod, mTProtoHandler, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <T extends TLObject> List<T> executeRpcQueries(List<? extends TLMethod<T>> methods, MTProtoHandler mtProtoHandler, int attemptCount) throws RpcErrorException, IOException {
        try {
            return mtProtoHandler.executeMethodsSync(methods, this.timeoutDuration);
        }
        catch (RuntimeException exception) {
            Throwable throwable = exception.getCause();
            if (throwable instanceof RpcErrorException) {
                Throwable throwable2 = exception.getCause();
                if (throwable2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.github.badoualy.telegram.tl.exception.RpcErrorException");
                }
                RpcErrorException rpcException = (RpcErrorException)throwable2;
                if (rpcException.getCode() == 303) {
                    DefaultTelegramClient.Companion.getLogger().error(this.marker, "Received DC error: " + (Object)((Object)rpcException));
                    if (StringsKt.startsWith$default((String)rpcException.getTag(), (String)"PHONE_MIGRATE_", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)rpcException.getTag(), (String)"NETWORK_MIGRATE_", (boolean)false, (int)2, null)) {
                        Integer dcId = rpcException.getTagInteger();
                        DefaultTelegramClient.Companion.getLogger().info(this.marker, "Repeat request after migration on DC" + dcId);
                        Integer n = dcId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"dcId");
                        this.migrate(n);
                        return this.executeRpcQueries(methods);
                    }
                    if (StringsKt.startsWith$default((String)rpcException.getTag(), (String)"FILE_MIGRATE_", (boolean)false, (int)2, null)) {
                        Integer dcId = rpcException.getTagInteger();
                        DefaultTelegramClient.Companion.getLogger().info(this.marker, "Repeat request with new handler on DC" + dcId);
                        Integer n = dcId;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"dcId");
                        MTProtoHandler exportedHandler = this.getExportedMTProtoHandler(n);
                        try {
                            List list = DefaultTelegramClient.executeRpcQueries$default(this, methods, exportedHandler, 0, 4, null);
                            return list;
                        }
                        finally {
                            Integer n2 = dcId;
                            Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"dcId");
                            this.releaseExportedHandler(exportedHandler, n2);
                        }
                    }
                }
                DefaultTelegramClient.Companion.getLogger().error(this.marker, "Unhandled RpcError " + (Object)((Object)rpcException));
                throw (Throwable)new RpcErrorException(rpcException.getCode(), rpcException.getTag());
            }
            if (throwable instanceof TimeoutException || throwable instanceof ClosedChannelException || throwable instanceof IOException) {
                if (attemptCount < 2) {
                    Thread.sleep(500L);
                    DefaultTelegramClient.Companion.getLogger().error(this.marker, "Attempting MtProtoHandler reset after failure");
                    mtProtoHandler.resetConnection();
                    List<T> result = this.executeRpcQueries(methods, mtProtoHandler, attemptCount + 1);
                    DefaultTelegramClient.Companion.getLogger().debug(this.marker, "Reset worked");
                    return result;
                }
                throw (Throwable)new TimeoutException("Request timed out");
            }
            throw (Throwable)exception;
        }
    }

    static /* bridge */ /* synthetic */ List executeRpcQueries$default(DefaultTelegramClient defaultTelegramClient, List list, MTProtoHandler mTProtoHandler, int n, int n2, Object object) throws RpcErrorException, IOException {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return defaultTelegramClient.executeRpcQueries(list, mTProtoHandler, n);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void downloadSync(@NotNull InputFileLocation inputLocation, int size, int partSize, @NotNull OutputStream outputStream) {
        Intrinsics.checkParameterIsNotNull((Object)inputLocation, (String)"inputLocation");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        int offset = 0;
        ArrayList<TLRequestUploadGetFile> methods = new ArrayList<TLRequestUploadGetFile>();
        do {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            methods.clear();
            int n = 0;
            int n2 = 5;
            if (n <= n2) {
                while (true) {
                    void i;
                    methods.add(new TLRequestUploadGetFile(inputLocation.getInputFileLocation(), offset, partSize));
                    if ((offset += partSize) >= size || i == n2) break;
                    ++i;
                }
            }
            Iterable i = this.executeRpcQueries((List)methods, inputLocation.getDcId());
            Iterator iterator = $receiver$iv;
            void $receiver$iv2 = iterator;
            for (Object element$iv : $receiver$iv2) {
                TLAbsFile it = (TLAbsFile)element$iv;
                if (!(it instanceof TLFileCdnRedirect)) continue;
                throw (Throwable)new IOException("Unhandled CDN redirection");
            }
            $receiver$iv = iterator;
            iterator = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                if (!(element$iv$iv instanceof TLFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            for (Object element$iv : $receiver$iv) {
                TLFile part = (TLFile)element$iv;
                outputStream.write(part.getBytes().getData());
            }
            outputStream.flush();
        } while (offset < size);
        outputStream.flush();
        outputStream.close();
    }

    @Override
    @NotNull
    public TLSentCode authSendCode(boolean allowFlashcall, @NotNull String phoneNumber, boolean currentNumber) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)phoneNumber, (String)"phoneNumber");
        TLSentCode tLSentCode = super.authSendCode(allowFlashcall, phoneNumber, currentNumber, this.application.getApiId(), this.application.getApiHash());
        if (tLSentCode == null) {
            Intrinsics.throwNpe();
        }
        return tLSentCode;
    }

    @Override
    @NotNull
    public TLAuthorization authCheckPassword(@NotNull String password) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)password, (String)"password");
        TLAbsPassword tLAbsPassword = this.accountGetPassword();
        if (!(tLAbsPassword instanceof TLPassword)) {
            tLAbsPassword = null;
        }
        TLPassword tLPassword = (TLPassword)tLAbsPassword;
        if (tLPassword == null) {
            throw (Throwable)new RpcErrorException(400, "NO_PASSWORD");
        }
        TLPassword tlPassword = tLPassword;
        byte[] passwordHash = CryptoUtils.encodePasswordHash((byte[])tlPassword.getCurrentSalt().getData(), (String)password);
        Object t = this.executeRpcQuery((TLMethod)new TLRequestAuthCheckPassword(new TLBytes(passwordHash)));
        Intrinsics.checkExpressionValueIsNotNull(t, (String)"executeRpcQuery(TLReques\u2026d(TLBytes(passwordHash)))");
        return (TLAuthorization)t;
    }

    @Override
    @NotNull
    public <T extends TLObject> T initConnection(@NotNull TLMethod<T> query) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(query, (String)"query");
        T t = this.executeRpcQuery((TLMethod)new TLRequestInitConnection(this.application.getApiId(), this.application.getDeviceModel(), this.application.getSystemVersion(), this.application.getAppVersion(), this.application.getLangCode(), query));
        if (t == null) {
            Intrinsics.throwNpe();
        }
        return t;
    }

    @Override
    @NotNull
    public TLAbsUpdates messagesSendMessage(@NotNull TLAbsInputPeer peer, @NotNull String message, long randomId) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)peer, (String)"peer");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        TLAbsUpdates tLAbsUpdates = super.messagesSendMessage(true, false, false, false, peer, null, message, randomId, null, null);
        if (tLAbsUpdates == null) {
            Intrinsics.throwNpe();
        }
        return tLAbsUpdates;
    }

    private final void migrate(int dcId) {
        DefaultTelegramClient.Companion.getLogger().info(this.marker, "Migrating to DC" + dcId);
        MTProtoHandler mTProtoHandler = this.mtProtoHandler;
        if (mTProtoHandler != null) {
            mTProtoHandler.close();
        }
        this.authKey = null;
        this.dataCenter = Kotlogram.getDcById(dcId);
        this.apiStorage.deleteAuthKey();
        this.apiStorage.deleteDc();
        this.apiStorage.saveSession(null);
        this.generateAuthKey = true;
        this.init(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final MTProtoHandler getExportedMTProtoHandler(int dcId) throws RpcErrorException, IOException {
        MTProtoHandler mTProtoHandler;
        void cachedHandler;
        Object object;
        DefaultTelegramClient.Companion.getLogger().trace(this.marker, "getExportedMTProtoHandler(DC" + dcId + ")");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Map<Integer, Object> map = this.exportedHandlerMap;
        synchronized (map) {
            cachedHandler.element = this.exportedHandlerMap.remove(dcId);
            object = Unit.INSTANCE;
        }
        if ((MTProtoHandler)cachedHandler.element != null) {
            DefaultTelegramClient.Companion.getLogger().debug(this.marker, "Using cached handler");
        }
        if ((mTProtoHandler = (MTProtoHandler)cachedHandler.element) == null) {
            map = this.authKeyMap;
            Integer $i$a$1$synchronized = dcId;
            Object object2 = object = map;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (object2.containsKey($i$a$1$synchronized)) {
                DefaultTelegramClient.Companion.getLogger().debug(this.marker, "Already have key for DC" + dcId);
                AuthKey authKey = this.authKeyMap.get(dcId);
                if (authKey == null) {
                    Intrinsics.throwNpe();
                }
                AuthKey authKey2 = authKey;
                DataCenter dataCenter = Kotlogram.getDcById(dcId);
                AuthKey authKey3 = authKey2;
                Intrinsics.checkExpressionValueIsNotNull((Object)authKey3, (String)"authKey");
                MTProtoHandler mtProtoHandler = new MTProtoHandler(dataCenter, authKey3, null, null, this.tag);
                mtProtoHandler.startWatchdog();
                this.initConnection(mtProtoHandler, (TLMethod)new TLRequestHelpGetNearestDc());
                mTProtoHandler = mtProtoHandler;
            } else {
                DefaultTelegramClient.Companion.getLogger().debug(this.marker, "Creating new handler on DC" + dcId);
                DataCenter dc = Kotlogram.getDcById(dcId);
                TLExportedAuthorization exportedAuthorization = this.authExportAuthorization(dcId);
                AuthResult authResult = AuthKeyCreation.createAuthKey((DataCenter)dc, (String)this.tag);
                if (authResult == null) {
                    throw (Throwable)new IOException("Couldn't create authorization key on DC" + dcId);
                }
                AuthResult authResult2 = authResult;
                MTProtoHandler mtProtoHandler = new MTProtoHandler(authResult2, null, this.tag);
                mtProtoHandler.startWatchdog();
                this.initConnection(mtProtoHandler, (TLMethod)new TLRequestAuthImportAuthorization(exportedAuthorization.getId(), exportedAuthorization.getBytes()));
                this.authKeyMap.put(dcId, authResult2.getAuthKey());
                mTProtoHandler = mtProtoHandler;
            }
        }
        return mTProtoHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void releaseExportedHandler(MTProtoHandler mtProtoHandler, int dcId) {
        HashMap<Integer, MTProtoHandler> hashMap = this.exportedHandlerMap;
        synchronized (hashMap) {
            if (this.exportedHandlerMap.containsKey(dcId)) {
                mtProtoHandler.close();
            } else {
                this.exportedHandlerMap.put(dcId, mtProtoHandler);
            }
            MTProtoTimer.INSTANCE.schedule(this.exportedHandlerTimeout, (Function1)new Function1<TimerTask, Unit>(this, dcId, mtProtoHandler){
                final /* synthetic */ DefaultTelegramClient this$0;
                final /* synthetic */ int $dcId$inlined;
                final /* synthetic */ MTProtoHandler $mtProtoHandler$inlined;
                {
                    this.this$0 = defaultTelegramClient;
                    this.$dcId$inlined = n;
                    this.$mtProtoHandler$inlined = mTProtoHandler;
                    super(1);
                }

                public final void invoke(TimerTask $receiver) {
                    DefaultTelegramClient.access$onExportedHandlerTimeout(this.this$0, this.$dcId$inlined);
                }
            });
            Long l = this.exportedHandlerTimeoutMap.put(dcId, System.currentTimeMillis() + this.exportedHandlerTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void onExportedHandlerTimeout(int dcId) {
        HashMap<Integer, MTProtoHandler> hashMap = this.exportedHandlerMap;
        synchronized (hashMap) {
            long l = System.currentTimeMillis();
            Long l2 = this.exportedHandlerTimeoutMap.getOrDefault(dcId, -1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)l2, (String)"exportedHandlerTimeoutMap.getOrDefault(dcId, -1)");
            if (Intrinsics.compare((long)l, (long)((Number)l2).longValue()) >= 0) {
                MTProtoHandler mTProtoHandler = this.exportedHandlerMap.remove(dcId);
                if (mTProtoHandler != null) {
                    mTProtoHandler.close();
                }
                this.exportedHandlerTimeoutMap.remove(dcId);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public void onUpdates(@NotNull TLAbsUpdates update) {
        block2: {
            TLAbsUpdates tLAbsUpdates;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            block3: {
                                block1: {
                                    Intrinsics.checkParameterIsNotNull((Object)update, (String)"update");
                                    tLAbsUpdates = update;
                                    if (!(tLAbsUpdates instanceof TLUpdates)) break block1;
                                    UpdateCallback updateCallback = this.updateCallback;
                                    if (updateCallback == null) break block2;
                                    updateCallback.onUpdates(this, (TLUpdates)update);
                                    break block2;
                                }
                                if (!(tLAbsUpdates instanceof TLUpdatesCombined)) break block3;
                                UpdateCallback updateCallback = this.updateCallback;
                                if (updateCallback == null) break block2;
                                updateCallback.onUpdatesCombined(this, (TLUpdatesCombined)update);
                                break block2;
                            }
                            if (!(tLAbsUpdates instanceof TLUpdateShort)) break block4;
                            UpdateCallback updateCallback = this.updateCallback;
                            if (updateCallback == null) break block2;
                            updateCallback.onUpdateShort(this, (TLUpdateShort)update);
                            break block2;
                        }
                        if (!(tLAbsUpdates instanceof TLUpdateShortChatMessage)) break block5;
                        UpdateCallback updateCallback = this.updateCallback;
                        if (updateCallback == null) break block2;
                        updateCallback.onShortChatMessage(this, (TLUpdateShortChatMessage)update);
                        break block2;
                    }
                    if (!(tLAbsUpdates instanceof TLUpdateShortMessage)) break block6;
                    UpdateCallback updateCallback = this.updateCallback;
                    if (updateCallback == null) break block2;
                    updateCallback.onShortMessage(this, (TLUpdateShortMessage)update);
                    break block2;
                }
                if (!(tLAbsUpdates instanceof TLUpdateShortSentMessage)) break block7;
                UpdateCallback updateCallback = this.updateCallback;
                if (updateCallback == null) break block2;
                updateCallback.onShortSentMessage(this, (TLUpdateShortSentMessage)update);
                break block2;
            }
            if (!(tLAbsUpdates instanceof TLUpdatesTooLong)) break block2;
            UpdateCallback updateCallback = this.updateCallback;
            if (updateCallback != null) {
                updateCallback.onUpdateTooLong(this);
            }
        }
    }

    @NotNull
    public final TelegramApp getApplication() {
        return this.application;
    }

    @NotNull
    public final TelegramApiStorage getApiStorage() {
        return this.apiStorage;
    }

    @NotNull
    public final DataCenter getPreferredDataCenter() {
        return this.preferredDataCenter;
    }

    @Nullable
    public final UpdateCallback getUpdateCallback() {
        return this.updateCallback;
    }

    @NotNull
    public final String getTag() {
        return this.tag;
    }

    public DefaultTelegramClient(@NotNull TelegramApp application, @NotNull TelegramApiStorage apiStorage, @NotNull DataCenter preferredDataCenter, @Nullable UpdateCallback updateCallback, @NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)apiStorage, (String)"apiStorage");
        Intrinsics.checkParameterIsNotNull((Object)preferredDataCenter, (String)"preferredDataCenter");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        this.application = application;
        this.apiStorage = apiStorage;
        this.preferredDataCenter = preferredDataCenter;
        this.updateCallback = updateCallback;
        this.tag = tag;
        this.authKeyMap = new HashMap();
        this.exportedHandlerMap = new HashMap();
        this.exportedHandlerTimeoutMap = new HashMap();
        this.timeoutDuration = 5000L;
        this.exportedHandlerTimeout = 15000L;
        this.marker = MarkerFactory.getMarker((String)this.tag);
        this.authKey = this.apiStorage.loadAuthKey();
        this.dataCenter = this.apiStorage.loadDc();
        boolean bl = this.generateAuthKey = this.authKey == null;
        if (this.dataCenter == null) {
            if (!this.generateAuthKey) {
                this.apiStorage.deleteAuthKey();
                this.apiStorage.saveSession(null);
                throw (Throwable)new RuntimeException("Found an authorization key in storage, but the DC configuration was not found, deleting authorization key");
            }
            DefaultTelegramClient.Companion.getLogger().warn(this.marker, "No data center found in storage, using preferred " + this.preferredDataCenter);
            this.dataCenter = this.preferredDataCenter;
        }
        this.init(this.generateAuthKey);
        DefaultTelegramClient.Companion.getLogger().info(this.marker, "Client ready");
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(TelegramClient.class);
    }

    @Override
    @NotNull
    public <T extends TLObject> T executeRpcQuery(@NotNull TLMethod<T> method, int dcId) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull(method, (String)"method");
        return TelegramClient.DefaultImpls.executeRpcQuery(this, method, dcId);
    }

    @Override
    public void downloadSync(@NotNull InputFileLocation inputLocation, int size, @NotNull OutputStream outputStream) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputLocation, (String)"inputLocation");
        Intrinsics.checkParameterIsNotNull((Object)outputStream, (String)"outputStream");
        TelegramClient.DefaultImpls.downloadSync(this, inputLocation, size, outputStream);
    }

    @Override
    @Nullable
    public TLFile getUserPhoto(@NotNull TLAbsUser user, boolean big) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)user, (String)"user");
        return TelegramClient.DefaultImpls.getUserPhoto(this, user, big);
    }

    @Override
    @Nullable
    public TLFile getChatPhoto(@NotNull TLAbsChat chat, boolean big) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
        return TelegramClient.DefaultImpls.getChatPhoto(this, chat, big);
    }

    @Override
    @Nullable
    public TLFile getChannelPhoto(@NotNull TLAbsChat chat, boolean big) throws RpcErrorException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)chat, (String)"chat");
        return TelegramClient.DefaultImpls.getChannelPhoto(this, chat, big);
    }

    public static final /* synthetic */ void access$onExportedHandlerTimeout(DefaultTelegramClient $this, int dcId) {
        $this.onExportedHandlerTimeout(dcId);
    }

    @Metadata(mv={1, 1, 6}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/github/badoualy/telegram/api/DefaultTelegramClient$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "api_main"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

