/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter.resolver;

import java.lang.reflect.Field;
import net.badata.protobuf.converter.annotation.ProtoField;
import net.badata.protobuf.converter.exception.ConverterException;
import net.badata.protobuf.converter.exception.WriteException;
import net.badata.protobuf.converter.resolver.DefaultFieldResolverImpl;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.resolver.FieldResolverFactory;
import net.badata.protobuf.converter.utils.AnnotationUtils;
import net.badata.protobuf.converter.utils.FieldUtils;

public class AnnotatedFieldResolverFactoryImpl
implements FieldResolverFactory {
    @Override
    public FieldResolver createResolver(Field field) {
        DefaultFieldResolverImpl fieldResolver = new DefaultFieldResolverImpl(field);
        if (field.isAnnotationPresent(ProtoField.class)) {
            try {
                this.initializeFieldResolver(fieldResolver, field.getAnnotation(ProtoField.class));
            }
            catch (WriteException e) {
                throw new ConverterException("Can't initialize field resolver", e);
            }
        }
        return fieldResolver;
    }

    private void initializeFieldResolver(DefaultFieldResolverImpl resolver, ProtoField annotation) throws WriteException {
        if (!"".equals(annotation.name())) {
            resolver.setProtobufName(annotation.name());
        }
        Class<?> protobufType = FieldUtils.extractProtobufFieldType(annotation.converter(), resolver.getProtobufType());
        resolver.setProtobufType(protobufType);
        resolver.setConverter(AnnotationUtils.createTypeConverter(annotation));
        resolver.setNullValueInspector(AnnotationUtils.createNullValueInspector(annotation));
        resolver.setDefaultValue(AnnotationUtils.createDefaultValue(annotation));
    }
}

