/*
 * Decompiled with CFR 0.152.
 */
package net.badata.protobuf.converter;

import com.google.protobuf.Message;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.badata.protobuf.converter.Configuration;
import net.badata.protobuf.converter.FieldsIgnore;
import net.badata.protobuf.converter.annotation.ProtoClass;
import net.badata.protobuf.converter.exception.ConverterException;
import net.badata.protobuf.converter.exception.MappingException;
import net.badata.protobuf.converter.exception.TypeRelationException;
import net.badata.protobuf.converter.exception.WriteException;
import net.badata.protobuf.converter.mapping.Mapper;
import net.badata.protobuf.converter.mapping.MappingResult;
import net.badata.protobuf.converter.resolver.FieldResolver;
import net.badata.protobuf.converter.resolver.FieldResolverFactory;
import net.badata.protobuf.converter.utils.AnnotationUtils;
import net.badata.protobuf.converter.utils.FieldUtils;
import net.badata.protobuf.converter.utils.MessageUtils;
import net.badata.protobuf.converter.writer.DomainWriter;
import net.badata.protobuf.converter.writer.ProtobufWriter;

public final class Converter {
    private final Configuration configuration;

    public static Converter create() {
        return Converter.create(Configuration.builder().build());
    }

    @Deprecated
    public static Converter create(FieldsIgnore fieldsIgnore) {
        Configuration.Builder configurationBuilder = Configuration.builder();
        configurationBuilder.setIgnoredFields(fieldsIgnore);
        return new Converter(configurationBuilder.build());
    }

    public static Converter create(Configuration configuration) {
        return new Converter(configuration);
    }

    private Converter(Configuration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Argument configuration can't be null");
        }
        this.configuration = configuration;
    }

    public <T, E extends Message> List<T> toDomain(Class<T> domainClass, Collection<E> protobufCollection) {
        return this.toDomain(List.class, domainClass, protobufCollection);
    }

    private <T, E extends Message, K extends Collection> K toDomain(Class<K> collectionClass, Class<T> domainClass, Collection<E> protobufCollection) {
        AbstractCollection domainList = List.class.isAssignableFrom(collectionClass) ? new ArrayList() : new HashSet();
        for (Message protobuf : protobufCollection) {
            domainList.add(this.toDomain(domainClass, protobuf));
        }
        return (K)domainList;
    }

    public <T, E extends Message> T toDomain(Class<T> domainClass, E protobuf) {
        if (protobuf == null) {
            return null;
        }
        T domain = this.createDomain(domainClass);
        ProtoClass protoClass = this.testDataBinding(domain.getClass(), protobuf.getClass());
        try {
            this.fillDomain(domain, protobuf, protoClass);
            return domain;
        }
        catch (MappingException e) {
            throw new ConverterException("Field mapping error", e);
        }
        catch (WriteException e) {
            throw new ConverterException("Domain field value setting error", e);
        }
    }

    private ProtoClass testDataBinding(Class<?> domainClass, Class<? extends Message> protobufClass) {
        ProtoClass protoClassAnnotation = AnnotationUtils.findProtoClass(domainClass, protobufClass);
        if (protoClassAnnotation == null) {
            throw new ConverterException(new TypeRelationException(domainClass, protobufClass));
        }
        return protoClassAnnotation;
    }

    private <T> T createDomain(Class<T> domainClass) {
        try {
            return domainClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConverterException("Default constructor not found for " + domainClass.getSimpleName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConverterException("Make default constructor of " + domainClass.getSimpleName() + " public", e);
        }
    }

    private <E extends Message> void fillDomain(Object domain, E protobuf, ProtoClass protoClassAnnotation) throws MappingException, WriteException {
        Class<?> domainClass = domain.getClass();
        Mapper fieldMapper = AnnotationUtils.createMapper(protoClassAnnotation);
        FieldResolverFactory fieldFactory = AnnotationUtils.createFieldFactory(protoClassAnnotation);
        for (Field field : this.getDomainFields(domainClass)) {
            if (this.configuration.getIgnoredFields().ignored(field)) continue;
            FieldResolver fieldResolver = fieldFactory.createResolver(field);
            this.fillDomainField(fieldResolver, fieldMapper.mapToDomainField(fieldResolver, protobuf, domain));
        }
    }

    private List<Field> getDomainFields(Class clazz) {
        Class superClazz;
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        if (this.configuration.withInheritedFields() && (superClazz = clazz.getSuperclass()) != null) {
            fields.addAll(this.getDomainFields(superClazz));
        }
        return fields;
    }

    private void fillDomainField(FieldResolver fieldResolver, MappingResult mappingResult) throws WriteException {
        DomainWriter fieldWriter = new DomainWriter(mappingResult.getDestination());
        List<?> mappedValue = mappingResult.getValue();
        switch (mappingResult.getCode()) {
            case NESTED_MAPPING: {
                fieldWriter.write(fieldResolver, this.createNestedConverter().toDomain(fieldResolver.getDomainType(), (Message)mappedValue));
                break;
            }
            case COLLECTION_MAPPING: {
                Class<?> collectionType = FieldUtils.extractCollectionType(fieldResolver.getField());
                if (FieldUtils.isComplexType(collectionType)) {
                    mappedValue = this.createDomainValueList(collectionType, mappedValue);
                }
            }
            default: {
                fieldWriter.write(fieldResolver, mappedValue);
            }
        }
    }

    private Converter createNestedConverter() {
        return Converter.create(this.configuration);
    }

    private <T> List<T> createDomainValueList(Class<T> type, Object protobufCollection) {
        return this.createNestedConverter().toDomain(type, (Message)((List)protobufCollection));
    }

    public <T, E extends Message> List<E> toProtobuf(Class<E> protobufClass, Collection<T> domainCollection) {
        return this.toProtobuf(List.class, protobufClass, domainCollection);
    }

    private <T, E extends Message, K extends Collection> K toProtobuf(Class<K> collectionClass, Class<E> protobufClass, Collection<T> domainCollection) {
        AbstractCollection protobufCollection;
        AbstractCollection abstractCollection = protobufCollection = List.class.isAssignableFrom(collectionClass) ? new ArrayList() : new HashSet();
        if (domainCollection != null) {
            for (T domain : domainCollection) {
                protobufCollection.add(this.toProtobuf(protobufClass, domain));
            }
        }
        return (K)protobufCollection;
    }

    public <T, E extends Message> E toProtobuf(Class<E> protobufClass, T domain) {
        if (domain == null) {
            return null;
        }
        Message.Builder protobuf = this.createProtobuf(protobufClass);
        ProtoClass protoClass = this.testDataBinding(domain.getClass(), protobufClass);
        try {
            this.fillProtobuf(protobuf, domain, protoClass);
            return (E)protobuf.build();
        }
        catch (MappingException e) {
            throw new ConverterException("Field mapping error", e);
        }
        catch (WriteException e) {
            throw new ConverterException("Protobuf field value setting error", e);
        }
    }

    private <E extends Message> Message.Builder createProtobuf(Class<E> protobufClass) {
        try {
            return (Message.Builder)protobufClass.getDeclaredMethod("newBuilder", new Class[0]).invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new ConverterException("Can't access 'newBuilder()' method for " + protobufClass.getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConverterException("Can't instantiate protobuf builder for " + protobufClass.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new ConverterException("Method 'newBuilder()' not found in " + protobufClass.getName(), e);
        }
    }

    private <E extends Message.Builder> void fillProtobuf(E protobuf, Object domain, ProtoClass protoClassAnnotation) throws MappingException, WriteException {
        Class<?> domainClass = domain.getClass();
        Mapper fieldMapper = AnnotationUtils.createMapper(protoClassAnnotation);
        FieldResolverFactory fieldFactory = AnnotationUtils.createFieldFactory(protoClassAnnotation);
        for (Field field : this.getDomainFields(domainClass)) {
            if (this.configuration.getIgnoredFields().ignored(field)) continue;
            FieldResolver fieldResolver = fieldFactory.createResolver(field);
            this.fillProtobufField(fieldResolver, fieldMapper.mapToProtobufField(fieldResolver, domain, protobuf));
        }
    }

    private void fillProtobufField(FieldResolver fieldResolver, MappingResult mappingResult) throws WriteException {
        ProtobufWriter fieldWriter = new ProtobufWriter((Message.Builder)mappingResult.getDestination());
        Collection<?> mappedValue = mappingResult.getValue();
        switch (mappingResult.getCode()) {
            case NESTED_MAPPING: {
                Class<? extends Message> protobufClass = MessageUtils.getMessageType(mappingResult.getDestination(), FieldUtils.createProtobufGetterName(fieldResolver));
                fieldWriter.write(fieldResolver, this.createNestedConverter().toProtobuf((Class)protobufClass, (Object)mappedValue));
                break;
            }
            case COLLECTION_MAPPING: {
                Class<?> collectionType = FieldUtils.extractCollectionType(fieldResolver.getField());
                if (FieldUtils.isComplexType(collectionType)) {
                    Class<? extends Message> protobufCollectionClass = MessageUtils.getMessageCollectionType(mappingResult.getDestination(), FieldUtils.createProtobufGetterName(fieldResolver));
                    mappedValue = this.createProtobufValueList(protobufCollectionClass, fieldResolver.getDomainType(), mappedValue);
                }
            }
            default: {
                fieldWriter.write(fieldResolver, mappedValue);
            }
        }
    }

    private <E extends Message> Collection<?> createProtobufValueList(Class<E> type, Class<?> domainCollectionClass, Collection<?> domainCollection) {
        return this.createNestedConverter().toProtobuf(domainCollectionClass, type, domainCollection);
    }
}

