/*
 * Decompiled with CFR 0.152.
 */
package com.franmontiel.persistentcookiejar.tray;

import android.content.Context;
import android.text.TextUtils;
import com.franmontiel.persistentcookiejar.persistence.CookiePersistor;
import com.franmontiel.persistentcookiejar.persistence.SerializableCookie;
import com.franmontiel.persistentcookiejar.tray.AppPreferences;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.grandcentrix.tray.core.TrayItem;
import okhttp3.Cookie;

public class AppPrefsCookiePersistor
implements CookiePersistor {
    private final AppPreferences sharedPreferences;

    public AppPrefsCookiePersistor(Context context) {
        this.sharedPreferences = new AppPreferences(context);
    }

    @Override
    public List<Cookie> loadAll() {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>(this.sharedPreferences.getAll().size());
        for (TrayItem entry : this.sharedPreferences.getAll()) {
            Cookie cookie;
            if (TextUtils.isEmpty((CharSequence)entry.value()) || (cookie = new SerializableCookie().decode(entry.value())) == null) continue;
            cookies.add(cookie);
        }
        return cookies;
    }

    @Override
    public void saveAll(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            if (!cookie.persistent()) continue;
            this.sharedPreferences.put(AppPrefsCookiePersistor.createCookieKey(cookie), new SerializableCookie().encode(cookie));
        }
    }

    @Override
    public void removeAll(Collection<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.sharedPreferences.remove(AppPrefsCookiePersistor.createCookieKey(cookie));
        }
    }

    private static String createCookieKey(Cookie cookie) {
        return (cookie.secure() ? "https" : "http") + "://" + cookie.domain() + cookie.path() + "|" + cookie.name();
    }

    @Override
    public void clear() {
        this.sharedPreferences.clear();
    }
}

