/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.threads;

import com.github.axet.threads.RecursiveThreadExecutor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class RecursiveThreadTasks {
    RecursiveThreadExecutor es;
    List<RecursiveThreadExecutor.Task> tasks = new ArrayList<RecursiveThreadExecutor.Task>();
    AtomicBoolean interrupted;

    public RecursiveThreadTasks(RecursiveThreadExecutor e) {
        this.es = e;
        this.interrupted = new AtomicBoolean(false);
    }

    public RecursiveThreadTasks(RecursiveThreadExecutor e, AtomicBoolean interrupted) {
        this.es = e;
        this.interrupted = interrupted;
    }

    public void execute(Runnable r) {
        RecursiveThreadExecutor.Task t = new RecursiveThreadExecutor.Task(r){

            @Override
            public boolean interrupted() {
                return RecursiveThreadTasks.this.interrupted.get();
            }
        };
        this.tasks.add(t);
        this.es.execute(t);
    }

    public void waitTermination() throws InterruptedException {
        try {
            for (RecursiveThreadExecutor.Task r : this.tasks) {
                this.es.waitTermination(r);
                if (r.e == null) continue;
                if (r.e instanceof InterruptedException) {
                    throw (InterruptedException)r.e;
                }
                if (r.e instanceof RuntimeException) {
                    throw (RuntimeException)r.e;
                }
                throw new RuntimeException(r.e);
            }
        }
        catch (InterruptedException e) {
            this.interrupted.set(true);
            throw e;
        }
    }
}

