/*
 * Decompiled with CFR 0.152.
 */
package com.github.axet.threads;

import java.util.ArrayList;
import java.util.List;

public class RecursiveThreadExecutor {
    int maxThreads;
    List<Job> threads = new ArrayList<Job>();
    List<Task> tasks = new ArrayList<Task>();
    int waitingThreads = 0;

    public RecursiveThreadExecutor(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public RecursiveThreadExecutor() {
        this.maxThreads = Runtime.getRuntime().availableProcessors();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.maxThreads = 0;
            for (Job j : this.threads) {
                j.interrupt();
            }
        }
        for (Job j : this.threads) {
            try {
                j.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.threads.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task t) {
        List<Task> list = this.tasks;
        synchronized (list) {
            this.tasks.add(t);
            if (this.waitingThreads == 0) {
                if (this.threads.size() < this.maxThreads) {
                    this.createThread();
                }
            } else {
                this.tasks.notify();
            }
        }
    }

    void createThread() {
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Job t = new Job();
        this.threads.add(t);
        t.start();
    }

    Task waitForNewTask() throws InterruptedException {
        return this.waitForNewTask(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Task waitForNewTask(Task taskEnd) throws InterruptedException {
        List<Task> list = this.tasks;
        synchronized (list) {
            ++this.waitingThreads;
            try {
                block14: {
                    block15: {
                        if (this.tasks.size() != 0) break block14;
                        if (taskEnd == null) break block15;
                        Task task = taskEnd;
                        synchronized (task) {
                            if (taskEnd.end) {
                            }
                            break block15;
                        }
                        return null;
                    }
                    this.tasks.wait();
                    if (this.tasks.size() == 0) {
                        return null;
                    }
                }
                Task task = this.tasks.remove(0);
                return task;
            }
            finally {
                --this.waitingThreads;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void waitTaskEnd(Task t) throws InterruptedException {
        while (true) {
            Task tt;
            if ((tt = this.waitForNewTask(t)) != null) {
                this.executeTaskFlag(tt);
                continue;
            }
            Task task = t;
            synchronized (task) {
                if (t.end) {
                    return;
                }
            }
        }
    }

    public void waitTermination(Task t) throws InterruptedException {
        if (!this.executeTaskFlag(t)) {
            this.waitTaskEnd(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean executeTaskFlag(Task t) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Current Thread Interrupted");
        }
        Task task = t;
        synchronized (task) {
            block22: {
                block21: {
                    if (t.interrupted()) {
                        throw new InterruptedException("Parent Task Interrupted");
                    }
                    if (!t.end) break block21;
                    return true;
                }
                if (!t.start) break block22;
                return false;
            }
            t.start = true;
        }
        try {
            t.run();
        }
        catch (Throwable throwable) {
            Object object = t;
            synchronized (object) {
                t.end = true;
            }
            object = this.tasks;
            synchronized (object) {
                this.tasks.notifyAll();
            }
            throw throwable;
        }
        Object object = t;
        synchronized (object) {
            t.end = true;
        }
        object = this.tasks;
        synchronized (object) {
            this.tasks.notifyAll();
        }
        return true;
    }

    class Job
    extends Thread {
        public Job() {
            super("RecursiveThread - " + RecursiveThreadExecutor.this.threads.size());
        }

        @Override
        public void run() {
            while (true) {
                Task t = null;
                try {
                    t = RecursiveThreadExecutor.this.waitForNewTask();
                    if (t == null) continue;
                    RecursiveThreadExecutor.this.executeTaskFlag(t);
                    continue;
                }
                catch (Error e) {
                    if (t == null) continue;
                    t.e = e;
                    continue;
                }
                catch (RuntimeException e) {
                    if (t == null) continue;
                    t.e = e;
                    continue;
                }
                catch (InterruptedException e) {
                    if (t != null) {
                        t.e = e;
                    }
                    return;
                }
                break;
            }
        }
    }

    public static class Task
    implements Runnable {
        Throwable e;
        Runnable r;
        boolean start = false;
        boolean end = false;

        public Task(Runnable r) {
            this.r = r;
        }

        @Override
        public void run() {
            this.r.run();
        }

        public boolean interrupted() {
            return false;
        }
    }
}

