/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.avito.android.krop.OverlayView;
import com.avito.android.krop.R;
import com.avito.android.krop.SizeF;
import com.avito.android.krop.Transformation;
import com.avito.android.krop.ZoomableImageView;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u000256B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\bJ8\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\b2\u0006\u0010\"\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\b\u0010#\u001a\u00020\u0019H\u0002J\b\u0010$\u001a\u0004\u0018\u00010\u000bJ\u0006\u0010%\u001a\u00020&J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010(\u001a\u00020\u001bH\u0016J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0014J\u0010\u0010,\u001a\u00020\u001b2\u0006\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020.H\u0014J\u0010\u00100\u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u000e\u00101\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u00102\u001a\u00020\u001b2\u0006\u00103\u001a\u000204R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/avito/android/krop/KropView;", "Landroid/widget/FrameLayout;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectX", "", "aspectY", "bitmap", "Landroid/graphics/Bitmap;", "cropListener", "Lcom/avito/android/krop/KropView$CropListener;", "getCropListener", "()Lcom/avito/android/krop/KropView$CropListener;", "setCropListener", "(Lcom/avito/android/krop/KropView$CropListener;)V", "imageView", "Lcom/avito/android/krop/ZoomableImageView;", "offset", "overlayColor", "overlayView", "Lcom/avito/android/krop/OverlayView;", "viewport", "Landroid/graphics/RectF;", "applyAspectRatio", "", "applyOffset", "applyOverlayColor", "color", "calculateViewport", "rect", "width", "height", "getCropRect", "getCroppedBitmap", "getTransformation", "Lcom/avito/android/krop/Transformation;", "initViews", "invalidate", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "parseAttrs", "setBitmap", "setZoom", "scale", "", "CropListener", "SavedState", "krop_release"})
public final class KropView
extends FrameLayout {
    private final RectF viewport;
    private int offset;
    private int aspectX;
    private int aspectY;
    private int overlayColor;
    private Bitmap bitmap;
    private ZoomableImageView imageView;
    private OverlayView overlayView;
    @Nullable
    private CropListener cropListener;

    @Nullable
    public final CropListener getCropListener() {
        return this.cropListener;
    }

    public final void setCropListener(@Nullable CropListener cropListener) {
        this.cropListener = cropListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseAttrs(AttributeSet attrs) {
        TypedArray arr = null;
        try {
            TypedArray typedArray;
            TypedArray typedArray2 = arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.KropView);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray2, (String)"arr");
            TypedArray $receiver = typedArray = typedArray2;
            this.offset = $receiver.getDimensionPixelOffset(R.styleable.KropView_krop_offset, this.offset);
            this.aspectX = $receiver.getInteger(R.styleable.KropView_krop_aspectX, this.aspectX);
            this.aspectY = $receiver.getInteger(R.styleable.KropView_krop_aspectY, this.aspectY);
            this.overlayColor = $receiver.getColor(R.styleable.KropView_krop_overlayColor, this.overlayColor);
        }
        catch (Throwable throwable) {
            TypedArray typedArray = arr;
            if (typedArray != null) {
                typedArray.recycle();
            }
            throw throwable;
        }
        arr.recycle();
    }

    private final void initViews(Context context) {
        ZoomableImageView zoomableImageView = this.imageView = new ZoomableImageView(context);
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setImageMoveListener(new ZoomableImageView.ImageMoveListener(this){
            final /* synthetic */ KropView this$0;

            public void onMove() {
                block0: {
                    CropListener cropListener = this.this$0.getCropListener();
                    if (cropListener == null) break block0;
                    cropListener.onCrop(this.this$0.getTransformation());
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        ZoomableImageView zoomableImageView2 = this.imageView;
        if (zoomableImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        this.addView((View)zoomableImageView2);
        OverlayView overlayView = this.overlayView = new OverlayView(context);
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.setBackgroundColor(this.overlayColor);
        OverlayView overlayView2 = this.overlayView;
        if (overlayView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        this.addView(overlayView2);
    }

    public final void setZoom(float scale) {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        ZoomableImageView.setZoom$default(zoomableImageView, scale, 0.0f, 0.0f, null, 14, null);
    }

    public final void setBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.bitmap = bitmap;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setImageBitmap(bitmap);
    }

    @NotNull
    public final Transformation getTransformation() {
        Transformation transformation = new Transformation(null, null, 3, null);
        Bitmap bitmap = this.bitmap;
        if (bitmap == null) {
            return transformation;
        }
        Bitmap bitmap2 = bitmap;
        Transformation $receiver = transformation;
        $receiver.setSize(new SizeF(bitmap2.getWidth(), bitmap2.getHeight()));
        $receiver.setCrop(this.getCropRect());
        return transformation;
    }

    private final RectF getCropRect() {
        RectF rect = new RectF();
        Bitmap bitmap = this.bitmap;
        if (bitmap == null) {
            return rect;
        }
        Bitmap bitmap2 = bitmap;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        RectF bounds = zoomableImageView.getImageBounds();
        float multiplier = bounds.width() / (float)bitmap2.getWidth();
        RectF $receiver = rect;
        $receiver.left = -bounds.left / multiplier;
        $receiver.top = -bounds.top / multiplier;
        $receiver.right = (-bounds.left + this.viewport.width()) / multiplier;
        $receiver.bottom = (-bounds.top + this.viewport.height()) / multiplier;
        return rect;
    }

    @Nullable
    public final Bitmap getCroppedBitmap() {
        RectF rect = this.getCropRect();
        return Bitmap.createBitmap((Bitmap)this.bitmap, (int)((int)rect.left), (int)((int)rect.top), (int)((int)rect.width()), (int)((int)rect.height()));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int height = View.MeasureSpec.getSize((int)heightMeasureSpec);
        this.calculateViewport(this.viewport, width, height, this.offset, this.aspectX, this.aspectY);
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setViewport(this.viewport);
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.setViewport(this.viewport);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public final void applyOffset(int offset) {
        this.offset = offset;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.requestLayout();
        ZoomableImageView zoomableImageView2 = this.imageView;
        if (zoomableImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView2.resetZoom();
        this.invalidate();
    }

    public final void applyAspectRatio(int aspectX, int aspectY) {
        this.aspectX = aspectX;
        this.aspectY = aspectY;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.requestLayout();
        ZoomableImageView zoomableImageView2 = this.imageView;
        if (zoomableImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView2.resetZoom();
        this.invalidate();
    }

    public final void applyOverlayColor(int color) {
        this.overlayColor = color;
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.setBackgroundColor(this.overlayColor);
        this.invalidate();
    }

    public void invalidate() {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.invalidate();
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.invalidate();
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        return (Parcelable)new SavedState(parcelable, this.offset, this.aspectX, this.aspectY, this.overlayColor, zoomableImageView.onSaveInstanceState());
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof SavedState) {
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
            this.offset = ((SavedState)state).getOffset();
            this.aspectX = ((SavedState)state).getAspectX();
            this.aspectY = ((SavedState)state).getAspectY();
            this.overlayColor = ((SavedState)state).getOverlayColor();
            ZoomableImageView zoomableImageView = this.imageView;
            if (zoomableImageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
            }
            zoomableImageView.onRestoreInstanceState(((SavedState)state).getImageViewState());
            OverlayView overlayView = this.overlayView;
            if (overlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
            }
            overlayView.setBackgroundColor(this.overlayColor);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private final RectF calculateViewport(RectF rect, int width, int height, int offset, int aspectX, int aspectY) {
        float desiredHeight;
        float desiredWidth;
        float x = (float)width * 0.5f;
        float y = (float)height * 0.5f;
        float maxWidth = (float)width - (float)offset * 2.0f;
        float maxHeight = (float)height - (float)offset * 2.0f;
        if (maxWidth < maxHeight) {
            desiredWidth = maxWidth;
            desiredHeight = maxWidth * (float)aspectY / (float)aspectX;
        } else if (maxWidth > maxHeight) {
            desiredWidth = maxHeight * (float)aspectX / (float)aspectY;
            desiredHeight = maxHeight;
        } else {
            desiredWidth = maxWidth;
            desiredHeight = maxHeight;
        }
        float resultWidth = maxWidth;
        float resultHeight = maxWidth * desiredHeight / desiredWidth;
        if (resultHeight > maxHeight) {
            resultHeight = maxHeight;
            resultWidth = desiredWidth * maxHeight / desiredHeight;
        }
        RectF $receiver = rect;
        $receiver.left = x - resultWidth / (float)2;
        $receiver.top = y - resultHeight / (float)2;
        $receiver.right = x + resultWidth / (float)2;
        $receiver.bottom = y + resultHeight / (float)2;
        return rect;
    }

    public KropView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.viewport = new RectF();
        this.aspectX = 1;
        this.aspectY = 1;
        this.parseAttrs(attrs);
        this.initViews(context);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/avito/android/krop/KropView$CropListener;", "", "onCrop", "", "transformation", "Lcom/avito/android/krop/Transformation;", "krop_release"})
    public static interface CropListener {
        public void onCrop(@NotNull Transformation var1);
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u000f\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000f\"\u0004\b\u0013\u0010\u0011R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u000f\"\u0004\b\u0017\u0010\u0011R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000f\"\u0004\b\u0019\u0010\u0011\u00a8\u0006\u001f"}, d2={"Lcom/avito/android/krop/KropView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "offset", "", "aspectX", "aspectY", "overlayColor", "imageViewState", "(Landroid/os/Parcelable;IIIILandroid/os/Parcelable;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getAspectX", "()I", "setAspectX", "(I)V", "getAspectY", "setAspectY", "getImageViewState", "()Landroid/os/Parcelable;", "getOffset", "setOffset", "getOverlayColor", "setOverlayColor", "writeToParcel", "", "out", "flags", "CREATOR", "krop_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private int offset;
        private int aspectX;
        private int aspectY;
        private int overlayColor;
        @NotNull
        private final Parcelable imageViewState;
        public static final CREATOR CREATOR = new CREATOR(null);

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        public final int getAspectX() {
            return this.aspectX;
        }

        public final void setAspectX(int n) {
            this.aspectX = n;
        }

        public final int getAspectY() {
            return this.aspectY;
        }

        public final void setAspectY(int n) {
            this.aspectY = n;
        }

        public final int getOverlayColor() {
            return this.overlayColor;
        }

        public final void setOverlayColor(int n) {
            this.overlayColor = n;
        }

        @NotNull
        public final Parcelable getImageViewState() {
            return this.imageViewState;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            Parcel $receiver = out;
            $receiver.writeInt(this.offset);
            $receiver.writeInt(this.aspectX);
            $receiver.writeInt(this.aspectY);
            $receiver.writeInt(this.overlayColor);
            $receiver.writeParcelable(this.imageViewState, flags);
        }

        public SavedState(@NotNull Parcelable superState, int offset, int aspectX, int aspectY, int overlayColor, @NotNull Parcelable imageViewState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            Intrinsics.checkParameterIsNotNull((Object)imageViewState, (String)"imageViewState");
            super(superState);
            this.offset = offset;
            this.aspectX = aspectX;
            this.aspectY = aspectY;
            this.overlayColor = overlayColor;
            this.imageViewState = imageViewState;
        }

        public SavedState(@NotNull Parcel source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.offset = source.readInt();
            this.aspectX = source.readInt();
            this.aspectY = source.readInt();
            this.overlayColor = source.readInt();
            Parcelable parcelable = source.readParcelable(Parcelable.class.getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"source.readParcelable(Pa\u2026::class.java.classLoader)");
            this.imageViewState = parcelable;
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/avito/android/krop/KropView$SavedState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/avito/android/krop/KropView$SavedState;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/avito/android/krop/KropView$SavedState;", "krop_release"})
        public static final class CREATOR
        implements Parcelable.Creator<SavedState> {
            @NotNull
            public SavedState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                return new SavedState(parcel);
            }

            @NotNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }

            private CREATOR() {
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

