/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop.util;

import com.avito.android.krop.util.KPoint;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\u0000J\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u0012J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\u0006\u0010\u0016\u001a\u00020\u0013J\u000e\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u001c"}, d2={"Lcom/avito/android/krop/util/KLine;", "", "p1", "Lcom/avito/android/krop/util/KPoint;", "p2", "(Lcom/avito/android/krop/util/KPoint;Lcom/avito/android/krop/util/KPoint;)V", "getP1", "()Lcom/avito/android/krop/util/KPoint;", "getP2", "component1", "component2", "copy", "equals", "", "other", "findIntersection", "line2", "getTransition", "Lkotlin/Pair;", "", "hashCode", "", "length", "nearestPointFor", "target", "normalFrom", "toString", "", "krop_release"})
public final class KLine {
    @NotNull
    private final KPoint p1;
    @NotNull
    private final KPoint p2;

    @Nullable
    public final KPoint findIntersection(@NotNull KLine line2) {
        Intrinsics.checkNotNullParameter((Object)line2, (String)"line2");
        float x1 = this.p1.getX();
        float y1 = this.p1.getY();
        float x2 = this.p2.getX();
        float y2 = this.p2.getY();
        float x3 = line2.p1.getX();
        float y3 = line2.p1.getY();
        float x4 = line2.p2.getX();
        float y4 = line2.p2.getY();
        float t = (y3 - y1 - (x3 - x1) * (y2 - y1) / (x2 - x1)) / ((x4 - x3) * (y2 - y1) / (x2 - x1) - (y4 - y3));
        if (t < 0.0f || t > 1.0f) {
            return null;
        }
        float s = (x3 - x1 + t * (x4 - x3)) / (x2 - x1);
        if (s < 0.0f || s > 1.0f) {
            return null;
        }
        return new KPoint(x1 + s * (x2 - x1), y1 + s * (y2 - y1));
    }

    public final float length() {
        float f = (this.p2.getX() - this.p1.getX()) * (this.p2.getX() - this.p1.getX()) + (this.p2.getY() - this.p1.getY()) * (this.p2.getY() - this.p1.getY());
        boolean bl = false;
        return (float)Math.sqrt(f);
    }

    @NotNull
    public final Pair<Float, Float> getTransition() {
        return TuplesKt.to((Object)Float.valueOf(this.p2.getX() - this.p1.getX()), (Object)Float.valueOf(this.p2.getY() - this.p1.getY()));
    }

    @NotNull
    public final KPoint nearestPointFor(@NotNull KPoint target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KPoint normalPoint = this.normalFrom((KPoint)target).p2;
        float len = this.length();
        float lenP1 = new KLine(this.p1, normalPoint).length();
        float lenP2 = new KLine(this.p2, normalPoint).length();
        float f = lenP1 + lenP2 - len;
        boolean bl = false;
        if (Math.abs(f) < 1.0f) {
            return normalPoint;
        }
        return lenP1 > lenP2 ? this.p2 : this.p1;
    }

    @NotNull
    public final KLine normalFrom(@NotNull KPoint target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        float sideLength1 = new KLine(this.p1, target).length();
        float sideLength2 = new KLine(this.p2, target).length();
        float lineLength = this.length();
        float weight2 = (sideLength2 * sideLength2 + lineLength * lineLength - sideLength1 * sideLength1) / ((float)2 * lineLength);
        float weight1 = lineLength - weight2;
        float weight = weight1 / (weight1 + weight2);
        KPoint destination = new KPoint(this.p1.getX() + (this.p2.getX() - this.p1.getX()) * weight, this.p1.getY() + (this.p2.getY() - this.p1.getY()) * weight);
        return new KLine(target, destination);
    }

    @NotNull
    public final KPoint getP1() {
        return this.p1;
    }

    @NotNull
    public final KPoint getP2() {
        return this.p2;
    }

    public KLine(@NotNull KPoint p1, @NotNull KPoint p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        this.p1 = p1;
        this.p2 = p2;
    }

    @NotNull
    public final KPoint component1() {
        return this.p1;
    }

    @NotNull
    public final KPoint component2() {
        return this.p2;
    }

    @NotNull
    public final KLine copy(@NotNull KPoint p1, @NotNull KPoint p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return new KLine(p1, p2);
    }

    public static /* synthetic */ KLine copy$default(KLine kLine, KPoint kPoint, KPoint kPoint2, int n, Object object) {
        if ((n & 1) != 0) {
            kPoint = kLine.p1;
        }
        if ((n & 2) != 0) {
            kPoint2 = kLine.p2;
        }
        return kLine.copy(kPoint, kPoint2);
    }

    @NotNull
    public String toString() {
        return "KLine(p1=" + this.p1 + ", p2=" + this.p2 + ")";
    }

    public int hashCode() {
        KPoint kPoint = this.p1;
        KPoint kPoint2 = this.p2;
        return (kPoint != null ? ((Object)kPoint).hashCode() : 0) * 31 + (kPoint2 != null ? ((Object)kPoint2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KLine)) break block3;
                KLine kLine = (KLine)object;
                if (!Intrinsics.areEqual((Object)this.p1, (Object)kLine.p1) || !Intrinsics.areEqual((Object)this.p2, (Object)kLine.p2)) break block3;
            }
            return true;
        }
        return false;
    }
}

