/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.IdRes;
import androidx.annotation.WorkerThread;
import com.avito.android.krop.OvalOverlay;
import com.avito.android.krop.OverlayView;
import com.avito.android.krop.R;
import com.avito.android.krop.RectOverlay;
import com.avito.android.krop.ZoomableImageView;
import com.avito.android.krop.util.ScaleAfterRotationStyle;
import com.avito.android.krop.util.Transformation;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u0002:\u0002EFB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u000e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\tJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0014J\u000e\u0010\"\u001a\u00020\u001e2\u0006\u0010#\u001a\u00020\tJ\u000e\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\tJ8\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0014\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020,0+H\u0002J\n\u0010-\u001a\u0004\u0018\u00010\fH\u0007J\u0006\u0010.\u001a\u00020/J\u0010\u00100\u001a\u00020\u001e2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u00101\u001a\u00020\u001eH\u0016J\b\u00102\u001a\u00020\u001eH\u0014J\b\u00103\u001a\u00020\u001eH\u0016J\u0010\u00104\u001a\u00020\u001e2\u0006\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000206H\u0014J\u0010\u00108\u001a\u00020\u001e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u00109\u001a\u00020\u001e2\u0006\u0010:\u001a\u00020,2\b\b\u0002\u0010;\u001a\u00020<J\u000e\u0010=\u001a\u00020\u001e2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010>\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020,J\u000e\u0010@\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020,J\u000e\u0010A\u001a\u00020\u001e2\u0006\u0010B\u001a\u00020/J\u000e\u0010C\u001a\u00020\u001e2\u0006\u0010?\u001a\u00020,J\b\u0010D\u001a\u00020\u001eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0011\u001a\u00020\t8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/avito/android/krop/KropView;", "Landroid/widget/FrameLayout;", "Lcom/avito/android/krop/OverlayView$MeasureListener;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "aspectX", "", "aspectY", "bitmap", "Landroid/graphics/Bitmap;", "imageView", "Lcom/avito/android/krop/ZoomableImageView;", "offset", "overlayColor", "overlayResId", "overlayShape", "overlayView", "Lcom/avito/android/krop/OverlayView;", "transformationListener", "Lcom/avito/android/krop/KropView$TransformationListener;", "getTransformationListener", "()Lcom/avito/android/krop/KropView$TransformationListener;", "setTransformationListener", "(Lcom/avito/android/krop/KropView$TransformationListener;)V", "viewport", "Landroid/graphics/RectF;", "applyAspectRatio", "", "applyOffset", "applyOverlay", "overlay", "applyOverlayColor", "color", "applyOverlayShape", "shape", "calculateViewport", "rect", "width", "height", "getCropRect", "Lkotlin/Pair;", "", "getCroppedBitmap", "getTransformation", "Lcom/avito/android/krop/util/Transformation;", "initViews", "invalidate", "onAttachedToWindow", "onOverlayMeasured", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "parseAttrs", "rotateBy", "angle", "scaleAnimation", "Lcom/avito/android/krop/util/ScaleAfterRotationStyle;", "setBitmap", "setMaxScale", "scale", "setMinScale", "setTransformation", "transformation", "setZoom", "setupOverlayView", "SavedState", "TransformationListener", "krop_release"})
public final class KropView
extends FrameLayout
implements OverlayView.MeasureListener {
    private final RectF viewport;
    private int offset;
    private int aspectX;
    private int aspectY;
    private int overlayColor;
    private int overlayShape;
    @IdRes
    private int overlayResId;
    private Bitmap bitmap;
    private ZoomableImageView imageView;
    private OverlayView overlayView;
    @Nullable
    private TransformationListener transformationListener;

    @Nullable
    public final TransformationListener getTransformationListener() {
        return this.transformationListener;
    }

    public final void setTransformationListener(@Nullable TransformationListener transformationListener) {
        this.transformationListener = transformationListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void parseAttrs(AttributeSet attrs) {
        TypedArray arr = null;
        try {
            TypedArray typedArray = arr = this.getContext().obtainStyledAttributes(attrs, R.styleable.KropView);
            Intrinsics.checkExpressionValueIsNotNull((Object)typedArray, (String)"arr");
            TypedArray typedArray2 = typedArray;
            boolean bl = false;
            boolean bl2 = false;
            TypedArray $this$with = typedArray2;
            boolean bl3 = false;
            this.offset = $this$with.getDimensionPixelOffset(R.styleable.KropView_krop_offset, this.offset);
            this.aspectX = $this$with.getInteger(R.styleable.KropView_krop_aspectX, this.aspectX);
            this.aspectY = $this$with.getInteger(R.styleable.KropView_krop_aspectY, this.aspectY);
            this.overlayShape = $this$with.getInteger(R.styleable.KropView_krop_shape, this.overlayShape);
            this.overlayColor = $this$with.getColor(R.styleable.KropView_krop_overlayColor, this.overlayColor);
            this.overlayResId = $this$with.getResourceId(R.styleable.KropView_krop_overlay, this.overlayResId);
        }
        catch (Throwable throwable) {
            TypedArray typedArray = arr;
            if (typedArray != null) {
                typedArray.recycle();
            }
            throw throwable;
        }
        arr.recycle();
    }

    private final void initViews(Context context) {
        ZoomableImageView zoomableImageView = this.imageView = new ZoomableImageView(context);
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setImageMoveListener(new ZoomableImageView.ImageMoveListener(this){
            final /* synthetic */ KropView this$0;

            public void onMove() {
                block0: {
                    TransformationListener transformationListener = this.this$0.getTransformationListener();
                    if (transformationListener == null) break block0;
                    transformationListener.onUpdate(this.this$0.getTransformation());
                }
            }
            {
                this.this$0 = $outer;
            }
        });
        ZoomableImageView zoomableImageView2 = this.imageView;
        if (zoomableImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        this.addView((View)zoomableImageView2);
        this.applyOverlayShape(this.overlayShape);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.overlayResId != 0) {
            View view = this.getRootView().findViewById(this.overlayResId);
            if (!(view instanceof OverlayView)) {
                view = null;
            }
            OverlayView overlayView = (OverlayView)view;
            if (overlayView == null) {
                String string = "Overlay should instantiate OverlayView class";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            OverlayView overlay = overlayView;
            this.applyOverlay(overlay);
        }
    }

    public final void rotateBy(float angle, @NotNull ScaleAfterRotationStyle scaleAnimation) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)scaleAnimation), (String)"scaleAnimation");
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.rotateBy(angle, scaleAnimation);
    }

    public static /* synthetic */ void rotateBy$default(KropView kropView, float f, ScaleAfterRotationStyle scaleAfterRotationStyle, int n, Object object) {
        if ((n & 2) != 0) {
            scaleAfterRotationStyle = ScaleAfterRotationStyle.NONE;
        }
        kropView.rotateBy(f, scaleAfterRotationStyle);
    }

    public final void setZoom(float scale) {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        ZoomableImageView.setZoom$default(zoomableImageView, scale, 0.0f, 0.0f, null, 14, null);
    }

    public final void setMaxScale(float scale) {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setMaxZoom(scale);
    }

    public final void setMinScale(float scale) {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setMinZoom(scale);
    }

    public final void setBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkParameterIsNotNull((Object)bitmap, (String)"bitmap");
        this.bitmap = bitmap;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setImageBitmap(bitmap);
    }

    public final void setTransformation(@NotNull Transformation transformation) {
        Intrinsics.checkParameterIsNotNull((Object)transformation, (String)"transformation");
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.setTransformation(transformation);
    }

    @NotNull
    public final Transformation getTransformation() {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        return zoomableImageView.getTransformation();
    }

    /*
     * WARNING - void declaration
     */
    @WorkerThread
    @Nullable
    public final Bitmap getCroppedBitmap() {
        void rect;
        Pair<RectF, Float> pair = this.getCropRect();
        RectF rectF = (RectF)pair.component1();
        float multiplier = ((Number)pair.component2()).floatValue();
        Bitmap bitmap = this.bitmap;
        if (bitmap == null) {
            return null;
        }
        Bitmap renderBitmap = bitmap;
        Bitmap result = Bitmap.createBitmap((int)((int)rect.width()), (int)((int)rect.height()), (Bitmap.Config)renderBitmap.getConfig());
        Canvas canvas = new Canvas(result);
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        Matrix matrix = new Matrix(zoomableImageView.getImageMatrix());
        Canvas canvas2 = canvas;
        boolean bl = false;
        boolean bl2 = false;
        Matrix $this$apply = matrix;
        boolean bl3 = false;
        $this$apply.postScale(multiplier, multiplier);
        Matrix matrix2 = matrix;
        canvas2.setMatrix(matrix2);
        canvas.drawBitmap(renderBitmap, 0.0f, 0.0f, null);
        return result;
    }

    @Override
    public void onOverlayMeasured() {
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        int width = overlayView.getMeasuredWidth();
        OverlayView overlayView2 = this.overlayView;
        if (overlayView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        int height = overlayView2.getMeasuredHeight();
        this.calculateViewport(this.viewport, width, height, this.offset, this.aspectX, this.aspectY);
        OverlayView overlayView3 = this.overlayView;
        if (overlayView3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView3.onUpdateViewport(this.viewport);
        RectF rectF = new RectF(this.viewport);
        boolean bl = false;
        boolean bl2 = false;
        RectF it = rectF;
        boolean bl3 = false;
        OverlayView overlayView4 = this.overlayView;
        if (overlayView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        int dx = overlayView4.getLeft() - this.getLeft();
        OverlayView overlayView5 = this.overlayView;
        if (overlayView5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        int dy = overlayView5.getTop() - this.getTop();
        it.offset((float)dx, (float)dy);
        RectF imageViewport = rectF;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.onUpdateViewport(imageViewport);
        ZoomableImageView zoomableImageView2 = this.imageView;
        if (zoomableImageView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView2.requestLayout();
        this.invalidate();
    }

    public final void applyOffset(int offset) {
        this.offset = offset;
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.requestLayout();
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.resetZoom();
        this.invalidate();
    }

    public final void applyAspectRatio(int aspectX, int aspectY) {
        this.aspectX = aspectX;
        this.aspectY = aspectY;
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.requestLayout();
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.resetZoom();
        this.invalidate();
    }

    public final void applyOverlayColor(int color) {
        this.overlayColor = color;
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.setOverlayColor(this.overlayColor);
        this.invalidate();
    }

    public final void applyOverlayShape(int shape) {
        OverlayView overlayView;
        this.overlayShape = shape;
        switch (this.overlayShape) {
            case 0: {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                overlayView = new OvalOverlay(context, null, 2, null);
                break;
            }
            default: {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                overlayView = new RectOverlay(context, null, 2, null);
            }
        }
        this.overlayView = overlayView;
        this.setupOverlayView();
    }

    public final void applyOverlay(@NotNull OverlayView overlay) {
        Intrinsics.checkParameterIsNotNull((Object)overlay, (String)"overlay");
        this.overlayShape = -1;
        this.overlayView = overlay;
        this.setupOverlayView();
    }

    public void invalidate() {
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        zoomableImageView.invalidate();
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.invalidate();
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Parcelable superState;
        Parcelable parcelable = superState = super.onSaveInstanceState();
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        return (Parcelable)new SavedState(parcelable, this.offset, this.aspectX, this.aspectY, this.overlayColor, this.overlayShape, zoomableImageView.onSaveInstanceState());
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof SavedState) {
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
            this.offset = ((SavedState)state).getOffset();
            this.aspectX = ((SavedState)state).getAspectX();
            this.aspectY = ((SavedState)state).getAspectY();
            this.overlayColor = ((SavedState)state).getOverlayColor();
            this.overlayShape = ((SavedState)state).getOverlayShape();
            ZoomableImageView zoomableImageView = this.imageView;
            if (zoomableImageView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
            }
            zoomableImageView.onRestoreInstanceState(((SavedState)state).getImageViewState());
            OverlayView overlayView = this.overlayView;
            if (overlayView == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
            }
            overlayView.setOverlayColor(this.overlayColor);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    private final void setupOverlayView() {
        OverlayView overlayView = this.overlayView;
        if (overlayView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView.setOverlayColor(this.overlayColor);
        if (this.getChildCount() > 1) {
            this.removeViewAt(1);
        }
        OverlayView overlayView2 = this.overlayView;
        if (overlayView2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        if (overlayView2.getParent() == null) {
            OverlayView overlayView3 = this.overlayView;
            if (overlayView3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
            }
            this.addView(overlayView3, 1);
        }
        OverlayView overlayView4 = this.overlayView;
        if (overlayView4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"overlayView");
        }
        overlayView4.setMeasureListener(this);
    }

    private final RectF calculateViewport(RectF rect, int width, int height, int offset, int aspectX, int aspectY) {
        float x = (float)width * 0.5f;
        float y = (float)height * 0.5f;
        float maxWidth = (float)width - (float)offset * 2.0f;
        float maxHeight = (float)height - (float)offset * 2.0f;
        float desiredWidth = 0.0f;
        float desiredHeight = 0.0f;
        if (maxWidth < maxHeight) {
            desiredWidth = maxWidth;
            desiredHeight = maxWidth * (float)aspectY / (float)aspectX;
        } else if (maxWidth > maxHeight) {
            desiredWidth = maxHeight * (float)aspectX / (float)aspectY;
            desiredHeight = maxHeight;
        } else {
            desiredWidth = maxWidth;
            desiredHeight = maxHeight;
        }
        float resultWidth = maxWidth;
        float resultHeight = maxWidth * desiredHeight / desiredWidth;
        if (resultHeight > maxHeight) {
            resultHeight = maxHeight;
            resultWidth = desiredWidth * maxHeight / desiredHeight;
        }
        boolean bl = false;
        boolean bl2 = false;
        RectF $this$with = rect;
        boolean bl3 = false;
        $this$with.left = x - resultWidth / (float)2;
        $this$with.top = y - resultHeight / (float)2;
        $this$with.right = x + resultWidth / (float)2;
        $this$with.bottom = y + resultHeight / (float)2;
        return rect;
    }

    private final Pair<RectF, Float> getCropRect() {
        RectF rect = new RectF();
        Bitmap bitmap = this.bitmap;
        if (bitmap == null) {
            return TuplesKt.to((Object)rect, (Object)Float.valueOf(1.0f));
        }
        Bitmap bitmap2 = bitmap;
        ZoomableImageView zoomableImageView = this.imageView;
        if (zoomableImageView == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageView");
        }
        RectF bounds = zoomableImageView.getImageBounds$krop_release();
        float multiplier = (float)bitmap2.getWidth() / bounds.width();
        boolean bl = false;
        boolean bl2 = false;
        RectF $this$with = rect;
        boolean bl3 = false;
        $this$with.left = -bounds.left * multiplier;
        $this$with.top = -bounds.top * multiplier;
        $this$with.right = (-bounds.left + this.viewport.width()) * multiplier;
        $this$with.bottom = (-bounds.top + this.viewport.height()) * multiplier;
        return TuplesKt.to((Object)rect, (Object)Float.valueOf(multiplier));
    }

    public KropView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.viewport = new RectF();
        this.aspectX = 1;
        this.aspectY = 1;
        this.parseAttrs(attrs);
        this.initViews(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/avito/android/krop/KropView$TransformationListener;", "", "onUpdate", "", "transformation", "Lcom/avito/android/krop/util/Transformation;", "krop_release"})
    public static interface TransformationListener {
        public void onUpdate(@NotNull Transformation var1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 !2\u00020\u0001:\u0001!B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bB\u000f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0005H\u0016R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0010\"\u0004\b\u0014\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0010\"\u0004\b\u001a\u0010\u0012R\u001a\u0010\t\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0010\"\u0004\b\u001c\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/avito/android/krop/KropView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "offset", "", "aspectX", "aspectY", "overlayColor", "overlayShape", "imageViewState", "(Landroid/os/Parcelable;IIIIILandroid/os/Parcelable;)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getAspectX", "()I", "setAspectX", "(I)V", "getAspectY", "setAspectY", "getImageViewState", "()Landroid/os/Parcelable;", "getOffset", "setOffset", "getOverlayColor", "setOverlayColor", "getOverlayShape", "setOverlayShape", "writeToParcel", "", "out", "flags", "CREATOR", "krop_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private int offset;
        private int aspectX;
        private int aspectY;
        private int overlayColor;
        private int overlayShape;
        @NotNull
        private final Parcelable imageViewState;
        public static final CREATOR CREATOR = new CREATOR(null);

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        public final int getAspectX() {
            return this.aspectX;
        }

        public final void setAspectX(int n) {
            this.aspectX = n;
        }

        public final int getAspectY() {
            return this.aspectY;
        }

        public final void setAspectY(int n) {
            this.aspectY = n;
        }

        public final int getOverlayColor() {
            return this.overlayColor;
        }

        public final void setOverlayColor(int n) {
            this.overlayColor = n;
        }

        public final int getOverlayShape() {
            return this.overlayShape;
        }

        public final void setOverlayShape(int n) {
            this.overlayShape = n;
        }

        @NotNull
        public final Parcelable getImageViewState() {
            return this.imageViewState;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            boolean bl = false;
            boolean bl2 = false;
            Parcel $this$with = out;
            boolean bl3 = false;
            $this$with.writeInt(this.offset);
            $this$with.writeInt(this.aspectX);
            $this$with.writeInt(this.aspectY);
            $this$with.writeInt(this.overlayColor);
            $this$with.writeInt(this.overlayShape);
            $this$with.writeParcelable(this.imageViewState, flags);
        }

        public SavedState(@NotNull Parcelable superState, int offset, int aspectX, int aspectY, int overlayColor, int overlayShape, @NotNull Parcelable imageViewState) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            Intrinsics.checkParameterIsNotNull((Object)imageViewState, (String)"imageViewState");
            super(superState);
            this.offset = offset;
            this.aspectX = aspectX;
            this.aspectY = aspectY;
            this.overlayColor = overlayColor;
            this.overlayShape = overlayShape;
            this.imageViewState = imageViewState;
        }

        public SavedState(@NotNull Parcel source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.offset = source.readInt();
            this.aspectX = source.readInt();
            this.aspectY = source.readInt();
            this.overlayColor = source.readInt();
            this.overlayShape = source.readInt();
            Parcelable parcelable = source.readParcelable(SavedState.class.getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"source.readParcelable(Sa\u2026::class.java.classLoader)");
            this.imageViewState = parcelable;
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001d\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/avito/android/krop/KropView$SavedState$CREATOR;", "Landroid/os/Parcelable$Creator;", "Lcom/avito/android/krop/KropView$SavedState;", "()V", "createFromParcel", "parcel", "Landroid/os/Parcel;", "newArray", "", "size", "", "(I)[Lcom/avito/android/krop/KropView$SavedState;", "krop_release"})
        public static final class CREATOR
        implements Parcelable.Creator<SavedState> {
            @NotNull
            public SavedState createFromParcel(@NotNull Parcel parcel) {
                Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                return new SavedState(parcel);
            }

            @NotNull
            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }

            private CREATOR() {
            }

            public /* synthetic */ CREATOR(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

