/*
 * Decompiled with CFR 0.152.
 */
package com.avito.android.krop;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewParent;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.ImageView;
import android.widget.OverScroller;
import android.widget.Scroller;
import com.avito.android.krop.SizeF;
import com.avito.android.krop.ZoomableImageView$WhenMappings;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u00e6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\"\u0018\u00002\u00020\u0001:\u0012\u00ab\u0001\u00ac\u0001\u00ad\u0001\u00ae\u0001\u00af\u0001\u00b0\u0001\u00b1\u0001\u00b2\u0001\u00b3\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010]\u001a\u00020'2\u0006\u0010^\u001a\u00020\tH\u0016J\u000e\u0010_\u001a\u00020'2\u0006\u0010^\u001a\u00020\tJ\u0010\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020cH\u0002J\b\u0010d\u001a\u00020aH\u0002J\b\u0010e\u001a\u00020aH\u0002J\b\u0010f\u001a\u00020aH\u0002J \u0010g\u001a\u00020\f2\u0006\u0010h\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0006\u0010i\u001a\u00020\fH\u0002J \u0010j\u001a\u00020\f2\u0006\u0010k\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0006\u0010i\u001a\u00020\fH\u0002J\u0006\u0010l\u001a\u00020VJ\b\u0010m\u001a\u00020)H\u0016J\u0010\u0010n\u001a\u00020a2\u0006\u0010o\u001a\u00020pH\u0016J\u0010\u0010q\u001a\u00020a2\u0006\u0010r\u001a\u00020sH\u0014J\u0018\u0010t\u001a\u00020a2\u0006\u0010u\u001a\u00020\t2\u0006\u0010v\u001a\u00020\tH\u0014J\u0010\u0010w\u001a\u00020a2\u0006\u0010J\u001a\u00020xH\u0016J\b\u0010y\u001a\u00020xH\u0016J\u0010\u0010z\u001a\u00020'2\u0006\u0010{\u001a\u00020|H\u0016J\b\u0010}\u001a\u00020aH\u0002J\u0010\u0010~\u001a\u00020a2\u0006\u0010\u007f\u001a\u00020'H\u0002J\u0007\u0010\u0080\u0001\u001a\u00020aJ\t\u0010\u0081\u0001\u001a\u00020aH\u0002J.\u0010\u0082\u0001\u001a\u00020a2\b\u0010\u0083\u0001\u001a\u00030\u0084\u00012\u0007\u0010\u0085\u0001\u001a\u00020\f2\u0007\u0010\u0086\u0001\u001a\u00020\f2\u0007\u0010\u0087\u0001\u001a\u00020'H\u0002J\u0013\u0010\u0088\u0001\u001a\u00020a2\b\u0010\u0089\u0001\u001a\u00030\u008a\u0001H\u0016J\u0015\u0010\u008b\u0001\u001a\u00020a2\n\u0010\u008c\u0001\u001a\u0005\u0018\u00010\u008d\u0001H\u0016J\u0012\u0010\u008e\u0001\u001a\u00020a2\u0007\u0010\u008f\u0001\u001a\u00020\tH\u0016J\u0015\u0010\u0090\u0001\u001a\u00020a2\n\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\u0012\u0010\u0093\u0001\u001a\u00020a2\u0007\u0010\u0094\u0001\u001a\u00020)H\u0016J\u0019\u0010\u0095\u0001\u001a\u00020a2\u0007\u0010\u0085\u0001\u001a\u00020\f2\u0007\u0010\u0086\u0001\u001a\u00020\fJ$\u0010\u0096\u0001\u001a\u00020\t2\u0007\u0010\u0097\u0001\u001a\u00020\t2\u0007\u0010\u0098\u0001\u001a\u00020\t2\u0007\u0010\u0099\u0001\u001a\u00020\tH\u0002J\u0010\u0010\u009a\u0001\u001a\u00020a2\u0007\u0010\u009b\u0001\u001a\u00020\u0000J3\u0010\u009a\u0001\u001a\u00020a2\u0007\u0010\u009c\u0001\u001a\u00020\f2\t\b\u0002\u0010\u0085\u0001\u001a\u00020\f2\t\b\u0002\u0010\u0086\u0001\u001a\u00020\f2\t\b\u0002\u0010\u009d\u0001\u001a\u00020)H\u0007J\u0011\u0010\u009e\u0001\u001a\u00020a2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001b\u0010\u009f\u0001\u001a\u0002012\u0007\u0010\u00a0\u0001\u001a\u00020\f2\u0007\u0010\u00a1\u0001\u001a\u00020\fH\u0002J$\u0010\u00a2\u0001\u001a\u0002012\u0007\u0010\u00a3\u0001\u001a\u00020\f2\u0007\u0010\u00a4\u0001\u001a\u00020\f2\u0007\u0010\u00a5\u0001\u001a\u00020'H\u0002JE\u0010\u00a6\u0001\u001a\u00020a2\u0007\u0010\u00a7\u0001\u001a\u00020\t2\u0006\u0010k\u001a\u00020\f2\u0007\u0010\u00a8\u0001\u001a\u00020\f2\u0007\u0010\u00a9\u0001\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0007\u0010\u00aa\u0001\u001a\u00020\tH\u0002R$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0018\u00010\u0013R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0018\u00010\u001bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u000e\u0010&\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010*\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000fR\u000e\u0010,\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010.\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u000e\u00100\u001a\u000201X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u00108\u001a\u00020\f2\u0006\u00107\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b9\u0010\u000f\"\u0004\b:\u0010\u0011R\u000e\u0010;\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010=\u001a\u00020\f2\u0006\u0010<\u001a\u00020\f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b>\u0010\u000f\"\u0004\b?\u0010\u0011R\u000e\u0010@\u001a\u00020'X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020-X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082.\u00a2\u0006\u0002\n\u0000R\u0013\u0010G\u001a\u0004\u0018\u0001018F\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u0010\u0010J\u001a\u0004\u0018\u00010KX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010N\u001a\u0004\u0018\u00010OX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bP\u0010Q\"\u0004\bR\u0010SR\u000e\u0010T\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010U\u001a\u00020VX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bW\u0010X\"\u0004\bY\u0010ZR\u0011\u0010[\u001a\u00020V8F\u00a2\u0006\u0006\u001a\u0004\b\\\u0010X\u00a8\u0006\u00b4\u0001"}, d2={"Lcom/avito/android/krop/ZoomableImageView;", "Landroid/widget/ImageView;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "<set-?>", "", "currentZoom", "getCurrentZoom", "()F", "setCurrentZoom", "(F)V", "delayedZoomVariables", "Lcom/avito/android/krop/ZoomableImageView$ZoomVariables;", "doubleTapListener", "Landroid/view/GestureDetector$OnDoubleTapListener;", "getDoubleTapListener", "()Landroid/view/GestureDetector$OnDoubleTapListener;", "setDoubleTapListener", "(Landroid/view/GestureDetector$OnDoubleTapListener;)V", "fling", "Lcom/avito/android/krop/ZoomableImageView$Fling;", "gestureDetector", "Landroid/view/GestureDetector;", "imageHeight", "getImageHeight", "imageMoveListener", "Lcom/avito/android/krop/ZoomableImageView$ImageMoveListener;", "getImageMoveListener", "()Lcom/avito/android/krop/ZoomableImageView$ImageMoveListener;", "setImageMoveListener", "(Lcom/avito/android/krop/ZoomableImageView$ImageMoveListener;)V", "imageRenderedAtLeastOnce", "", "imageScaleType", "Landroid/widget/ImageView$ScaleType;", "imageWidth", "getImageWidth", "imgMatrix", "Landroid/graphics/Matrix;", "isZoomed", "()Z", "lastMovePoint", "Landroid/graphics/PointF;", "matchViewSize", "Lcom/avito/android/krop/SizeF;", "matrix", "", "maxScale", "max", "maxZoom", "getMaxZoom", "setMaxZoom", "minScale", "min", "minZoom", "getMinZoom", "setMinZoom", "onDrawReady", "prevMatchViewSize", "prevMatrix", "prevViewSize", "realSize", "scaleDetector", "Landroid/view/ScaleGestureDetector;", "scrollPosition", "getScrollPosition", "()Landroid/graphics/PointF;", "state", "Lcom/avito/android/krop/ZoomableImageView$State;", "superMaxScale", "superMinScale", "userTouchListener", "Landroid/view/View$OnTouchListener;", "getUserTouchListener", "()Landroid/view/View$OnTouchListener;", "setUserTouchListener", "(Landroid/view/View$OnTouchListener;)V", "viewSize", "viewport", "Landroid/graphics/RectF;", "getViewport", "()Landroid/graphics/RectF;", "setViewport", "(Landroid/graphics/RectF;)V", "zoomedRect", "getZoomedRect", "canScrollHorizontally", "direction", "canScrollHorizontallyFroyo", "compatPostOnAnimation", "", "runnable", "Ljava/lang/Runnable;", "fitImageToView", "fixScaleTrans", "fixTrans", "getFixDragTrans", "delta", "contentSize", "getFixTrans", "trans", "getImageBounds", "getScaleType", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onDraw", "canvas", "Landroid/graphics/Canvas;", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "Landroid/os/Parcelable;", "onSaveInstanceState", "onTouchEvent", "event", "Landroid/view/MotionEvent;", "printMatrixInfo", "requestDisallowInterceptTouchEvent", "disallowIntercept", "resetZoom", "savePreviousImageValues", "scaleImage", "deltaScale", "", "focusX", "focusY", "stretchImageToSuper", "setImageBitmap", "bm", "Landroid/graphics/Bitmap;", "setImageDrawable", "drawable", "Landroid/graphics/drawable/Drawable;", "setImageResource", "resId", "setImageURI", "uri", "Landroid/net/Uri;", "setScaleType", "type", "setScrollPosition", "setViewSize", "mode", "size", "drawableWidth", "setZoom", "img", "scale", "scaleType", "sharedConstructing", "transformCoordBitmapToTouch", "bx", "by", "transformCoordTouchToBitmap", "x", "y", "clipToBitmap", "translateMatrixAfterRotate", "axis", "prevImageSize", "imageSize", "drawableSize", "CompatScroller", "DoubleTapZoom", "Fling", "GestureListener", "ImageMoveListener", "SavedState", "ScaleListener", "State", "ZoomVariables", "krop_release"})
public final class ZoomableImageView
extends ImageView {
    private Matrix imgMatrix;
    private Matrix prevMatrix;
    private State state;
    private float minScale;
    private float maxScale;
    private float superMinScale;
    private float superMaxScale;
    private float[] matrix;
    private Fling fling;
    private final PointF lastMovePoint;
    private ImageView.ScaleType imageScaleType;
    private boolean imageRenderedAtLeastOnce;
    private boolean onDrawReady;
    private ZoomVariables delayedZoomVariables;
    private SizeF realSize;
    private SizeF viewSize;
    private SizeF prevViewSize;
    private SizeF matchViewSize;
    private SizeF prevMatchViewSize;
    private ScaleGestureDetector scaleDetector;
    private GestureDetector gestureDetector;
    @Nullable
    private GestureDetector.OnDoubleTapListener doubleTapListener;
    @Nullable
    private View.OnTouchListener userTouchListener;
    @Nullable
    private ImageMoveListener imageMoveListener;
    @NotNull
    private RectF viewport;
    private float currentZoom;

    @Nullable
    public final GestureDetector.OnDoubleTapListener getDoubleTapListener() {
        return this.doubleTapListener;
    }

    public final void setDoubleTapListener(@Nullable GestureDetector.OnDoubleTapListener onDoubleTapListener) {
        this.doubleTapListener = onDoubleTapListener;
    }

    @Nullable
    public final View.OnTouchListener getUserTouchListener() {
        return this.userTouchListener;
    }

    public final void setUserTouchListener(@Nullable View.OnTouchListener onTouchListener) {
        this.userTouchListener = onTouchListener;
    }

    @Nullable
    public final ImageMoveListener getImageMoveListener() {
        return this.imageMoveListener;
    }

    public final void setImageMoveListener(@Nullable ImageMoveListener imageMoveListener) {
        this.imageMoveListener = imageMoveListener;
    }

    private final float getImageWidth() {
        return this.matchViewSize.getWidth() * this.currentZoom;
    }

    private final float getImageHeight() {
        return this.matchViewSize.getHeight() * this.currentZoom;
    }

    @NotNull
    public final RectF getViewport() {
        return this.viewport;
    }

    public final void setViewport(@NotNull RectF rectF) {
        Intrinsics.checkParameterIsNotNull((Object)rectF, (String)"<set-?>");
        this.viewport = rectF;
    }

    @Nullable
    public final PointF getScrollPosition() {
        Drawable drawable = this.getDrawable();
        if (drawable == null) {
            return null;
        }
        Drawable drawable2 = drawable;
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        PointF point = this.transformCoordTouchToBitmap(this.viewSize.getWidth() / (float)2, this.viewSize.getHeight() / (float)2, true);
        point.x /= (float)drawableWidth;
        point.y /= (float)drawableHeight;
        return point;
    }

    public final float getCurrentZoom() {
        return this.currentZoom;
    }

    private final void setCurrentZoom(float f) {
        this.currentZoom = f;
    }

    public final boolean isZoomed() {
        return this.currentZoom != 1.0f;
    }

    @NotNull
    public final RectF getZoomedRect() {
        ImageView.ScaleType scaleType = this.imageScaleType;
        if (scaleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageScaleType");
        }
        if (Intrinsics.areEqual((Object)scaleType, (Object)ImageView.ScaleType.FIT_XY)) {
            throw (Throwable)new UnsupportedOperationException("getZoomedRect() not supported with FIT_XY");
        }
        PointF topLeft = this.transformCoordTouchToBitmap(0.0f, 0.0f, true);
        PointF bottomRight = this.transformCoordTouchToBitmap(this.viewSize.getWidth(), this.viewSize.getHeight(), true);
        float w = this.getDrawable().getIntrinsicWidth();
        float h = this.getDrawable().getIntrinsicHeight();
        return new RectF(topLeft.x / w, topLeft.y / h, bottomRight.x / w, bottomRight.y / h);
    }

    public final float getMaxZoom() {
        return this.maxScale;
    }

    public final void setMaxZoom(float max) {
        this.maxScale = max;
        this.superMaxScale = 1.25f * this.maxScale;
    }

    public final float getMinZoom() {
        return this.minScale;
    }

    public final void setMinZoom(float min) {
        this.minScale = min;
        this.superMinScale = 0.75f * this.minScale;
    }

    private final void sharedConstructing(Context context) {
        super.setClickable(true);
        this.scaleDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleListener());
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureListener());
        this.imgMatrix = new Matrix();
        this.prevMatrix = new Matrix();
        this.matrix = new float[9];
        this.currentZoom = 1.0f;
        this.imageScaleType = ImageView.ScaleType.CENTER_CROP;
        this.minScale = 1.0f;
        this.maxScale = 5.0f;
        this.superMinScale = 0.75f * this.minScale;
        this.superMaxScale = 1.25f * this.maxScale;
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        this.setImageMatrix(matrix);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.state = State.NONE;
        this.onDrawReady = false;
    }

    public void setImageResource(int resId) {
        super.setImageResource(resId);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageBitmap(@NotNull Bitmap bm) {
        Intrinsics.checkParameterIsNotNull((Object)bm, (String)"bm");
        super.setImageBitmap(bm);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageDrawable(@Nullable Drawable drawable) {
        super.setImageDrawable(drawable);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setImageURI(@Nullable Uri uri) {
        super.setImageURI(uri);
        this.savePreviousImageValues();
        this.fitImageToView();
    }

    public void setScaleType(@NotNull ImageView.ScaleType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)ImageView.ScaleType.FIT_START) || Intrinsics.areEqual((Object)type, (Object)ImageView.ScaleType.FIT_END)) {
            throw (Throwable)new UnsupportedOperationException("ZoomableImageView does not support FIT_START or FIT_END");
        }
        if (Intrinsics.areEqual((Object)type, (Object)ImageView.ScaleType.MATRIX)) {
            super.setScaleType(ImageView.ScaleType.MATRIX);
        } else {
            this.imageScaleType = type;
            if (this.onDrawReady) {
                this.setZoom(this);
            }
        }
    }

    @NotNull
    public ImageView.ScaleType getScaleType() {
        ImageView.ScaleType scaleType = this.imageScaleType;
        if (scaleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageScaleType");
        }
        return scaleType;
    }

    private final void savePreviousImageValues() {
        if (this.viewSize.getHeight() != 0.0f && this.viewSize.getWidth() != 0.0f) {
            Matrix matrix = this.imgMatrix;
            if (matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            matrix.getValues(this.matrix);
            Matrix matrix2 = this.prevMatrix;
            if (matrix2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prevMatrix");
            }
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            matrix2.setValues(this.matrix);
            this.prevMatchViewSize.setHeight(this.matchViewSize.getHeight());
            this.prevMatchViewSize.setWidth(this.matchViewSize.getWidth());
            this.prevViewSize.setHeight(this.viewSize.getHeight());
            this.prevViewSize.setWidth(this.viewSize.getWidth());
        }
    }

    @NotNull
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        Parcelable parcelable = superState;
        Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"superState");
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        return (Parcelable)new SavedState(parcelable, this.currentZoom, this.matrix, this.matchViewSize, this.viewSize, this.imageRenderedAtLeastOnce);
    }

    public void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        if (state instanceof SavedState) {
            super.onRestoreInstanceState(((SavedState)state).getSuperState());
            this.currentZoom = ((SavedState)state).getCurrentZoom();
            this.matrix = ((SavedState)state).getMatrix();
            this.prevMatchViewSize = ((SavedState)state).getPrevMatchViewSize();
            this.prevViewSize = ((SavedState)state).getPrevViewSize();
            this.imageRenderedAtLeastOnce = ((SavedState)state).getImageRenderedAtLeastOnce();
            Matrix matrix = this.prevMatrix;
            if (matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prevMatrix");
            }
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            matrix.setValues(this.matrix);
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.onDrawReady = true;
        this.imageRenderedAtLeastOnce = true;
        ZoomVariables zoomVariables = this.delayedZoomVariables;
        if (zoomVariables != null) {
            ZoomVariables zoomVariables2;
            ZoomVariables it = zoomVariables2 = zoomVariables;
            this.setZoom(it.getScale(), it.getFocusX(), it.getFocusY(), it.getScaleType());
            this.delayedZoomVariables = null;
        }
        super.onDraw(canvas);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkParameterIsNotNull((Object)newConfig, (String)"newConfig");
        super.onConfigurationChanged(newConfig);
        this.savePreviousImageValues();
    }

    public final void resetZoom() {
        this.currentZoom = 1.0f;
        this.fitImageToView();
    }

    @JvmOverloads
    public final void setZoom(float scale, float focusX, float focusY, @NotNull ImageView.ScaleType scaleType) {
        Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
        if (!this.onDrawReady) {
            this.delayedZoomVariables = new ZoomVariables(scale, focusX, focusY, scaleType);
            return;
        }
        ImageView.ScaleType scaleType2 = this.imageScaleType;
        if (scaleType2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageScaleType");
        }
        if (Intrinsics.areEqual((Object)scaleType, (Object)scaleType2) ^ true) {
            this.setScaleType(scaleType);
        }
        this.resetZoom();
        this.scaleImage(scale, this.viewSize.getWidth() / (float)2, this.viewSize.getHeight() / (float)2, true);
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        this.matrix[2] = -(focusX * this.getImageWidth() - this.viewSize.getWidth() / (float)2);
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        this.matrix[5] = -(focusY * this.getImageHeight() - this.viewSize.getHeight() / (float)2);
        Matrix matrix2 = this.imgMatrix;
        if (matrix2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix2.setValues(this.matrix);
        this.fixTrans();
        Matrix matrix3 = this.imgMatrix;
        if (matrix3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        this.setImageMatrix(matrix3);
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void setZoom$default(ZoomableImageView zoomableImageView, float f, float f2, float f3, ImageView.ScaleType scaleType, int n, Object object) {
        if ((n & 2) != 0) {
            f2 = 0.5f;
        }
        if ((n & 4) != 0) {
            f3 = 0.5f;
        }
        if ((n & 8) != 0) {
            ImageView.ScaleType scaleType2 = zoomableImageView.imageScaleType;
            if (scaleType2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imageScaleType");
            }
            scaleType = scaleType2;
        }
        zoomableImageView.setZoom(f, f2, f3, scaleType);
    }

    @JvmOverloads
    public final void setZoom(float scale, float focusX, float focusY) {
        ZoomableImageView.setZoom$default(this, scale, focusX, focusY, null, 8, null);
    }

    @JvmOverloads
    public final void setZoom(float scale, float focusX) {
        ZoomableImageView.setZoom$default(this, scale, focusX, 0.0f, null, 12, null);
    }

    @JvmOverloads
    public final void setZoom(float scale) {
        ZoomableImageView.setZoom$default(this, scale, 0.0f, 0.0f, null, 14, null);
    }

    public final void setZoom(@NotNull ZoomableImageView img) {
        block0: {
            PointF pointF;
            Intrinsics.checkParameterIsNotNull((Object)((Object)img), (String)"img");
            PointF pointF2 = img.getScrollPosition();
            if (pointF2 == null) break block0;
            PointF center = pointF = pointF2;
            this.setZoom(img.currentZoom, center.x, center.y, img.getScaleType());
        }
    }

    public final void setScrollPosition(float focusX, float focusY) {
        ZoomableImageView.setZoom$default(this, this.currentZoom, focusX, focusY, null, 8, null);
    }

    private final void fixTrans() {
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float transX = this.matrix[2];
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float transY = this.matrix[5];
        float fixTransX = this.getFixTrans(transX, this.viewSize.getWidth(), this.getImageWidth());
        float fixTransY = this.getFixTrans(transY, this.viewSize.getHeight(), this.getImageHeight());
        if (fixTransX != 0.0f || fixTransY != 0.0f) {
            Matrix matrix2 = this.imgMatrix;
            if (matrix2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            matrix2.postTranslate(fixTransX, fixTransY);
        }
    }

    private final void fixScaleTrans() {
        this.fixTrans();
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        if (this.getImageWidth() < this.viewSize.getWidth()) {
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[2] = (this.viewSize.getWidth() - this.getImageWidth()) / (float)2;
        }
        if (this.getImageHeight() < this.viewSize.getHeight()) {
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[5] = (this.viewSize.getHeight() - this.getImageHeight()) / (float)2;
        }
        Matrix matrix2 = this.imgMatrix;
        if (matrix2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix2.setValues(this.matrix);
    }

    private final float getFixTrans(float trans, float viewSize, float contentSize) {
        float maxTrans;
        float minTrans;
        if (contentSize <= viewSize) {
            minTrans = 0.0f;
            maxTrans = viewSize - contentSize;
        } else {
            minTrans = viewSize - contentSize;
            maxTrans = 0.0f;
        }
        if (trans < minTrans) {
            return -trans + minTrans;
        }
        if (trans > maxTrans) {
            return -trans + maxTrans;
        }
        return 0.0f;
    }

    private final float getFixDragTrans(float delta, float viewSize, float contentSize) {
        if (contentSize <= viewSize) {
            return 0.0f;
        }
        return delta;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            this.setMeasuredDimension(0, 0);
            return;
        }
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        this.realSize.setWidth(this.setViewSize(widthMode, widthSize, drawableWidth));
        this.realSize.setHeight(this.setViewSize(heightMode, heightSize, drawableHeight));
        if (this.viewport.isEmpty()) {
            RectF rectF;
            RectF $receiver = rectF = this.viewport;
            $receiver.left = 0.0f;
            $receiver.top = 0.0f;
            $receiver.right = this.realSize.getWidth();
            $receiver.bottom = this.realSize.getHeight();
        }
        this.viewSize.setWidth(this.viewport.width());
        this.viewSize.setHeight(this.viewport.height());
        RectF rect = this.realSize.middle(this.viewSize);
        this.setMeasuredDimension(this.realSize.getWidthInt(), this.realSize.getHeightInt());
        this.setPadding((int)rect.left, (int)rect.top, (int)rect.right, (int)rect.bottom);
        this.fitImageToView();
    }

    private final void fitImageToView() {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            return;
        }
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        float scaleX = this.viewSize.getWidth() / (float)drawableWidth;
        float scaleY = this.viewSize.getHeight() / (float)drawableHeight;
        ImageView.ScaleType scaleType = this.imageScaleType;
        if (scaleType == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imageScaleType");
        }
        switch (ZoomableImageView$WhenMappings.$EnumSwitchMapping$0[scaleType.ordinal()]) {
            case 1: {
                scaleX = scaleY = 1.0f;
                break;
            }
            case 2: {
                scaleX = scaleY = Math.max(scaleX, scaleY);
                break;
            }
            case 3: {
                scaleX = scaleY = Math.min(1.0f, Math.min(scaleX, scaleY));
                scaleX = scaleY = Math.min(scaleX, scaleY);
                break;
            }
            case 4: {
                scaleX = scaleY = Math.min(scaleX, scaleY);
                break;
            }
            case 5: {
                break;
            }
            default: {
                throw (Throwable)new UnsupportedOperationException("ZoomableImageView does not support FIT_START or FIT_END");
            }
        }
        float redundantXSpace = this.viewSize.getWidth() - scaleX * (float)drawableWidth;
        float redundantYSpace = this.viewSize.getHeight() - scaleY * (float)drawableHeight;
        this.matchViewSize.setWidth(this.viewSize.getWidth() - redundantXSpace);
        this.matchViewSize.setHeight(this.viewSize.getHeight() - redundantYSpace);
        if (!this.isZoomed() && !this.imageRenderedAtLeastOnce) {
            Matrix matrix = this.imgMatrix;
            if (matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            matrix.setScale(scaleX, scaleY);
            Matrix matrix2 = this.imgMatrix;
            if (matrix2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            matrix2.postTranslate(redundantXSpace / (float)2, redundantYSpace / (float)2);
            this.currentZoom = 1.0f;
        } else {
            if (this.prevMatchViewSize.getWidth() == 0.0f || this.prevMatchViewSize.getHeight() == 0.0f) {
                this.savePreviousImageValues();
            }
            Matrix matrix = this.prevMatrix;
            if (matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"prevMatrix");
            }
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            matrix.getValues(this.matrix);
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[0] = this.matchViewSize.getWidth() / (float)drawableWidth * this.currentZoom;
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[4] = this.matchViewSize.getHeight() / (float)drawableHeight * this.currentZoom;
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            float transX = this.matrix[2];
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            float transY = this.matrix[5];
            float prevActualWidth = this.prevMatchViewSize.getWidth() * this.currentZoom;
            float actualWidth = this.getImageWidth();
            this.translateMatrixAfterRotate(2, transX, prevActualWidth, actualWidth, this.prevViewSize.getWidth(), this.viewSize.getWidth(), drawableWidth);
            float prevActualHeight = this.prevMatchViewSize.getHeight() * this.currentZoom;
            float actualHeight = this.getImageHeight();
            this.translateMatrixAfterRotate(5, transY, prevActualHeight, actualHeight, this.prevViewSize.getHeight(), this.viewSize.getHeight(), drawableHeight);
            Matrix matrix3 = this.imgMatrix;
            if (matrix3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            matrix3.setValues(this.matrix);
        }
        this.fixTrans();
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        this.setImageMatrix(matrix);
    }

    private final int setViewSize(int mode, int size, int drawableWidth) {
        int viewSize;
        switch (mode) {
            case 0x40000000: {
                viewSize = size;
                break;
            }
            case -2147483648: {
                viewSize = Math.min(drawableWidth, size);
                break;
            }
            case 0: {
                viewSize = drawableWidth;
                break;
            }
            default: {
                viewSize = size;
            }
        }
        return viewSize;
    }

    private final void translateMatrixAfterRotate(int axis, float trans, float prevImageSize, float imageSize, float prevViewSize, float viewSize, int drawableSize) {
        if (imageSize < viewSize) {
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            float f = drawableSize;
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[axis] = (viewSize - f * this.matrix[0]) * 0.5f;
        } else if (trans > 0.0f) {
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[axis] = -((imageSize - viewSize) / (float)2);
        } else {
            float percentage = (Math.abs(trans) + prevViewSize / (float)2) / prevImageSize;
            if (this.matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
            }
            this.matrix[axis] = -(percentage * imageSize - viewSize / (float)2);
        }
    }

    public final boolean canScrollHorizontallyFroyo(int direction) {
        return this.canScrollHorizontally(direction);
    }

    public boolean canScrollHorizontally(int direction) {
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float x = this.matrix[2];
        if (this.getImageWidth() < this.viewSize.getWidth()) {
            return false;
        }
        if (x >= (float)-1 && direction < 0) {
            return false;
        }
        return !(Math.abs(x) + this.viewSize.getWidth() + 1.0f >= this.getImageWidth()) || direction <= 0;
    }

    @NotNull
    public final RectF getImageBounds() {
        Drawable drawable = this.getDrawable();
        if (drawable == null || drawable.getIntrinsicWidth() == 0 || drawable.getIntrinsicHeight() == 0) {
            return new RectF();
        }
        int drawableWidth = drawable.getIntrinsicWidth();
        int drawableHeight = drawable.getIntrinsicHeight();
        RectF realImageBounds = new RectF();
        RectF imageBounds = new RectF();
        realImageBounds.set(0.0f, 0.0f, (float)drawableWidth, (float)drawableHeight);
        this.getImageMatrix().mapRect(imageBounds, realImageBounds);
        return new RectF(imageBounds);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            event.offsetLocation(-this.viewport.left, -this.viewport.top);
            ScaleGestureDetector scaleGestureDetector = this.scaleDetector;
            if (scaleGestureDetector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scaleDetector");
            }
            scaleGestureDetector.onTouchEvent(event);
            GestureDetector gestureDetector = this.gestureDetector;
            if (gestureDetector == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"gestureDetector");
            }
            gestureDetector.onTouchEvent(event);
            PointF curr = new PointF(event.getX(), event.getY());
            if (Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)State.NONE)) || Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)State.DRAG)) || Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)State.FLING))) {
                switch (event.getAction()) {
                    case 0: {
                        this.requestDisallowInterceptTouchEvent(true);
                        this.lastMovePoint.set(curr);
                        Fling fling = this.fling;
                        if (fling != null) {
                            fling.cancelFling();
                        }
                        this.state = State.DRAG;
                        break;
                    }
                    case 2: {
                        if (!Intrinsics.areEqual((Object)((Object)this.state), (Object)((Object)State.DRAG))) break;
                        float deltaX = curr.x - this.lastMovePoint.x;
                        float deltaY = curr.y - this.lastMovePoint.y;
                        float fixTransX = this.getFixDragTrans(deltaX, this.viewSize.getWidth(), this.getImageWidth());
                        float fixTransY = this.getFixDragTrans(deltaY, this.viewSize.getHeight(), this.getImageHeight());
                        Matrix matrix = this.imgMatrix;
                        if (matrix == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
                        }
                        matrix.postTranslate(fixTransX, fixTransY);
                        this.fixTrans();
                        this.lastMovePoint.set(curr.x, curr.y);
                        break;
                    }
                    case 1: 
                    case 6: {
                        this.state = State.NONE;
                        this.requestDisallowInterceptTouchEvent(false);
                    }
                }
            }
            Matrix matrix = this.imgMatrix;
            if (matrix == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
            }
            this.setImageMatrix(matrix);
            View.OnTouchListener onTouchListener = this.userTouchListener;
            if (onTouchListener != null) {
                onTouchListener.onTouch((View)this, event);
            }
            ImageMoveListener imageMoveListener = this.imageMoveListener;
            if (imageMoveListener == null) break block12;
            imageMoveListener.onMove();
        }
        return true;
    }

    private final void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        block0: {
            ViewParent viewParent = this.getParent();
            if (viewParent == null) break block0;
            viewParent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private final void scaleImage(double deltaScale, float focusX, float focusY, boolean stretchImageToSuper) {
        float upperScale;
        float lowerScale;
        double scale = deltaScale;
        if (stretchImageToSuper) {
            lowerScale = this.superMinScale;
            upperScale = this.superMaxScale;
        } else {
            lowerScale = this.minScale;
            upperScale = this.maxScale;
        }
        float origScale = this.currentZoom;
        this.currentZoom *= (float)scale;
        if (this.currentZoom > upperScale) {
            this.currentZoom = upperScale;
            scale = upperScale / origScale;
        } else if (this.currentZoom < lowerScale) {
            this.currentZoom = lowerScale;
            scale = lowerScale / origScale;
        }
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        matrix.postScale((float)scale, (float)scale, focusX, focusY);
        this.fixScaleTrans();
    }

    private final PointF transformCoordTouchToBitmap(float x, float y, boolean clipToBitmap) {
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float transX = this.matrix[2];
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float transY = this.matrix[5];
        float finalX = (x - transX) * origW / this.getImageWidth();
        float finalY = (y - transY) * origH / this.getImageHeight();
        if (clipToBitmap) {
            finalX = Math.min(Math.max(finalX, 0.0f), origW);
            finalY = Math.min(Math.max(finalY, 0.0f), origH);
        }
        return new PointF(finalX, finalY);
    }

    private final PointF transformCoordBitmapToTouch(float bx, float by) {
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        matrix.getValues(this.matrix);
        float origW = this.getDrawable().getIntrinsicWidth();
        float origH = this.getDrawable().getIntrinsicHeight();
        float px = bx / origW;
        float py = by / origH;
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float finalX = this.matrix[2] + this.getImageWidth() * px;
        if (this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        float finalY = this.matrix[5] + this.getImageHeight() * py;
        return new PointF(finalX, finalY);
    }

    private final void compatPostOnAnimation(Runnable runnable) {
        if (Build.VERSION.SDK_INT >= 16) {
            this.postOnAnimation(runnable);
        } else {
            this.postDelayed(runnable, 16);
        }
    }

    private final void printMatrixInfo() {
        float[] n = new float[9];
        Matrix matrix = this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        matrix.getValues(n);
    }

    public ZoomableImageView(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context);
        this.lastMovePoint = new PointF();
        this.realSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.matchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevMatchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewport = new RectF();
        this.sharedConstructing(context);
    }

    public ZoomableImageView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.lastMovePoint = new PointF();
        this.realSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.matchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevMatchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewport = new RectF();
        this.sharedConstructing(context);
    }

    public ZoomableImageView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyle) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)attrs, (String)"attrs");
        super(context, attrs, defStyle);
        this.lastMovePoint = new PointF();
        this.realSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.matchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.prevMatchViewSize = new SizeF(0.0f, 0.0f, 3, null);
        this.viewport = new RectF();
        this.sharedConstructing(context);
    }

    public static final /* synthetic */ float access$getCurrentZoom$p(ZoomableImageView $this) {
        return $this.currentZoom;
    }

    public static final /* synthetic */ void access$setCurrentZoom$p(ZoomableImageView $this, float f) {
        $this.currentZoom = f;
    }

    public static final /* synthetic */ void access$setMinScale$p(ZoomableImageView $this, float f) {
        $this.minScale = f;
    }

    public static final /* synthetic */ void access$setMaxScale$p(ZoomableImageView $this, float f) {
        $this.maxScale = f;
    }

    public static final /* synthetic */ void access$setViewSize$p(ZoomableImageView $this, @NotNull SizeF sizeF) {
        $this.viewSize = sizeF;
    }

    @NotNull
    public static final /* synthetic */ Matrix access$getImgMatrix$p(ZoomableImageView $this) {
        Matrix matrix = $this.imgMatrix;
        if (matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"imgMatrix");
        }
        return matrix;
    }

    public static final /* synthetic */ void access$setImgMatrix$p(ZoomableImageView $this, @NotNull Matrix matrix) {
        $this.imgMatrix = matrix;
    }

    @NotNull
    public static final /* synthetic */ float[] access$getMatrix$p(ZoomableImageView $this) {
        if ($this.matrix == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"matrix");
        }
        return $this.matrix;
    }

    public static final /* synthetic */ void access$setMatrix$p(ZoomableImageView $this, @NotNull float[] fArray) {
        $this.matrix = fArray;
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/avito/android/krop/ZoomableImageView$State;", "", "(Ljava/lang/String;I)V", "NONE", "DRAG", "ZOOM", "FLING", "ANIMATE_ZOOM", "krop_release"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State NONE;
        public static final /* enum */ State DRAG;
        public static final /* enum */ State ZOOM;
        public static final /* enum */ State FLING;
        public static final /* enum */ State ANIMATE_ZOOM;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[5];
            State[] stateArray2 = stateArray;
            stateArray[0] = NONE = new State();
            stateArray[1] = DRAG = new State();
            stateArray[2] = ZOOM = new State();
            stateArray[3] = FLING = new State();
            stateArray[4] = ANIMATE_ZOOM = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016J(\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u0006H\u0016J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/avito/android/krop/ZoomableImageView$GestureListener;", "Landroid/view/GestureDetector$SimpleOnGestureListener;", "(Lcom/avito/android/krop/ZoomableImageView;)V", "onDoubleTap", "", "event", "Landroid/view/MotionEvent;", "onDoubleTapEvent", "e", "onFling", "e1", "e2", "velocityX", "", "velocityY", "onLongPress", "", "onSingleTapConfirmed", "krop_release"})
    private final class GestureListener
    extends GestureDetector.SimpleOnGestureListener {
        public boolean onSingleTapConfirmed(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GestureDetector.OnDoubleTapListener onDoubleTapListener = ZoomableImageView.this.getDoubleTapListener();
            if (onDoubleTapListener != null) {
                GestureDetector.OnDoubleTapListener onDoubleTapListener2;
                GestureDetector.OnDoubleTapListener it = onDoubleTapListener2 = onDoubleTapListener;
                return it.onSingleTapConfirmed(e);
            }
            return ZoomableImageView.this.performClick();
        }

        public void onLongPress(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            ZoomableImageView.this.performLongClick();
        }

        public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
            block1: {
                Fling fling;
                Intrinsics.checkParameterIsNotNull((Object)e1, (String)"e1");
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e2");
                Fling fling2 = ZoomableImageView.this.fling;
                if (fling2 != null) {
                    fling2.cancelFling();
                }
                ZoomableImageView.this.fling = new Fling((int)velocityX, (int)velocityY);
                Fling fling3 = ZoomableImageView.this.fling;
                if (fling3 == null) break block1;
                Fling it = fling = fling3;
                ZoomableImageView.this.compatPostOnAnimation(it);
            }
            return super.onFling(e1, e2, velocityX, velocityY);
        }

        public boolean onDoubleTap(@NotNull MotionEvent event) {
            boolean consumed;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            GestureDetector.OnDoubleTapListener onDoubleTapListener = ZoomableImageView.this.getDoubleTapListener();
            boolean bl = consumed = onDoubleTapListener != null ? onDoubleTapListener.onDoubleTap(event) : false;
            if (Intrinsics.areEqual((Object)((Object)ZoomableImageView.this.state), (Object)((Object)State.NONE))) {
                float targetZoom = ZoomableImageView.this.getCurrentZoom() == ZoomableImageView.this.minScale ? ZoomableImageView.this.maxScale : ZoomableImageView.this.minScale;
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, event.getX(), event.getY(), false);
                ZoomableImageView.this.compatPostOnAnimation(doubleTap);
                consumed = true;
            }
            return consumed;
        }

        public boolean onDoubleTapEvent(@NotNull MotionEvent e) {
            Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
            GestureDetector.OnDoubleTapListener onDoubleTapListener = ZoomableImageView.this.getDoubleTapListener();
            return onDoubleTapListener != null ? onDoubleTapListener.onDoubleTapEvent(e) : false;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/avito/android/krop/ZoomableImageView$ImageMoveListener;", "", "onMove", "", "krop_release"})
    public static interface ImageMoveListener {
        public void onMove();
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/avito/android/krop/ZoomableImageView$ScaleListener;", "Landroid/view/ScaleGestureDetector$SimpleOnScaleGestureListener;", "(Lcom/avito/android/krop/ZoomableImageView;)V", "onScale", "", "detector", "Landroid/view/ScaleGestureDetector;", "onScaleBegin", "onScaleEnd", "", "krop_release"})
    private final class ScaleListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScaleBegin(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            ZoomableImageView.this.state = State.ZOOM;
            return true;
        }

        public boolean onScale(@NotNull ScaleGestureDetector detector) {
            block0: {
                Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
                ZoomableImageView.this.scaleImage(detector.getScaleFactor(), detector.getFocusX(), detector.getFocusY(), true);
                ImageMoveListener imageMoveListener = ZoomableImageView.this.getImageMoveListener();
                if (imageMoveListener == null) break block0;
                imageMoveListener.onMove();
            }
            return true;
        }

        public void onScaleEnd(@NotNull ScaleGestureDetector detector) {
            Intrinsics.checkParameterIsNotNull((Object)detector, (String)"detector");
            super.onScaleEnd(detector);
            ZoomableImageView.this.state = State.NONE;
            boolean animateToZoomBoundary = false;
            float targetZoom = ZoomableImageView.this.getCurrentZoom();
            if (ZoomableImageView.this.getCurrentZoom() > ZoomableImageView.this.maxScale) {
                targetZoom = ZoomableImageView.this.maxScale;
                animateToZoomBoundary = true;
            } else if (ZoomableImageView.this.getCurrentZoom() < ZoomableImageView.this.minScale) {
                targetZoom = ZoomableImageView.this.minScale;
                animateToZoomBoundary = true;
            }
            if (animateToZoomBoundary) {
                DoubleTapZoom doubleTap = new DoubleTapZoom(targetZoom, ZoomableImageView.this.viewSize.getWidth() / (float)2, ZoomableImageView.this.viewSize.getHeight() / (float)2, true);
                ZoomableImageView.this.compatPostOnAnimation(doubleTap);
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\b\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/avito/android/krop/ZoomableImageView$DoubleTapZoom;", "Ljava/lang/Runnable;", "targetZoom", "", "focusX", "focusY", "stretchImageToSuper", "", "(Lcom/avito/android/krop/ZoomableImageView;FFFZ)V", "ZOOM_TIME", "bitmapX", "bitmapY", "endTouch", "Landroid/graphics/PointF;", "interpolator", "Landroid/view/animation/AccelerateDecelerateInterpolator;", "startTime", "", "startTouch", "startZoom", "calculateDeltaScale", "", "t", "interpolate", "run", "", "translateImageToCenterTouchPosition", "krop_release"})
    private final class DoubleTapZoom
    implements Runnable {
        private final float ZOOM_TIME = 300.0f;
        private final long startTime;
        private final float startZoom;
        private final float bitmapX;
        private final float bitmapY;
        private final AccelerateDecelerateInterpolator interpolator;
        private final PointF startTouch;
        private final PointF endTouch;
        private final float targetZoom;
        private final boolean stretchImageToSuper;

        @Override
        public void run() {
            float t = this.interpolate();
            double deltaScale = this.calculateDeltaScale(t);
            ZoomableImageView.this.scaleImage(deltaScale, this.bitmapX, this.bitmapY, this.stretchImageToSuper);
            this.translateImageToCenterTouchPosition(t);
            ZoomableImageView.this.fixScaleTrans();
            ZoomableImageView.this.setImageMatrix(ZoomableImageView.access$getImgMatrix$p(ZoomableImageView.this));
            ImageMoveListener imageMoveListener = ZoomableImageView.this.getImageMoveListener();
            if (imageMoveListener != null) {
                imageMoveListener.onMove();
            }
            if (t < 1.0f) {
                ZoomableImageView.this.compatPostOnAnimation(this);
            } else {
                ZoomableImageView.this.state = State.NONE;
            }
        }

        private final void translateImageToCenterTouchPosition(float t) {
            float targetX = this.startTouch.x + t * (this.endTouch.x - this.startTouch.x);
            float targetY = this.startTouch.y + t * (this.endTouch.y - this.startTouch.y);
            PointF curr = ZoomableImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            ZoomableImageView.access$getImgMatrix$p(ZoomableImageView.this).postTranslate(targetX - curr.x, targetY - curr.y);
        }

        private final float interpolate() {
            long currTime = System.currentTimeMillis();
            float elapsed = (float)(currTime - this.startTime) / this.ZOOM_TIME;
            elapsed = Math.min(1.0f, elapsed);
            return this.interpolator.getInterpolation(elapsed);
        }

        private final double calculateDeltaScale(float t) {
            double zoom = this.startZoom + t * (this.targetZoom - this.startZoom);
            return zoom / (double)ZoomableImageView.this.getCurrentZoom();
        }

        public DoubleTapZoom(float targetZoom, float focusX, float focusY, boolean stretchImageToSuper) {
            this.targetZoom = targetZoom;
            this.stretchImageToSuper = stretchImageToSuper;
            this.ZOOM_TIME = 300.0f;
            this.interpolator = new AccelerateDecelerateInterpolator();
            ZoomableImageView.this.state = State.ANIMATE_ZOOM;
            this.startTime = System.currentTimeMillis();
            this.startZoom = ZoomableImageView.this.getCurrentZoom();
            PointF bitmapPoint = ZoomableImageView.this.transformCoordTouchToBitmap(focusX, focusY, false);
            this.bitmapX = bitmapPoint.x;
            this.bitmapY = bitmapPoint.y;
            this.startTouch = ZoomableImageView.this.transformCoordBitmapToTouch(this.bitmapX, this.bitmapY);
            this.endTouch = new PointF(ZoomableImageView.this.viewSize.getWidth() / (float)2, ZoomableImageView.this.viewSize.getHeight() / (float)2);
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0016H\u0016R\u001a\u0010\u0006\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR \u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/avito/android/krop/ZoomableImageView$Fling;", "Ljava/lang/Runnable;", "velocityX", "", "velocityY", "(Lcom/avito/android/krop/ZoomableImageView;II)V", "currX", "getCurrX$krop_release", "()I", "setCurrX$krop_release", "(I)V", "currY", "getCurrY$krop_release", "setCurrY$krop_release", "scroller", "Lcom/avito/android/krop/ZoomableImageView$CompatScroller;", "Lcom/avito/android/krop/ZoomableImageView;", "getScroller$krop_release", "()Lcom/avito/android/krop/ZoomableImageView$CompatScroller;", "setScroller$krop_release", "(Lcom/avito/android/krop/ZoomableImageView$CompatScroller;)V", "cancelFling", "", "run", "krop_release"})
    private final class Fling
    implements Runnable {
        @Nullable
        private CompatScroller scroller;
        private int currX;
        private int currY;

        @Nullable
        public final CompatScroller getScroller$krop_release() {
            return this.scroller;
        }

        public final void setScroller$krop_release(@Nullable CompatScroller compatScroller) {
            this.scroller = compatScroller;
        }

        public final int getCurrX$krop_release() {
            return this.currX;
        }

        public final void setCurrX$krop_release(int n) {
            this.currX = n;
        }

        public final int getCurrY$krop_release() {
            return this.currY;
        }

        public final void setCurrY$krop_release(int n) {
            this.currY = n;
        }

        public final void cancelFling() {
            block1: {
                if (this.scroller == null) break block1;
                ZoomableImageView.this.state = State.NONE;
                CompatScroller compatScroller = this.scroller;
                if (compatScroller != null) {
                    compatScroller.forceFinished(true);
                }
            }
        }

        @Override
        public void run() {
            block2: {
                CompatScroller compatScroller;
                CompatScroller scroller;
                ImageMoveListener imageMoveListener = ZoomableImageView.this.getImageMoveListener();
                if (imageMoveListener != null) {
                    imageMoveListener.onMove();
                }
                CompatScroller compatScroller2 = this.scroller;
                if (compatScroller2 != null ? compatScroller2.isFinished() : false) {
                    this.scroller = null;
                    return;
                }
                CompatScroller compatScroller3 = this.scroller;
                if (compatScroller3 == null || !(scroller = (compatScroller = compatScroller3)).computeScrollOffset()) break block2;
                int newX = scroller.getCurrX();
                int newY = scroller.getCurrY();
                int transX = newX - this.currX;
                int transY = newY - this.currY;
                this.currX = newX;
                this.currY = newY;
                ZoomableImageView.access$getImgMatrix$p(ZoomableImageView.this).postTranslate((float)transX, (float)transY);
                ZoomableImageView.this.fixTrans();
                ZoomableImageView.this.setImageMatrix(ZoomableImageView.access$getImgMatrix$p(ZoomableImageView.this));
                ZoomableImageView.this.compatPostOnAnimation(this);
            }
        }

        public Fling(int velocityX, int velocityY) {
            int maxY;
            int minY;
            int maxX;
            int minX;
            ZoomableImageView.this.state = State.FLING;
            Context context = ZoomableImageView.this.getContext();
            Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
            this.scroller = new CompatScroller(context);
            ZoomableImageView.access$getImgMatrix$p(ZoomableImageView.this).getValues(ZoomableImageView.access$getMatrix$p(ZoomableImageView.this));
            int startX = (int)ZoomableImageView.access$getMatrix$p(ZoomableImageView.this)[2];
            int startY = (int)ZoomableImageView.access$getMatrix$p(ZoomableImageView.this)[5];
            if (ZoomableImageView.this.getImageWidth() > ZoomableImageView.this.viewSize.getWidth()) {
                minX = (int)(ZoomableImageView.this.viewSize.getWidth() - ZoomableImageView.this.getImageWidth());
                maxX = 0;
            } else {
                minX = maxX = startX;
            }
            if (ZoomableImageView.this.getImageHeight() > ZoomableImageView.this.viewSize.getHeight()) {
                minY = (int)(ZoomableImageView.this.viewSize.getHeight() - ZoomableImageView.this.getImageHeight());
                maxY = 0;
            } else {
                minY = maxY = startY;
            }
            CompatScroller compatScroller = this.scroller;
            if (compatScroller != null) {
                compatScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            }
            this.currX = startX;
            this.currY = startY;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0083\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u001e\u001a\u00020\fJF\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u0006J\u000e\u0010)\u001a\u00020 2\u0006\u0010*\u001a\u00020\fR\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\rR\u001a\u0010\u000e\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\r\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006+"}, d2={"Lcom/avito/android/krop/ZoomableImageView$CompatScroller;", "", "context", "Landroid/content/Context;", "(Lcom/avito/android/krop/ZoomableImageView;Landroid/content/Context;)V", "currX", "", "getCurrX", "()I", "currY", "getCurrY", "isFinished", "", "()Z", "isPreGingerbread", "isPreGingerbread$krop_release", "setPreGingerbread$krop_release", "(Z)V", "overScroller", "Landroid/widget/OverScroller;", "getOverScroller$krop_release", "()Landroid/widget/OverScroller;", "setOverScroller$krop_release", "(Landroid/widget/OverScroller;)V", "scroller", "Landroid/widget/Scroller;", "getScroller$krop_release", "()Landroid/widget/Scroller;", "setScroller$krop_release", "(Landroid/widget/Scroller;)V", "computeScrollOffset", "fling", "", "startX", "startY", "velocityX", "velocityY", "minX", "maxX", "minY", "maxY", "forceFinished", "finished", "krop_release"})
    @TargetApi(value=9)
    private final class CompatScroller {
        @NotNull
        public Scroller scroller;
        @NotNull
        public OverScroller overScroller;
        private boolean isPreGingerbread;

        @NotNull
        public final Scroller getScroller$krop_release() {
            Scroller scroller = this.scroller;
            if (scroller == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
            }
            return scroller;
        }

        public final void setScroller$krop_release(@NotNull Scroller scroller) {
            Intrinsics.checkParameterIsNotNull((Object)scroller, (String)"<set-?>");
            this.scroller = scroller;
        }

        @NotNull
        public final OverScroller getOverScroller$krop_release() {
            OverScroller overScroller = this.overScroller;
            if (overScroller == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
            }
            return overScroller;
        }

        public final void setOverScroller$krop_release(@NotNull OverScroller overScroller) {
            Intrinsics.checkParameterIsNotNull((Object)overScroller, (String)"<set-?>");
            this.overScroller = overScroller;
        }

        public final boolean isPreGingerbread$krop_release() {
            return this.isPreGingerbread;
        }

        public final void setPreGingerbread$krop_release(boolean bl) {
            this.isPreGingerbread = bl;
        }

        public final int getCurrX() {
            int n;
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                n = scroller.getCurrX();
            } else {
                OverScroller overScroller = this.overScroller;
                if (overScroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
                }
                n = overScroller.getCurrX();
            }
            return n;
        }

        public final int getCurrY() {
            int n;
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                n = scroller.getCurrY();
            } else {
                OverScroller overScroller = this.overScroller;
                if (overScroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
                }
                n = overScroller.getCurrY();
            }
            return n;
        }

        public final void fling(int startX, int startY, int velocityX, int velocityY, int minX, int maxX, int minY, int maxY) {
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                scroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            } else {
                OverScroller overScroller = this.overScroller;
                if (overScroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
                }
                overScroller.fling(startX, startY, velocityX, velocityY, minX, maxX, minY, maxY);
            }
        }

        public final void forceFinished(boolean finished) {
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                scroller.forceFinished(finished);
            } else {
                OverScroller overScroller = this.overScroller;
                if (overScroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
                }
                overScroller.forceFinished(finished);
            }
        }

        public final boolean isFinished() {
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                return scroller.isFinished();
            }
            OverScroller overScroller = this.overScroller;
            if (overScroller == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
            }
            return overScroller.isFinished();
        }

        public final boolean computeScrollOffset() {
            if (this.isPreGingerbread) {
                Scroller scroller = this.scroller;
                if (scroller == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scroller");
                }
                return scroller.computeScrollOffset();
            }
            OverScroller overScroller = this.overScroller;
            if (overScroller == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
            }
            overScroller.computeScrollOffset();
            OverScroller overScroller2 = this.overScroller;
            if (overScroller2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"overScroller");
            }
            return overScroller2.computeScrollOffset();
        }

        public CompatScroller(Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            if (Build.VERSION.SDK_INT < 9) {
                this.isPreGingerbread = true;
                this.scroller = new Scroller(context);
            } else {
                this.isPreGingerbread = false;
                this.overScroller = new OverScroller(context);
            }
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\b\u0082\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/avito/android/krop/ZoomableImageView$ZoomVariables;", "", "scale", "", "focusX", "focusY", "scaleType", "Landroid/widget/ImageView$ScaleType;", "(Lcom/avito/android/krop/ZoomableImageView;FFFLandroid/widget/ImageView$ScaleType;)V", "getFocusX", "()F", "setFocusX", "(F)V", "getFocusY", "setFocusY", "getScale", "setScale", "getScaleType", "()Landroid/widget/ImageView$ScaleType;", "setScaleType", "(Landroid/widget/ImageView$ScaleType;)V", "krop_release"})
    private final class ZoomVariables {
        private float scale;
        private float focusX;
        private float focusY;
        @NotNull
        private ImageView.ScaleType scaleType;

        public final float getScale() {
            return this.scale;
        }

        public final void setScale(float f) {
            this.scale = f;
        }

        public final float getFocusX() {
            return this.focusX;
        }

        public final void setFocusX(float f) {
            this.focusX = f;
        }

        public final float getFocusY() {
            return this.focusY;
        }

        public final void setFocusY(float f) {
            this.focusY = f;
        }

        @NotNull
        public final ImageView.ScaleType getScaleType() {
            return this.scaleType;
        }

        public final void setScaleType(@NotNull ImageView.ScaleType scaleType) {
            Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"<set-?>");
            this.scaleType = scaleType;
        }

        public ZoomVariables(float scale, float focusX, @NotNull float focusY, ImageView.ScaleType scaleType) {
            Intrinsics.checkParameterIsNotNull((Object)scaleType, (String)"scaleType");
            this.scale = scale;
            this.focusX = focusX;
            this.focusY = focusY;
            this.scaleType = scaleType;
        }
    }

    @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB7\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB\u000f\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0018\u00a8\u0006 "}, d2={"Lcom/avito/android/krop/ZoomableImageView$SavedState;", "Landroid/view/View$BaseSavedState;", "superState", "Landroid/os/Parcelable;", "currentZoom", "", "matrix", "", "prevMatchViewSize", "Lcom/avito/android/krop/SizeF;", "prevViewSize", "imageRenderedAtLeastOnce", "", "(Landroid/os/Parcelable;F[FLcom/avito/android/krop/SizeF;Lcom/avito/android/krop/SizeF;Z)V", "source", "Landroid/os/Parcel;", "(Landroid/os/Parcel;)V", "getCurrentZoom", "()F", "getImageRenderedAtLeastOnce", "()Z", "getMatrix", "()[F", "getPrevMatchViewSize", "()Lcom/avito/android/krop/SizeF;", "getPrevViewSize", "writeToParcel", "", "out", "flags", "", "Companion", "krop_release"})
    public static final class SavedState
    extends View.BaseSavedState {
        private final float currentZoom;
        @NotNull
        private final float[] matrix;
        @NotNull
        private final SizeF prevMatchViewSize;
        @NotNull
        private final SizeF prevViewSize;
        private final boolean imageRenderedAtLeastOnce;
        @JvmField
        @NotNull
        public static final Parcelable.Creator<SavedState> CREATOR;
        public static final Companion Companion;

        public final float getCurrentZoom() {
            return this.currentZoom;
        }

        @NotNull
        public final float[] getMatrix() {
            return this.matrix;
        }

        @NotNull
        public final SizeF getPrevMatchViewSize() {
            return this.prevMatchViewSize;
        }

        @NotNull
        public final SizeF getPrevViewSize() {
            return this.prevViewSize;
        }

        public final boolean getImageRenderedAtLeastOnce() {
            return this.imageRenderedAtLeastOnce;
        }

        public void writeToParcel(@NotNull Parcel out, int flags) {
            Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
            super.writeToParcel(out, flags);
            Parcel $receiver = out;
            $receiver.writeFloat(this.currentZoom);
            $receiver.writeFloatArray(this.matrix);
            $receiver.writeParcelable((Parcelable)this.prevMatchViewSize, flags);
            $receiver.writeParcelable((Parcelable)this.prevViewSize, flags);
            $receiver.writeInt(this.imageRenderedAtLeastOnce ? 1 : 0);
        }

        public SavedState(@NotNull Parcelable superState, float currentZoom, @NotNull float[] matrix, @NotNull SizeF prevMatchViewSize, @NotNull SizeF prevViewSize, boolean imageRenderedAtLeastOnce) {
            Intrinsics.checkParameterIsNotNull((Object)superState, (String)"superState");
            Intrinsics.checkParameterIsNotNull((Object)matrix, (String)"matrix");
            Intrinsics.checkParameterIsNotNull((Object)prevMatchViewSize, (String)"prevMatchViewSize");
            Intrinsics.checkParameterIsNotNull((Object)prevViewSize, (String)"prevViewSize");
            super(superState);
            this.currentZoom = currentZoom;
            this.matrix = matrix;
            this.prevMatchViewSize = prevMatchViewSize;
            this.prevViewSize = prevViewSize;
            this.imageRenderedAtLeastOnce = imageRenderedAtLeastOnce;
        }

        public SavedState(@NotNull Parcel source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super(source);
            this.currentZoom = source.readFloat();
            float[] fArray = source.createFloatArray();
            Intrinsics.checkExpressionValueIsNotNull((Object)fArray, (String)"source.createFloatArray()");
            this.matrix = fArray;
            Parcelable parcelable = source.readParcelable(SizeF.class.getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable, (String)"source.readParcelable(Si\u2026::class.java.classLoader)");
            this.prevMatchViewSize = (SizeF)parcelable;
            Parcelable parcelable2 = source.readParcelable(SizeF.class.getClassLoader());
            Intrinsics.checkExpressionValueIsNotNull((Object)parcelable2, (String)"source.readParcelable(Si\u2026::class.java.classLoader)");
            this.prevViewSize = (SizeF)parcelable2;
            this.imageRenderedAtLeastOnce = source.readInt() == 1;
        }

        static {
            Companion = new Companion(null);
            CREATOR = (Parcelable.Creator)new Parcelable.Creator<SavedState>(){

                @NotNull
                public SavedState createFromParcel(@NotNull Parcel parcel) {
                    Intrinsics.checkParameterIsNotNull((Object)parcel, (String)"parcel");
                    return new SavedState(parcel);
                }

                @NotNull
                public SavedState[] newArray(int size) {
                    return new SavedState[size];
                }
            };
        }

        @Metadata(mv={1, 1, 7}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/avito/android/krop/ZoomableImageView$SavedState$Companion;", "", "()V", "CREATOR", "Landroid/os/Parcelable$Creator;", "Lcom/avito/android/krop/ZoomableImageView$SavedState;", "krop_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

