/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.whatsapp.internal;

import com.google.zxing.common.BitMatrix;
import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.binary.BinaryDecoder;
import it.auties.whatsapp4j.binary.BinaryFlag;
import it.auties.whatsapp4j.binary.BinaryMetric;
import it.auties.whatsapp4j.listener.WhatsappListener;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.manager.WhatsappKeysManager;
import it.auties.whatsapp4j.protobuf.chat.Chat;
import it.auties.whatsapp4j.protobuf.chat.GroupAction;
import it.auties.whatsapp4j.protobuf.chat.GroupPolicy;
import it.auties.whatsapp4j.protobuf.chat.GroupSetting;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.contact.ContactStatus;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.request.impl.InitialRequest;
import it.auties.whatsapp4j.request.impl.LogOutRequest;
import it.auties.whatsapp4j.request.impl.MediaConnectionRequest;
import it.auties.whatsapp4j.request.impl.SolveChallengeRequest;
import it.auties.whatsapp4j.request.impl.TakeOverRequest;
import it.auties.whatsapp4j.request.model.BinaryRequest;
import it.auties.whatsapp4j.response.impl.binary.ChatResponse;
import it.auties.whatsapp4j.response.impl.json.AckResponse;
import it.auties.whatsapp4j.response.impl.json.BlocklistResponse;
import it.auties.whatsapp4j.response.impl.json.ChatCmdResponse;
import it.auties.whatsapp4j.response.impl.json.DescriptionChangeResponse;
import it.auties.whatsapp4j.response.impl.json.GroupActionResponse;
import it.auties.whatsapp4j.response.impl.json.InitialResponse;
import it.auties.whatsapp4j.response.impl.json.MediaConnectionResponse;
import it.auties.whatsapp4j.response.impl.json.PresenceResponse;
import it.auties.whatsapp4j.response.impl.json.PropsResponse;
import it.auties.whatsapp4j.response.impl.json.SimpleStatusResponse;
import it.auties.whatsapp4j.response.impl.json.SubjectChangeResponse;
import it.auties.whatsapp4j.response.impl.json.TakeOverResponse;
import it.auties.whatsapp4j.response.impl.json.UserInformationResponse;
import it.auties.whatsapp4j.response.model.binary.BinaryResponse;
import it.auties.whatsapp4j.response.model.common.Response;
import it.auties.whatsapp4j.response.model.json.JsonListResponse;
import it.auties.whatsapp4j.response.model.json.JsonResponse;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import it.auties.whatsapp4j.utils.internal.Pair;
import it.auties.whatsapp4j.utils.internal.Validate;
import it.auties.whatsapp4j.utils.internal.WhatsappQRCode;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import it.auties.whatsapp4j.whatsapp.internal.WhatsappSocketConfiguration;
import jakarta.websocket.ClientEndpoint;
import jakarta.websocket.CloseReason;
import jakarta.websocket.ContainerProvider;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.OnError;
import jakarta.websocket.OnMessage;
import jakarta.websocket.OnOpen;
import jakarta.websocket.Session;
import jakarta.websocket.WebSocketContainer;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;

@ClientEndpoint(configurator=WhatsappSocketConfiguration.class)
public class WhatsappWebSocket {
    private Session session;
    private boolean loggedIn;
    @NonNull
    private final WebSocketContainer webSocketContainer;
    @NonNull
    private final ScheduledExecutorService pingService;
    @NonNull
    private final WhatsappDataManager whatsappManager;
    @NonNull
    private final WhatsappKeysManager whatsappKeys;
    @NonNull
    private final WhatsappConfiguration options;
    @NonNull
    private final WhatsappQRCode qrCode;
    @NonNull
    private final BinaryDecoder decoder;

    public WhatsappWebSocket(@NonNull WhatsappConfiguration options, @NonNull WhatsappKeysManager manager) {
        this(ContainerProvider.getWebSocketContainer(), Executors.newSingleThreadScheduledExecutor(), WhatsappDataManager.singletonInstance(), manager, options, new WhatsappQRCode(), new BinaryDecoder());
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
    }

    @OnOpen
    public void onOpen(@NonNull Session session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        if (this.session == null || !this.session.isOpen()) {
            this.session(session);
        }
        this.sendInitialRequest(session);
    }

    private void sendInitialRequest(Session session) {
        if (this.loggedIn) {
            return;
        }
        new InitialRequest<InitialResponse>(this.options, this.whatsappKeys){}.send(session).thenAccept(this::handleInitialMessage);
    }

    private void handleInitialMessage(@NonNull InitialResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (!this.whatsappKeys.mayRestore()) {
            this.generateQrCode(response);
        }
        new TakeOverRequest<TakeOverResponse>(this.options, this.whatsappKeys){}.send(this.session()).thenAccept(this::solveChallenge);
    }

    private void generateQrCode(@NonNull InitialResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (this.loggedIn) {
            return;
        }
        this.scheduleQrCodeUpdate(response);
        BitMatrix matrix = this.createMatrix(response);
        this.whatsappManager.callListeners(listener -> listener.onQRCode(matrix));
    }

    @NonNull
    private BitMatrix createMatrix(@NonNull InitialResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String ref = Objects.requireNonNull(response.ref(), "Cannot find ref for QR code generation, the version code is probably outdated");
        byte[] publicKey = CypherUtils.extractRawPublicKey(this.whatsappKeys.keyPair().getPublic());
        String clientId = this.whatsappKeys.clientId();
        return this.qrCode.generate(ref, publicKey, clientId);
    }

    private void scheduleQrCodeUpdate(InitialResponse response) {
        Validate.isTrue(response.status() != 429, "Out of attempts to scan the QR code", IllegalStateException.class, new Object[0]);
        CompletableFuture.delayedExecutor(response.ttl(), TimeUnit.MILLISECONDS).execute(() -> this.sendInitialRequest(this.session()));
    }

    private void solveChallenge(@NonNull TakeOverResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        if (response.status() >= 400) {
            this.whatsappKeys.deleteKeysFromMemory();
            this.disconnect(null, false, true);
            return;
        }
        this.sendChallenge(response);
    }

    private void sendChallenge(@NonNull TakeOverResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String challengeBase64 = response.challenge();
        if (challengeBase64 == null) {
            return;
        }
        BinaryArray challenge = BinaryArray.forBase64(challengeBase64);
        BinaryArray signedChallenge = CypherUtils.hmacSha256(challenge, this.whatsappKeys.macKey());
        new SolveChallengeRequest<SimpleStatusResponse>(this.options, this.whatsappKeys, signedChallenge){}.send(this.session()).thenAcceptAsync(SimpleStatusResponse::orElseThrow);
    }

    private void login(@NonNull UserInformationResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        String base64Secret = response.secret();
        BinaryArray secret = BinaryArray.forBase64(base64Secret);
        BinaryArray pubKey = secret.cut(32);
        BinaryArray sharedSecret = CypherUtils.calculateSharedSecret(pubKey.data(), this.whatsappKeys.keyPair().getPrivate());
        BinaryArray sharedSecretExpanded = CypherUtils.hkdfExpand(sharedSecret, 80);
        BinaryArray hmacValidation = CypherUtils.hmacSha256(secret.cut(32).merged(secret.slice(64)), sharedSecretExpanded.slice(32, 64));
        Validate.isTrue(hmacValidation.equals(secret.slice(32, 64)), "Cannot login: Hmac validation failed!", SecurityException.class, new Object[0]);
        BinaryArray keysEncrypted = sharedSecretExpanded.slice(64).merged(secret.slice(64));
        BinaryArray key = sharedSecretExpanded.cut(32);
        BinaryArray keysDecrypted = CypherUtils.aesDecrypt(keysEncrypted, key);
        this.whatsappKeys.initializeKeys(response.serverToken(), response.clientToken(), keysDecrypted.cut(32), keysDecrypted.slice(32, 64));
    }

    @OnMessage
    public void onText(@NonNull String data) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        Response<?> response = Response.fromTaggedResponse(data);
        if (response instanceof JsonListResponse) {
            JsonListResponse listResponse = (JsonListResponse)response;
            this.handleList(listResponse);
            return;
        }
        JsonResponse mapResponse = (JsonResponse)response;
        if (((Map)mapResponse.content()).isEmpty()) {
            return;
        }
        if (this.whatsappManager.resolvePendingRequest(response.tag(), mapResponse)) {
            return;
        }
        if (response.description() == null) {
            return;
        }
        switch (response.description()) {
            case "Conn": {
                this.handleUserInformation(mapResponse.toModel(UserInformationResponse.class));
                break;
            }
            case "Blocklist": {
                this.handleBlocklist(mapResponse.toModel(BlocklistResponse.class));
                break;
            }
            case "Cmd": {
                this.handleCmd(mapResponse);
                break;
            }
            case "Props": {
                this.handleProps(mapResponse.toModel(PropsResponse.class));
                break;
            }
            case "Presence": {
                this.handlePresence(mapResponse.toModel(PresenceResponse.class));
                break;
            }
            case "Msg": 
            case "MsgInfo": {
                this.handleMessageInfo(mapResponse.toModel(AckResponse.class));
                break;
            }
            case "Chat": {
                this.handleChatCmd(mapResponse.toModel(ChatCmdResponse.class));
            }
        }
    }

    @OnMessage
    public void onBinary(byte @NonNull [] msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked non-null but is null");
        }
        Validate.isTrue(msg[0] != 33, "Server pong from whatsapp, why did this get through?", new Object[0]);
        BinaryArray binaryMessage = BinaryArray.forArray(msg);
        Pair tagAndMessagePair = binaryMessage.indexOf(',').map(binaryMessage::split).orElseThrow();
        String messageTag = ((BinaryArray)tagAndMessagePair.key()).toString();
        BinaryArray messageContent = (BinaryArray)tagAndMessagePair.value();
        BinaryArray message = messageContent.slice(32);
        BinaryArray hmacValidation = CypherUtils.hmacSha256(message, Objects.requireNonNull(this.whatsappKeys.macKey()));
        Validate.isTrue(hmacValidation.equals(messageContent.cut(32)), "Cannot read message: Hmac validation failed!", SecurityException.class, new Object[0]);
        BinaryArray decryptedMessage = CypherUtils.aesDecrypt(message, Objects.requireNonNull(this.whatsappKeys.encKey()));
        BinaryResponse response = new BinaryResponse(messageTag, this.decoder.decodeDecryptedMessage(decryptedMessage));
        if (this.whatsappManager.resolvePendingRequest(response.tag(), response)) {
            return;
        }
        this.whatsappManager.digestWhatsappNode(this, (Node)response.content());
    }

    @OnError
    public void onError(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked non-null but is null");
        }
        throw new RuntimeException("An uncaught exception was thrown during the WebSocket lifecycle", throwable);
    }

    public void connect() {
        Validate.isTrue(!this.loggedIn, "WhatsappAPI: Cannot establish a connection with whatsapp as one already exists", IllegalStateException.class, new Object[0]);
        this.openConnection();
        this.pingService.scheduleAtFixedRate(this::sendPing, 0L, 1L, TimeUnit.MINUTES);
    }

    public void disconnect(String reason, boolean logout, boolean reconnect) {
        Validate.isTrue(this.loggedIn, "WhatsappAPI: Cannot terminate the connection with whatsapp as it doesn't exist", IllegalStateException.class, new Object[0]);
        this.whatsappManager.clear();
        if (logout) {
            new LogOutRequest(this.options){}.send(this.session()).thenRunAsync(this.whatsappKeys::deleteKeysFromMemory);
        }
        this.session().close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, reason));
        this.session(null);
        this.whatsappManager.callListeners(WhatsappListener::onDisconnected);
        if (reconnect) {
            this.openConnection();
        }
    }

    private void openConnection() {
        try {
            this.webSocketContainer.setDefaultMaxSessionIdleTimeout(0L);
            this.webSocketContainer.connectToServer((Object)this, URI.create(this.options.whatsappUrl()));
        }
        catch (DeploymentException | IOException exception) {
            throw new RuntimeException("Cannot connect to WhatsappWeb's WebServer", exception);
        }
    }

    private void sendPing() {
        this.session().getAsyncRemote().sendPing(ByteBuffer.allocate(0));
    }

    private void handleChatCmd(@NonNull ChatCmdResponse cmdResponse) {
        if (cmdResponse == null) {
            throw new NullPointerException("cmdResponse is marked non-null but is null");
        }
        if (cmdResponse.cmd() == null) {
            return;
        }
        Optional<Chat> chatOpt = this.whatsappManager.findChatByJid(cmdResponse.jid());
        if (chatOpt.isEmpty()) {
            return;
        }
        Chat chat = chatOpt.get();
        Node node = Node.fromList(cmdResponse.data());
        String content = (String)node.content();
        switch (node.description()) {
            case "restrict": {
                this.notifyGroupSettingChange(chat, GroupSetting.EDIT_GROUP_INFO, content);
                break;
            }
            case "announce": {
                this.notifyGroupSettingChange(chat, GroupSetting.SEND_MESSAGES, content);
                break;
            }
            case "add": 
            case "remove": 
            case "promote": 
            case "demote": {
                this.notifyGroupAction(chat, node, content);
                break;
            }
            case "ephemeral": {
                this.updateAndNotifyEphemeralStatus(chat, content);
                break;
            }
            case "desc_add": {
                this.notifyGroupDescriptionChange(chat, content);
                break;
            }
            case "subject": {
                this.updateAndNotifyGroupSubject(chat, content);
            }
        }
    }

    private void notifyGroupDescriptionChange(@NonNull Chat chat, @NonNull String content) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        DescriptionChangeResponse response = JsonResponse.fromJson(content).toModel(DescriptionChangeResponse.class);
        String description = response.description();
        String descriptionId = response.descriptionId();
        this.whatsappManager.callListeners(listener -> listener.onGroupDescriptionChange(chat, description, descriptionId));
    }

    private void updateAndNotifyGroupSubject(@NonNull Chat chat, @NonNull String content) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        SubjectChangeResponse response = JsonResponse.fromJson(content).toModel(SubjectChangeResponse.class);
        chat.displayName(response.subject());
        this.whatsappManager.callListeners(listener -> listener.onGroupSubjectChange(chat));
    }

    private void updateAndNotifyEphemeralStatus(@NonNull Chat chat, @NonNull String content) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        chat.ephemeralMessageDuration(Long.parseLong(content));
        chat.ephemeralMessagesToggleTime(ZonedDateTime.now().toEpochSecond());
        this.whatsappManager.callListeners(listener -> listener.onChatEphemeralStatusChange(chat));
    }

    private void notifyGroupAction(@NonNull Chat chat, @NonNull Node node, @NonNull String content) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        JsonResponse.fromJson(content).toModel(GroupActionResponse.class).participants().stream().map(this.whatsappManager::findContactByJid).map(Optional::orElseThrow).forEach(contact -> this.notifyGroupAction(chat, node, (Contact)contact));
    }

    private void notifyGroupAction(@NonNull Chat chat, @NonNull Node node, @NonNull Contact contact) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        GroupAction action = GroupAction.valueOf(node.description().toUpperCase());
        this.whatsappManager.callListeners(listener -> listener.onGroupAction(chat, contact, action));
    }

    private void notifyGroupSettingChange(@NonNull Chat chat, @NonNull GroupSetting setting, @NonNull String content) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (setting == null) {
            throw new NullPointerException("setting is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        GroupPolicy policy = GroupPolicy.forData(Boolean.parseBoolean(content));
        this.whatsappManager.callListeners(listener -> listener.onGroupSettingsChange(chat, setting, policy));
    }

    private void handleMessageInfo(@NonNull AckResponse ackResponse) {
        if (ackResponse == null) {
            throw new NullPointerException("ackResponse is marked non-null but is null");
        }
        if (ackResponse.cmd() == null) {
            return;
        }
        String participant = Objects.requireNonNullElse(ackResponse.participant(), ackResponse.to());
        Optional<Contact> to = this.whatsappManager.findContactByJid(participant);
        if (to.isEmpty()) {
            return;
        }
        Optional<Chat> chat = this.whatsappManager.findChatByJid(ackResponse.to());
        if (chat.isEmpty()) {
            return;
        }
        Arrays.stream(ackResponse.ids()).map(id -> this.whatsappManager.findMessageById((Chat)chat.get(), (String)id)).filter(Optional::isPresent).map(Optional::get).forEach(message -> this.updateAndNotifyMessageReadStatusChange(ackResponse, (Contact)to.get(), (Chat)chat.get(), (MessageInfo)message));
    }

    private void updateAndNotifyMessageReadStatusChange(@NonNull AckResponse ackResponse, @NonNull Contact to, @NonNull Chat chat, MessageInfo message) {
        if (ackResponse == null) {
            throw new NullPointerException("ackResponse is marked non-null but is null");
        }
        if (to == null) {
            throw new NullPointerException("to is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        MessageInfo.MessageInfoStatus status = MessageInfo.MessageInfoStatus.forIndex(ackResponse.ack());
        message.individualReadStatus().put(to, status);
        this.whatsappManager.callListeners(listener -> listener.onMessageReadStatusUpdate(chat, to, message));
    }

    private void handleUserInformation(@NonNull UserInformationResponse info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        if (info.ref() == null) {
            this.whatsappManager.callListeners(listener -> listener.onInformationUpdate(info));
            return;
        }
        Validate.isTrue(info.connected(), "WhatsappAPI: Cannot establish a connection with WhatsappWeb", new Object[0]);
        if (!this.whatsappKeys.mayRestore()) {
            this.login(info);
        }
        this.configureSelfContact(info);
        this.scheduleMediaConnection(0);
        this.loggedIn(true);
        this.whatsappManager.callListeners(listener -> listener.onLoggedIn(info));
    }

    private void configureSelfContact(@NonNull UserInformationResponse info) {
        if (info == null) {
            throw new NullPointerException("info is marked non-null but is null");
        }
        String jid = WhatsappUtils.parseJid(info.wid());
        this.whatsappManager.contacts().add(Contact.fromJid(jid));
        this.whatsappManager.phoneNumberJid(jid);
    }

    private void scheduleMediaConnection(int delay) {
        CompletableFuture.delayedExecutor(delay, TimeUnit.SECONDS).execute(this::createMediaConnection);
    }

    private void createMediaConnection() {
        ((CompletableFuture)((CompletableFuture)new MediaConnectionRequest<MediaConnectionResponse>(this.options){}.send(this.session()).thenApplyAsync(MediaConnectionResponse::connection)).thenApplyAsync(this.whatsappManager::mediaConnection)).thenRunAsync(() -> this.scheduleMediaConnection(this.whatsappManager.mediaConnection().ttl()));
    }

    private void handleBlocklist(@NonNull BlocklistResponse blocklist) {
        if (blocklist == null) {
            throw new NullPointerException("blocklist is marked non-null but is null");
        }
        this.whatsappManager.callListeners(listener -> listener.onBlocklistUpdate(blocklist));
    }

    private void handleProps(@NonNull PropsResponse props) {
        if (props == null) {
            throw new NullPointerException("props is marked non-null but is null");
        }
        this.whatsappManager.callListeners(listener -> listener.onPropsUpdate(props));
    }

    private void handleCmd(@NonNull JsonResponse res) {
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        Optional<String> type = res.getString("type");
        if (type.isPresent() && type.get().equals("upgrade_md_prod")) {
            throw new IllegalStateException("Please turn off multidevice beta from Whatsapp");
        }
        String kind = res.getString("kind").orElse("unknown");
        this.disconnect(kind, false, this.options.reconnectWhenDisconnected().apply(kind));
    }

    private void handlePresence(@NonNull PresenceResponse res) {
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        Optional<Chat> chatOpt = this.whatsappManager.findChatByJid(res.jid());
        if (chatOpt.isEmpty()) {
            return;
        }
        Chat chat = chatOpt.get();
        if (chat.isGroup()) {
            this.handleGroupPresence(res, chat);
            return;
        }
        Contact contact = this.whatsappManager.findContactByJid(res.jid()).orElseThrow(() -> new IllegalArgumentException("Cannot update presence of unknown contact"));
        this.handleContactPresence(res, chat, contact);
    }

    private void handleContactPresence(@NonNull PresenceResponse res, @NonNull Chat chat, @NonNull Contact contact) {
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        Long offset = res.offsetFromLastSeen();
        if (offset != null) {
            ZonedDateTime lastSeen = contact.lastSeen().map(time -> time.plusSeconds(offset)).orElse(ZonedDateTime.ofInstant(Instant.ofEpochSecond(offset), ZoneId.systemDefault()));
            contact.lastSeen(lastSeen);
        } else if (res.presence() == ContactStatus.UNAVAILABLE) {
            contact.lastKnownPresence().filter(lastPresence -> lastPresence != ContactStatus.UNAVAILABLE).ifPresent(__ -> contact.lastSeen(ZonedDateTime.now()));
        }
        contact.lastKnownPresence(res.presence());
        chat.presences().put(contact, res.presence());
        this.whatsappManager.callListeners(listener -> listener.onContactPresenceUpdate(chat, contact));
    }

    private void handleGroupPresence(@NonNull PresenceResponse res, @NonNull Chat chat) {
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (res.participant() == null) {
            return;
        }
        Optional<Contact> participantOpt = this.whatsappManager.findContactByJid(res.participant());
        if (participantOpt.isEmpty()) {
            return;
        }
        Contact participant = participantOpt.get();
        chat.presences().put(participant, res.presence());
        this.whatsappManager.callListeners(listener -> listener.onContactPresenceUpdate(chat, participant));
    }

    private void handleList(@NonNull JsonListResponse response) {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        this.whatsappManager.callListeners(listener -> listener.onListResponse((List)response.content()));
    }

    @NonNull
    public Session session() {
        return Objects.requireNonNull(this.session, "WhatsappAPI: The session linked to the WebSocket is null");
    }

    @NonNull
    public CompletableFuture<ChatResponse> queryChat(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        Node node = new Node("query", WhatsappUtils.attributes(WhatsappUtils.attr("type", "chat"), WhatsappUtils.attr("jid", jid)), null);
        return new BinaryRequest<ChatResponse>(this.options, this.whatsappKeys, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.QUERY_CHAT}){}.send(this.session());
    }

    public WhatsappWebSocket(@NonNull WebSocketContainer webSocketContainer, @NonNull ScheduledExecutorService pingService, @NonNull WhatsappDataManager whatsappManager, @NonNull WhatsappKeysManager whatsappKeys, @NonNull WhatsappConfiguration options, @NonNull WhatsappQRCode qrCode, @NonNull BinaryDecoder decoder) {
        if (webSocketContainer == null) {
            throw new NullPointerException("webSocketContainer is marked non-null but is null");
        }
        if (pingService == null) {
            throw new NullPointerException("pingService is marked non-null but is null");
        }
        if (whatsappManager == null) {
            throw new NullPointerException("whatsappManager is marked non-null but is null");
        }
        if (whatsappKeys == null) {
            throw new NullPointerException("whatsappKeys is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (qrCode == null) {
            throw new NullPointerException("qrCode is marked non-null but is null");
        }
        if (decoder == null) {
            throw new NullPointerException("decoder is marked non-null but is null");
        }
        this.webSocketContainer = webSocketContainer;
        this.pingService = pingService;
        this.whatsappManager = whatsappManager;
        this.whatsappKeys = whatsappKeys;
        this.options = options;
        this.qrCode = qrCode;
        this.decoder = decoder;
    }

    public boolean loggedIn() {
        return this.loggedIn;
    }

    @NonNull
    public WebSocketContainer webSocketContainer() {
        return this.webSocketContainer;
    }

    @NonNull
    public ScheduledExecutorService pingService() {
        return this.pingService;
    }

    @NonNull
    public WhatsappDataManager whatsappManager() {
        return this.whatsappManager;
    }

    @NonNull
    public WhatsappKeysManager whatsappKeys() {
        return this.whatsappKeys;
    }

    @NonNull
    public WhatsappConfiguration options() {
        return this.options;
    }

    @NonNull
    public WhatsappQRCode qrCode() {
        return this.qrCode;
    }

    @NonNull
    public BinaryDecoder decoder() {
        return this.decoder;
    }

    public WhatsappWebSocket session(Session session) {
        this.session = session;
        return this;
    }

    public WhatsappWebSocket loggedIn(boolean loggedIn) {
        this.loggedIn = loggedIn;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsappWebSocket)) {
            return false;
        }
        WhatsappWebSocket other = (WhatsappWebSocket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.loggedIn() != other.loggedIn()) {
            return false;
        }
        Session this$session = this.session();
        Session other$session = other.session();
        if (this$session == null ? other$session != null : !this$session.equals(other$session)) {
            return false;
        }
        WebSocketContainer this$webSocketContainer = this.webSocketContainer();
        WebSocketContainer other$webSocketContainer = other.webSocketContainer();
        if (this$webSocketContainer == null ? other$webSocketContainer != null : !this$webSocketContainer.equals(other$webSocketContainer)) {
            return false;
        }
        ScheduledExecutorService this$pingService = this.pingService();
        ScheduledExecutorService other$pingService = other.pingService();
        if (this$pingService == null ? other$pingService != null : !this$pingService.equals(other$pingService)) {
            return false;
        }
        WhatsappDataManager this$whatsappManager = this.whatsappManager();
        WhatsappDataManager other$whatsappManager = other.whatsappManager();
        if (this$whatsappManager == null ? other$whatsappManager != null : !((Object)this$whatsappManager).equals(other$whatsappManager)) {
            return false;
        }
        WhatsappKeysManager this$whatsappKeys = this.whatsappKeys();
        WhatsappKeysManager other$whatsappKeys = other.whatsappKeys();
        if (this$whatsappKeys == null ? other$whatsappKeys != null : !((Object)this$whatsappKeys).equals(other$whatsappKeys)) {
            return false;
        }
        WhatsappConfiguration this$options = this.options();
        WhatsappConfiguration other$options = other.options();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        WhatsappQRCode this$qrCode = this.qrCode();
        WhatsappQRCode other$qrCode = other.qrCode();
        if (this$qrCode == null ? other$qrCode != null : !this$qrCode.equals(other$qrCode)) {
            return false;
        }
        BinaryDecoder this$decoder = this.decoder();
        BinaryDecoder other$decoder = other.decoder();
        return !(this$decoder == null ? other$decoder != null : !this$decoder.equals(other$decoder));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsappWebSocket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.loggedIn() ? 79 : 97);
        Session $session = this.session();
        result = result * 59 + ($session == null ? 43 : $session.hashCode());
        WebSocketContainer $webSocketContainer = this.webSocketContainer();
        result = result * 59 + ($webSocketContainer == null ? 43 : $webSocketContainer.hashCode());
        ScheduledExecutorService $pingService = this.pingService();
        result = result * 59 + ($pingService == null ? 43 : $pingService.hashCode());
        WhatsappDataManager $whatsappManager = this.whatsappManager();
        result = result * 59 + ($whatsappManager == null ? 43 : ((Object)$whatsappManager).hashCode());
        WhatsappKeysManager $whatsappKeys = this.whatsappKeys();
        result = result * 59 + ($whatsappKeys == null ? 43 : ((Object)$whatsappKeys).hashCode());
        WhatsappConfiguration $options = this.options();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        WhatsappQRCode $qrCode = this.qrCode();
        result = result * 59 + ($qrCode == null ? 43 : $qrCode.hashCode());
        BinaryDecoder $decoder = this.decoder();
        result = result * 59 + ($decoder == null ? 43 : $decoder.hashCode());
        return result;
    }

    public String toString() {
        return "WhatsappWebSocket(session=" + this.session() + ", loggedIn=" + this.loggedIn() + ", webSocketContainer=" + this.webSocketContainer() + ", pingService=" + this.pingService() + ", whatsappManager=" + this.whatsappManager() + ", whatsappKeys=" + this.whatsappKeys() + ", options=" + this.options() + ", qrCode=" + this.qrCode() + ", decoder=" + this.decoder() + ")";
    }
}

