/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.whatsapp;

import it.auties.whatsapp4j.binary.BinaryFlag;
import it.auties.whatsapp4j.binary.BinaryMetric;
import it.auties.whatsapp4j.listener.RegisterListenerProcessor;
import it.auties.whatsapp4j.listener.WhatsappListener;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.manager.WhatsappKeysManager;
import it.auties.whatsapp4j.protobuf.chat.Chat;
import it.auties.whatsapp4j.protobuf.chat.ChatMute;
import it.auties.whatsapp4j.protobuf.chat.GroupAction;
import it.auties.whatsapp4j.protobuf.chat.GroupPolicy;
import it.auties.whatsapp4j.protobuf.chat.GroupSetting;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.contact.ContactStatus;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.Message;
import it.auties.whatsapp4j.protobuf.message.model.MessageContainer;
import it.auties.whatsapp4j.protobuf.message.model.MessageKey;
import it.auties.whatsapp4j.protobuf.message.standard.TextMessage;
import it.auties.whatsapp4j.protobuf.model.Messages;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.request.impl.SubscribeUserPresenceRequest;
import it.auties.whatsapp4j.request.impl.UserQueryRequest;
import it.auties.whatsapp4j.request.model.BinaryRequest;
import it.auties.whatsapp4j.response.impl.binary.ChatResponse;
import it.auties.whatsapp4j.response.impl.binary.MessagesResponse;
import it.auties.whatsapp4j.response.impl.json.ChatPictureResponse;
import it.auties.whatsapp4j.response.impl.json.CommonGroupsResponse;
import it.auties.whatsapp4j.response.impl.json.GroupInviteCodeResponse;
import it.auties.whatsapp4j.response.impl.json.GroupMetadataResponse;
import it.auties.whatsapp4j.response.impl.json.GroupModificationResponse;
import it.auties.whatsapp4j.response.impl.json.MessageResponse;
import it.auties.whatsapp4j.response.impl.json.SimpleStatusResponse;
import it.auties.whatsapp4j.response.impl.json.UserStatusResponse;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import it.auties.whatsapp4j.utils.internal.Validate;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import it.auties.whatsapp4j.whatsapp.internal.WhatsappWebSocket;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public class WhatsappAPI {
    @NonNull
    private final WhatsappWebSocket socket;
    @NonNull
    private final WhatsappConfiguration configuration;
    @NonNull
    private final WhatsappDataManager manager;

    public WhatsappAPI() {
        this(WhatsappConfiguration.defaultOptions());
    }

    public WhatsappAPI(@NonNull WhatsappConfiguration configuration) {
        this(configuration, WhatsappKeysManager.fromPreferences());
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    public WhatsappAPI(@NonNull WhatsappKeysManager manager) {
        this(WhatsappConfiguration.defaultOptions(), manager);
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
    }

    public WhatsappAPI(@NonNull WhatsappConfiguration configuration, @NonNull WhatsappKeysManager manager) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (manager == null) {
            throw new NullPointerException("manager is marked non-null but is null");
        }
        this.configuration = configuration;
        this.manager = WhatsappDataManager.singletonInstance();
        this.socket = new WhatsappWebSocket(configuration, manager);
    }

    @NonNull
    public WhatsappKeysManager keys() {
        return this.socket.whatsappKeys();
    }

    @NonNull
    public WhatsappAPI connect() {
        this.socket.connect();
        return this;
    }

    @NonNull
    public WhatsappAPI disconnect() {
        this.socket.disconnect(null, false, false);
        return this;
    }

    @NonNull
    public WhatsappAPI logout() {
        this.socket.disconnect(null, true, false);
        return this;
    }

    @NonNull
    public WhatsappAPI reconnect() {
        this.socket.disconnect(null, false, true);
        return this;
    }

    @NonNull
    public WhatsappAPI autodetectListeners() {
        Validate.isTrue(this.manager.listeners().addAll(RegisterListenerProcessor.queryAllListeners()), "WhatsappAPI: Cannot autodetect listeners", new Object[0]);
        return this;
    }

    @NonNull
    public WhatsappAPI registerListener(@NonNull WhatsappListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Validate.isTrue(this.manager.listeners().add(listener), "WhatsappAPI: Cannot add listener %s", listener.getClass().getName());
        return this;
    }

    @NonNull
    public WhatsappAPI removeListener(@NonNull WhatsappListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener is marked non-null but is null");
        }
        Validate.isTrue(this.manager.listeners().remove(listener), "WhatsappAPI: Cannot remove listener %s", listener.getClass().getName());
        return this;
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> subscribeToContactPresence(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return new SubscribeUserPresenceRequest<SimpleStatusResponse>(this.configuration, contact.jid()){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull Chat chat, @NonNull String message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        MessageKey key = new MessageKey(chat);
        MessageContainer messageContainer = new MessageContainer(message);
        return this.sendMessage(new MessageInfo(key, messageContainer));
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull Chat chat, @NonNull String message, @NonNull MessageInfo quotedMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        ContextInfo messageContext = new ContextInfo(quotedMessage);
        return this.sendMessage(chat, (ContextualMessage)new TextMessage(message), messageContext);
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull Chat chat, @NonNull Message message) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        MessageKey key = new MessageKey(chat);
        MessageContainer messageContainer = new MessageContainer(message);
        return this.sendMessage(new MessageInfo(key, messageContainer));
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull Chat chat, @NonNull ContextualMessage message, @NonNull MessageInfo quotedMessage) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        ContextInfo messageContext = Optional.ofNullable(message.contextInfo()).orElse(new ContextInfo(quotedMessage)).quotedMessageContainer(quotedMessage.container()).quotedMessageId(quotedMessage.key().id()).quotedMessageSenderJid(quotedMessage.senderJid());
        return this.sendMessage(chat, message, messageContext);
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull Chat chat, @NonNull ContextualMessage message, @NonNull ContextInfo contextInfo) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (contextInfo == null) {
            throw new NullPointerException("contextInfo is marked non-null but is null");
        }
        MessageKey key = new MessageKey(chat);
        MessageContainer messageContainer = new MessageContainer(message.contextInfo(contextInfo));
        return this.sendMessage(new MessageInfo(key, messageContainer));
    }

    @NonNull
    public CompletableFuture<MessageResponse> sendMessage(@NonNull MessageInfo message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("type", "relay"), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement())), List.of(new Node("message", WhatsappUtils.attributes(new Map.Entry[0]), message)));
        return new BinaryRequest<MessageResponse>(this.configuration, this.keys(), message.key().id(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.MESSAGE}){}.send(this.socket.session()).thenApplyAsync(messageRes -> {
            if (messageRes.status() == 200) {
                message.key().chat().ifPresent(chat -> chat.messages().add(message));
            }
            return messageRes;
        });
    }

    @NonNull
    public CompletableFuture<Boolean> hasWhatsapp(@NonNull String phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        return new UserQueryRequest<SimpleStatusResponse>(this.configuration, phoneNumber, UserQueryRequest.QueryType.EXISTS){}.send(this.socket.session()).thenApplyAsync(status -> status.status() == 200);
    }

    @NonNull
    public CompletableFuture<UserStatusResponse> queryUserStatus(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return new UserQueryRequest<UserStatusResponse>(this.configuration, contact.jid(), UserQueryRequest.QueryType.USER_STATUS){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<ChatPictureResponse> queryChatPicture(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return new UserQueryRequest<ChatPictureResponse>(this.configuration, chat.jid(), UserQueryRequest.QueryType.CHAT_PICTURE){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<GroupMetadataResponse> queryGroupMetadata(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Validate.isTrue(chat.isGroup(), "WhatsappAPI: Cannot query metadata for %s as it's not a group", chat.jid());
        return new UserQueryRequest<GroupMetadataResponse>(this.configuration, chat.jid(), UserQueryRequest.QueryType.GROUP_METADATA){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<GroupInviteCodeResponse> queryGroupInviteCode(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Validate.isTrue(chat.isGroup(), "WhatsappAPI: Cannot query invite code for %s as it's not a group", chat.jid());
        return new UserQueryRequest<GroupInviteCodeResponse>(this.configuration, chat.jid(), UserQueryRequest.QueryType.GROUP_INVITE_CODE){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<CommonGroupsResponse> queryGroupsInCommon(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return new UserQueryRequest<CommonGroupsResponse>(this.configuration, contact.jid(), UserQueryRequest.QueryType.GROUPS_IN_COMMON){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<ChatResponse> queryChat(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        return this.queryChat(contact.jid());
    }

    @NonNull
    public CompletableFuture<ChatResponse> queryChat(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return this.socket.queryChat(jid);
    }

    @NonNull
    public CompletableFuture<MessagesResponse> queryFavouriteMessagesInChat(@NonNull Chat chat, int count) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node node = new Node("query", WhatsappUtils.attributes(WhatsappUtils.attr("chat", chat.jid()), WhatsappUtils.attr("count", count), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "star")), null);
        return new BinaryRequest<MessagesResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.QUERY_MESSAGES}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<Chat> loadEntireChatHistory(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        int last = chat.messages().size();
        return this.loadChatHistory(chat).thenComposeAsync(__ -> chat.messages().isEmpty() || chat.messages().size() == last ? CompletableFuture.completedFuture(chat) : this.loadEntireChatHistory(chat));
    }

    @NonNull
    public CompletableFuture<Chat> loadChatHistory(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.loadChatHistory(chat, 20);
    }

    @NonNull
    public CompletableFuture<Chat> loadChatHistory(@NonNull Chat chat, int messageCount) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return chat.firstMessage().map(userMessage -> this.loadChatHistory(chat, (MessageInfo)userMessage, messageCount)).orElseGet(() -> this.queryChat(chat.jid()).thenApplyAsync(res -> {
            ((Optional)res.data()).ifPresent(data -> chat.messages().addAll(data.messages()));
            return chat;
        }));
    }

    @NonNull
    public CompletableFuture<Chat> loadChatHistory(@NonNull Chat chat, @NonNull MessageInfo lastMessage, int messageCount) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (lastMessage == null) {
            throw new NullPointerException("lastMessage is marked non-null but is null");
        }
        Node node = new Node("query", WhatsappUtils.attributes(WhatsappUtils.attr("owner", lastMessage.key().fromMe()), WhatsappUtils.attr("index", lastMessage.key().id()), WhatsappUtils.attr("type", "message"), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("kind", "before"), WhatsappUtils.attr("count", messageCount)), null);
        return new BinaryRequest<MessagesResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.QUERY_MESSAGES}){}.send(this.socket.session()).thenApplyAsync(res -> {
            chat.messages().addAll((Collection)res.data());
            return chat;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changePresence(@NonNull ContactStatus presence) {
        if (presence == null) {
            throw new NullPointerException("presence is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("type", "set"), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement())), List.of(new Node("presence", WhatsappUtils.attributes(WhatsappUtils.attr("type", presence.data())), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, presence.flag(), new BinaryMetric[]{BinaryMetric.PRESENCE}){}.noResponse(presence != ContactStatus.AVAILABLE).send(this.socket.session()).thenApplyAsync(res -> Optional.ofNullable(res).orElse(new SimpleStatusResponse(200)));
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changePresence(@NonNull Chat chat, @NonNull ContactStatus presence) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (presence == null) {
            throw new NullPointerException("presence is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("type", "set"), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement())), List.of(new Node("presence", WhatsappUtils.attributes(WhatsappUtils.attr("type", presence.data()), WhatsappUtils.attr("to", chat.jid())), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, presence.flag(), new BinaryMetric[]{BinaryMetric.PRESENCE}){}.noResponse(presence != ContactStatus.AVAILABLE).send(this.socket.session()).thenApplyAsync(res -> Optional.ofNullable(res).orElse(new SimpleStatusResponse(200)));
    }

    @NonNull
    public CompletableFuture<GroupModificationResponse> promote(@NonNull Chat group, Contact ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.PROMOTE, WhatsappUtils.jidsToParticipantNodes(contacts));
    }

    @NonNull
    public CompletableFuture<GroupModificationResponse> demote(@NonNull Chat group, Contact ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.DEMOTE, WhatsappUtils.jidsToParticipantNodes(contacts));
    }

    @NonNull
    public CompletableFuture<GroupModificationResponse> add(@NonNull Chat group, Contact ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.ADD, WhatsappUtils.jidsToParticipantNodes(contacts));
    }

    @NonNull
    public CompletableFuture<GroupModificationResponse> remove(@NonNull Chat group, Contact ... contacts) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return this.executeActionOnGroupParticipant(group, GroupAction.REMOVE, WhatsappUtils.jidsToParticipantNodes(contacts));
    }

    @NonNull
    public CompletableFuture<GroupModificationResponse> executeActionOnGroupParticipant(@NonNull Chat group, @NonNull GroupAction action, @NonNull List<Node> jids) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (action == null) {
            throw new NullPointerException("action is marked non-null but is null");
        }
        if (jids == null) {
            throw new NullPointerException("jids is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot execute action on group's participant, %s is not a group", group.jid());
        Validate.isTrue(!jids.isEmpty(), "WhatsappAPI: Cannot execute action on group's participant, expected at least one participant node", new Object[0]);
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", action.data())), jids)));
        return new BinaryRequest<GroupModificationResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeGroupName(@NonNull Chat group, @NonNull String newName) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (newName == null) {
            throw new NullPointerException("newName is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot change group's name: %s is not a group", group.jid());
        Validate.isTrue(!newName.isBlank(), "WhatsappAPI: Cannot change group's name: the new name cannot be empty or blank", new Object[0]);
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("subject", newName), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "subject")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeGroupDescription(@NonNull Chat group, @NonNull String newDescription) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (newDescription == null) {
            throw new NullPointerException("newDescription is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot change group's description: %s is not a group", group.jid());
        return ((CompletableFuture)this.queryGroupMetadata(group).thenApplyAsync(GroupMetadataResponse::descriptionMessageId)).thenComposeAsync(previousId -> {
            String tag = WhatsappUtils.buildRequestTag(this.configuration);
            Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "description")), List.of(new Node("description", WhatsappUtils.attributes(WhatsappUtils.attr("id", WhatsappUtils.randomId()), WhatsappUtils.attr("prev", Objects.requireNonNullElse(previousId, "none"))), newDescription)))));
            return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeWhoCanSendMessagesInGroup(@NonNull Chat group, @NonNull GroupPolicy policy) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.changeGroupSetting(group, GroupSetting.SEND_MESSAGES, policy);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeWhoCanEditGroupInfo(@NonNull Chat group, @NonNull GroupPolicy policy) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        return this.changeGroupSetting(group, GroupSetting.EDIT_GROUP_INFO, policy);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeGroupSetting(@NonNull Chat group, @NonNull GroupSetting setting, @NonNull GroupPolicy policy) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (setting == null) {
            throw new NullPointerException("setting is marked non-null but is null");
        }
        if (policy == null) {
            throw new NullPointerException("policy is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot change group's setting: %s is not a group", group.jid());
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "prop")), List.of(new Node(setting.data(), WhatsappUtils.attributes(WhatsappUtils.attr("value", policy.data())), null)))));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeGroupPicture(@NonNull Chat group, byte @NonNull [] image) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot change group's picture: %s is not a group", group.jid());
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("picture", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "set")), List.of(new Node("image", WhatsappUtils.attributes(new Map.Entry[0]), image)))));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.PICTURE}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> removeGroupPicture(@NonNull Chat group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot remove group's picture: %s is not a group", group.jid());
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("picture", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "delete")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.PICTURE}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> leave(@NonNull Chat group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        Validate.isTrue(group.isGroup(), "WhatsappAPI: Cannot leave group: %s is not a group", group.jid());
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", group.jid()), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "leave")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> mute(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.mute(chat, -1L);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> mute(@NonNull Chat chat, @NonNull ZonedDateTime until) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (until == null) {
            throw new NullPointerException("until is marked non-null but is null");
        }
        return this.mute(chat, until.toEpochSecond());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> mute(@NonNull Chat chat, long untilInSeconds) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("mute", untilInSeconds), WhatsappUtils.attr("type", "mute")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
            if (res.status() == 200) {
                chat.mute(new ChatMute(untilInSeconds));
            }
            return res;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> unmute(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        String previousMute = chat.mute().muteEndDate().map(ChronoZonedDateTime::toEpochSecond).map(String::valueOf).orElse("0");
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("previous", previousMute), WhatsappUtils.attr("type", "mute")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
            if (res.status() == 200) {
                chat.mute(new ChatMute(0L));
            }
            return res;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> block(@NonNull Contact contact) {
        if (contact == null) {
            throw new NullPointerException("contact is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("block", WhatsappUtils.attributes(WhatsappUtils.attr("jid", contact.jid())), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.BLOCK}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> enableEphemeralMessages(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.changeEphemeralStatus(chat, 604800);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> disableEphemeralMessages(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.changeEphemeralStatus(chat, 0);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> changeEphemeralStatus(@NonNull Chat chat, int time) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "prop")), List.of(new Node("ephemeral", WhatsappUtils.attributes(WhatsappUtils.attr("value", time)), null)))));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), tag, node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> markAsUnread(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.markChat(chat, -2, -1);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> markAsRead(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.markChat(chat, chat.unreadMessages(), 0);
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> markChat(@NonNull Chat chat, int flag, int newFlag) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return chat.lastMessage().map(lastMessage -> this.markChat(chat, (MessageInfo)lastMessage, flag, newFlag)).orElse(this.loadAndMarkChat(chat, flag, newFlag));
    }

    private CompletableFuture<SimpleStatusResponse> loadAndMarkChat(@NonNull Chat chat, int flag, int newFlag) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return ((CompletableFuture)this.loadChatHistory(chat).thenApplyAsync(Chat::lastMessage)).thenComposeAsync(message -> this.loadAndMarkChat(chat, message.orElse(null), flag, newFlag));
    }

    private CompletableFuture<SimpleStatusResponse> loadAndMarkChat(@NonNull Chat chat, MessageInfo info, int flag, int newFlag) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return Optional.ofNullable(info).map(message -> this.markChat(chat, (MessageInfo)message, flag, newFlag)).orElse(CompletableFuture.completedFuture(new SimpleStatusResponse(404)));
    }

    public CompletableFuture<SimpleStatusResponse> markChat(@NonNull Chat chat, @NonNull MessageInfo lastMessage, int flag, int newFlag) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        if (lastMessage == null) {
            throw new NullPointerException("lastMessage is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("read", WhatsappUtils.attributes(WhatsappUtils.attr("owner", lastMessage.key().fromMe()), WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("count", flag), WhatsappUtils.attr("index", lastMessage.key().id())), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.READ}){}.send(this.socket.session()).thenApplyAsync(response -> {
            if (response.status() == 200) {
                chat.unreadMessages(newFlag);
            }
            return response;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> pin(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        long now = ZonedDateTime.now().toEpochSecond();
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("pin", String.valueOf(now)), WhatsappUtils.attr("type", "pin")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
            if (res.status() == 200) {
                chat.pinned(now);
            }
            return res;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> unpin(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("previous", chat.pinned().map(ChronoZonedDateTime::toEpochSecond).map(String::valueOf).orElse("")), WhatsappUtils.attr("type", "pin")), null)));
        return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
            if (res.status() == 200) {
                chat.pinned(0L);
            }
            return res;
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> archive(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.loadChatHistory(chat).thenComposeAsync(__ -> {
            MessageInfo lastMessage = chat.lastMessage().orElseThrow(() -> new IllegalArgumentException("Cannot archive chat: the chat's history is empty"));
            Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("owner", lastMessage.key().fromMe()), WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("index", lastMessage.key().id()), WhatsappUtils.attr("type", "archive")), null)));
            return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
                if (res.status() == 200) {
                    chat.pinned(0L);
                    chat.isArchived(true);
                }
                return res;
            });
        });
    }

    @NonNull
    public CompletableFuture<SimpleStatusResponse> unarchive(@NonNull Chat chat) {
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        return this.loadChatHistory(chat).thenComposeAsync(__ -> {
            MessageInfo lastMessage = chat.lastMessage().orElseThrow(() -> new IllegalArgumentException("Cannot unarchive chat: the chat's history is empty"));
            Node node = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("chat", WhatsappUtils.attributes(WhatsappUtils.attr("owner", lastMessage.key().fromMe()), WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("index", lastMessage.key().id()), WhatsappUtils.attr("type", "unarchive")), null)));
            return new BinaryRequest<SimpleStatusResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.CHAT}){}.send(this.socket.session()).thenApplyAsync(res -> {
                if (res.status() == 200) {
                    chat.isArchived(false);
                }
                return res;
            });
        });
    }

    @NonNull
    public CompletableFuture<Chat> createGroup(@NonNull String subject, Contact ... contacts) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        Validate.isTrue(!subject.isBlank(), "WhatsappAPI: Cannot create a group with a blank name", new Object[0]);
        List<Node> jids = WhatsappUtils.jidsToParticipantNodes(contacts);
        Validate.isTrue(jids.stream().noneMatch(node -> Objects.equals(node.attrs().get("jid"), this.manager.phoneNumberJid())), "WhatsappAPI: Cannot create a group with name %s with yourself as a participant", subject);
        String tag = WhatsappUtils.buildRequestTag(this.configuration);
        Node node2 = new Node("action", WhatsappUtils.attributes(WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("type", "set")), List.of(new Node("group", WhatsappUtils.attributes(WhatsappUtils.attr("subject", subject), WhatsappUtils.attr("author", this.manager.phoneNumberJid()), WhatsappUtils.attr("id", tag), WhatsappUtils.attr("type", "create")), WhatsappUtils.jidsToParticipantNodes(contacts))));
        return ((CompletableFuture)new BinaryRequest<GroupModificationResponse>(this.configuration, this.keys(), tag, node2, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.GROUP}){}.send(this.socket.session()).thenApplyAsync(res -> this.createGroup(subject, (GroupModificationResponse)res))).thenComposeAsync(this::loadChatHistory);
    }

    private Chat createGroup(@NonNull String subject, @NonNull GroupModificationResponse res) {
        if (subject == null) {
            throw new NullPointerException("subject is marked non-null but is null");
        }
        if (res == null) {
            throw new NullPointerException("res is marked non-null but is null");
        }
        Validate.isTrue(res.status() == 200, "WhatsappAPI: Cannot create group with name %s, error code %s", subject, res.status(), IllegalStateException.class);
        Chat group = Chat.builder().timestamp(ZonedDateTime.now().toEpochSecond()).jid(res.jid()).mute(new ChatMute(0L)).displayName(subject).messages(new Messages()).presences(new HashMap<Contact, ContactStatus>()).build();
        return this.manager.addChat(group);
    }

    @NonNull
    public CompletableFuture<MessagesResponse> search(@NonNull String search, int count, int page) {
        if (search == null) {
            throw new NullPointerException("search is marked non-null but is null");
        }
        Node node = new Node("query", WhatsappUtils.attributes(WhatsappUtils.attr("search", search), WhatsappUtils.attr("count", count), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("page", String.valueOf(page)), WhatsappUtils.attr("type", "search")), null);
        return new BinaryRequest<MessagesResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.QUERY_MESSAGES}){}.send(this.socket.session());
    }

    @NonNull
    public CompletableFuture<MessagesResponse> searchInChat(@NonNull String search, @NonNull Chat chat, int count, int page) {
        if (search == null) {
            throw new NullPointerException("search is marked non-null but is null");
        }
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
        Node node = new Node("query", WhatsappUtils.attributes(WhatsappUtils.attr("search", search), WhatsappUtils.attr("jid", chat.jid()), WhatsappUtils.attr("count", count), WhatsappUtils.attr("epoch", this.manager.tagAndIncrement()), WhatsappUtils.attr("page", page), WhatsappUtils.attr("type", "search")), null);
        return new BinaryRequest<MessagesResponse>(this.configuration, this.keys(), node, BinaryFlag.IGNORE, new BinaryMetric[]{BinaryMetric.QUERY_MESSAGES}){}.send(this.socket.session());
    }

    @NonNull
    public WhatsappDataManager manager() {
        return this.manager;
    }
}

