/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.utils;

import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import java.net.URL;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;

public final class WhatsappUtils {
    private static final WhatsappDataManager MANAGER = WhatsappDataManager.singletonInstance();

    @NonNull
    public static String phoneNumberFromJid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return jid.split("@", 2)[0];
    }

    @NonNull
    public static String parseJid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return jid.replaceAll("@c.us", "@s.whatsapp.net");
    }

    @NonNull
    public static String randomId() {
        return BinaryArray.random(10).toHex();
    }

    @NonNull
    public static String buildRequestTag(@NonNull WhatsappConfiguration configuration) {
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        return "%s.--%s".formatted(configuration.requestTag(), MANAGER.tagAndIncrement());
    }

    @NonNull
    public static Optional<ZonedDateTime> parseWhatsappTime(long time) {
        return time == 0L ? Optional.empty() : Optional.of(ZonedDateTime.ofInstant(Instant.ofEpochSecond(time), ZoneId.systemDefault()));
    }

    public static boolean isGroup(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return jid.endsWith("g.us");
    }

    @NonNull
    public static List<Node> jidsToParticipantNodes(Contact ... contacts) {
        if (contacts == null) {
            throw new NullPointerException("contacts is marked non-null but is null");
        }
        return WhatsappUtils.jidsToParticipantNodes((String[])Arrays.stream(contacts).map(Contact::jid).toArray(String[]::new));
    }

    @NonNull
    public static List<Node> jidsToParticipantNodes(String ... jids) {
        if (jids == null) {
            throw new NullPointerException("jids is marked non-null but is null");
        }
        return Arrays.stream(jids).map(jid -> new Node("participant", Map.of("jid", jid), null)).toList();
    }

    @NonNull
    public static Optional<BinaryArray> readEncryptedMedia(@NonNull String url) {
        if (url == null) {
            throw new NullPointerException("url is marked non-null but is null");
        }
        try {
            return Optional.of(BinaryArray.forArray(new URL(url).openStream().readAllBytes()));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    @SafeVarargs
    @NonNull
    public static Map<String, String> attributes(Map.Entry<String, String> ... entries) {
        if (entries == null) {
            throw new NullPointerException("entries is marked non-null but is null");
        }
        return Arrays.stream(entries).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @NonNull
    public static Map.Entry<String, String> attr(@NonNull String key, @NonNull Object value) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        return Map.entry(key, String.valueOf(value));
    }

    private WhatsappUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

