/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.NamedParameterSpec;
import java.security.spec.XECPrivateKeySpec;
import java.security.spec.XECPublicKeySpec;

public class KeyPairDeserializer
extends JsonDeserializer<KeyPair> {
    public KeyPair deserialize(JsonParser parser, DeserializationContext deserializationContext) throws IOException {
        ObjectCodec codec = parser.getCodec();
        JsonNode node = (JsonNode)codec.readTree(parser);
        KeyFactory factory = KeyFactory.getInstance("XDH");
        NamedParameterSpec algorithm = new NamedParameterSpec("X25519");
        PublicKey publicKey = factory.generatePublic(new XECPublicKeySpec(algorithm, node.get("publicKey").bigIntegerValue()));
        PrivateKey privateKey = factory.generatePrivate(new XECPrivateKeySpec(algorithm, node.get("privateKey").binaryValue()));
        return new KeyPair(publicKey, privateKey);
    }
}

