/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.response.model.common;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.auties.whatsapp4j.response.model.common.ResponseModel;
import it.auties.whatsapp4j.response.model.json.JsonListResponse;
import it.auties.whatsapp4j.response.model.json.JsonResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class Response<C> {
    protected static final ObjectMapper JACKSON = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    @NonNull
    protected String tag;
    protected String description;
    @NonNull
    protected C content;

    @NonNull
    public static Response<?> fromTaggedResponse(@NonNull String parse) {
        if (parse == null) {
            throw new NullPointerException("parse is marked non-null but is null");
        }
        try {
            String[] split = parse.split(",", 2);
            if (split.length != 2 && parse.startsWith("!")) {
                return new JsonResponse(parse, "pong", new HashMap());
            }
            String tag = split[0];
            String content = Response.parseContent(split[1], 0);
            if (content.isEmpty()) {
                return new JsonResponse(tag, null, new HashMap());
            }
            JsonNode jsonNode = JACKSON.readTree(content);
            if (!jsonNode.isArray()) {
                return new JsonResponse(tag, null, (Map)JACKSON.readerFor((TypeReference)new TypeReference<Object>(){}).readValue(jsonNode));
            }
            String possibleMap = Optional.ofNullable(jsonNode.get(1)).map(JsonNode::toString).orElse("");
            if (!possibleMap.startsWith("{") || !possibleMap.endsWith("}")) {
                return new JsonListResponse(tag, null, (List)JACKSON.readerFor((TypeReference)new TypeReference<Object>(){}).readValue(jsonNode));
            }
            return new JsonResponse(tag, jsonNode.get(0).textValue(), (Map)JACKSON.readerFor((TypeReference)new TypeReference<Object>(){}).readValue(possibleMap));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot decode Response %s with error %s".formatted(parse, e.getMessage()));
        }
    }

    @NonNull
    private static String parseContent(@NonNull String content, int index) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        return content.length() > index && content.charAt(index) == ',' ? Response.parseContent(content, index + 1) : content.substring(index);
    }

    @NonNull
    public <T extends ResponseModel> T toModel(@NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        throw new UnsupportedOperationException("To model is not supported on this object");
    }

    public Response(@NonNull String tag, String description, @NonNull C content) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.tag = tag;
        this.description = description;
        this.content = content;
    }

    @NonNull
    public String tag() {
        return this.tag;
    }

    public String description() {
        return this.description;
    }

    @NonNull
    public C content() {
        return this.content;
    }

    public Response<C> tag(@NonNull String tag) {
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        this.tag = tag;
        return this;
    }

    public Response<C> description(String description) {
        this.description = description;
        return this;
    }

    public Response<C> content(@NonNull C content) {
        if (content == null) {
            throw new NullPointerException("content is marked non-null but is null");
        }
        this.content = content;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tag = this.tag();
        String other$tag = other.tag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        String this$description = this.description();
        String other$description = other.description();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        C this$content = this.content();
        C other$content = other.content();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $tag = this.tag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        String $description = this.description();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        C $content = this.content();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "Response(tag=" + this.tag() + ", description=" + this.description() + ", content=" + this.content() + ")";
    }
}

