/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.request.model;

import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.binary.BinaryEncoder;
import it.auties.whatsapp4j.binary.BinaryFlag;
import it.auties.whatsapp4j.binary.BinaryMetric;
import it.auties.whatsapp4j.manager.WhatsappKeysManager;
import it.auties.whatsapp4j.protobuf.model.Node;
import it.auties.whatsapp4j.request.model.Request;
import it.auties.whatsapp4j.response.model.common.ResponseModel;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import jakarta.websocket.Session;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;

public abstract class BinaryRequest<M extends ResponseModel>
extends Request<Node, M> {
    private static final BinaryEncoder ENCODER = new BinaryEncoder();
    @NonNull
    private final Node node;
    @NonNull
    private final WhatsappKeysManager keys;
    @NonNull
    private final BinaryFlag flag;
    @NonNull
    private final BinaryMetric[] tags;

    protected BinaryRequest(@NonNull WhatsappConfiguration configuration, @NonNull WhatsappKeysManager keys, @NonNull String tag, @NonNull Node node, @NonNull BinaryFlag flag, BinaryMetric ... tags) {
        super(tag, configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (tag == null) {
            throw new NullPointerException("tag is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        this.keys = keys;
        this.node = node;
        this.flag = flag;
        this.tags = tags;
    }

    protected BinaryRequest(@NonNull WhatsappConfiguration configuration, @NonNull WhatsappKeysManager keys, @NonNull Node node, @NonNull BinaryFlag flag, BinaryMetric ... tags) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        if (node == null) {
            throw new NullPointerException("node is marked non-null but is null");
        }
        if (flag == null) {
            throw new NullPointerException("flag is marked non-null but is null");
        }
        if (tags == null) {
            throw new NullPointerException("tags is marked non-null but is null");
        }
        this.keys = keys;
        this.node = node;
        this.flag = flag;
        this.tags = tags;
    }

    @Override
    @NonNull
    public Node buildBody() {
        return this.node;
    }

    @Override
    public CompletableFuture<M> send(@NonNull Session session) {
        if (session == null) {
            throw new NullPointerException("session is marked non-null but is null");
        }
        try {
            ByteBuffer binaryMessage = this.encode();
            if (this.configuration.async()) {
                session.getAsyncRemote().sendBinary(binaryMessage, __ -> this.addRequest());
                return this.future;
            }
            session.getBasicRemote().sendBinary(binaryMessage);
            this.addRequest();
            return this.future;
        }
        catch (IOException exception) {
            throw new RuntimeException("An exception occurred while sending a binary message", exception);
        }
    }

    @NonNull
    private ByteBuffer encode() {
        BinaryArray messageTag = BinaryArray.forString("%s,".formatted(this.tag()));
        byte[] encodedMessage = ENCODER.encodeMessage(this.buildBody());
        BinaryArray encrypted = CypherUtils.aesEncrypt(encodedMessage, Objects.requireNonNull(this.keys.encKey()));
        BinaryArray hmacSign = CypherUtils.hmacSha256(encrypted, Objects.requireNonNull(this.keys.macKey()));
        return messageTag.merged(BinaryMetric.toArray(this.tags()).merged(BinaryArray.singleton(this.flag().data()))).merged(hmacSign).merged(encrypted).toBuffer();
    }

    @NonNull
    public Node node() {
        return this.node;
    }

    @NonNull
    public BinaryFlag flag() {
        return this.flag;
    }

    @NonNull
    public BinaryMetric[] tags() {
        return this.tags;
    }
}

