/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.request.impl;

import it.auties.whatsapp4j.request.model.JsonRequest;
import it.auties.whatsapp4j.response.model.json.JsonResponseModel;
import it.auties.whatsapp4j.whatsapp.WhatsappConfiguration;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public abstract class UserQueryRequest<M extends JsonResponseModel>
extends JsonRequest<M> {
    @NonNull
    private final String jid;
    @NonNull
    private final QueryType queryType;

    public UserQueryRequest(@NonNull WhatsappConfiguration configuration, @NonNull String jid, @NonNull QueryType queryType) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (queryType == null) {
            throw new NullPointerException("queryType is marked non-null but is null");
        }
        this.jid = jid;
        this.queryType = queryType;
    }

    @Override
    @NonNull
    public List<Object> buildBody() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add("query");
        list.addAll(this.queryType.data());
        list.add(this.jid);
        return list;
    }

    public static enum QueryType {
        CHAT_PICTURE(List.of("ProfilePicThumb")),
        GROUP_METADATA(List.of("GroupMetadata")),
        USER_STATUS(List.of("Status")),
        GROUP_INVITE_CODE(List.of("inviteCode")),
        GROUPS_IN_COMMON(List.of("group", "common")),
        EXISTS(List.of("exist"));

        private final List<String> data;

        private QueryType(List<String> data) {
            this.data = data;
        }

        public List<String> data() {
            return this.data;
        }
    }
}

