/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.protobuf.model.CallButton;
import it.auties.whatsapp4j.protobuf.model.QuickReplyButton;
import it.auties.whatsapp4j.protobuf.model.URLButton;
import java.util.Arrays;

public class TemplateButton {
    @JsonProperty(value="3")
    private CallButton callButton;
    @JsonProperty(value="2")
    private URLButton urlButton;
    @JsonProperty(value="1")
    private QuickReplyButton quickReplyButton;
    @JsonProperty(value="4")
    private int index;

    public Button buttonCase() {
        if (this.quickReplyButton != null) {
            return Button.QUICK_REPLY_BUTTON;
        }
        if (this.urlButton != null) {
            return Button.URL_BUTTON;
        }
        if (this.callButton != null) {
            return Button.CALL_BUTTON;
        }
        return Button.UNKNOWN;
    }

    public static TemplateButtonBuilder builder() {
        return new TemplateButtonBuilder();
    }

    public TemplateButton(CallButton callButton, URLButton urlButton, QuickReplyButton quickReplyButton, int index) {
        this.callButton = callButton;
        this.urlButton = urlButton;
        this.quickReplyButton = quickReplyButton;
        this.index = index;
    }

    public TemplateButton() {
    }

    public CallButton callButton() {
        return this.callButton;
    }

    public URLButton urlButton() {
        return this.urlButton;
    }

    public QuickReplyButton quickReplyButton() {
        return this.quickReplyButton;
    }

    public int index() {
        return this.index;
    }

    @JsonProperty(value="3")
    public TemplateButton callButton(CallButton callButton) {
        this.callButton = callButton;
        return this;
    }

    @JsonProperty(value="2")
    public TemplateButton urlButton(URLButton urlButton) {
        this.urlButton = urlButton;
        return this;
    }

    @JsonProperty(value="1")
    public TemplateButton quickReplyButton(QuickReplyButton quickReplyButton) {
        this.quickReplyButton = quickReplyButton;
        return this;
    }

    @JsonProperty(value="4")
    public TemplateButton index(int index) {
        this.index = index;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TemplateButton)) {
            return false;
        }
        TemplateButton other = (TemplateButton)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.index() != other.index()) {
            return false;
        }
        CallButton this$callButton = this.callButton();
        CallButton other$callButton = other.callButton();
        if (this$callButton == null ? other$callButton != null : !((Object)this$callButton).equals(other$callButton)) {
            return false;
        }
        URLButton this$urlButton = this.urlButton();
        URLButton other$urlButton = other.urlButton();
        if (this$urlButton == null ? other$urlButton != null : !((Object)this$urlButton).equals(other$urlButton)) {
            return false;
        }
        QuickReplyButton this$quickReplyButton = this.quickReplyButton();
        QuickReplyButton other$quickReplyButton = other.quickReplyButton();
        return !(this$quickReplyButton == null ? other$quickReplyButton != null : !((Object)this$quickReplyButton).equals(other$quickReplyButton));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TemplateButton;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.index();
        CallButton $callButton = this.callButton();
        result = result * 59 + ($callButton == null ? 43 : ((Object)$callButton).hashCode());
        URLButton $urlButton = this.urlButton();
        result = result * 59 + ($urlButton == null ? 43 : ((Object)$urlButton).hashCode());
        QuickReplyButton $quickReplyButton = this.quickReplyButton();
        result = result * 59 + ($quickReplyButton == null ? 43 : ((Object)$quickReplyButton).hashCode());
        return result;
    }

    public String toString() {
        return "TemplateButton(callButton=" + this.callButton() + ", urlButton=" + this.urlButton() + ", quickReplyButton=" + this.quickReplyButton() + ", index=" + this.index() + ")";
    }

    public static enum Button {
        UNKNOWN(0),
        QUICK_REPLY_BUTTON(1),
        URL_BUTTON(2),
        CALL_BUTTON(3);

        private final int index;

        private Button(int index) {
            this.index = index;
        }

        @JsonCreator
        public static Button forIndex(int index) {
            return Arrays.stream(Button.values()).filter(entry -> entry.index() == index).findFirst().orElse(UNKNOWN);
        }

        public int index() {
            return this.index;
        }
    }

    public static class TemplateButtonBuilder {
        private CallButton callButton;
        private URLButton urlButton;
        private QuickReplyButton quickReplyButton;
        private int index;

        TemplateButtonBuilder() {
        }

        @JsonProperty(value="3")
        public TemplateButtonBuilder callButton(CallButton callButton) {
            this.callButton = callButton;
            return this;
        }

        @JsonProperty(value="2")
        public TemplateButtonBuilder urlButton(URLButton urlButton) {
            this.urlButton = urlButton;
            return this;
        }

        @JsonProperty(value="1")
        public TemplateButtonBuilder quickReplyButton(QuickReplyButton quickReplyButton) {
            this.quickReplyButton = quickReplyButton;
            return this;
        }

        @JsonProperty(value="4")
        public TemplateButtonBuilder index(int index) {
            this.index = index;
            return this;
        }

        public TemplateButton build() {
            return new TemplateButton(this.callButton, this.urlButton, this.quickReplyButton, this.index);
        }

        public String toString() {
            return "TemplateButton.TemplateButtonBuilder(callButton=" + this.callButton + ", urlButton=" + this.urlButton + ", quickReplyButton=" + this.quickReplyButton + ", index=" + this.index + ")";
        }
    }
}

