/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.model;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import it.auties.whatsapp4j.utils.internal.Validate;
import java.util.List;
import java.util.Map;
import lombok.NonNull;

public record Node(@NonNull String description, @NonNull Map<String, String> attrs, Object content) {
    private static final ObjectMapper JACKSON = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public Node(@NonNull String description, @NonNull Map<String, String> attrs, Object content) {
        if (description == null) {
            throw new NullPointerException("description is marked non-null but is null");
        }
        if (attrs == null) {
            throw new NullPointerException("attrs is marked non-null but is null");
        }
    }

    @NonNull
    public static Node fromList(@NonNull List<?> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        Validate.isTrue(list.size() == 3, "WhatsappAPI: Cannot parse %s as a WhatsappNode", list);
        Object obj = list.get(0);
        if (!(obj instanceof String)) {
            throw new IllegalArgumentException("WhatsappAPI: Cannot parse %s as a WhatsappNode, no description found".formatted(list));
        }
        String description = (String)obj;
        Object obj2 = list.get(1);
        if (!(obj2 instanceof String)) {
            throw new IllegalArgumentException("WhatsappAPI: Cannot parse %s as a WhatsappNode, no attrs found".formatted(list));
        }
        String attrs = (String)obj2;
        return new Node(description, Node.parseListAttrs(attrs), JACKSON.writeValueAsString(list.get(2)));
    }

    @NonNull
    private static Map<String, String> parseListAttrs(String attrs) {
        return attrs == null ? Map.of() : (attrs.startsWith("}") && attrs.endsWith("}") ? (Map<Object, Object>)JACKSON.readValue(attrs, (TypeReference)new TypeReference<Map<String, String>>(){}) : Map.of("content", attrs));
    }

    @NonNull
    public static List<Node> fromGenericList(@NonNull List<?> list) {
        if (list == null) {
            throw new NullPointerException("list is marked non-null but is null");
        }
        return list.stream().filter(entry -> entry instanceof Node).map(Node.class::cast).toList();
    }

    @NonNull
    public List<Node> childNodes() {
        if (this.content == null) {
            return List.of();
        }
        Object object = this.content;
        if (!(object instanceof List)) {
            throw new IllegalArgumentException("WhatsappAPI: Cannot extract child nodes from %s: expected List<?> as content".formatted(this));
        }
        List listContent = (List)object;
        return Node.fromGenericList(listContent);
    }
}

