/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.model;

import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import lombok.NonNull;

public class Messages
extends ArrayList<MessageInfo> {
    private static final Comparator<MessageInfo> ENTRY_COMPARATOR = Comparator.comparingLong(MessageInfo::timestamp);

    public Messages(@NonNull MessageInfo message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.add(message);
    }

    @Override
    public boolean add(@NonNull MessageInfo message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        int initialSize = this.size();
        int insertionPoint = Collections.binarySearch(this, message, ENTRY_COMPARATOR);
        super.add(insertionPoint > -1 ? insertionPoint : -insertionPoint - 1, message);
        return this.size() != initialSize;
    }

    public boolean addOrReplace(@NonNull MessageInfo message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        boolean result = this.remove(message);
        this.add(message);
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends MessageInfo> collection) {
        return collection.stream().map(this::addOrReplace).reduce(true, (a, b) -> a != false && b != false);
    }

    @Override
    public void add(int index, MessageInfo element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends MessageInfo> c) {
        throw new UnsupportedOperationException();
    }

    public Messages() {
    }
}

