/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;

public class HistorySyncNotification {
    @JsonProperty(value="7")
    private int chunkOrder;
    @JsonProperty(value="6")
    private HistorySyncType syncType;
    @JsonProperty(value="5")
    private String directPath;
    @JsonProperty(value="4")
    private byte[] fileEncSha256;
    @JsonProperty(value="3")
    private byte[] mediaKey;
    @JsonProperty(value="2")
    private long fileLength;
    @JsonProperty(value="1")
    private byte[] fileSha256;

    public static HistorySyncNotificationBuilder builder() {
        return new HistorySyncNotificationBuilder();
    }

    public HistorySyncNotification(int chunkOrder, HistorySyncType syncType, String directPath, byte[] fileEncSha256, byte[] mediaKey, long fileLength, byte[] fileSha256) {
        this.chunkOrder = chunkOrder;
        this.syncType = syncType;
        this.directPath = directPath;
        this.fileEncSha256 = fileEncSha256;
        this.mediaKey = mediaKey;
        this.fileLength = fileLength;
        this.fileSha256 = fileSha256;
    }

    public HistorySyncNotification() {
    }

    public int chunkOrder() {
        return this.chunkOrder;
    }

    public HistorySyncType syncType() {
        return this.syncType;
    }

    public String directPath() {
        return this.directPath;
    }

    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public long fileLength() {
        return this.fileLength;
    }

    public byte[] fileSha256() {
        return this.fileSha256;
    }

    @JsonProperty(value="7")
    public HistorySyncNotification chunkOrder(int chunkOrder) {
        this.chunkOrder = chunkOrder;
        return this;
    }

    @JsonProperty(value="6")
    public HistorySyncNotification syncType(HistorySyncType syncType) {
        this.syncType = syncType;
        return this;
    }

    @JsonProperty(value="5")
    public HistorySyncNotification directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="4")
    public HistorySyncNotification fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="3")
    public HistorySyncNotification mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="2")
    public HistorySyncNotification fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="1")
    public HistorySyncNotification fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistorySyncNotification)) {
            return false;
        }
        HistorySyncNotification other = (HistorySyncNotification)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.chunkOrder() != other.chunkOrder()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        HistorySyncType this$syncType = this.syncType();
        HistorySyncType other$syncType = other.syncType();
        if (this$syncType == null ? other$syncType != null : !((Object)((Object)this$syncType)).equals((Object)other$syncType)) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        return Arrays.equals(this.fileSha256(), other.fileSha256());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistorySyncNotification;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.chunkOrder();
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        HistorySyncType $syncType = this.syncType();
        result = result * 59 + ($syncType == null ? 43 : ((Object)((Object)$syncType)).hashCode());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        return result;
    }

    public String toString() {
        return "HistorySyncNotification(chunkOrder=" + this.chunkOrder() + ", syncType=" + this.syncType() + ", directPath=" + this.directPath() + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", fileLength=" + this.fileLength() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ")";
    }

    public static class HistorySyncNotificationBuilder {
        private int chunkOrder;
        private HistorySyncType syncType;
        private String directPath;
        private byte[] fileEncSha256;
        private byte[] mediaKey;
        private long fileLength;
        private byte[] fileSha256;

        HistorySyncNotificationBuilder() {
        }

        @JsonProperty(value="7")
        public HistorySyncNotificationBuilder chunkOrder(int chunkOrder) {
            this.chunkOrder = chunkOrder;
            return this;
        }

        @JsonProperty(value="6")
        public HistorySyncNotificationBuilder syncType(HistorySyncType syncType) {
            this.syncType = syncType;
            return this;
        }

        @JsonProperty(value="5")
        public HistorySyncNotificationBuilder directPath(String directPath) {
            this.directPath = directPath;
            return this;
        }

        @JsonProperty(value="4")
        public HistorySyncNotificationBuilder fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return this;
        }

        @JsonProperty(value="3")
        public HistorySyncNotificationBuilder mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return this;
        }

        @JsonProperty(value="2")
        public HistorySyncNotificationBuilder fileLength(long fileLength) {
            this.fileLength = fileLength;
            return this;
        }

        @JsonProperty(value="1")
        public HistorySyncNotificationBuilder fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return this;
        }

        public HistorySyncNotification build() {
            return new HistorySyncNotification(this.chunkOrder, this.syncType, this.directPath, this.fileEncSha256, this.mediaKey, this.fileLength, this.fileSha256);
        }

        public String toString() {
            return "HistorySyncNotification.HistorySyncNotificationBuilder(chunkOrder=" + this.chunkOrder + ", syncType=" + this.syncType + ", directPath=" + this.directPath + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", fileLength=" + this.fileLength + ", fileSha256=" + Arrays.toString(this.fileSha256) + ")";
        }
    }

    public static enum HistorySyncType {
        INITIAL_BOOTSTRAP(0),
        INITIAL_STATUS_V3(1),
        FULL(2),
        RECENT(3);

        private final int index;

        private HistorySyncType(int index) {
            this.index = index;
        }

        @JsonCreator
        public static HistorySyncType forIndex(int index) {
            return Arrays.stream(HistorySyncType.values()).filter(entry -> entry.index() == index).findFirst().orElse(null);
        }

        public int index() {
            return this.index;
        }
    }
}

