/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.standard;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.protobuf.model.InteractiveAnnotation;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import it.auties.whatsapp4j.utils.internal.Validate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URLConnection;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;

public final class VideoMessage
extends MediaMessage {
    @JsonProperty(value="19")
    private VideoMessageAttribution gifAttribution;
    @JsonProperty(value="18")
    private byte[] streamingSidecar;
    @JsonProperty(value="16")
    private byte[] jpegThumbnail;
    @JsonProperty(value="14")
    private long mediaKeyTimestamp;
    @JsonProperty(value="13")
    private String directPath;
    @JsonProperty(value="12")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<InteractiveAnnotation> interactiveAnnotations;
    @JsonProperty(value="11")
    private byte[] fileEncSha256;
    @JsonProperty(value="10")
    private int width;
    @JsonProperty(value="9")
    private int height;
    @JsonProperty(value="8")
    private boolean gifPlayback;
    @JsonProperty(value="7")
    private String caption;
    @JsonProperty(value="6")
    private byte[] mediaKey;
    @JsonProperty(value="5")
    private int seconds;
    @JsonProperty(value="4")
    private long fileLength;
    @JsonProperty(value="3")
    private byte[] fileSha256;
    @JsonProperty(value="2")
    private String mimetype;
    @JsonProperty(value="1")
    private String url;

    private static VideoMessage videoBuilder(byte @NonNull [] media, String mimeType, String caption, int width, int height, int seconds, ContextInfo contextInfo) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.VIDEO);
        return ((VideoMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)VideoMessage.builder().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.VIDEO.defaultMimeType()))).caption(caption)).width(width)).height(height)).seconds(seconds)).contextInfo(contextInfo)).create();
    }

    private static VideoMessage gifBuilder(byte @NonNull [] media, String mimeType, String caption, int width, int height, VideoMessageAttribution gifAttribution, ContextInfo contextInfo) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        Validate.isTrue(!Objects.equals(VideoMessage.guessMimeType(media), "image/gif") && !Objects.equals(mimeType, "image/gif"), "Cannot create a VideoMessage with mime type image/gif: gif messages on whatsapp are videos played as gifs", new Object[0]);
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.VIDEO);
        return ((VideoMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)((VideoMessageBuilder)VideoMessage.builder().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.VIDEO.defaultMimeType()))).caption(caption)).width(width)).height(height)).gifPlayback(true)).gifAttribution(Optional.ofNullable(gifAttribution).orElse(VideoMessageAttribution.NONE))).caption(caption)).contextInfo(contextInfo)).create();
    }

    @NonNull
    private static String guessMimeType(byte[] media) {
        String result = "";
        try {
            result = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(media));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.ofNullable(result).orElse("application/octet-stream");
    }

    private static VideoMessageBuilder<?, ?> builder() {
        return new VideoMessageBuilderImpl();
    }

    @Override
    @NonNull
    public MediaMessageType type() {
        return MediaMessageType.VIDEO;
    }

    protected VideoMessage(VideoMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.gifAttribution = b.gifAttribution;
        this.streamingSidecar = b.streamingSidecar;
        this.jpegThumbnail = b.jpegThumbnail;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.directPath = b.directPath;
        this.interactiveAnnotations = b.interactiveAnnotations;
        this.fileEncSha256 = b.fileEncSha256;
        this.width = b.width;
        this.height = b.height;
        this.gifPlayback = b.gifPlayback;
        this.caption = b.caption;
        this.mediaKey = b.mediaKey;
        this.seconds = b.seconds;
        this.fileLength = b.fileLength;
        this.fileSha256 = b.fileSha256;
        this.mimetype = b.mimetype;
        this.url = b.url;
    }

    public static NewVideoMessageBuilder newVideoMessage() {
        return new NewVideoMessageBuilder();
    }

    public static NewGifMessageBuilder newGifMessage() {
        return new NewGifMessageBuilder();
    }

    public VideoMessage(VideoMessageAttribution gifAttribution, byte[] streamingSidecar, byte[] jpegThumbnail, long mediaKeyTimestamp, String directPath, List<InteractiveAnnotation> interactiveAnnotations, byte[] fileEncSha256, int width, int height, boolean gifPlayback, String caption, byte[] mediaKey, int seconds, long fileLength, byte[] fileSha256, String mimetype, String url) {
        this.gifAttribution = gifAttribution;
        this.streamingSidecar = streamingSidecar;
        this.jpegThumbnail = jpegThumbnail;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.directPath = directPath;
        this.interactiveAnnotations = interactiveAnnotations;
        this.fileEncSha256 = fileEncSha256;
        this.width = width;
        this.height = height;
        this.gifPlayback = gifPlayback;
        this.caption = caption;
        this.mediaKey = mediaKey;
        this.seconds = seconds;
        this.fileLength = fileLength;
        this.fileSha256 = fileSha256;
        this.mimetype = mimetype;
        this.url = url;
    }

    public VideoMessage() {
    }

    public VideoMessageAttribution gifAttribution() {
        return this.gifAttribution;
    }

    public byte[] streamingSidecar() {
        return this.streamingSidecar;
    }

    public byte[] jpegThumbnail() {
        return this.jpegThumbnail;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    @Override
    public String directPath() {
        return this.directPath;
    }

    public List<InteractiveAnnotation> interactiveAnnotations() {
        return this.interactiveAnnotations;
    }

    @Override
    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public boolean gifPlayback() {
        return this.gifPlayback;
    }

    public String caption() {
        return this.caption;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public int seconds() {
        return this.seconds;
    }

    @Override
    public long fileLength() {
        return this.fileLength;
    }

    @Override
    public byte[] fileSha256() {
        return this.fileSha256;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public String url() {
        return this.url;
    }

    @JsonProperty(value="19")
    public VideoMessage gifAttribution(VideoMessageAttribution gifAttribution) {
        this.gifAttribution = gifAttribution;
        return this;
    }

    @JsonProperty(value="18")
    public VideoMessage streamingSidecar(byte[] streamingSidecar) {
        this.streamingSidecar = streamingSidecar;
        return this;
    }

    @JsonProperty(value="16")
    public VideoMessage jpegThumbnail(byte[] jpegThumbnail) {
        this.jpegThumbnail = jpegThumbnail;
        return this;
    }

    @JsonProperty(value="14")
    public VideoMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    @JsonProperty(value="13")
    public VideoMessage directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="12")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public VideoMessage interactiveAnnotations(List<InteractiveAnnotation> interactiveAnnotations) {
        this.interactiveAnnotations = interactiveAnnotations;
        return this;
    }

    @JsonProperty(value="11")
    public VideoMessage fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="10")
    public VideoMessage width(int width) {
        this.width = width;
        return this;
    }

    @JsonProperty(value="9")
    public VideoMessage height(int height) {
        this.height = height;
        return this;
    }

    @JsonProperty(value="8")
    public VideoMessage gifPlayback(boolean gifPlayback) {
        this.gifPlayback = gifPlayback;
        return this;
    }

    @JsonProperty(value="7")
    public VideoMessage caption(String caption) {
        this.caption = caption;
        return this;
    }

    @JsonProperty(value="6")
    public VideoMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="5")
    public VideoMessage seconds(int seconds) {
        this.seconds = seconds;
        return this;
    }

    @JsonProperty(value="4")
    public VideoMessage fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="3")
    public VideoMessage fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    @JsonProperty(value="2")
    public VideoMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @JsonProperty(value="1")
    public VideoMessage url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return "VideoMessage(gifAttribution=" + this.gifAttribution() + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar()) + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail()) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", directPath=" + this.directPath() + ", interactiveAnnotations=" + this.interactiveAnnotations() + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", width=" + this.width() + ", height=" + this.height() + ", gifPlayback=" + this.gifPlayback() + ", caption=" + this.caption() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", seconds=" + this.seconds() + ", fileLength=" + this.fileLength() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", mimetype=" + this.mimetype() + ", url=" + this.url() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VideoMessage)) {
            return false;
        }
        VideoMessage other = (VideoMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.width() != other.width()) {
            return false;
        }
        if (this.height() != other.height()) {
            return false;
        }
        if (this.gifPlayback() != other.gifPlayback()) {
            return false;
        }
        if (this.seconds() != other.seconds()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        VideoMessageAttribution this$gifAttribution = this.gifAttribution();
        VideoMessageAttribution other$gifAttribution = other.gifAttribution();
        if (this$gifAttribution == null ? other$gifAttribution != null : !((Object)((Object)this$gifAttribution)).equals((Object)other$gifAttribution)) {
            return false;
        }
        if (!Arrays.equals(this.streamingSidecar(), other.streamingSidecar())) {
            return false;
        }
        if (!Arrays.equals(this.jpegThumbnail(), other.jpegThumbnail())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        List<InteractiveAnnotation> this$interactiveAnnotations = this.interactiveAnnotations();
        List<InteractiveAnnotation> other$interactiveAnnotations = other.interactiveAnnotations();
        if (this$interactiveAnnotations == null ? other$interactiveAnnotations != null : !((Object)this$interactiveAnnotations).equals(other$interactiveAnnotations)) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        String this$caption = this.caption();
        String other$caption = other.caption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof VideoMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + this.width();
        result = result * 59 + this.height();
        result = result * 59 + (this.gifPlayback() ? 79 : 97);
        result = result * 59 + this.seconds();
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        VideoMessageAttribution $gifAttribution = this.gifAttribution();
        result = result * 59 + ($gifAttribution == null ? 43 : ((Object)((Object)$gifAttribution)).hashCode());
        result = result * 59 + Arrays.hashCode(this.streamingSidecar());
        result = result * 59 + Arrays.hashCode(this.jpegThumbnail());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        List<InteractiveAnnotation> $interactiveAnnotations = this.interactiveAnnotations();
        result = result * 59 + ($interactiveAnnotations == null ? 43 : ((Object)$interactiveAnnotations).hashCode());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        String $caption = this.caption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class VideoMessageBuilder<C extends VideoMessage, B extends VideoMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private VideoMessageAttribution gifAttribution;
        private byte[] streamingSidecar;
        private byte[] jpegThumbnail;
        private long mediaKeyTimestamp;
        private String directPath;
        private List<InteractiveAnnotation> interactiveAnnotations;
        private byte[] fileEncSha256;
        private int width;
        private int height;
        private boolean gifPlayback;
        private String caption;
        private byte[] mediaKey;
        private int seconds;
        private long fileLength;
        private byte[] fileSha256;
        private String mimetype;
        private String url;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        @JsonProperty(value="19")
        public B gifAttribution(VideoMessageAttribution gifAttribution) {
            this.gifAttribution = gifAttribution;
            return (B)this.self();
        }

        @JsonProperty(value="18")
        public B streamingSidecar(byte[] streamingSidecar) {
            this.streamingSidecar = streamingSidecar;
            return (B)this.self();
        }

        @JsonProperty(value="16")
        public B jpegThumbnail(byte[] jpegThumbnail) {
            this.jpegThumbnail = jpegThumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="14")
        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="13")
        public B directPath(String directPath) {
            this.directPath = directPath;
            return (B)this.self();
        }

        @JsonProperty(value="12")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public B interactiveAnnotations(List<InteractiveAnnotation> interactiveAnnotations) {
            this.interactiveAnnotations = interactiveAnnotations;
            return (B)this.self();
        }

        @JsonProperty(value="11")
        public B fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="10")
        public B width(int width) {
            this.width = width;
            return (B)this.self();
        }

        @JsonProperty(value="9")
        public B height(int height) {
            this.height = height;
            return (B)this.self();
        }

        @JsonProperty(value="8")
        public B gifPlayback(boolean gifPlayback) {
            this.gifPlayback = gifPlayback;
            return (B)this.self();
        }

        @JsonProperty(value="7")
        public B caption(String caption) {
            this.caption = caption;
            return (B)this.self();
        }

        @JsonProperty(value="6")
        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        @JsonProperty(value="5")
        public B seconds(int seconds) {
            this.seconds = seconds;
            return (B)this.self();
        }

        @JsonProperty(value="4")
        public B fileLength(long fileLength) {
            this.fileLength = fileLength;
            return (B)this.self();
        }

        @JsonProperty(value="3")
        public B fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="2")
        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        @JsonProperty(value="1")
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "VideoMessage.VideoMessageBuilder(super=" + super.toString() + ", gifAttribution=" + this.gifAttribution + ", streamingSidecar=" + Arrays.toString(this.streamingSidecar) + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", directPath=" + this.directPath + ", interactiveAnnotations=" + this.interactiveAnnotations + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", width=" + this.width + ", height=" + this.height + ", gifPlayback=" + this.gifPlayback + ", caption=" + this.caption + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", seconds=" + this.seconds + ", fileLength=" + this.fileLength + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", mimetype=" + this.mimetype + ", url=" + this.url + ")";
        }
    }

    public static enum VideoMessageAttribution {
        NONE(0),
        GIPHY(1),
        TENOR(2);

        private final int index;

        private VideoMessageAttribution(int index) {
            this.index = index;
        }

        @JsonCreator
        public static VideoMessageAttribution forIndex(int index) {
            return Arrays.stream(VideoMessageAttribution.values()).filter(entry -> entry.index() == index).findFirst().orElse(null);
        }

        public int index() {
            return this.index;
        }
    }

    private static final class VideoMessageBuilderImpl
    extends VideoMessageBuilder<VideoMessage, VideoMessageBuilderImpl> {
        private VideoMessageBuilderImpl() {
        }

        @Override
        protected VideoMessageBuilderImpl self() {
            return this;
        }

        @Override
        public VideoMessage create() {
            return new VideoMessage(this);
        }
    }

    public static class NewVideoMessageBuilder {
        private byte @NonNull [] media;
        private String mimeType;
        private String caption;
        private int width;
        private int height;
        private int seconds;
        private ContextInfo contextInfo;

        NewVideoMessageBuilder() {
        }

        public NewVideoMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewVideoMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewVideoMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public NewVideoMessageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public NewVideoMessageBuilder height(int height) {
            this.height = height;
            return this;
        }

        public NewVideoMessageBuilder seconds(int seconds) {
            this.seconds = seconds;
            return this;
        }

        public NewVideoMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public VideoMessage create() {
            return VideoMessage.videoBuilder(this.media, this.mimeType, this.caption, this.width, this.height, this.seconds, this.contextInfo);
        }

        public String toString() {
            return "VideoMessage.NewVideoMessageBuilder(media=" + this.media + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", width=" + this.width + ", height=" + this.height + ", seconds=" + this.seconds + ", contextInfo=" + this.contextInfo + ")";
        }
    }

    public static class NewGifMessageBuilder {
        private byte @NonNull [] media;
        private String mimeType;
        private String caption;
        private int width;
        private int height;
        private VideoMessageAttribution gifAttribution;
        private ContextInfo contextInfo;

        NewGifMessageBuilder() {
        }

        public NewGifMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewGifMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewGifMessageBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public NewGifMessageBuilder width(int width) {
            this.width = width;
            return this;
        }

        public NewGifMessageBuilder height(int height) {
            this.height = height;
            return this;
        }

        public NewGifMessageBuilder gifAttribution(VideoMessageAttribution gifAttribution) {
            this.gifAttribution = gifAttribution;
            return this;
        }

        public NewGifMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public VideoMessage create() {
            return VideoMessage.gifBuilder(this.media, this.mimeType, this.caption, this.width, this.height, this.gifAttribution, this.contextInfo);
        }

        public String toString() {
            return "VideoMessage.NewGifMessageBuilder(media=" + this.media + ", mimeType=" + this.mimeType + ", caption=" + this.caption + ", width=" + this.width + ", height=" + this.height + ", gifAttribution=" + this.gifAttribution + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

