/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.standard;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public final class StickerMessage
extends MediaMessage {
    @JsonProperty(value="16")
    private byte[] pngThumbnail;
    @JsonProperty(value="13")
    private boolean isAnimated;
    @JsonProperty(value="12")
    private byte[] firstFrameSidecar;
    @JsonProperty(value="11")
    private int firstFrameLength;
    @JsonProperty(value="10")
    private long mediaKeyTimestamp;
    @JsonProperty(value="9")
    private long fileLength;
    @JsonProperty(value="8")
    private String directPath;
    @JsonProperty(value="7")
    private int width;
    @JsonProperty(value="6")
    private int height;
    @JsonProperty(value="5")
    private String mimetype;
    @JsonProperty(value="4")
    private byte[] mediaKey;
    @JsonProperty(value="3")
    private byte[] fileEncSha256;
    @JsonProperty(value="2")
    private byte[] fileSha256;
    @JsonProperty(value="1")
    private String url;

    private static StickerMessage builder(byte @NonNull [] media, String mimeType, byte[] pngThumbnail, boolean isAnimated, ContextInfo contextInfo) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.STICKER);
        return ((StickerMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)((StickerMessageBuilder)StickerMessage.builder().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.STICKER.defaultMimeType()))).firstFrameSidecar(upload.sidecar())).firstFrameLength(upload.sidecar().length)).isAnimated(isAnimated)).pngThumbnail(pngThumbnail)).contextInfo(contextInfo)).create();
    }

    private static StickerMessageBuilder<?, ?> builder() {
        return new StickerMessageBuilderImpl();
    }

    @Override
    @NonNull
    public MediaMessageType type() {
        return MediaMessageType.STICKER;
    }

    protected StickerMessage(StickerMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.pngThumbnail = b.pngThumbnail;
        this.isAnimated = b.isAnimated;
        this.firstFrameSidecar = b.firstFrameSidecar;
        this.firstFrameLength = b.firstFrameLength;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.fileLength = b.fileLength;
        this.directPath = b.directPath;
        this.width = b.width;
        this.height = b.height;
        this.mimetype = b.mimetype;
        this.mediaKey = b.mediaKey;
        this.fileEncSha256 = b.fileEncSha256;
        this.fileSha256 = b.fileSha256;
        this.url = b.url;
    }

    public static NewStickerMessageBuilder newStickerMessage() {
        return new NewStickerMessageBuilder();
    }

    public StickerMessage(byte[] pngThumbnail, boolean isAnimated, byte[] firstFrameSidecar, int firstFrameLength, long mediaKeyTimestamp, long fileLength, String directPath, int width, int height, String mimetype, byte[] mediaKey, byte[] fileEncSha256, byte[] fileSha256, String url) {
        this.pngThumbnail = pngThumbnail;
        this.isAnimated = isAnimated;
        this.firstFrameSidecar = firstFrameSidecar;
        this.firstFrameLength = firstFrameLength;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.fileLength = fileLength;
        this.directPath = directPath;
        this.width = width;
        this.height = height;
        this.mimetype = mimetype;
        this.mediaKey = mediaKey;
        this.fileEncSha256 = fileEncSha256;
        this.fileSha256 = fileSha256;
        this.url = url;
    }

    public StickerMessage() {
    }

    public byte[] pngThumbnail() {
        return this.pngThumbnail;
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }

    public byte[] firstFrameSidecar() {
        return this.firstFrameSidecar;
    }

    public int firstFrameLength() {
        return this.firstFrameLength;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    @Override
    public long fileLength() {
        return this.fileLength;
    }

    @Override
    public String directPath() {
        return this.directPath;
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    @Override
    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    @Override
    public byte[] fileSha256() {
        return this.fileSha256;
    }

    @Override
    public String url() {
        return this.url;
    }

    @JsonProperty(value="16")
    public StickerMessage pngThumbnail(byte[] pngThumbnail) {
        this.pngThumbnail = pngThumbnail;
        return this;
    }

    @JsonProperty(value="13")
    public StickerMessage isAnimated(boolean isAnimated) {
        this.isAnimated = isAnimated;
        return this;
    }

    @JsonProperty(value="12")
    public StickerMessage firstFrameSidecar(byte[] firstFrameSidecar) {
        this.firstFrameSidecar = firstFrameSidecar;
        return this;
    }

    @JsonProperty(value="11")
    public StickerMessage firstFrameLength(int firstFrameLength) {
        this.firstFrameLength = firstFrameLength;
        return this;
    }

    @JsonProperty(value="10")
    public StickerMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    @JsonProperty(value="9")
    public StickerMessage fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="8")
    public StickerMessage directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="7")
    public StickerMessage width(int width) {
        this.width = width;
        return this;
    }

    @JsonProperty(value="6")
    public StickerMessage height(int height) {
        this.height = height;
        return this;
    }

    @JsonProperty(value="5")
    public StickerMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @JsonProperty(value="4")
    public StickerMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="3")
    public StickerMessage fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="2")
    public StickerMessage fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    @JsonProperty(value="1")
    public StickerMessage url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return "StickerMessage(pngThumbnail=" + Arrays.toString(this.pngThumbnail()) + ", isAnimated=" + this.isAnimated() + ", firstFrameSidecar=" + Arrays.toString(this.firstFrameSidecar()) + ", firstFrameLength=" + this.firstFrameLength() + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", fileLength=" + this.fileLength() + ", directPath=" + this.directPath() + ", width=" + this.width() + ", height=" + this.height() + ", mimetype=" + this.mimetype() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", url=" + this.url() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StickerMessage)) {
            return false;
        }
        StickerMessage other = (StickerMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAnimated() != other.isAnimated()) {
            return false;
        }
        if (this.firstFrameLength() != other.firstFrameLength()) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        if (this.width() != other.width()) {
            return false;
        }
        if (this.height() != other.height()) {
            return false;
        }
        if (!Arrays.equals(this.pngThumbnail(), other.pngThumbnail())) {
            return false;
        }
        if (!Arrays.equals(this.firstFrameSidecar(), other.firstFrameSidecar())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof StickerMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAnimated() ? 79 : 97);
        result = result * 59 + this.firstFrameLength();
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        result = result * 59 + this.width();
        result = result * 59 + this.height();
        result = result * 59 + Arrays.hashCode(this.pngThumbnail());
        result = result * 59 + Arrays.hashCode(this.firstFrameSidecar());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class StickerMessageBuilder<C extends StickerMessage, B extends StickerMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private byte[] pngThumbnail;
        private boolean isAnimated;
        private byte[] firstFrameSidecar;
        private int firstFrameLength;
        private long mediaKeyTimestamp;
        private long fileLength;
        private String directPath;
        private int width;
        private int height;
        private String mimetype;
        private byte[] mediaKey;
        private byte[] fileEncSha256;
        private byte[] fileSha256;
        private String url;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        @JsonProperty(value="16")
        public B pngThumbnail(byte[] pngThumbnail) {
            this.pngThumbnail = pngThumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="13")
        public B isAnimated(boolean isAnimated) {
            this.isAnimated = isAnimated;
            return (B)this.self();
        }

        @JsonProperty(value="12")
        public B firstFrameSidecar(byte[] firstFrameSidecar) {
            this.firstFrameSidecar = firstFrameSidecar;
            return (B)this.self();
        }

        @JsonProperty(value="11")
        public B firstFrameLength(int firstFrameLength) {
            this.firstFrameLength = firstFrameLength;
            return (B)this.self();
        }

        @JsonProperty(value="10")
        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="9")
        public B fileLength(long fileLength) {
            this.fileLength = fileLength;
            return (B)this.self();
        }

        @JsonProperty(value="8")
        public B directPath(String directPath) {
            this.directPath = directPath;
            return (B)this.self();
        }

        @JsonProperty(value="7")
        public B width(int width) {
            this.width = width;
            return (B)this.self();
        }

        @JsonProperty(value="6")
        public B height(int height) {
            this.height = height;
            return (B)this.self();
        }

        @JsonProperty(value="5")
        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        @JsonProperty(value="4")
        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        @JsonProperty(value="3")
        public B fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="2")
        public B fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="1")
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "StickerMessage.StickerMessageBuilder(super=" + super.toString() + ", pngThumbnail=" + Arrays.toString(this.pngThumbnail) + ", isAnimated=" + this.isAnimated + ", firstFrameSidecar=" + Arrays.toString(this.firstFrameSidecar) + ", firstFrameLength=" + this.firstFrameLength + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", fileLength=" + this.fileLength + ", directPath=" + this.directPath + ", width=" + this.width + ", height=" + this.height + ", mimetype=" + this.mimetype + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", url=" + this.url + ")";
        }
    }

    private static final class StickerMessageBuilderImpl
    extends StickerMessageBuilder<StickerMessage, StickerMessageBuilderImpl> {
        private StickerMessageBuilderImpl() {
        }

        @Override
        protected StickerMessageBuilderImpl self() {
            return this;
        }

        @Override
        public StickerMessage create() {
            return new StickerMessage(this);
        }
    }

    public static class NewStickerMessageBuilder {
        private byte @NonNull [] media;
        private String mimeType;
        private byte[] pngThumbnail;
        private boolean isAnimated;
        private ContextInfo contextInfo;

        NewStickerMessageBuilder() {
        }

        public NewStickerMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewStickerMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewStickerMessageBuilder pngThumbnail(byte[] pngThumbnail) {
            this.pngThumbnail = pngThumbnail;
            return this;
        }

        public NewStickerMessageBuilder isAnimated(boolean isAnimated) {
            this.isAnimated = isAnimated;
            return this;
        }

        public NewStickerMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public StickerMessage create() {
            return StickerMessage.builder(this.media, this.mimeType, this.pngThumbnail, this.isAnimated, this.contextInfo);
        }

        public String toString() {
            return "StickerMessage.NewStickerMessageBuilder(media=" + this.media + ", mimeType=" + this.mimeType + ", pngThumbnail=" + Arrays.toString(this.pngThumbnail) + ", isAnimated=" + this.isAnimated + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

