/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.standard;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.media.MediaUpload;
import it.auties.whatsapp4j.protobuf.info.ContextInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessage;
import it.auties.whatsapp4j.protobuf.message.model.MediaMessageType;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Optional;
import lombok.NonNull;

public final class DocumentMessage
extends MediaMessage {
    @JsonProperty(value="16")
    private byte[] jpegThumbnail;
    @JsonProperty(value="11")
    private long mediaKeyTimestamp;
    @JsonProperty(value="10")
    private String directPath;
    @JsonProperty(value="9")
    private byte[] fileEncSha256;
    @JsonProperty(value="8")
    private String fileName;
    @JsonProperty(value="7")
    private byte[] mediaKey;
    @JsonProperty(value="6")
    private int pageCount;
    @JsonProperty(value="5")
    private long fileLength;
    @JsonProperty(value="4")
    private byte[] fileSha256;
    @JsonProperty(value="3")
    private String title;
    @JsonProperty(value="2")
    private String mimetype;
    @JsonProperty(value="1")
    private String url;

    private static DocumentMessage builder(byte @NonNull [] media, String mimeType, String title, int pageCount, String fileName, byte[] jpegThumbnail, ContextInfo contextInfo) {
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        MediaUpload upload = CypherUtils.mediaEncrypt(media, MediaMessageType.DOCUMENT);
        return ((DocumentMessageBuilder)((ContextualMessage.ContextualMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)((DocumentMessageBuilder)DocumentMessage.builder().fileSha256(upload.fileSha256())).fileEncSha256(upload.fileEncSha256())).mediaKey(upload.mediaKey().data())).mediaKeyTimestamp(ZonedDateTime.now().toEpochSecond())).url(upload.url())).directPath(upload.directPath())).fileLength(media.length)).mimetype(Optional.ofNullable(mimeType).orElse(MediaMessageType.DOCUMENT.defaultMimeType()))).fileName(fileName)).pageCount(pageCount)).jpegThumbnail(jpegThumbnail)).contextInfo(contextInfo)).create();
    }

    private static DocumentMessageBuilder<?, ?> builder() {
        return new DocumentMessageBuilderImpl();
    }

    @Override
    @NonNull
    public MediaMessageType type() {
        return MediaMessageType.DOCUMENT;
    }

    protected DocumentMessage(DocumentMessageBuilder<?, ?> b) {
        super((MediaMessage.MediaMessageBuilder<?, ?>)b);
        this.jpegThumbnail = b.jpegThumbnail;
        this.mediaKeyTimestamp = b.mediaKeyTimestamp;
        this.directPath = b.directPath;
        this.fileEncSha256 = b.fileEncSha256;
        this.fileName = b.fileName;
        this.mediaKey = b.mediaKey;
        this.pageCount = b.pageCount;
        this.fileLength = b.fileLength;
        this.fileSha256 = b.fileSha256;
        this.title = b.title;
        this.mimetype = b.mimetype;
        this.url = b.url;
    }

    public static NewDocumentMessageBuilder newDocumentMessage() {
        return new NewDocumentMessageBuilder();
    }

    public DocumentMessage(byte[] jpegThumbnail, long mediaKeyTimestamp, String directPath, byte[] fileEncSha256, String fileName, byte[] mediaKey, int pageCount, long fileLength, byte[] fileSha256, String title, String mimetype, String url) {
        this.jpegThumbnail = jpegThumbnail;
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        this.directPath = directPath;
        this.fileEncSha256 = fileEncSha256;
        this.fileName = fileName;
        this.mediaKey = mediaKey;
        this.pageCount = pageCount;
        this.fileLength = fileLength;
        this.fileSha256 = fileSha256;
        this.title = title;
        this.mimetype = mimetype;
        this.url = url;
    }

    public DocumentMessage() {
    }

    public byte[] jpegThumbnail() {
        return this.jpegThumbnail;
    }

    @Override
    public long mediaKeyTimestamp() {
        return this.mediaKeyTimestamp;
    }

    @Override
    public String directPath() {
        return this.directPath;
    }

    @Override
    public byte[] fileEncSha256() {
        return this.fileEncSha256;
    }

    public String fileName() {
        return this.fileName;
    }

    @Override
    public byte[] mediaKey() {
        return this.mediaKey;
    }

    public int pageCount() {
        return this.pageCount;
    }

    @Override
    public long fileLength() {
        return this.fileLength;
    }

    @Override
    public byte[] fileSha256() {
        return this.fileSha256;
    }

    public String title() {
        return this.title;
    }

    public String mimetype() {
        return this.mimetype;
    }

    @Override
    public String url() {
        return this.url;
    }

    @JsonProperty(value="16")
    public DocumentMessage jpegThumbnail(byte[] jpegThumbnail) {
        this.jpegThumbnail = jpegThumbnail;
        return this;
    }

    @JsonProperty(value="11")
    public DocumentMessage mediaKeyTimestamp(long mediaKeyTimestamp) {
        this.mediaKeyTimestamp = mediaKeyTimestamp;
        return this;
    }

    @JsonProperty(value="10")
    public DocumentMessage directPath(String directPath) {
        this.directPath = directPath;
        return this;
    }

    @JsonProperty(value="9")
    public DocumentMessage fileEncSha256(byte[] fileEncSha256) {
        this.fileEncSha256 = fileEncSha256;
        return this;
    }

    @JsonProperty(value="8")
    public DocumentMessage fileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    @JsonProperty(value="7")
    public DocumentMessage mediaKey(byte[] mediaKey) {
        this.mediaKey = mediaKey;
        return this;
    }

    @JsonProperty(value="6")
    public DocumentMessage pageCount(int pageCount) {
        this.pageCount = pageCount;
        return this;
    }

    @JsonProperty(value="5")
    public DocumentMessage fileLength(long fileLength) {
        this.fileLength = fileLength;
        return this;
    }

    @JsonProperty(value="4")
    public DocumentMessage fileSha256(byte[] fileSha256) {
        this.fileSha256 = fileSha256;
        return this;
    }

    @JsonProperty(value="3")
    public DocumentMessage title(String title) {
        this.title = title;
        return this;
    }

    @JsonProperty(value="2")
    public DocumentMessage mimetype(String mimetype) {
        this.mimetype = mimetype;
        return this;
    }

    @JsonProperty(value="1")
    public DocumentMessage url(String url) {
        this.url = url;
        return this;
    }

    @Override
    public String toString() {
        return "DocumentMessage(jpegThumbnail=" + Arrays.toString(this.jpegThumbnail()) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp() + ", directPath=" + this.directPath() + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256()) + ", fileName=" + this.fileName() + ", mediaKey=" + Arrays.toString(this.mediaKey()) + ", pageCount=" + this.pageCount() + ", fileLength=" + this.fileLength() + ", fileSha256=" + Arrays.toString(this.fileSha256()) + ", title=" + this.title() + ", mimetype=" + this.mimetype() + ", url=" + this.url() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DocumentMessage)) {
            return false;
        }
        DocumentMessage other = (DocumentMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.mediaKeyTimestamp() != other.mediaKeyTimestamp()) {
            return false;
        }
        if (this.pageCount() != other.pageCount()) {
            return false;
        }
        if (this.fileLength() != other.fileLength()) {
            return false;
        }
        if (!Arrays.equals(this.jpegThumbnail(), other.jpegThumbnail())) {
            return false;
        }
        String this$directPath = this.directPath();
        String other$directPath = other.directPath();
        if (this$directPath == null ? other$directPath != null : !this$directPath.equals(other$directPath)) {
            return false;
        }
        if (!Arrays.equals(this.fileEncSha256(), other.fileEncSha256())) {
            return false;
        }
        String this$fileName = this.fileName();
        String other$fileName = other.fileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        if (!Arrays.equals(this.mediaKey(), other.mediaKey())) {
            return false;
        }
        if (!Arrays.equals(this.fileSha256(), other.fileSha256())) {
            return false;
        }
        String this$title = this.title();
        String other$title = other.title();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$mimetype = this.mimetype();
        String other$mimetype = other.mimetype();
        if (this$mimetype == null ? other$mimetype != null : !this$mimetype.equals(other$mimetype)) {
            return false;
        }
        String this$url = this.url();
        String other$url = other.url();
        return !(this$url == null ? other$url != null : !this$url.equals(other$url));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DocumentMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $mediaKeyTimestamp = this.mediaKeyTimestamp();
        result = result * 59 + (int)($mediaKeyTimestamp >>> 32 ^ $mediaKeyTimestamp);
        result = result * 59 + this.pageCount();
        long $fileLength = this.fileLength();
        result = result * 59 + (int)($fileLength >>> 32 ^ $fileLength);
        result = result * 59 + Arrays.hashCode(this.jpegThumbnail());
        String $directPath = this.directPath();
        result = result * 59 + ($directPath == null ? 43 : $directPath.hashCode());
        result = result * 59 + Arrays.hashCode(this.fileEncSha256());
        String $fileName = this.fileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaKey());
        result = result * 59 + Arrays.hashCode(this.fileSha256());
        String $title = this.title();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $mimetype = this.mimetype();
        result = result * 59 + ($mimetype == null ? 43 : $mimetype.hashCode());
        String $url = this.url();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    public static abstract class DocumentMessageBuilder<C extends DocumentMessage, B extends DocumentMessageBuilder<C, B>>
    extends MediaMessage.MediaMessageBuilder<C, B> {
        private byte[] jpegThumbnail;
        private long mediaKeyTimestamp;
        private String directPath;
        private byte[] fileEncSha256;
        private String fileName;
        private byte[] mediaKey;
        private int pageCount;
        private long fileLength;
        private byte[] fileSha256;
        private String title;
        private String mimetype;
        private String url;

        @Override
        protected abstract B self();

        @Override
        public abstract C create();

        @JsonProperty(value="16")
        public B jpegThumbnail(byte[] jpegThumbnail) {
            this.jpegThumbnail = jpegThumbnail;
            return (B)this.self();
        }

        @JsonProperty(value="11")
        public B mediaKeyTimestamp(long mediaKeyTimestamp) {
            this.mediaKeyTimestamp = mediaKeyTimestamp;
            return (B)this.self();
        }

        @JsonProperty(value="10")
        public B directPath(String directPath) {
            this.directPath = directPath;
            return (B)this.self();
        }

        @JsonProperty(value="9")
        public B fileEncSha256(byte[] fileEncSha256) {
            this.fileEncSha256 = fileEncSha256;
            return (B)this.self();
        }

        @JsonProperty(value="8")
        public B fileName(String fileName) {
            this.fileName = fileName;
            return (B)this.self();
        }

        @JsonProperty(value="7")
        public B mediaKey(byte[] mediaKey) {
            this.mediaKey = mediaKey;
            return (B)this.self();
        }

        @JsonProperty(value="6")
        public B pageCount(int pageCount) {
            this.pageCount = pageCount;
            return (B)this.self();
        }

        @JsonProperty(value="5")
        public B fileLength(long fileLength) {
            this.fileLength = fileLength;
            return (B)this.self();
        }

        @JsonProperty(value="4")
        public B fileSha256(byte[] fileSha256) {
            this.fileSha256 = fileSha256;
            return (B)this.self();
        }

        @JsonProperty(value="3")
        public B title(String title) {
            this.title = title;
            return (B)this.self();
        }

        @JsonProperty(value="2")
        public B mimetype(String mimetype) {
            this.mimetype = mimetype;
            return (B)this.self();
        }

        @JsonProperty(value="1")
        public B url(String url) {
            this.url = url;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DocumentMessage.DocumentMessageBuilder(super=" + super.toString() + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail) + ", mediaKeyTimestamp=" + this.mediaKeyTimestamp + ", directPath=" + this.directPath + ", fileEncSha256=" + Arrays.toString(this.fileEncSha256) + ", fileName=" + this.fileName + ", mediaKey=" + Arrays.toString(this.mediaKey) + ", pageCount=" + this.pageCount + ", fileLength=" + this.fileLength + ", fileSha256=" + Arrays.toString(this.fileSha256) + ", title=" + this.title + ", mimetype=" + this.mimetype + ", url=" + this.url + ")";
        }
    }

    private static final class DocumentMessageBuilderImpl
    extends DocumentMessageBuilder<DocumentMessage, DocumentMessageBuilderImpl> {
        private DocumentMessageBuilderImpl() {
        }

        @Override
        protected DocumentMessageBuilderImpl self() {
            return this;
        }

        @Override
        public DocumentMessage create() {
            return new DocumentMessage(this);
        }
    }

    public static class NewDocumentMessageBuilder {
        private byte @NonNull [] media;
        private String mimeType;
        private String title;
        private int pageCount;
        private String fileName;
        private byte[] jpegThumbnail;
        private ContextInfo contextInfo;

        NewDocumentMessageBuilder() {
        }

        public NewDocumentMessageBuilder media(byte @NonNull [] media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public NewDocumentMessageBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public NewDocumentMessageBuilder title(String title) {
            this.title = title;
            return this;
        }

        public NewDocumentMessageBuilder pageCount(int pageCount) {
            this.pageCount = pageCount;
            return this;
        }

        public NewDocumentMessageBuilder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public NewDocumentMessageBuilder jpegThumbnail(byte[] jpegThumbnail) {
            this.jpegThumbnail = jpegThumbnail;
            return this;
        }

        public NewDocumentMessageBuilder contextInfo(ContextInfo contextInfo) {
            this.contextInfo = contextInfo;
            return this;
        }

        public DocumentMessage create() {
            return DocumentMessage.builder(this.media, this.mimeType, this.title, this.pageCount, this.fileName, this.jpegThumbnail, this.contextInfo);
        }

        public String toString() {
            return "DocumentMessage.NewDocumentMessageBuilder(media=" + this.media + ", mimeType=" + this.mimeType + ", title=" + this.title + ", pageCount=" + this.pageCount + ", fileName=" + this.fileName + ", jpegThumbnail=" + Arrays.toString(this.jpegThumbnail) + ", contextInfo=" + this.contextInfo + ")";
        }
    }
}

