/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.protobuf.chat.Chat;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import java.util.Optional;
import lombok.NonNull;

public class MessageKey {
    @JsonProperty(value="3")
    private String id;
    @JsonProperty(value="1")
    private String chatJid;
    @JsonProperty(value="2")
    private boolean fromMe;

    public MessageKey(@NonNull Chat chat) {
        this(WhatsappUtils.randomId(), chat.jid(), true);
        if (chat == null) {
            throw new NullPointerException("chat is marked non-null but is null");
        }
    }

    public Optional<Chat> chat() {
        return WhatsappDataManager.singletonInstance().findChatByJid(this.chatJid);
    }

    private static String $default$id() {
        return WhatsappUtils.randomId();
    }

    public static MessageKeyBuilder newMessageKey() {
        return new MessageKeyBuilder();
    }

    public MessageKey(String id, String chatJid, boolean fromMe) {
        this.id = id;
        this.chatJid = chatJid;
        this.fromMe = fromMe;
    }

    public MessageKey() {
        this.id = MessageKey.$default$id();
    }

    public String id() {
        return this.id;
    }

    public String chatJid() {
        return this.chatJid;
    }

    public boolean fromMe() {
        return this.fromMe;
    }

    @JsonProperty(value="3")
    public MessageKey id(String id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="1")
    public MessageKey chatJid(String chatJid) {
        this.chatJid = chatJid;
        return this;
    }

    @JsonProperty(value="2")
    public MessageKey fromMe(boolean fromMe) {
        this.fromMe = fromMe;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageKey)) {
            return false;
        }
        MessageKey other = (MessageKey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.fromMe() != other.fromMe()) {
            return false;
        }
        String this$id = this.id();
        String other$id = other.id();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$chatJid = this.chatJid();
        String other$chatJid = other.chatJid();
        return !(this$chatJid == null ? other$chatJid != null : !this$chatJid.equals(other$chatJid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageKey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.fromMe() ? 79 : 97);
        String $id = this.id();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $chatJid = this.chatJid();
        result = result * 59 + ($chatJid == null ? 43 : $chatJid.hashCode());
        return result;
    }

    public String toString() {
        return "MessageKey(id=" + this.id() + ", chatJid=" + this.chatJid() + ", fromMe=" + this.fromMe() + ")";
    }

    public static class MessageKeyBuilder {
        private boolean id$set;
        private String id$value;
        private String chatJid;
        private boolean fromMe;

        MessageKeyBuilder() {
        }

        @JsonProperty(value="3")
        public MessageKeyBuilder id(String id) {
            this.id$value = id;
            this.id$set = true;
            return this;
        }

        @JsonProperty(value="1")
        public MessageKeyBuilder chatJid(String chatJid) {
            this.chatJid = chatJid;
            return this;
        }

        @JsonProperty(value="2")
        public MessageKeyBuilder fromMe(boolean fromMe) {
            this.fromMe = fromMe;
            return this;
        }

        public MessageKey create() {
            String id$value = this.id$value;
            if (!this.id$set) {
                id$value = MessageKey.$default$id();
            }
            return new MessageKey(id$value, this.chatJid, this.fromMe);
        }

        public String toString() {
            return "MessageKey.MessageKeyBuilder(id$value=" + this.id$value + ", chatJid=" + this.chatJid + ", fromMe=" + this.fromMe + ")";
        }
    }
}

