/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.message.model;

import lombok.NonNull;

public enum MediaMessageType {
    IMAGE("image/jpeg"),
    DOCUMENT("application/octet-stream"),
    AUDIO("audio/mpeg"),
    VIDEO("video/mp4"),
    STICKER("image/webp");

    private static final String WHATSAPP_URL = "https://media-mxp1-1.cdn.whatsapp.net/mms/%s";
    @NonNull
    private final String defaultMimeType;

    public byte @NonNull [] key() {
        String name = this.whatsappName();
        return "WhatsApp %s Keys".formatted(Character.toUpperCase(name.charAt(0)) + name.substring(1)).getBytes();
    }

    @NonNull
    public String url() {
        return WHATSAPP_URL.formatted(this.whatsappName());
    }

    @NonNull
    public String whatsappName() {
        return this == STICKER ? IMAGE.whatsappName() : this.name().toLowerCase();
    }

    private MediaMessageType(String defaultMimeType) {
        if (defaultMimeType == null) {
            throw new NullPointerException("defaultMimeType is marked non-null but is null");
        }
        this.defaultMimeType = defaultMimeType;
    }

    @NonNull
    public String defaultMimeType() {
        return this.defaultMimeType;
    }
}

