/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.info;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.manager.WhatsappDataManager;
import it.auties.whatsapp4j.protobuf.chat.Chat;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.info.PaymentInfo;
import it.auties.whatsapp4j.protobuf.message.model.ContextualMessage;
import it.auties.whatsapp4j.protobuf.message.model.MessageContainer;
import it.auties.whatsapp4j.protobuf.message.model.MessageKey;
import it.auties.whatsapp4j.protobuf.message.standard.LiveLocationMessage;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class MessageInfo {
    private static final WhatsappDataManager MANAGER = WhatsappDataManager.singletonInstance();
    @JsonProperty(value="33")
    private int ephemeralDuration;
    @JsonProperty(value="32")
    private long ephemeralStartTimestamp;
    @JsonProperty(value="31")
    private PaymentInfo quotedPaymentInfo;
    @JsonProperty(value="30")
    private LiveLocationMessage finalLiveLocation;
    @JsonProperty(value="29")
    private PaymentInfo paymentInfo;
    @JsonProperty(value="28")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> labels;
    @JsonProperty(value="27")
    private int duration;
    @JsonProperty(value="26")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> messageStubParameters;
    @JsonProperty(value="25")
    private boolean clearMedia;
    @JsonProperty(value="24")
    private MessageInfoStubType messageStubType;
    @JsonProperty(value="23")
    private boolean urlNumber;
    @JsonProperty(value="22")
    private boolean urlText;
    @JsonProperty(value="21")
    private boolean multicast;
    @JsonProperty(value="20")
    private byte[] mediaCiphertextSha256;
    @JsonProperty(value="19")
    private String pushName;
    @JsonProperty(value="18")
    private boolean broadcast;
    @JsonProperty(value="17")
    private boolean starred;
    @JsonProperty(value="16")
    private boolean ignore;
    @JsonProperty(value="5")
    private String senderJid;
    @JsonProperty(value="4")
    @NonNull
    private MessageInfoStatus globalStatus;
    @NonNull
    private Map<Contact, MessageInfoStatus> individualReadStatus;
    @JsonProperty(value="3")
    private long timestamp;
    @JsonProperty(value="2")
    @NonNull
    private MessageContainer container;
    @JsonProperty(value="1", required=true)
    @NonNull
    private MessageKey key;

    public MessageInfo(@NonNull MessageKey key, @NonNull MessageContainer container) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        this.key = key;
        this.timestamp = Instant.now().getEpochSecond();
        this.globalStatus = MessageInfoStatus.PENDING;
        this.container = container;
        this.individualReadStatus = new HashMap<Contact, MessageInfoStatus>();
    }

    @NonNull
    public String chatJid() {
        return this.key().chatJid();
    }

    @NonNull
    public Optional<Chat> chat() {
        return this.key().chat();
    }

    @NonNull
    public String senderJid() {
        return this.key.fromMe() ? MANAGER.phoneNumberJid() : Optional.ofNullable(this.senderJid).orElse(this.key.chatJid());
    }

    @NonNull
    public Optional<Contact> sender() {
        return MANAGER.findContactByJid(this.senderJid());
    }

    @NonNull
    public Optional<MessageInfo> quotedMessage() {
        return Optional.of(this.container).flatMap(MessageContainer::populatedContextualMessage).map(ContextualMessage::contextInfo).flatMap(contextualMessage -> MANAGER.findMessageById(this.key.chat().orElseThrow(), contextualMessage.quotedMessageId()));
    }

    private static MessageInfoStatus $default$globalStatus() {
        return MessageInfoStatus.ERROR;
    }

    private static Map<Contact, MessageInfoStatus> $default$individualReadStatus() {
        return new HashMap<Contact, MessageInfoStatus>();
    }

    private static MessageContainer $default$container() {
        return new MessageContainer();
    }

    public static MessageInfoBuilder newMessageInfo() {
        return new MessageInfoBuilder();
    }

    public MessageInfo(int ephemeralDuration, long ephemeralStartTimestamp, PaymentInfo quotedPaymentInfo, LiveLocationMessage finalLiveLocation, PaymentInfo paymentInfo, List<String> labels, int duration, List<String> messageStubParameters, boolean clearMedia, MessageInfoStubType messageStubType, boolean urlNumber, boolean urlText, boolean multicast, byte[] mediaCiphertextSha256, String pushName, boolean broadcast, boolean starred, boolean ignore, String senderJid, @NonNull MessageInfoStatus globalStatus, @NonNull Map<Contact, MessageInfoStatus> individualReadStatus, long timestamp, @NonNull MessageContainer container, @NonNull MessageKey key) {
        if (globalStatus == null) {
            throw new NullPointerException("globalStatus is marked non-null but is null");
        }
        if (individualReadStatus == null) {
            throw new NullPointerException("individualReadStatus is marked non-null but is null");
        }
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.ephemeralDuration = ephemeralDuration;
        this.ephemeralStartTimestamp = ephemeralStartTimestamp;
        this.quotedPaymentInfo = quotedPaymentInfo;
        this.finalLiveLocation = finalLiveLocation;
        this.paymentInfo = paymentInfo;
        this.labels = labels;
        this.duration = duration;
        this.messageStubParameters = messageStubParameters;
        this.clearMedia = clearMedia;
        this.messageStubType = messageStubType;
        this.urlNumber = urlNumber;
        this.urlText = urlText;
        this.multicast = multicast;
        this.mediaCiphertextSha256 = mediaCiphertextSha256;
        this.pushName = pushName;
        this.broadcast = broadcast;
        this.starred = starred;
        this.ignore = ignore;
        this.senderJid = senderJid;
        this.globalStatus = globalStatus;
        this.individualReadStatus = individualReadStatus;
        this.timestamp = timestamp;
        this.container = container;
        this.key = key;
    }

    public MessageInfo() {
        this.globalStatus = MessageInfo.$default$globalStatus();
        this.individualReadStatus = MessageInfo.$default$individualReadStatus();
        this.container = MessageInfo.$default$container();
    }

    public int ephemeralDuration() {
        return this.ephemeralDuration;
    }

    public long ephemeralStartTimestamp() {
        return this.ephemeralStartTimestamp;
    }

    public PaymentInfo quotedPaymentInfo() {
        return this.quotedPaymentInfo;
    }

    public LiveLocationMessage finalLiveLocation() {
        return this.finalLiveLocation;
    }

    public PaymentInfo paymentInfo() {
        return this.paymentInfo;
    }

    public List<String> labels() {
        return this.labels;
    }

    public int duration() {
        return this.duration;
    }

    public List<String> messageStubParameters() {
        return this.messageStubParameters;
    }

    public boolean clearMedia() {
        return this.clearMedia;
    }

    public MessageInfoStubType messageStubType() {
        return this.messageStubType;
    }

    public boolean urlNumber() {
        return this.urlNumber;
    }

    public boolean urlText() {
        return this.urlText;
    }

    public boolean multicast() {
        return this.multicast;
    }

    public byte[] mediaCiphertextSha256() {
        return this.mediaCiphertextSha256;
    }

    public String pushName() {
        return this.pushName;
    }

    public boolean broadcast() {
        return this.broadcast;
    }

    public boolean starred() {
        return this.starred;
    }

    public boolean ignore() {
        return this.ignore;
    }

    @NonNull
    public MessageInfoStatus globalStatus() {
        return this.globalStatus;
    }

    @NonNull
    public Map<Contact, MessageInfoStatus> individualReadStatus() {
        return this.individualReadStatus;
    }

    public long timestamp() {
        return this.timestamp;
    }

    @NonNull
    public MessageContainer container() {
        return this.container;
    }

    @NonNull
    public MessageKey key() {
        return this.key;
    }

    @JsonProperty(value="33")
    public MessageInfo ephemeralDuration(int ephemeralDuration) {
        this.ephemeralDuration = ephemeralDuration;
        return this;
    }

    @JsonProperty(value="32")
    public MessageInfo ephemeralStartTimestamp(long ephemeralStartTimestamp) {
        this.ephemeralStartTimestamp = ephemeralStartTimestamp;
        return this;
    }

    @JsonProperty(value="31")
    public MessageInfo quotedPaymentInfo(PaymentInfo quotedPaymentInfo) {
        this.quotedPaymentInfo = quotedPaymentInfo;
        return this;
    }

    @JsonProperty(value="30")
    public MessageInfo finalLiveLocation(LiveLocationMessage finalLiveLocation) {
        this.finalLiveLocation = finalLiveLocation;
        return this;
    }

    @JsonProperty(value="29")
    public MessageInfo paymentInfo(PaymentInfo paymentInfo) {
        this.paymentInfo = paymentInfo;
        return this;
    }

    @JsonProperty(value="28")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public MessageInfo labels(List<String> labels) {
        this.labels = labels;
        return this;
    }

    @JsonProperty(value="27")
    public MessageInfo duration(int duration) {
        this.duration = duration;
        return this;
    }

    @JsonProperty(value="26")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public MessageInfo messageStubParameters(List<String> messageStubParameters) {
        this.messageStubParameters = messageStubParameters;
        return this;
    }

    @JsonProperty(value="25")
    public MessageInfo clearMedia(boolean clearMedia) {
        this.clearMedia = clearMedia;
        return this;
    }

    @JsonProperty(value="24")
    public MessageInfo messageStubType(MessageInfoStubType messageStubType) {
        this.messageStubType = messageStubType;
        return this;
    }

    @JsonProperty(value="23")
    public MessageInfo urlNumber(boolean urlNumber) {
        this.urlNumber = urlNumber;
        return this;
    }

    @JsonProperty(value="22")
    public MessageInfo urlText(boolean urlText) {
        this.urlText = urlText;
        return this;
    }

    @JsonProperty(value="21")
    public MessageInfo multicast(boolean multicast) {
        this.multicast = multicast;
        return this;
    }

    @JsonProperty(value="20")
    public MessageInfo mediaCiphertextSha256(byte[] mediaCiphertextSha256) {
        this.mediaCiphertextSha256 = mediaCiphertextSha256;
        return this;
    }

    @JsonProperty(value="19")
    public MessageInfo pushName(String pushName) {
        this.pushName = pushName;
        return this;
    }

    @JsonProperty(value="18")
    public MessageInfo broadcast(boolean broadcast) {
        this.broadcast = broadcast;
        return this;
    }

    @JsonProperty(value="17")
    public MessageInfo starred(boolean starred) {
        this.starred = starred;
        return this;
    }

    @JsonProperty(value="16")
    public MessageInfo ignore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    @JsonProperty(value="5")
    public MessageInfo senderJid(String senderJid) {
        this.senderJid = senderJid;
        return this;
    }

    @JsonProperty(value="4")
    public MessageInfo globalStatus(@NonNull MessageInfoStatus globalStatus) {
        if (globalStatus == null) {
            throw new NullPointerException("globalStatus is marked non-null but is null");
        }
        this.globalStatus = globalStatus;
        return this;
    }

    public MessageInfo individualReadStatus(@NonNull Map<Contact, MessageInfoStatus> individualReadStatus) {
        if (individualReadStatus == null) {
            throw new NullPointerException("individualReadStatus is marked non-null but is null");
        }
        this.individualReadStatus = individualReadStatus;
        return this;
    }

    @JsonProperty(value="3")
    public MessageInfo timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    @JsonProperty(value="2")
    public MessageInfo container(@NonNull MessageContainer container) {
        if (container == null) {
            throw new NullPointerException("container is marked non-null but is null");
        }
        this.container = container;
        return this;
    }

    @JsonProperty(value="1", required=true)
    public MessageInfo key(@NonNull MessageKey key) {
        if (key == null) {
            throw new NullPointerException("key is marked non-null but is null");
        }
        this.key = key;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MessageInfo)) {
            return false;
        }
        MessageInfo other = (MessageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.ephemeralDuration() != other.ephemeralDuration()) {
            return false;
        }
        if (this.ephemeralStartTimestamp() != other.ephemeralStartTimestamp()) {
            return false;
        }
        if (this.duration() != other.duration()) {
            return false;
        }
        if (this.clearMedia() != other.clearMedia()) {
            return false;
        }
        if (this.urlNumber() != other.urlNumber()) {
            return false;
        }
        if (this.urlText() != other.urlText()) {
            return false;
        }
        if (this.multicast() != other.multicast()) {
            return false;
        }
        if (this.broadcast() != other.broadcast()) {
            return false;
        }
        if (this.starred() != other.starred()) {
            return false;
        }
        if (this.ignore() != other.ignore()) {
            return false;
        }
        if (this.timestamp() != other.timestamp()) {
            return false;
        }
        PaymentInfo this$quotedPaymentInfo = this.quotedPaymentInfo();
        PaymentInfo other$quotedPaymentInfo = other.quotedPaymentInfo();
        if (this$quotedPaymentInfo == null ? other$quotedPaymentInfo != null : !((Object)this$quotedPaymentInfo).equals(other$quotedPaymentInfo)) {
            return false;
        }
        LiveLocationMessage this$finalLiveLocation = this.finalLiveLocation();
        LiveLocationMessage other$finalLiveLocation = other.finalLiveLocation();
        if (this$finalLiveLocation == null ? other$finalLiveLocation != null : !((Object)this$finalLiveLocation).equals(other$finalLiveLocation)) {
            return false;
        }
        PaymentInfo this$paymentInfo = this.paymentInfo();
        PaymentInfo other$paymentInfo = other.paymentInfo();
        if (this$paymentInfo == null ? other$paymentInfo != null : !((Object)this$paymentInfo).equals(other$paymentInfo)) {
            return false;
        }
        List<String> this$labels = this.labels();
        List<String> other$labels = other.labels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<String> this$messageStubParameters = this.messageStubParameters();
        List<String> other$messageStubParameters = other.messageStubParameters();
        if (this$messageStubParameters == null ? other$messageStubParameters != null : !((Object)this$messageStubParameters).equals(other$messageStubParameters)) {
            return false;
        }
        MessageInfoStubType this$messageStubType = this.messageStubType();
        MessageInfoStubType other$messageStubType = other.messageStubType();
        if (this$messageStubType == null ? other$messageStubType != null : !((Object)((Object)this$messageStubType)).equals((Object)other$messageStubType)) {
            return false;
        }
        if (!Arrays.equals(this.mediaCiphertextSha256(), other.mediaCiphertextSha256())) {
            return false;
        }
        String this$pushName = this.pushName();
        String other$pushName = other.pushName();
        if (this$pushName == null ? other$pushName != null : !this$pushName.equals(other$pushName)) {
            return false;
        }
        String this$senderJid = this.senderJid();
        String other$senderJid = other.senderJid();
        if (this$senderJid == null ? other$senderJid != null : !this$senderJid.equals(other$senderJid)) {
            return false;
        }
        MessageInfoStatus this$globalStatus = this.globalStatus();
        MessageInfoStatus other$globalStatus = other.globalStatus();
        if (this$globalStatus == null ? other$globalStatus != null : !((Object)((Object)this$globalStatus)).equals((Object)other$globalStatus)) {
            return false;
        }
        Map<Contact, MessageInfoStatus> this$individualReadStatus = this.individualReadStatus();
        Map<Contact, MessageInfoStatus> other$individualReadStatus = other.individualReadStatus();
        if (this$individualReadStatus == null ? other$individualReadStatus != null : !((Object)this$individualReadStatus).equals(other$individualReadStatus)) {
            return false;
        }
        MessageContainer this$container = this.container();
        MessageContainer other$container = other.container();
        if (this$container == null ? other$container != null : !((Object)this$container).equals(other$container)) {
            return false;
        }
        MessageKey this$key = this.key();
        MessageKey other$key = other.key();
        return !(this$key == null ? other$key != null : !((Object)this$key).equals(other$key));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MessageInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.ephemeralDuration();
        long $ephemeralStartTimestamp = this.ephemeralStartTimestamp();
        result = result * 59 + (int)($ephemeralStartTimestamp >>> 32 ^ $ephemeralStartTimestamp);
        result = result * 59 + this.duration();
        result = result * 59 + (this.clearMedia() ? 79 : 97);
        result = result * 59 + (this.urlNumber() ? 79 : 97);
        result = result * 59 + (this.urlText() ? 79 : 97);
        result = result * 59 + (this.multicast() ? 79 : 97);
        result = result * 59 + (this.broadcast() ? 79 : 97);
        result = result * 59 + (this.starred() ? 79 : 97);
        result = result * 59 + (this.ignore() ? 79 : 97);
        long $timestamp = this.timestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        PaymentInfo $quotedPaymentInfo = this.quotedPaymentInfo();
        result = result * 59 + ($quotedPaymentInfo == null ? 43 : ((Object)$quotedPaymentInfo).hashCode());
        LiveLocationMessage $finalLiveLocation = this.finalLiveLocation();
        result = result * 59 + ($finalLiveLocation == null ? 43 : ((Object)$finalLiveLocation).hashCode());
        PaymentInfo $paymentInfo = this.paymentInfo();
        result = result * 59 + ($paymentInfo == null ? 43 : ((Object)$paymentInfo).hashCode());
        List<String> $labels = this.labels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<String> $messageStubParameters = this.messageStubParameters();
        result = result * 59 + ($messageStubParameters == null ? 43 : ((Object)$messageStubParameters).hashCode());
        MessageInfoStubType $messageStubType = this.messageStubType();
        result = result * 59 + ($messageStubType == null ? 43 : ((Object)((Object)$messageStubType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.mediaCiphertextSha256());
        String $pushName = this.pushName();
        result = result * 59 + ($pushName == null ? 43 : $pushName.hashCode());
        String $senderJid = this.senderJid();
        result = result * 59 + ($senderJid == null ? 43 : $senderJid.hashCode());
        MessageInfoStatus $globalStatus = this.globalStatus();
        result = result * 59 + ($globalStatus == null ? 43 : ((Object)((Object)$globalStatus)).hashCode());
        Map<Contact, MessageInfoStatus> $individualReadStatus = this.individualReadStatus();
        result = result * 59 + ($individualReadStatus == null ? 43 : ((Object)$individualReadStatus).hashCode());
        MessageContainer $container = this.container();
        result = result * 59 + ($container == null ? 43 : ((Object)$container).hashCode());
        MessageKey $key = this.key();
        result = result * 59 + ($key == null ? 43 : ((Object)$key).hashCode());
        return result;
    }

    public String toString() {
        return "MessageInfo(ephemeralDuration=" + this.ephemeralDuration() + ", ephemeralStartTimestamp=" + this.ephemeralStartTimestamp() + ", quotedPaymentInfo=" + this.quotedPaymentInfo() + ", finalLiveLocation=" + this.finalLiveLocation() + ", paymentInfo=" + this.paymentInfo() + ", labels=" + this.labels() + ", duration=" + this.duration() + ", messageStubParameters=" + this.messageStubParameters() + ", clearMedia=" + this.clearMedia() + ", messageStubType=" + this.messageStubType() + ", urlNumber=" + this.urlNumber() + ", urlText=" + this.urlText() + ", multicast=" + this.multicast() + ", mediaCiphertextSha256=" + Arrays.toString(this.mediaCiphertextSha256()) + ", pushName=" + this.pushName() + ", broadcast=" + this.broadcast() + ", starred=" + this.starred() + ", ignore=" + this.ignore() + ", senderJid=" + this.senderJid() + ", globalStatus=" + this.globalStatus() + ", individualReadStatus=" + this.individualReadStatus() + ", timestamp=" + this.timestamp() + ", container=" + this.container() + ", key=" + this.key() + ")";
    }

    public static enum MessageInfoStatus {
        ERROR(0),
        PENDING(1),
        SERVER_ACK(2),
        DELIVERY_ACK(3),
        READ(4),
        PLAYED(5);

        private final int index;

        private MessageInfoStatus(int index) {
            this.index = index;
        }

        @JsonCreator
        public static MessageInfoStatus forIndex(int index) {
            return Arrays.stream(MessageInfoStatus.values()).filter(entry -> entry.index() == index).findFirst().orElse(null);
        }

        public static MessageInfoStatus forName(String name) {
            return Arrays.stream(MessageInfoStatus.values()).filter(entry -> entry.name().equalsIgnoreCase(name)).findFirst().orElse(null);
        }

        public int index() {
            return this.index;
        }
    }

    public static class MessageInfoBuilder {
        private int ephemeralDuration;
        private long ephemeralStartTimestamp;
        private PaymentInfo quotedPaymentInfo;
        private LiveLocationMessage finalLiveLocation;
        private PaymentInfo paymentInfo;
        private List<String> labels;
        private int duration;
        private List<String> messageStubParameters;
        private boolean clearMedia;
        private MessageInfoStubType messageStubType;
        private boolean urlNumber;
        private boolean urlText;
        private boolean multicast;
        private byte[] mediaCiphertextSha256;
        private String pushName;
        private boolean broadcast;
        private boolean starred;
        private boolean ignore;
        private String senderJid;
        private boolean globalStatus$set;
        private MessageInfoStatus globalStatus$value;
        private boolean individualReadStatus$set;
        private Map<Contact, MessageInfoStatus> individualReadStatus$value;
        private long timestamp;
        private boolean container$set;
        private MessageContainer container$value;
        private MessageKey key;

        MessageInfoBuilder() {
        }

        @JsonProperty(value="33")
        public MessageInfoBuilder ephemeralDuration(int ephemeralDuration) {
            this.ephemeralDuration = ephemeralDuration;
            return this;
        }

        @JsonProperty(value="32")
        public MessageInfoBuilder ephemeralStartTimestamp(long ephemeralStartTimestamp) {
            this.ephemeralStartTimestamp = ephemeralStartTimestamp;
            return this;
        }

        @JsonProperty(value="31")
        public MessageInfoBuilder quotedPaymentInfo(PaymentInfo quotedPaymentInfo) {
            this.quotedPaymentInfo = quotedPaymentInfo;
            return this;
        }

        @JsonProperty(value="30")
        public MessageInfoBuilder finalLiveLocation(LiveLocationMessage finalLiveLocation) {
            this.finalLiveLocation = finalLiveLocation;
            return this;
        }

        @JsonProperty(value="29")
        public MessageInfoBuilder paymentInfo(PaymentInfo paymentInfo) {
            this.paymentInfo = paymentInfo;
            return this;
        }

        @JsonProperty(value="28")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public MessageInfoBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        @JsonProperty(value="27")
        public MessageInfoBuilder duration(int duration) {
            this.duration = duration;
            return this;
        }

        @JsonProperty(value="26")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public MessageInfoBuilder messageStubParameters(List<String> messageStubParameters) {
            this.messageStubParameters = messageStubParameters;
            return this;
        }

        @JsonProperty(value="25")
        public MessageInfoBuilder clearMedia(boolean clearMedia) {
            this.clearMedia = clearMedia;
            return this;
        }

        @JsonProperty(value="24")
        public MessageInfoBuilder messageStubType(MessageInfoStubType messageStubType) {
            this.messageStubType = messageStubType;
            return this;
        }

        @JsonProperty(value="23")
        public MessageInfoBuilder urlNumber(boolean urlNumber) {
            this.urlNumber = urlNumber;
            return this;
        }

        @JsonProperty(value="22")
        public MessageInfoBuilder urlText(boolean urlText) {
            this.urlText = urlText;
            return this;
        }

        @JsonProperty(value="21")
        public MessageInfoBuilder multicast(boolean multicast) {
            this.multicast = multicast;
            return this;
        }

        @JsonProperty(value="20")
        public MessageInfoBuilder mediaCiphertextSha256(byte[] mediaCiphertextSha256) {
            this.mediaCiphertextSha256 = mediaCiphertextSha256;
            return this;
        }

        @JsonProperty(value="19")
        public MessageInfoBuilder pushName(String pushName) {
            this.pushName = pushName;
            return this;
        }

        @JsonProperty(value="18")
        public MessageInfoBuilder broadcast(boolean broadcast) {
            this.broadcast = broadcast;
            return this;
        }

        @JsonProperty(value="17")
        public MessageInfoBuilder starred(boolean starred) {
            this.starred = starred;
            return this;
        }

        @JsonProperty(value="16")
        public MessageInfoBuilder ignore(boolean ignore) {
            this.ignore = ignore;
            return this;
        }

        @JsonProperty(value="5")
        public MessageInfoBuilder senderJid(String senderJid) {
            this.senderJid = senderJid;
            return this;
        }

        @JsonProperty(value="4")
        public MessageInfoBuilder globalStatus(@NonNull MessageInfoStatus globalStatus) {
            if (globalStatus == null) {
                throw new NullPointerException("globalStatus is marked non-null but is null");
            }
            this.globalStatus$value = globalStatus;
            this.globalStatus$set = true;
            return this;
        }

        public MessageInfoBuilder individualReadStatus(@NonNull Map<Contact, MessageInfoStatus> individualReadStatus) {
            if (individualReadStatus == null) {
                throw new NullPointerException("individualReadStatus is marked non-null but is null");
            }
            this.individualReadStatus$value = individualReadStatus;
            this.individualReadStatus$set = true;
            return this;
        }

        @JsonProperty(value="3")
        public MessageInfoBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @JsonProperty(value="2")
        public MessageInfoBuilder container(@NonNull MessageContainer container) {
            if (container == null) {
                throw new NullPointerException("container is marked non-null but is null");
            }
            this.container$value = container;
            this.container$set = true;
            return this;
        }

        @JsonProperty(value="1", required=true)
        public MessageInfoBuilder key(@NonNull MessageKey key) {
            if (key == null) {
                throw new NullPointerException("key is marked non-null but is null");
            }
            this.key = key;
            return this;
        }

        public MessageInfo create() {
            MessageInfoStatus globalStatus$value = this.globalStatus$value;
            if (!this.globalStatus$set) {
                globalStatus$value = MessageInfo.$default$globalStatus();
            }
            Map<Contact, MessageInfoStatus> individualReadStatus$value = this.individualReadStatus$value;
            if (!this.individualReadStatus$set) {
                individualReadStatus$value = MessageInfo.$default$individualReadStatus();
            }
            MessageContainer container$value = this.container$value;
            if (!this.container$set) {
                container$value = MessageInfo.$default$container();
            }
            return new MessageInfo(this.ephemeralDuration, this.ephemeralStartTimestamp, this.quotedPaymentInfo, this.finalLiveLocation, this.paymentInfo, this.labels, this.duration, this.messageStubParameters, this.clearMedia, this.messageStubType, this.urlNumber, this.urlText, this.multicast, this.mediaCiphertextSha256, this.pushName, this.broadcast, this.starred, this.ignore, this.senderJid, globalStatus$value, individualReadStatus$value, this.timestamp, container$value, this.key);
        }

        public String toString() {
            return "MessageInfo.MessageInfoBuilder(ephemeralDuration=" + this.ephemeralDuration + ", ephemeralStartTimestamp=" + this.ephemeralStartTimestamp + ", quotedPaymentInfo=" + this.quotedPaymentInfo + ", finalLiveLocation=" + this.finalLiveLocation + ", paymentInfo=" + this.paymentInfo + ", labels=" + this.labels + ", duration=" + this.duration + ", messageStubParameters=" + this.messageStubParameters + ", clearMedia=" + this.clearMedia + ", messageStubType=" + this.messageStubType + ", urlNumber=" + this.urlNumber + ", urlText=" + this.urlText + ", multicast=" + this.multicast + ", mediaCiphertextSha256=" + Arrays.toString(this.mediaCiphertextSha256) + ", pushName=" + this.pushName + ", broadcast=" + this.broadcast + ", starred=" + this.starred + ", ignore=" + this.ignore + ", senderJid=" + this.senderJid + ", globalStatus$value=" + this.globalStatus$value + ", individualReadStatus$value=" + this.individualReadStatus$value + ", timestamp=" + this.timestamp + ", container$value=" + this.container$value + ", key=" + this.key + ")";
        }
    }

    public static enum MessageInfoStubType {
        UNKNOWN(0),
        REVOKE(1),
        CIPHERTEXT(2),
        FUTUREPROOF(3),
        NON_VERIFIED_TRANSITION(4),
        UNVERIFIED_TRANSITION(5),
        VERIFIED_TRANSITION(6),
        VERIFIED_LOW_UNKNOWN(7),
        VERIFIED_HIGH(8),
        VERIFIED_INITIAL_UNKNOWN(9),
        VERIFIED_INITIAL_LOW(10),
        VERIFIED_INITIAL_HIGH(11),
        VERIFIED_TRANSITION_ANY_TO_NONE(12),
        VERIFIED_TRANSITION_ANY_TO_HIGH(13),
        VERIFIED_TRANSITION_HIGH_TO_LOW(14),
        VERIFIED_TRANSITION_HIGH_TO_UNKNOWN(15),
        VERIFIED_TRANSITION_UNKNOWN_TO_LOW(16),
        VERIFIED_TRANSITION_LOW_TO_UNKNOWN(17),
        VERIFIED_TRANSITION_NONE_TO_LOW(18),
        VERIFIED_TRANSITION_NONE_TO_UNKNOWN(19),
        GROUP_CREATE(20),
        GROUP_CHANGE_SUBJECT(21),
        GROUP_CHANGE_ICON(22),
        GROUP_CHANGE_INVITE_LINK(23),
        GROUP_CHANGE_DESCRIPTION(24),
        GROUP_CHANGE_RESTRICT(25),
        GROUP_CHANGE_ANNOUNCE(26),
        GROUP_PARTICIPANT_ADD(27),
        GROUP_PARTICIPANT_REMOVE(28),
        GROUP_PARTICIPANT_PROMOTE(29),
        GROUP_PARTICIPANT_DEMOTE(30),
        GROUP_PARTICIPANT_INVITE(31),
        GROUP_PARTICIPANT_LEAVE(32),
        GROUP_PARTICIPANT_CHANGE_NUMBER(33),
        BROADCAST_CREATE(34),
        BROADCAST_ADD(35),
        BROADCAST_REMOVE(36),
        GENERIC_NOTIFICATION(37),
        E2E_IDENTITY_CHANGED(38),
        E2E_ENCRYPTED(39),
        CALL_MISSED_VOICE(40),
        CALL_MISSED_VIDEO(41),
        INDIVIDUAL_CHANGE_NUMBER(42),
        GROUP_DELETE(43),
        GROUP_ANNOUNCE_MODE_MESSAGE_BOUNCE(44),
        CALL_MISSED_GROUP_VOICE(45),
        CALL_MISSED_GROUP_VIDEO(46),
        PAYMENT_CIPHERTEXT(47),
        PAYMENT_FUTUREPROOF(48),
        PAYMENT_TRANSACTION_STATUS_UPDATE_FAILED(49),
        PAYMENT_TRANSACTION_STATUS_UPDATE_REFUNDED(50),
        PAYMENT_TRANSACTION_STATUS_UPDATE_REFUND_FAILED(51),
        PAYMENT_TRANSACTION_STATUS_RECEIVER_PENDING_SETUP(52),
        PAYMENT_TRANSACTION_STATUS_RECEIVER_SUCCESS_AFTER_HICCUP(53),
        PAYMENT_ACTION_ACCOUNT_SETUP_REMINDER(54),
        PAYMENT_ACTION_SEND_PAYMENT_REMINDER(55),
        PAYMENT_ACTION_SEND_PAYMENT_INVITATION(56),
        PAYMENT_ACTION_REQUEST_DECLINED(57),
        PAYMENT_ACTION_REQUEST_EXPIRED(58),
        PAYMENT_ACTION_REQUEST_CANCELLED(59),
        BIZ_VERIFIED_TRANSITION_TOP_TO_BOTTOM(60),
        BIZ_VERIFIED_TRANSITION_BOTTOM_TO_TOP(61),
        BIZ_INTRO_TOP(62),
        BIZ_INTRO_BOTTOM(63),
        BIZ_NAME_CHANGE(64),
        BIZ_MOVE_TO_CONSUMER_APP(65),
        BIZ_TWO_TIER_MIGRATION_TOP(66),
        BIZ_TWO_TIER_MIGRATION_BOTTOM(67),
        OVERSIZED(68),
        GROUP_CHANGE_NO_FREQUENTLY_FORWARDED(69),
        GROUP_V4_ADD_INVITE_SENT(70),
        GROUP_PARTICIPANT_ADD_REQUEST_JOIN(71),
        CHANGE_EPHEMERAL_SETTING(72);

        private final int index;

        private MessageInfoStubType(int index) {
            this.index = index;
        }

        @JsonCreator
        public static MessageInfoStubType forIndex(int index) {
            return Arrays.stream(MessageInfoStubType.values()).filter(entry -> entry.index() == index).findFirst().orElse(null);
        }

        public int index() {
            return this.index;
        }
    }
}

