/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.info;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.protobuf.info.AdReplyInfo;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.message.model.MessageContainer;
import it.auties.whatsapp4j.protobuf.message.model.MessageKey;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;

public class ContextInfo {
    @JsonProperty(value="26")
    private long ephemeralSettingTimestamp;
    @JsonProperty(value="25")
    private int expiration;
    @JsonProperty(value="24")
    private MessageKey placeholderKey;
    @JsonProperty(value="23")
    private AdReplyInfo quotedAd;
    @JsonProperty(value="22")
    private boolean isForwarded;
    @JsonProperty(value="21")
    private int forwardingScore;
    @JsonProperty(value="20")
    private int conversionDelaySeconds;
    @JsonProperty(value="19")
    private byte[] conversionData;
    @JsonProperty(value="18")
    private String conversionSource;
    @JsonProperty(value="15")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    private List<String> mentionedJid;
    @JsonProperty(value="3")
    private MessageContainer quotedMessageContainer;
    @JsonProperty(value="2")
    private String quotedMessageSenderJid;
    @JsonProperty(value="1")
    private String quotedMessageId;

    public ContextInfo(@NonNull MessageInfo quotedMessage) {
        if (quotedMessage == null) {
            throw new NullPointerException("quotedMessage is marked non-null but is null");
        }
        this.quotedMessageContainer = quotedMessage.container();
        this.quotedMessageId = quotedMessage.key().id();
        this.quotedMessageSenderJid = quotedMessage.senderJid();
    }

    public static ContextInfoBuilder newContextInfo() {
        return new ContextInfoBuilder();
    }

    public ContextInfo(long ephemeralSettingTimestamp, int expiration, MessageKey placeholderKey, AdReplyInfo quotedAd, boolean isForwarded, int forwardingScore, int conversionDelaySeconds, byte[] conversionData, String conversionSource, List<String> mentionedJid, MessageContainer quotedMessageContainer, String quotedMessageSenderJid, String quotedMessageId) {
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        this.expiration = expiration;
        this.placeholderKey = placeholderKey;
        this.quotedAd = quotedAd;
        this.isForwarded = isForwarded;
        this.forwardingScore = forwardingScore;
        this.conversionDelaySeconds = conversionDelaySeconds;
        this.conversionData = conversionData;
        this.conversionSource = conversionSource;
        this.mentionedJid = mentionedJid;
        this.quotedMessageContainer = quotedMessageContainer;
        this.quotedMessageSenderJid = quotedMessageSenderJid;
        this.quotedMessageId = quotedMessageId;
    }

    public ContextInfo() {
    }

    public long ephemeralSettingTimestamp() {
        return this.ephemeralSettingTimestamp;
    }

    public int expiration() {
        return this.expiration;
    }

    public MessageKey placeholderKey() {
        return this.placeholderKey;
    }

    public AdReplyInfo quotedAd() {
        return this.quotedAd;
    }

    public boolean isForwarded() {
        return this.isForwarded;
    }

    public int forwardingScore() {
        return this.forwardingScore;
    }

    public int conversionDelaySeconds() {
        return this.conversionDelaySeconds;
    }

    public byte[] conversionData() {
        return this.conversionData;
    }

    public String conversionSource() {
        return this.conversionSource;
    }

    public List<String> mentionedJid() {
        return this.mentionedJid;
    }

    public MessageContainer quotedMessageContainer() {
        return this.quotedMessageContainer;
    }

    public String quotedMessageSenderJid() {
        return this.quotedMessageSenderJid;
    }

    public String quotedMessageId() {
        return this.quotedMessageId;
    }

    @JsonProperty(value="26")
    public ContextInfo ephemeralSettingTimestamp(long ephemeralSettingTimestamp) {
        this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
        return this;
    }

    @JsonProperty(value="25")
    public ContextInfo expiration(int expiration) {
        this.expiration = expiration;
        return this;
    }

    @JsonProperty(value="24")
    public ContextInfo placeholderKey(MessageKey placeholderKey) {
        this.placeholderKey = placeholderKey;
        return this;
    }

    @JsonProperty(value="23")
    public ContextInfo quotedAd(AdReplyInfo quotedAd) {
        this.quotedAd = quotedAd;
        return this;
    }

    @JsonProperty(value="22")
    public ContextInfo isForwarded(boolean isForwarded) {
        this.isForwarded = isForwarded;
        return this;
    }

    @JsonProperty(value="21")
    public ContextInfo forwardingScore(int forwardingScore) {
        this.forwardingScore = forwardingScore;
        return this;
    }

    @JsonProperty(value="20")
    public ContextInfo conversionDelaySeconds(int conversionDelaySeconds) {
        this.conversionDelaySeconds = conversionDelaySeconds;
        return this;
    }

    @JsonProperty(value="19")
    public ContextInfo conversionData(byte[] conversionData) {
        this.conversionData = conversionData;
        return this;
    }

    @JsonProperty(value="18")
    public ContextInfo conversionSource(String conversionSource) {
        this.conversionSource = conversionSource;
        return this;
    }

    @JsonProperty(value="15")
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    public ContextInfo mentionedJid(List<String> mentionedJid) {
        this.mentionedJid = mentionedJid;
        return this;
    }

    @JsonProperty(value="3")
    public ContextInfo quotedMessageContainer(MessageContainer quotedMessageContainer) {
        this.quotedMessageContainer = quotedMessageContainer;
        return this;
    }

    @JsonProperty(value="2")
    public ContextInfo quotedMessageSenderJid(String quotedMessageSenderJid) {
        this.quotedMessageSenderJid = quotedMessageSenderJid;
        return this;
    }

    @JsonProperty(value="1")
    public ContextInfo quotedMessageId(String quotedMessageId) {
        this.quotedMessageId = quotedMessageId;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextInfo)) {
            return false;
        }
        ContextInfo other = (ContextInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.ephemeralSettingTimestamp() != other.ephemeralSettingTimestamp()) {
            return false;
        }
        if (this.expiration() != other.expiration()) {
            return false;
        }
        if (this.isForwarded() != other.isForwarded()) {
            return false;
        }
        if (this.forwardingScore() != other.forwardingScore()) {
            return false;
        }
        if (this.conversionDelaySeconds() != other.conversionDelaySeconds()) {
            return false;
        }
        MessageKey this$placeholderKey = this.placeholderKey();
        MessageKey other$placeholderKey = other.placeholderKey();
        if (this$placeholderKey == null ? other$placeholderKey != null : !((Object)this$placeholderKey).equals(other$placeholderKey)) {
            return false;
        }
        AdReplyInfo this$quotedAd = this.quotedAd();
        AdReplyInfo other$quotedAd = other.quotedAd();
        if (this$quotedAd == null ? other$quotedAd != null : !((Object)this$quotedAd).equals(other$quotedAd)) {
            return false;
        }
        if (!Arrays.equals(this.conversionData(), other.conversionData())) {
            return false;
        }
        String this$conversionSource = this.conversionSource();
        String other$conversionSource = other.conversionSource();
        if (this$conversionSource == null ? other$conversionSource != null : !this$conversionSource.equals(other$conversionSource)) {
            return false;
        }
        List<String> this$mentionedJid = this.mentionedJid();
        List<String> other$mentionedJid = other.mentionedJid();
        if (this$mentionedJid == null ? other$mentionedJid != null : !((Object)this$mentionedJid).equals(other$mentionedJid)) {
            return false;
        }
        MessageContainer this$quotedMessageContainer = this.quotedMessageContainer();
        MessageContainer other$quotedMessageContainer = other.quotedMessageContainer();
        if (this$quotedMessageContainer == null ? other$quotedMessageContainer != null : !((Object)this$quotedMessageContainer).equals(other$quotedMessageContainer)) {
            return false;
        }
        String this$quotedMessageSenderJid = this.quotedMessageSenderJid();
        String other$quotedMessageSenderJid = other.quotedMessageSenderJid();
        if (this$quotedMessageSenderJid == null ? other$quotedMessageSenderJid != null : !this$quotedMessageSenderJid.equals(other$quotedMessageSenderJid)) {
            return false;
        }
        String this$quotedMessageId = this.quotedMessageId();
        String other$quotedMessageId = other.quotedMessageId();
        return !(this$quotedMessageId == null ? other$quotedMessageId != null : !this$quotedMessageId.equals(other$quotedMessageId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $ephemeralSettingTimestamp = this.ephemeralSettingTimestamp();
        result = result * 59 + (int)($ephemeralSettingTimestamp >>> 32 ^ $ephemeralSettingTimestamp);
        result = result * 59 + this.expiration();
        result = result * 59 + (this.isForwarded() ? 79 : 97);
        result = result * 59 + this.forwardingScore();
        result = result * 59 + this.conversionDelaySeconds();
        MessageKey $placeholderKey = this.placeholderKey();
        result = result * 59 + ($placeholderKey == null ? 43 : ((Object)$placeholderKey).hashCode());
        AdReplyInfo $quotedAd = this.quotedAd();
        result = result * 59 + ($quotedAd == null ? 43 : ((Object)$quotedAd).hashCode());
        result = result * 59 + Arrays.hashCode(this.conversionData());
        String $conversionSource = this.conversionSource();
        result = result * 59 + ($conversionSource == null ? 43 : $conversionSource.hashCode());
        List<String> $mentionedJid = this.mentionedJid();
        result = result * 59 + ($mentionedJid == null ? 43 : ((Object)$mentionedJid).hashCode());
        MessageContainer $quotedMessageContainer = this.quotedMessageContainer();
        result = result * 59 + ($quotedMessageContainer == null ? 43 : ((Object)$quotedMessageContainer).hashCode());
        String $quotedMessageSenderJid = this.quotedMessageSenderJid();
        result = result * 59 + ($quotedMessageSenderJid == null ? 43 : $quotedMessageSenderJid.hashCode());
        String $quotedMessageId = this.quotedMessageId();
        result = result * 59 + ($quotedMessageId == null ? 43 : $quotedMessageId.hashCode());
        return result;
    }

    public String toString() {
        return "ContextInfo(ephemeralSettingTimestamp=" + this.ephemeralSettingTimestamp() + ", expiration=" + this.expiration() + ", placeholderKey=" + this.placeholderKey() + ", quotedAd=" + this.quotedAd() + ", isForwarded=" + this.isForwarded() + ", forwardingScore=" + this.forwardingScore() + ", conversionDelaySeconds=" + this.conversionDelaySeconds() + ", conversionData=" + Arrays.toString(this.conversionData()) + ", conversionSource=" + this.conversionSource() + ", mentionedJid=" + this.mentionedJid() + ", quotedMessageContainer=" + this.quotedMessageContainer() + ", quotedMessageSenderJid=" + this.quotedMessageSenderJid() + ", quotedMessageId=" + this.quotedMessageId() + ")";
    }

    public static class ContextInfoBuilder {
        private long ephemeralSettingTimestamp;
        private int expiration;
        private MessageKey placeholderKey;
        private AdReplyInfo quotedAd;
        private boolean isForwarded;
        private int forwardingScore;
        private int conversionDelaySeconds;
        private byte[] conversionData;
        private String conversionSource;
        private List<String> mentionedJid;
        private MessageContainer quotedMessageContainer;
        private String quotedMessageSenderJid;
        private String quotedMessageId;

        ContextInfoBuilder() {
        }

        @JsonProperty(value="26")
        public ContextInfoBuilder ephemeralSettingTimestamp(long ephemeralSettingTimestamp) {
            this.ephemeralSettingTimestamp = ephemeralSettingTimestamp;
            return this;
        }

        @JsonProperty(value="25")
        public ContextInfoBuilder expiration(int expiration) {
            this.expiration = expiration;
            return this;
        }

        @JsonProperty(value="24")
        public ContextInfoBuilder placeholderKey(MessageKey placeholderKey) {
            this.placeholderKey = placeholderKey;
            return this;
        }

        @JsonProperty(value="23")
        public ContextInfoBuilder quotedAd(AdReplyInfo quotedAd) {
            this.quotedAd = quotedAd;
            return this;
        }

        @JsonProperty(value="22")
        public ContextInfoBuilder isForwarded(boolean isForwarded) {
            this.isForwarded = isForwarded;
            return this;
        }

        @JsonProperty(value="21")
        public ContextInfoBuilder forwardingScore(int forwardingScore) {
            this.forwardingScore = forwardingScore;
            return this;
        }

        @JsonProperty(value="20")
        public ContextInfoBuilder conversionDelaySeconds(int conversionDelaySeconds) {
            this.conversionDelaySeconds = conversionDelaySeconds;
            return this;
        }

        @JsonProperty(value="19")
        public ContextInfoBuilder conversionData(byte[] conversionData) {
            this.conversionData = conversionData;
            return this;
        }

        @JsonProperty(value="18")
        public ContextInfoBuilder conversionSource(String conversionSource) {
            this.conversionSource = conversionSource;
            return this;
        }

        @JsonProperty(value="15")
        @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
        public ContextInfoBuilder mentionedJid(List<String> mentionedJid) {
            this.mentionedJid = mentionedJid;
            return this;
        }

        @JsonProperty(value="3")
        public ContextInfoBuilder quotedMessageContainer(MessageContainer quotedMessageContainer) {
            this.quotedMessageContainer = quotedMessageContainer;
            return this;
        }

        @JsonProperty(value="2")
        public ContextInfoBuilder quotedMessageSenderJid(String quotedMessageSenderJid) {
            this.quotedMessageSenderJid = quotedMessageSenderJid;
            return this;
        }

        @JsonProperty(value="1")
        public ContextInfoBuilder quotedMessageId(String quotedMessageId) {
            this.quotedMessageId = quotedMessageId;
            return this;
        }

        public ContextInfo create() {
            return new ContextInfo(this.ephemeralSettingTimestamp, this.expiration, this.placeholderKey, this.quotedAd, this.isForwarded, this.forwardingScore, this.conversionDelaySeconds, this.conversionData, this.conversionSource, this.mentionedJid, this.quotedMessageContainer, this.quotedMessageSenderJid, this.quotedMessageId);
        }

        public String toString() {
            return "ContextInfo.ContextInfoBuilder(ephemeralSettingTimestamp=" + this.ephemeralSettingTimestamp + ", expiration=" + this.expiration + ", placeholderKey=" + this.placeholderKey + ", quotedAd=" + this.quotedAd + ", isForwarded=" + this.isForwarded + ", forwardingScore=" + this.forwardingScore + ", conversionDelaySeconds=" + this.conversionDelaySeconds + ", conversionData=" + Arrays.toString(this.conversionData) + ", conversionSource=" + this.conversionSource + ", mentionedJid=" + this.mentionedJid + ", quotedMessageContainer=" + this.quotedMessageContainer + ", quotedMessageSenderJid=" + this.quotedMessageSenderJid + ", quotedMessageId=" + this.quotedMessageId + ")";
        }
    }
}

