/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.contact;

import com.fasterxml.jackson.annotation.JsonCreator;
import it.auties.whatsapp4j.binary.BinaryFlag;
import java.util.Arrays;
import lombok.NonNull;

public enum ContactStatus {
    AVAILABLE(BinaryFlag.AVAILABLE),
    UNAVAILABLE(BinaryFlag.UNAVAILABLE),
    COMPOSING(BinaryFlag.COMPOSING),
    RECORDING(BinaryFlag.RECORDING),
    PAUSED(BinaryFlag.PAUSED);

    private final BinaryFlag flag;

    @NonNull
    public String data() {
        return this.name().toLowerCase();
    }

    @JsonCreator
    public static ContactStatus forValue(@NonNull String jsonValue) {
        if (jsonValue == null) {
            throw new NullPointerException("jsonValue is marked non-null but is null");
        }
        return Arrays.stream(ContactStatus.values()).filter(entry -> entry.name().equalsIgnoreCase(jsonValue)).findFirst().orElseThrow();
    }

    private ContactStatus(BinaryFlag flag) {
        this.flag = flag;
    }

    public BinaryFlag flag() {
        return this.flag;
    }
}

