/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.contact;

import it.auties.whatsapp4j.protobuf.contact.ContactStatus;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class Contact {
    @NonNull
    private final String jid;
    private final String chosenName;
    private final String name;
    private final String shortName;
    private ContactStatus lastKnownPresence;
    private ZonedDateTime lastSeen;

    public static Contact fromJid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        return Contact.builder().jid(jid).build();
    }

    @NonNull
    public static Contact fromAttributes(@NonNull Map<String, String> attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs is marked non-null but is null");
        }
        return Contact.builder().jid(attrs.get("jid")).name(attrs.get("name")).chosenName(attrs.get("notify")).shortName(attrs.get("short")).build();
    }

    @NonNull
    public Optional<String> bestName() {
        return Optional.ofNullable(this.name != null ? this.name : this.chosenName);
    }

    @NonNull
    public String bestName(@NonNull String orElse) {
        if (orElse == null) {
            throw new NullPointerException("orElse is marked non-null but is null");
        }
        return this.bestName().orElse(orElse);
    }

    @NonNull
    public Optional<ContactStatus> lastKnownPresence() {
        return Optional.ofNullable(this.lastKnownPresence);
    }

    @NonNull
    public Optional<ZonedDateTime> lastSeen() {
        return Optional.ofNullable(this.lastSeen);
    }

    public static ContactBuilder builder() {
        return new ContactBuilder();
    }

    public Contact(@NonNull String jid, String chosenName, String name, String shortName, ContactStatus lastKnownPresence, ZonedDateTime lastSeen) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        this.jid = jid;
        this.chosenName = chosenName;
        this.name = name;
        this.shortName = shortName;
        this.lastKnownPresence = lastKnownPresence;
        this.lastSeen = lastSeen;
    }

    @NonNull
    public String jid() {
        return this.jid;
    }

    public String chosenName() {
        return this.chosenName;
    }

    public String name() {
        return this.name;
    }

    public String shortName() {
        return this.shortName;
    }

    public Contact lastKnownPresence(ContactStatus lastKnownPresence) {
        this.lastKnownPresence = lastKnownPresence;
        return this;
    }

    public Contact lastSeen(ZonedDateTime lastSeen) {
        this.lastSeen = lastSeen;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Contact)) {
            return false;
        }
        Contact other = (Contact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$jid = this.jid();
        String other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !this$jid.equals(other$jid)) {
            return false;
        }
        String this$chosenName = this.chosenName();
        String other$chosenName = other.chosenName();
        if (this$chosenName == null ? other$chosenName != null : !this$chosenName.equals(other$chosenName)) {
            return false;
        }
        String this$name = this.name();
        String other$name = other.name();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$shortName = this.shortName();
        String other$shortName = other.shortName();
        if (this$shortName == null ? other$shortName != null : !this$shortName.equals(other$shortName)) {
            return false;
        }
        Optional<ContactStatus> this$lastKnownPresence = this.lastKnownPresence();
        Optional<ContactStatus> other$lastKnownPresence = other.lastKnownPresence();
        if (this$lastKnownPresence == null ? other$lastKnownPresence != null : !((Object)this$lastKnownPresence).equals(other$lastKnownPresence)) {
            return false;
        }
        Optional<ZonedDateTime> this$lastSeen = this.lastSeen();
        Optional<ZonedDateTime> other$lastSeen = other.lastSeen();
        return !(this$lastSeen == null ? other$lastSeen != null : !((Object)this$lastSeen).equals(other$lastSeen));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Contact;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : $jid.hashCode());
        String $chosenName = this.chosenName();
        result = result * 59 + ($chosenName == null ? 43 : $chosenName.hashCode());
        String $name = this.name();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $shortName = this.shortName();
        result = result * 59 + ($shortName == null ? 43 : $shortName.hashCode());
        Optional<ContactStatus> $lastKnownPresence = this.lastKnownPresence();
        result = result * 59 + ($lastKnownPresence == null ? 43 : ((Object)$lastKnownPresence).hashCode());
        Optional<ZonedDateTime> $lastSeen = this.lastSeen();
        result = result * 59 + ($lastSeen == null ? 43 : ((Object)$lastSeen).hashCode());
        return result;
    }

    public String toString() {
        return "Contact(jid=" + this.jid() + ", chosenName=" + this.chosenName() + ", name=" + this.name() + ", shortName=" + this.shortName() + ", lastKnownPresence=" + this.lastKnownPresence() + ", lastSeen=" + this.lastSeen() + ")";
    }

    public static class ContactBuilder {
        private String jid;
        private String chosenName;
        private String name;
        private String shortName;
        private ContactStatus lastKnownPresence;
        private ZonedDateTime lastSeen;

        ContactBuilder() {
        }

        public ContactBuilder jid(@NonNull String jid) {
            if (jid == null) {
                throw new NullPointerException("jid is marked non-null but is null");
            }
            this.jid = jid;
            return this;
        }

        public ContactBuilder chosenName(String chosenName) {
            this.chosenName = chosenName;
            return this;
        }

        public ContactBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ContactBuilder shortName(String shortName) {
            this.shortName = shortName;
            return this;
        }

        public ContactBuilder lastKnownPresence(ContactStatus lastKnownPresence) {
            this.lastKnownPresence = lastKnownPresence;
            return this;
        }

        public ContactBuilder lastSeen(ZonedDateTime lastSeen) {
            this.lastSeen = lastSeen;
            return this;
        }

        public Contact build() {
            return new Contact(this.jid, this.chosenName, this.name, this.shortName, this.lastKnownPresence, this.lastSeen);
        }

        public String toString() {
            return "Contact.ContactBuilder(jid=" + this.jid + ", chosenName=" + this.chosenName + ", name=" + this.name + ", shortName=" + this.shortName + ", lastKnownPresence=" + this.lastKnownPresence + ", lastSeen=" + this.lastSeen + ")";
        }
    }
}

