/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.protobuf.chat;

import com.fasterxml.jackson.annotation.JsonProperty;
import it.auties.whatsapp4j.protobuf.chat.ChatMute;
import it.auties.whatsapp4j.protobuf.contact.Contact;
import it.auties.whatsapp4j.protobuf.contact.ContactStatus;
import it.auties.whatsapp4j.protobuf.info.MessageInfo;
import it.auties.whatsapp4j.protobuf.model.Messages;
import it.auties.whatsapp4j.response.model.json.JsonResponse;
import it.auties.whatsapp4j.utils.WhatsappUtils;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.NonNull;

public class Chat {
    @JsonProperty(value="2")
    @NonNull
    private String jid;
    @JsonProperty(value="1")
    @NonNull
    private String displayName;
    @NonNull
    private Messages messages;
    @NonNull
    private Map<Contact, ContactStatus> presences;
    @NonNull
    private ChatMute mute;
    private String newJid;
    private long timestamp;
    private int unreadMessages;
    private long pinned;
    private long ephemeralMessageDuration;
    private long ephemeralMessagesToggleTime;
    private boolean isArchived;
    private boolean isReadOnly;
    private boolean isSpam;

    @NonNull
    public static Chat fromAttributes(@NonNull Map<String, String> attrs) {
        if (attrs == null) {
            throw new NullPointerException("attrs is marked non-null but is null");
        }
        JsonResponse json = JsonResponse.fromMap(attrs);
        String jid = json.getString("jid").orElseThrow(() -> new IllegalArgumentException("Cannot parse chat(%s): missing attribute jid".formatted(json)));
        return Chat.builder().displayName(json.getString("name").orElse(WhatsappUtils.phoneNumberFromJid(jid))).jid(jid).timestamp(json.getLong("t").orElse(ZonedDateTime.now().toEpochSecond())).newJid(json.getString("new_jid").orElse(null)).unreadMessages(json.getInt("count")).mute(json.getLong("mute").map(ChatMute::new).orElse(ChatMute.UNKNOWN)).isSpam(json.getBoolean("spam")).isArchived(json.getBoolean("archive")).isReadOnly(json.getBoolean("read_only")).pinned(json.getLong("pin").orElse(0L)).build();
    }

    public boolean isGroup() {
        return WhatsappUtils.isGroup(this.jid);
    }

    public boolean isPinned() {
        return this.pinned != 0L;
    }

    public boolean isEphemeral() {
        return this.ephemeralMessageDuration != 0L && this.ephemeralMessagesToggleTime != 0L;
    }

    public boolean hasNewJid() {
        return this.newJid != null;
    }

    public boolean hasUnreadMessages() {
        return !this.isMarkedRead();
    }

    public boolean isMarkedRead() {
        return this.unreadMessages == 0;
    }

    public boolean isManuallyMarkedUnread() {
        return this.unreadMessages < 0;
    }

    @NonNull
    public Optional<String> newJid() {
        return Optional.ofNullable(this.newJid);
    }

    @NonNull
    public Optional<ZonedDateTime> pinned() {
        return WhatsappUtils.parseWhatsappTime(this.pinned);
    }

    @NonNull
    public Optional<ZonedDateTime> ephemeralMessageDuration() {
        return WhatsappUtils.parseWhatsappTime(this.ephemeralMessageDuration);
    }

    @NonNull
    public Optional<ZonedDateTime> ephemeralMessagesToggleTime() {
        return WhatsappUtils.parseWhatsappTime(this.ephemeralMessagesToggleTime);
    }

    @NonNull
    public Optional<MessageInfo> lastMessage() {
        return this.messages.isEmpty() ? Optional.empty() : Optional.of((MessageInfo)this.messages.get(this.messages.size() - 1));
    }

    @NonNull
    public Optional<MessageInfo> firstMessage() {
        return this.messages.isEmpty() ? Optional.empty() : Optional.of((MessageInfo)this.messages.get(0));
    }

    private static Messages $default$messages() {
        return new Messages();
    }

    private static Map<Contact, ContactStatus> $default$presences() {
        return new HashMap<Contact, ContactStatus>();
    }

    private static ChatMute $default$mute() {
        return ChatMute.UNKNOWN;
    }

    public static ChatBuilder builder() {
        return new ChatBuilder();
    }

    public Chat(@NonNull String jid, @NonNull String displayName, @NonNull Messages messages, @NonNull Map<Contact, ContactStatus> presences, @NonNull ChatMute mute, String newJid, long timestamp, int unreadMessages, long pinned, long ephemeralMessageDuration, long ephemeralMessagesToggleTime, boolean isArchived, boolean isReadOnly, boolean isSpam) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        if (presences == null) {
            throw new NullPointerException("presences is marked non-null but is null");
        }
        if (mute == null) {
            throw new NullPointerException("mute is marked non-null but is null");
        }
        this.jid = jid;
        this.displayName = displayName;
        this.messages = messages;
        this.presences = presences;
        this.mute = mute;
        this.newJid = newJid;
        this.timestamp = timestamp;
        this.unreadMessages = unreadMessages;
        this.pinned = pinned;
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
        this.isArchived = isArchived;
        this.isReadOnly = isReadOnly;
        this.isSpam = isSpam;
    }

    public Chat() {
        this.messages = Chat.$default$messages();
        this.presences = Chat.$default$presences();
        this.mute = Chat.$default$mute();
    }

    @NonNull
    public String jid() {
        return this.jid;
    }

    @NonNull
    public String displayName() {
        return this.displayName;
    }

    @NonNull
    public Messages messages() {
        return this.messages;
    }

    @NonNull
    public Map<Contact, ContactStatus> presences() {
        return this.presences;
    }

    @NonNull
    public ChatMute mute() {
        return this.mute;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public int unreadMessages() {
        return this.unreadMessages;
    }

    public boolean isArchived() {
        return this.isArchived;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public boolean isSpam() {
        return this.isSpam;
    }

    @JsonProperty(value="2")
    public Chat jid(@NonNull String jid) {
        if (jid == null) {
            throw new NullPointerException("jid is marked non-null but is null");
        }
        this.jid = jid;
        return this;
    }

    @JsonProperty(value="1")
    public Chat displayName(@NonNull String displayName) {
        if (displayName == null) {
            throw new NullPointerException("displayName is marked non-null but is null");
        }
        this.displayName = displayName;
        return this;
    }

    public Chat messages(@NonNull Messages messages) {
        if (messages == null) {
            throw new NullPointerException("messages is marked non-null but is null");
        }
        this.messages = messages;
        return this;
    }

    public Chat presences(@NonNull Map<Contact, ContactStatus> presences) {
        if (presences == null) {
            throw new NullPointerException("presences is marked non-null but is null");
        }
        this.presences = presences;
        return this;
    }

    public Chat mute(@NonNull ChatMute mute) {
        if (mute == null) {
            throw new NullPointerException("mute is marked non-null but is null");
        }
        this.mute = mute;
        return this;
    }

    public Chat newJid(String newJid) {
        this.newJid = newJid;
        return this;
    }

    public Chat timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Chat unreadMessages(int unreadMessages) {
        this.unreadMessages = unreadMessages;
        return this;
    }

    public Chat pinned(long pinned) {
        this.pinned = pinned;
        return this;
    }

    public Chat ephemeralMessageDuration(long ephemeralMessageDuration) {
        this.ephemeralMessageDuration = ephemeralMessageDuration;
        return this;
    }

    public Chat ephemeralMessagesToggleTime(long ephemeralMessagesToggleTime) {
        this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
        return this;
    }

    public Chat isArchived(boolean isArchived) {
        this.isArchived = isArchived;
        return this;
    }

    public Chat isReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
        return this;
    }

    public Chat isSpam(boolean isSpam) {
        this.isSpam = isSpam;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Chat)) {
            return false;
        }
        Chat other = (Chat)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.timestamp() != other.timestamp()) {
            return false;
        }
        if (this.unreadMessages() != other.unreadMessages()) {
            return false;
        }
        Optional<ZonedDateTime> this$pinned = this.pinned();
        Optional<ZonedDateTime> other$pinned = other.pinned();
        if (this$pinned == null ? other$pinned != null : !((Object)this$pinned).equals(other$pinned)) {
            return false;
        }
        Optional<ZonedDateTime> this$ephemeralMessageDuration = this.ephemeralMessageDuration();
        Optional<ZonedDateTime> other$ephemeralMessageDuration = other.ephemeralMessageDuration();
        if (this$ephemeralMessageDuration == null ? other$ephemeralMessageDuration != null : !((Object)this$ephemeralMessageDuration).equals(other$ephemeralMessageDuration)) {
            return false;
        }
        Optional<ZonedDateTime> this$ephemeralMessagesToggleTime = this.ephemeralMessagesToggleTime();
        Optional<ZonedDateTime> other$ephemeralMessagesToggleTime = other.ephemeralMessagesToggleTime();
        if (this$ephemeralMessagesToggleTime == null ? other$ephemeralMessagesToggleTime != null : !((Object)this$ephemeralMessagesToggleTime).equals(other$ephemeralMessagesToggleTime)) {
            return false;
        }
        if (this.isArchived() != other.isArchived()) {
            return false;
        }
        if (this.isReadOnly() != other.isReadOnly()) {
            return false;
        }
        if (this.isSpam() != other.isSpam()) {
            return false;
        }
        String this$jid = this.jid();
        String other$jid = other.jid();
        if (this$jid == null ? other$jid != null : !this$jid.equals(other$jid)) {
            return false;
        }
        String this$displayName = this.displayName();
        String other$displayName = other.displayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        Messages this$messages = this.messages();
        Messages other$messages = other.messages();
        if (this$messages == null ? other$messages != null : !((Object)this$messages).equals(other$messages)) {
            return false;
        }
        Map<Contact, ContactStatus> this$presences = this.presences();
        Map<Contact, ContactStatus> other$presences = other.presences();
        if (this$presences == null ? other$presences != null : !((Object)this$presences).equals(other$presences)) {
            return false;
        }
        ChatMute this$mute = this.mute();
        ChatMute other$mute = other.mute();
        if (this$mute == null ? other$mute != null : !((Object)this$mute).equals(other$mute)) {
            return false;
        }
        Optional<String> this$newJid = this.newJid();
        Optional<String> other$newJid = other.newJid();
        return !(this$newJid == null ? other$newJid != null : !((Object)this$newJid).equals(other$newJid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Chat;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.timestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        result = result * 59 + this.unreadMessages();
        Optional<ZonedDateTime> $pinned = this.pinned();
        result = result * 59 + ($pinned == null ? 43 : ((Object)$pinned).hashCode());
        Optional<ZonedDateTime> $ephemeralMessageDuration = this.ephemeralMessageDuration();
        result = result * 59 + ($ephemeralMessageDuration == null ? 43 : ((Object)$ephemeralMessageDuration).hashCode());
        Optional<ZonedDateTime> $ephemeralMessagesToggleTime = this.ephemeralMessagesToggleTime();
        result = result * 59 + ($ephemeralMessagesToggleTime == null ? 43 : ((Object)$ephemeralMessagesToggleTime).hashCode());
        result = result * 59 + (this.isArchived() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        result = result * 59 + (this.isSpam() ? 79 : 97);
        String $jid = this.jid();
        result = result * 59 + ($jid == null ? 43 : $jid.hashCode());
        String $displayName = this.displayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        Messages $messages = this.messages();
        result = result * 59 + ($messages == null ? 43 : ((Object)$messages).hashCode());
        Map<Contact, ContactStatus> $presences = this.presences();
        result = result * 59 + ($presences == null ? 43 : ((Object)$presences).hashCode());
        ChatMute $mute = this.mute();
        result = result * 59 + ($mute == null ? 43 : ((Object)$mute).hashCode());
        Optional<String> $newJid = this.newJid();
        result = result * 59 + ($newJid == null ? 43 : ((Object)$newJid).hashCode());
        return result;
    }

    public String toString() {
        return "Chat(jid=" + this.jid() + ", displayName=" + this.displayName() + ", messages=" + this.messages() + ", presences=" + this.presences() + ", mute=" + this.mute() + ", newJid=" + this.newJid() + ", timestamp=" + this.timestamp() + ", unreadMessages=" + this.unreadMessages() + ", pinned=" + this.pinned() + ", ephemeralMessageDuration=" + this.ephemeralMessageDuration() + ", ephemeralMessagesToggleTime=" + this.ephemeralMessagesToggleTime() + ", isArchived=" + this.isArchived() + ", isReadOnly=" + this.isReadOnly() + ", isSpam=" + this.isSpam() + ")";
    }

    public static class ChatBuilder {
        private String jid;
        private String displayName;
        private boolean messages$set;
        private Messages messages$value;
        private boolean presences$set;
        private Map<Contact, ContactStatus> presences$value;
        private boolean mute$set;
        private ChatMute mute$value;
        private String newJid;
        private long timestamp;
        private int unreadMessages;
        private long pinned;
        private long ephemeralMessageDuration;
        private long ephemeralMessagesToggleTime;
        private boolean isArchived;
        private boolean isReadOnly;
        private boolean isSpam;

        ChatBuilder() {
        }

        @JsonProperty(value="2")
        public ChatBuilder jid(@NonNull String jid) {
            if (jid == null) {
                throw new NullPointerException("jid is marked non-null but is null");
            }
            this.jid = jid;
            return this;
        }

        @JsonProperty(value="1")
        public ChatBuilder displayName(@NonNull String displayName) {
            if (displayName == null) {
                throw new NullPointerException("displayName is marked non-null but is null");
            }
            this.displayName = displayName;
            return this;
        }

        public ChatBuilder messages(@NonNull Messages messages) {
            if (messages == null) {
                throw new NullPointerException("messages is marked non-null but is null");
            }
            this.messages$value = messages;
            this.messages$set = true;
            return this;
        }

        public ChatBuilder presences(@NonNull Map<Contact, ContactStatus> presences) {
            if (presences == null) {
                throw new NullPointerException("presences is marked non-null but is null");
            }
            this.presences$value = presences;
            this.presences$set = true;
            return this;
        }

        public ChatBuilder mute(@NonNull ChatMute mute) {
            if (mute == null) {
                throw new NullPointerException("mute is marked non-null but is null");
            }
            this.mute$value = mute;
            this.mute$set = true;
            return this;
        }

        public ChatBuilder newJid(String newJid) {
            this.newJid = newJid;
            return this;
        }

        public ChatBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public ChatBuilder unreadMessages(int unreadMessages) {
            this.unreadMessages = unreadMessages;
            return this;
        }

        public ChatBuilder pinned(long pinned) {
            this.pinned = pinned;
            return this;
        }

        public ChatBuilder ephemeralMessageDuration(long ephemeralMessageDuration) {
            this.ephemeralMessageDuration = ephemeralMessageDuration;
            return this;
        }

        public ChatBuilder ephemeralMessagesToggleTime(long ephemeralMessagesToggleTime) {
            this.ephemeralMessagesToggleTime = ephemeralMessagesToggleTime;
            return this;
        }

        public ChatBuilder isArchived(boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public ChatBuilder isReadOnly(boolean isReadOnly) {
            this.isReadOnly = isReadOnly;
            return this;
        }

        public ChatBuilder isSpam(boolean isSpam) {
            this.isSpam = isSpam;
            return this;
        }

        public Chat build() {
            Messages messages$value = this.messages$value;
            if (!this.messages$set) {
                messages$value = Chat.$default$messages();
            }
            Map<Contact, ContactStatus> presences$value = this.presences$value;
            if (!this.presences$set) {
                presences$value = Chat.$default$presences();
            }
            ChatMute mute$value = this.mute$value;
            if (!this.mute$set) {
                mute$value = Chat.$default$mute();
            }
            return new Chat(this.jid, this.displayName, messages$value, presences$value, mute$value, this.newJid, this.timestamp, this.unreadMessages, this.pinned, this.ephemeralMessageDuration, this.ephemeralMessagesToggleTime, this.isArchived, this.isReadOnly, this.isSpam);
        }

        public String toString() {
            return "Chat.ChatBuilder(jid=" + this.jid + ", displayName=" + this.displayName + ", messages$value=" + this.messages$value + ", presences$value=" + this.presences$value + ", mute$value=" + this.mute$value + ", newJid=" + this.newJid + ", timestamp=" + this.timestamp + ", unreadMessages=" + this.unreadMessages + ", pinned=" + this.pinned + ", ephemeralMessageDuration=" + this.ephemeralMessageDuration + ", ephemeralMessagesToggleTime=" + this.ephemeralMessagesToggleTime + ", isArchived=" + this.isArchived + ", isReadOnly=" + this.isReadOnly + ", isSpam=" + this.isSpam + ")";
        }
    }
}

