/*
 * Decompiled with CFR 0.152.
 */
package it.auties.whatsapp4j.manager;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import it.auties.whatsapp4j.binary.BinaryArray;
import it.auties.whatsapp4j.serialization.KeyPairDeserializer;
import it.auties.whatsapp4j.serialization.KeyPairSerializer;
import it.auties.whatsapp4j.utils.internal.CypherUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.util.Base64;
import java.util.Objects;
import java.util.prefs.Preferences;
import lombok.NonNull;

public class WhatsappKeysManager {
    public static final String PREFERENCES_PATH = WhatsappKeysManager.class.getName();
    private static final ObjectWriter JACKSON_WRITER = new ObjectMapper().writer();
    private static final ObjectReader JACKSON_READER = new ObjectMapper().reader();
    @JsonProperty
    @NonNull
    private String clientId;
    @JsonProperty
    @JsonSerialize(using=KeyPairSerializer.class)
    @JsonDeserialize(using=KeyPairDeserializer.class)
    @NonNull
    private KeyPair keyPair;
    @JsonProperty
    private String serverToken;
    @JsonProperty
    private String clientToken;
    @JsonProperty
    private BinaryArray encKey;
    @JsonProperty
    private BinaryArray macKey;

    public static WhatsappKeysManager fromJson(byte[] json) {
        try {
            return (WhatsappKeysManager)JACKSON_READER.readValue(json, WhatsappKeysManager.class);
        }
        catch (IOException exception) {
            throw new RuntimeException("WhatsappAPI: Cannot deserialize WhatsappKeysManager from %s".formatted(new String(json)), exception);
        }
    }

    public static WhatsappKeysManager fromJson(String json) {
        return WhatsappKeysManager.fromJson(json.getBytes(StandardCharsets.UTF_8));
    }

    public static WhatsappKeysManager fromPreferences() {
        String preferences = Preferences.userRoot().get(PREFERENCES_PATH, null);
        if (preferences != null) {
            return WhatsappKeysManager.fromJson(preferences);
        }
        return new WhatsappKeysManager(Base64.getEncoder().encodeToString(BinaryArray.random(16).data()), CypherUtils.calculateRandomKeyPair(), null, null, null, null);
    }

    public boolean mayRestore() {
        return Objects.nonNull(this.serverToken) && Objects.nonNull(this.clientToken);
    }

    public void initializeKeys(@NonNull String serverToken, @NonNull String clientToken, @NonNull BinaryArray encKey, @NonNull BinaryArray macKey) {
        if (serverToken == null) {
            throw new NullPointerException("serverToken is marked non-null but is null");
        }
        if (clientToken == null) {
            throw new NullPointerException("clientToken is marked non-null but is null");
        }
        if (encKey == null) {
            throw new NullPointerException("encKey is marked non-null but is null");
        }
        if (macKey == null) {
            throw new NullPointerException("macKey is marked non-null but is null");
        }
        this.encKey(encKey).macKey(macKey).serverToken(serverToken).clientToken(clientToken);
        this.serialize();
    }

    public void serialize() {
        try {
            Preferences.userRoot().put(PREFERENCES_PATH, JACKSON_WRITER.writeValueAsString((Object)this));
        }
        catch (JsonProcessingException exception) {
            throw new RuntimeException("WhatsappAPI: Cannot serialize WhatsappKeysManager to JSON", exception);
        }
    }

    public void deleteKeysFromMemory() {
        Preferences.userRoot().clear();
    }

    private WhatsappKeysManager(@NonNull String clientId, @NonNull KeyPair keyPair, String serverToken, String clientToken, BinaryArray encKey, BinaryArray macKey) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
        this.clientId = clientId;
        this.keyPair = keyPair;
        this.serverToken = serverToken;
        this.clientToken = clientToken;
        this.encKey = encKey;
        this.macKey = macKey;
    }

    private WhatsappKeysManager() {
    }

    @NonNull
    public String clientId() {
        return this.clientId;
    }

    @NonNull
    public KeyPair keyPair() {
        return this.keyPair;
    }

    public String serverToken() {
        return this.serverToken;
    }

    public String clientToken() {
        return this.clientToken;
    }

    public BinaryArray encKey() {
        return this.encKey;
    }

    public BinaryArray macKey() {
        return this.macKey;
    }

    @JsonProperty
    public WhatsappKeysManager clientId(@NonNull String clientId) {
        if (clientId == null) {
            throw new NullPointerException("clientId is marked non-null but is null");
        }
        this.clientId = clientId;
        return this;
    }

    @JsonProperty
    @JsonDeserialize(using=KeyPairDeserializer.class)
    public WhatsappKeysManager keyPair(@NonNull KeyPair keyPair) {
        if (keyPair == null) {
            throw new NullPointerException("keyPair is marked non-null but is null");
        }
        this.keyPair = keyPair;
        return this;
    }

    @JsonProperty
    public WhatsappKeysManager serverToken(String serverToken) {
        this.serverToken = serverToken;
        return this;
    }

    @JsonProperty
    public WhatsappKeysManager clientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    @JsonProperty
    public WhatsappKeysManager encKey(BinaryArray encKey) {
        this.encKey = encKey;
        return this;
    }

    @JsonProperty
    public WhatsappKeysManager macKey(BinaryArray macKey) {
        this.macKey = macKey;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WhatsappKeysManager)) {
            return false;
        }
        WhatsappKeysManager other = (WhatsappKeysManager)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$clientId = this.clientId();
        String other$clientId = other.clientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        KeyPair this$keyPair = this.keyPair();
        KeyPair other$keyPair = other.keyPair();
        if (this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair)) {
            return false;
        }
        String this$serverToken = this.serverToken();
        String other$serverToken = other.serverToken();
        if (this$serverToken == null ? other$serverToken != null : !this$serverToken.equals(other$serverToken)) {
            return false;
        }
        String this$clientToken = this.clientToken();
        String other$clientToken = other.clientToken();
        if (this$clientToken == null ? other$clientToken != null : !this$clientToken.equals(other$clientToken)) {
            return false;
        }
        BinaryArray this$encKey = this.encKey();
        BinaryArray other$encKey = other.encKey();
        if (this$encKey == null ? other$encKey != null : !((Object)this$encKey).equals(other$encKey)) {
            return false;
        }
        BinaryArray this$macKey = this.macKey();
        BinaryArray other$macKey = other.macKey();
        return !(this$macKey == null ? other$macKey != null : !((Object)this$macKey).equals(other$macKey));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WhatsappKeysManager;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $clientId = this.clientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        KeyPair $keyPair = this.keyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        String $serverToken = this.serverToken();
        result = result * 59 + ($serverToken == null ? 43 : $serverToken.hashCode());
        String $clientToken = this.clientToken();
        result = result * 59 + ($clientToken == null ? 43 : $clientToken.hashCode());
        BinaryArray $encKey = this.encKey();
        result = result * 59 + ($encKey == null ? 43 : ((Object)$encKey).hashCode());
        BinaryArray $macKey = this.macKey();
        result = result * 59 + ($macKey == null ? 43 : ((Object)$macKey).hashCode());
        return result;
    }

    public String toString() {
        return "WhatsappKeysManager(clientId=" + this.clientId() + ", keyPair=" + this.keyPair() + ", serverToken=" + this.serverToken() + ", clientToken=" + this.clientToken() + ", encKey=" + this.encKey() + ", macKey=" + this.macKey() + ")";
    }
}

